<?php 
ob_start();
session_start();
include("db.php"); // $conn should be initialized here

// Show session message if exists
if (isset($_SESSION['bank'])) {
    $message = $_SESSION['bank']; 
    echo "<script>alert('$message');</script>";
    unset($_SESSION["bank"]);
}

// Check if user is logged in
if (!isset($_SESSION['user_email'])) {
    header("location:login.php?login=failed");
    exit;
}

$user_email = $_SESSION['user_email'];

// Get manager info
$select_query_1 = "SELECT * FROM `managers` WHERE `email` = '$user_email'";
$result_1 = mysqli_query($conn, $select_query_1);

$branch_id = '';
$count_1 = 0;

if ($result_1) {
    while ($row = mysqli_fetch_assoc($result_1)) {
        $branch_id = $row['branch_id'];
    }
    $count_1 = mysqli_num_rows($result_1);
} else {
    die("Query Error (managers): " . mysqli_error($conn));
}

// Redirect if manager is linked with a branch
if ($count_1 > 0) {
    header("location:javascript://history.go(-1)");
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Banks</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
  <link href="dist/css/style.css" rel="stylesheet" type="text/css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
 <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
 <script src="bootstrap/js/bootstrap.min.js"></script>

</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <header class="main-header">
    <!-- Logo -->
 <?php  include('inc/main-header.php');  ?>
    </header>
  <!-- Left side column. contains the logo and sidebar -->
    <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
 <?php  include('inc/main-sidebar.php');  ?>
  </aside>
<?php include('inc/calculator.php'); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Bank
        <small>Details</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
        <li class="active">Add Bank</li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-xs-12">
        

          <div class="box">
            <div class="box-header">
              <h3 class="box-title">Registration</h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              
            <form role="form" id="register-form" method="post"  novalidate="novalidate" enctype="multipart/form-data"> 
              <div class="box-body">
                <div class="form-group" style="width:48%;float:left">
                  <label for="">Name</label>
                  <input type="text" name="name" id="name" placeholder="Branch's name" class="form-control" style="width:90%;">
                </div>
                
                </div>
              <!-- /.box-body -->

              <div class="box-footer">
                <input type="submit" name="submit" id="add_bank" class="btn btn-primary">
              </div>
            </form>
  		
           
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <!-- Footer -->
  <?php include("inc/footer.php"); ?>

  <!-- Control Sidebar -->
  <?php include("inc/aside.php"); ?>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<!-- Bootstrap 3.3.6 -->
<!-- DataTables -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
<!-- page script -->
<script>

  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
</script>

  <script src="//ajax.aspnetcdn.com/ajax/jquery.validate/1.9/jquery.validate.min.js"></script>
  
  <!-- jQuery Form Validation code -->

  <script>

  // When the browser is ready...
$(document).ready(function (e) {
  
    // Setup form validation on the #register-form element
    $("#register-form").validate({
    
        // Specify the validation rules
        rules: {
            name: "required"
        },
        
        // Specify the validation error messages
        messages: {
           	name: "Please enter the Bank name"
		},
        
        submitHandler: function(form) {
            form.submit();
        }
    });
	//ajax area add student
	  $("#add_bank").click(function(){
	  	var name = $("#name").val();

	  $.ajax({
		url: "functions.php",
		type: "POST",
		async: false,
		data: {
		"bank_added": 1,
		"s_name": name,
		},
		success: function(data){
			
		}
		
	})
	

	  });

});
              
//ajax add student end

  </script>
</body>
</html>
