<?php 
ob_start();
session_start();
include("db.php"); // Ensure $conn is a valid mysqli connection

// Show branch alert if set
if (isset($_SESSION['branch'])) {
    $message = $_SESSION['branch'];
    echo "<script>alert('" . htmlspecialchars($message, ENT_QUOTES) . "');</script>";
    unset($_SESSION['branch']);
}

// Session email check
if (!isset($_SESSION['user_email'])) {
    header("Location: login.php?login=failed");
    exit();
}


$user_email = $_SESSION['user_email'];

// Get manager's branch info
$branch_id = null;
$stmt = $conn->prepare("SELECT branch_id FROM managers WHERE email = ?");
$stmt->bind_param("s", $user_email);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    $branch_id = $row['branch_id'];
    header("Location: javascript://history.go(-1)");
    exit();
}

// Handle Branch Picture Upload
$branch_image_path = '';
if (!empty($_FILES['image']['name'])) {
    $allowed = ['jpeg', 'jpg', 'png'];
    $file_name = $_FILES['image']['name'];
    $file_tmp = $_FILES['image']['tmp_name'];
    $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
    $file_size = $_FILES['image']['size'];

    if (!in_array($file_ext, $allowed)) {
        echo "<script>alert('Invalid branch image format. Only JPEG or PNG allowed.');</script>";
    } elseif ($file_size > 2097152) {
        echo "<script>alert('Branch image size must not exceed 2MB.');</script>";
    } else {
        $branch_image_path = "uploads/" . uniqid("branch_") . "." . $file_ext;
        move_uploaded_file($file_tmp, $branch_image_path);
    }
}

// Handle Map Picture Upload
$map_image_path = '';
if (!empty($_FILES['map']['name'])) {
    $allowed = ['jpeg', 'jpg', 'png'];
    $file_name = $_FILES['map']['name'];
    $file_tmp = $_FILES['map']['tmp_name'];
    $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
    $file_size = $_FILES['map']['size'];

    if (!in_array($file_ext, $allowed)) {
        echo "<script>alert('Invalid map image format. Only JPEG or PNG allowed.');</script>";
    } elseif ($file_size > 2097152) {
        echo "<script>alert('Map image size must not exceed 2MB.');</script>";
    } else {
        $map_image_path = "uploads/" . uniqid("map_") . "." . $file_ext;
        move_uploaded_file($file_tmp, $map_image_path);
    }
}

?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>ADD Branch</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
  <link href="dist/css/style.css" rel="stylesheet" type="text/css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
 <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
 <script src="bootstrap/js/bootstrap.min.js"></script>

<style type="text/css">
#cnic_error, #email_error
{
  margin:0;
  color:red;
}
.form-control
{
  border-radius: 5px;
}
</style>
<script type="text/javascript">
  $(document).ready(function(){

    /* checking branch name start */
    $('#name').on('keyup',function(){
        var nameB = $(this).val();
        if(nameB){
            $.ajax({
                type:'POST',
                url:'ajaxdata.php',
                data:{
                    'name_branch': nameB,
                  },
                success:function(outcome){ 
                    if(outcome == 0){
                        $('#name_error').html('Branch Name Already Exists');
                        $("#name").css("border-color", "red");
                        $('#name').focus();
                        $("#add_branch").attr('disabled', true); 
                    }else if(outcome == 1){
                        $('#name_error').html('');
                        $("#name").css("border-color", "#d2d6de");
                        $("#add_branch").attr('disabled', false); 
                    }
                }
            }); 
        }
    });

    /* checking branch name End */



});
</script>
</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <header class="main-header">
    <!-- Logo -->
 <?php  include('inc/main-header.php');  ?>
    </header>
  <!-- Left side column. contains the logo and sidebar -->
    <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
 <?php  include('inc/main-sidebar.php');  ?>
  </aside>
 <?php include('inc/calculator.php'); ?>


  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        ADD Branch
        <small>Housing Society</small>
        <a href="add_manager.php" class="btn btn-primary">Add Manager</a>
      </h1>
      <ol class="breadcrumb">
        <li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
        <li class="active">Add Branch</li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-xs-12">
        

          <div class="box box-primary">
            <div class="box-header">
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              
            <form role="form" id="register-form" method="post"  novalidate="novalidate" enctype="multipart/form-data"> 
              <div class="box-body">
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="">Manager</label>
                    <select id="manager" name="manager" class="form-control" required>
                      <?php
                      $select_query = "SELECT `id`, `name` FROM `managers` WHERE `branch_id` = 0 ORDER BY `id` DESC";
                      $result_query = $conn->query($select_query);

                      if ($result_query && $result_query->num_rows > 0) {
                          while ($row = $result_query->fetch_assoc()) {
                              $manager_id = htmlspecialchars($row['id']);
                              $manager_name = htmlspecialchars($row['name']);
                              echo "<option value=\"$manager_id\">$manager_name</option>";
                          }
                      } else {
                          echo '<option disabled>No available managers</option>';
                      }
                      ?>
                    </select>

                  </div>  
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="">Name</label>
                    <input type="text" name="name" id="name" placeholder="Branch's name" class="form-control">
                    <p id="name_error"></p>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="">Branch Password</label>
                    <input type="text" name="pass" id="pass" class="form-control" placeholder="Branch's Password">
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="">Location</label>
                    <input type="text" name="location" id="location" class="form-control" placeholder="Location">
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="">Total Area</label>
                    <input type="number" name="area" id="area" class="form-control" placeholder="Total Area">
                  </div>
                </div>
                <div class="col-md-6">
  				        <div class="form-group">
                    <label for="">Square Feet Per Marla Size</label>
                    <input type="number" name="sqr" id="sqr" class="form-control" placeholder="Square Feet Per Marla Size">
                  </div>
                </div>
                <div class="col-md-6">
  				        <div class="form-group">
                    <label for="">Branch Phone Number</label>
                    <input type="number" name="branch_phone" id="branch_phone" class="form-control" placeholder="Phone Number">
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="">Status</label>
                    <Select id="status" name="status" class="form-control" placeholder="Status">
                    	<option value="1">Enabled</option>
                      <option value="0">Disabled</option>
                    </Select>
                  </div>
                </div>
                <div class="col-md-6">
                	<div class="form-group">
                      	<label for="">Branch Picture</label><br>
                   		<input type="file" name="image" id="image" class="form-control"  style="display:inline-block" required/>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                      	<label for="">Branch Map Picture</label><br>
                   		<input type="file" name="map" id="map" class="form-control"  style="display:inline-block" required/>
                  </div>
               </div>
                </div>
              <!-- /.box-body -->

              <div class="box-footer">
                <input type="submit" name="submit" id="add_branch" class="btn btn-primary">
              </div>
            </form>
  		
           
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <!-- Footer -->
  <?php include("inc/footer.php"); ?>

  <!-- Control Sidebar -->
  <?php include("inc/aside.php"); ?>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<!-- Bootstrap 3.3.6 -->
<!-- DataTables -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
<!-- page script -->
<script>

  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
</script>

  <script src="//ajax.aspnetcdn.com/ajax/jquery.validate/1.9/jquery.validate.min.js"></script>
  
  <!-- jQuery Form Validation code -->

  <script>

  // When the browser is ready...
$(document).ready(function (e) {
  
    // Setup form validation on the #register-form element
    $("#register-form").validate({
    
        // Specify the validation rules
        rules: {
            name: "required",
			location: "required",
			image: "required",
			pass: "required",
			area: "required",
			sqr: "required",
			map: "required",
			branch_phone: "required"
        },
        
        // Specify the validation error messages
        messages: {
           	name: "Please enter the Branch name",
			location: "Please enter the Branch Location",
			image: "Please enter the Picture",
			pass: "Please Enter Password for Branch",
			area: "Please enter the Total area of the branch",
			sqr: "Please Enter Square feet size",
			map: "Please add map image of the branch",
			branch_phone: "Please Enter Branch Phone number"
        },
        
        submitHandler: function(form) {
            form.submit();
        }
    });
	//ajax area add student
	  $("#add_branch").click(function(){
	  	var name = $("#name").val();
		var manager = $("#manager").val();
		var pass = $("#pass").val();
		var location = $("#location").val();
		var status = $("#status").val();
		var area = $("#area").val();
		var sqr = $("#sqr").val();
		var branch_phone = $("#branch_phone").val();
		/*var file_data = $('#file').prop('files')[0];
		var form_data = new FormData();
		form_data.append('file', file_data);*/
	  	var image = $('#image').val().split('\\').pop();
    	image1=image.split('.')[0];
		fileExtension = image.substr((image.lastIndexOf('.') + 1));
		console.log (fileExtension);
		var map = $('#map').val().split('\\').pop();
    	map1=map.split('.')[0];
		fileExtension1 = map.substr((map.lastIndexOf('.') + 1));
		console.log (fileExtension1);

	  $.ajax({
		url: "functions.php",
		type: "POST",
		async: false,
		data: {
		"branch_added": 1,
		"s_name": name,
		"s_manager": manager,
		"s_pass": pass,
		"s_location": location,
		"s_status": status,
		"s_image": 'uploads/'+image1+'.'+fileExtension,
		"s_map": 'uploads/'+map1+'.'+fileExtension1,
		"s_area": area,
		"s_sqr": sqr,
		"s_branch_phone": branch_phone,
		},
		success: function(data){
			
		}
		
	})
	

	  });

});
              
//ajax add student end

  </script>
</body>
</html>
