<?php
ob_start();
session_start();
include("db.php"); // assumes $conn is created here using mysqli

$date = date('Y-m-d');

if (!isset($_SESSION['user_email'])) {
    header("location:login.php?login=failed");
    exit();
}

$error_message = ''; // ✅ Error message

$user_email = $_SESSION['user_email'];

$select_query_q = mysqli_query($conn, "SELECT * FROM `managers` WHERE `email`='$user_email'");
$manager = mysqli_fetch_assoc($select_query_q);

$branch_id = $manager['branch_id'] ?? null;
$M_name = $manager['name'] ?? '';
$M_privileges = $manager['privileges'] ?? '';
$count_1 = mysqli_num_rows($select_query_q);

$branch_id_s = $_GET['branch_id'] ?? '';

if ($count_1 > 0) {
    $privileges = unserialize($M_privileges);
    if ($branch_id_s != $branch_id) {
        header("location:javascript://history.go(-1)");
        exit();
    }
}

$branch_query = mysqli_query($conn, "SELECT * FROM `branches` WHERE `id` = '$branch_id_s'");
$branch = mysqli_fetch_assoc($branch_query);
$branch_id = $branch['id'];
$branch_name = $branch['name'];
$branch_image = $branch['image'];
$square_feet_size = $branch['square_feet_size'];

if (isset($_SESSION['make_payment'])) {
    header("location:add_payment.php?branch_id=$branch_id");
    exit();
}

if (isset($_POST['submit'])) {
    $ledgerErrors = 0;

    $vouncher_number = $_POST['voucher_no'];
    $entydate = $_POST['entydate'];
    $voucher_type = $_POST['voucher_type'];

    foreach (['ledger_id', 'dr_amount', 'cr_amount', 'narration', 'check_num', 'check_name', 'check_date', 'check_details', 'check_to'] as $pos) {
        foreach ($_POST[$pos] as $id => $row) {
            $_POST[$pos][$id] = mysqli_real_escape_string($conn, $row);
        }
    }

    $ledger = $_POST['ledger_id'];
    $debit = $_POST['dr_amount'];
    $credit = $_POST['cr_amount'];
    $memo = $_POST['narration'];
    $check_num = $_POST['check_num'];
    $check_name = $_POST['check_name'];
    $check_date = $_POST['check_date'];
    $check_details = $_POST['check_details'];
    $check_to = $_POST['check_to'];

    $items = [];
    $size = count($ledger);

    for ($i = 0; $i < $size; $i++) {
        $items[] = [
            "ledger_id" => $ledger[$i],
            "dr_amount" => $debit[$i],
            "cr_amount" => $credit[$i],
            "narration" => $memo[$i],
            "check_num" => $check_num[$i],
            "check_name" => $check_name[$i],
            "check_date" => $check_date[$i],
            "check_details" => $check_details[$i],
            "check_to" => $check_to[$i],
        ];
    }

    $values = [];
    $customer_ledger_id = null;

    foreach ($items as $item) {
        $values[] = "('$branch_id', '$vouncher_number','$voucher_type', '{$item['ledger_id']}', '{$item['dr_amount']}', '{$item['cr_amount']}', '{$item['narration']}', '{$item['check_num']}', '{$item['check_name']}', '{$item['check_date']}', '{$item['check_details']}',  '{$item['check_to']}',  '$entydate')";

        if (empty($item['ledger_id']) || $item['ledger_id'] == 0) {
            $ledgerErrors = 1;
        }

        // Get customer ledger id
        $cust_query = mysqli_query($conn, "SELECT * FROM `ledgers` WHERE `id` = '{$item['ledger_id']}' AND `customer_id` != ''");
        $cust_result = mysqli_fetch_assoc($cust_query);
        if ($cust_result) {
            $customer_ledger_id = $cust_result['id'];
        }
    }

    $check_voucher_num = mysqli_query($conn, "SELECT * FROM `all_payments` WHERE `branch_id` = '$branch_id' AND `voucher_no` = '$vouncher_number'");

    if ($ledgerErrors == 1) {
        $error_message = '<div class="alert alert-danger"><button data-dismiss="alert" class="close" type="button">×</button>Please Select All Ledgers</div>';
    } elseif (mysqli_num_rows($check_voucher_num) > 0) {
        $error_message = '<div class="alert alert-danger"><button data-dismiss="alert" class="close" type="button">×</button>Voucher Number Cannot Be Same</div>';
    } else {
        $values_str = implode(", ", $values);
        $sql = mysqli_query($conn, "INSERT INTO `all_payments` (`branch_id`, `voucher_no`, `voucher_type`, `ledger_id`, `debit`, `credit`, `narration`, `check_num`, `check_name`, `check_date`, `check_details`, `check_to`, `date`) VALUES $values_str");

        // Get inserted payment id
        $payment_id = null;
        if ($customer_ledger_id) {
            $payment_result = mysqli_query($conn, "SELECT * FROM `all_payments` WHERE `ledger_id` = '$customer_ledger_id' ORDER BY id DESC LIMIT 1");
            $payment_row = mysqli_fetch_assoc($payment_result);
            $payment_id = $payment_row['id'] ?? null;
        }

        $voucher_data_result = mysqli_query($conn, "SELECT * FROM `all_payments` ORDER BY id DESC LIMIT 1");
        $voucher_data = mysqli_fetch_assoc($voucher_data_result);
        $voucher_no = $voucher_data['voucher_no'] ?? null;

        if ($sql) {
            if ($voucher_type == 'CR') {
				$_SESSION['getReceipt'] = 'Entry Successful. <a href="print_payment_invoice.php?branch_id=' . $branch_id . '&payment_id=' . $payment_id . '" target="blank">Click here</a> for Receipt.';
            } else {
                $_SESSION['getReceipt'] = 'Entry Successful. <a href="print_voucher.php?branch_id=' . $branch_id . '&voucher_no=' . $voucher_no . '" target="blank">Click here</a> for Receipt.';
            }
        } else {
            echo "<script>alert('Something Went Wrong!');</script>";
        }
    }
}

// Get new voucher number
$voucher_count = 0;
$voucher_query = mysqli_query($conn, "SELECT MAX(voucher_no) as max_voucher FROM `all_payments` WHERE `branch_id` = '$branch_id'");
$voucher_value = mysqli_fetch_assoc($voucher_query);
$voucher_count = (int)($voucher_value['max_voucher'] ?? 0) + 1;
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Add Entry</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
<!--Entry Date picker-->
 
  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
 <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>

 <script src="bootstrap/js/bootstrap.min.js"></script>
 
 
 
 <!-- for select box with input -->
  <script src="plugins/jQuery/choosen.js"></script>
  <link href="dist/css/chosen.css" rel="stylesheet" type="text/css">
 <!-- Select Box with input end --> 

 
 
 <!-- For Date Picker -->
 <script type="text/javascript" src="https://formden.com/static/cdn/formden.js"></script>
  <!-- For Date End -->

<style>
.jquery-date
{
  background-color: #fff !important;
}
.account-table td
{
	padding:10px;
}
.reciept-table th,td 
{
	padding:10px;
}
.reciept-table tr
{
	border-bottom:1px solid #eee;	
}
.meta-receipt div
{
	border-bottom:1px solid #eee;	
}
br {
    line-height: 10px;
 }
</style>
     
     
  </head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <header class="main-header">
    <!-- Logo -->
 <?php  include('inc/main-header.php');  ?>
    </header>
  <!-- Left side column. contains the logo and sidebar -->
    <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
 <?php  include('inc/main-sidebar.php');  ?>
  </aside>
<?php include('inc/calculator.php'); ?>


	<script type="text/javascript">
$(document).ready(function() {
// show hide checkboxes
					$('input[type="checkbox"]').change(function() {
					  $(this).next().find('input').toggle()
					});
	/* javascript floating point operations */
	var jsFloatOps = function(param1, param2, op) {
					param1 = param1 * 100;
			param2 = param2 * 100;
				param1 = param1.toFixed(0);
		param2 = param2.toFixed(0);
		param1 = Math.floor(param1);
		param2 = Math.floor(param2);
		var result = 0;
		if (op == '+') {
			result = param1 + param2;
							result = result/100;
						return result;
		}
		if (op == '-') {
			result = param1 - param2;
							result = result/100;
						return result;
		}
		if (op == '!=') {
			if (param1 != param2)
				return true;
			else
				return false;
		}
		if (op == '==') {
			if (param1 == param2)
				return true;
			else
				return false;
		}
		if (op == '>') {
			if (param1 > param2)
				return true;
			else
				return false;
		}
		if (op == '<') {
			if (param1 < param2)
				return true;
			else
				return false;
		}
	}

	/* Calculating Dr and Cr total */
	$(document).on('change', '.dr-item', function() {
		var drTotal = 0;
		$("table tr .dr-item").each(function() {
			var curDr = $(this).prop('value');
			curDr = parseFloat(curDr);
			if (isNaN(curDr))
				curDr = 0;
			drTotal = jsFloatOps(drTotal, curDr, '+');
		});
		$("table tr #dr-total").text(drTotal);
		var crTotal = 0;
		$("table tr .cr-item").each(function() {
			var curCr = $(this).prop('value');
			curCr = parseFloat(curCr);
			if (isNaN(curCr))
				curCr = 0;
			crTotal = jsFloatOps(crTotal, curCr, '+');
		});
		$("table tr #cr-total").text(crTotal);

		if (jsFloatOps(drTotal, crTotal, '==')) {
			$("#disabler").removeAttr('disabled');
			$("table tr #dr-total").css("background-color", "#FFFF99");
			$("table tr #cr-total").css("background-color", "#FFFF99");
			$("table tr #dr-diff").text("-");
			$("table tr #cr-diff").text("");
		} else {
			$("#disabler").attr('disabled', true); 
			$("table tr #dr-total").css("background-color", "#FFE9E8");
			$("table tr #cr-total").css("background-color", "#FFE9E8");
			if (jsFloatOps(drTotal, crTotal, '>')) {
				$("table tr #dr-diff").text("");
				$("table tr #cr-diff").text(jsFloatOps(drTotal, crTotal, '-'));
			} else {
				$("table tr #dr-diff").text(jsFloatOps(crTotal, drTotal, '-'));
				$("table tr #cr-diff").text("");
			}
		}
	});

	$(document).on('change', '.cr-item', function() {
		var drTotal = 0;
		$("table tr .dr-item").each(function() {
			var curDr = $(this).prop('value')
			curDr = parseFloat(curDr);
			if (isNaN(curDr))
				curDr = 0;
			drTotal = jsFloatOps(drTotal, curDr, '+');
		});
		$("table tr #dr-total").text(drTotal);
		var crTotal = 0;
		$("table tr .cr-item").each(function() {
			var curCr = $(this).prop('value')
			curCr = parseFloat(curCr);
			if (isNaN(curCr))
				curCr = 0;
			crTotal = jsFloatOps(crTotal, curCr, '+');
		});
		$("table tr #cr-total").text(crTotal);

		if (jsFloatOps(drTotal, crTotal, '==')) {
			$("#disabler").removeAttr('disabled');
			$("table tr #dr-total").css("background-color", "#FFFF99");
			$("table tr #cr-total").css("background-color", "#FFFF99");
			$("table tr #dr-diff").text("-");
			$("table tr #cr-diff").text("");
		} else {
			$("#disabler").attr('disabled', true); 
			$("table tr #dr-total").css("background-color", "#FFE9E8");
			$("table tr #cr-total").css("background-color", "#FFE9E8");
			if (jsFloatOps(drTotal, crTotal, '>')) {
				$("table tr #dr-diff").text("");
				$("table tr #cr-diff").text(jsFloatOps(drTotal, crTotal, '-'));
			} else {
				$("table tr #dr-diff").text(jsFloatOps(crTotal, drTotal, '-'));
				$("table tr #cr-diff").text("");
			}
		}
	});

	/* Dr - Cr dropdown changed */
	$(document).on('change', '.dc-dropdown', function() {
		var drValue = $(this).parent().parent().next().next().children().children().prop('value');
		var crValue = $(this).parent().parent().next().next().next().children().children().prop('value');

		if ($(this).parent().parent().next().children().children().val() == "0") {
			return;
		}

		drValue = parseFloat(drValue);
		if (isNaN(drValue))
			drValue = 0;

		crValue = parseFloat(crValue);
		if (isNaN(crValue))
			crValue = 0;

		if ($(this).prop('value') == "D") {
			if (drValue == 0 && crValue != 0) {
				$(this).parent().parent().next().next().children().children().prop('value', crValue);
			}
			$(this).parent().parent().next().next().next().children().children().prop('value', "");
			$(this).parent().parent().next().next().next().children().children().prop('disabled', 'disabled');
			$(this).parent().parent().next().next().children().children().prop('disabled', '');
		} else {
			if (crValue == 0 && drValue != 0) {
				$(this).parent().parent().next().next().next().children().prop('value', drValue);
			}
			$(this).parent().parent().next().next().children().children().prop('value', "");
			$(this).parent().parent().next().next().children().children().prop('disabled', 'disabled');
			$(this).parent().parent().next().next().next().children().children().prop('disabled', '');
		}
		/* Recalculate Total */
		$('.dr-item:first').trigger('change');
		$('.cr-item:first').trigger('change');
	});

	/* Ledger dropdown changed */
	$(document).on('change', '.ledger-dropdown', function() {
		if ($(this).val() == "0") {
			/* Reset and diable dr and cr amount */
			$(this).parent().parent().next().children().children().prop('value', "");
			$(this).parent().parent().next().next().children().children().prop('value', "");
			$(this).parent().parent().next().children().children().prop('disabled', 'disabled');
			$(this).parent().parent().next().next().children().children().prop('disabled', 'disabled');
		} else {
			/* Enable dr and cr amount and trigger Dr/Cr change */
			$(this).parent().parent().next().children().children().prop('disabled', '');
			$(this).parent().parent().next().next().children().children().prop('disabled', '');
			$(this).parent().parent().prev().children().children().trigger('change');
		}
		/* Trigger dr and cr change */
		$(this).parent().parent().next().children().children().trigger('change');
		$(this).parent().parent().next().next().children().children().trigger('change');

		var ledgerid = $(this).val();
		var rowid = $(this);
		if (ledgerid > 0) {
			$.ajax({
				url: 'functions.php',
				data: 'id=' + ledgerid,
				dataType: 'json',
				success: function(data)
				{
					var ledger_bal = parseFloat(data['cl']['amount']);

					var prefix = '';
					var suffix = '';
					if (data['cl']['status'] == 'neg') {
						prefix = '<span class="error-text">';
						suffix = '</span>';
					}

					if (data['cl']['dc'] == 'D') {
						rowid.parent().parent().next().next().next().next().children().html(prefix + "Dr " + ledger_bal + suffix);
					} else if (data['cl']['dc'] == 'C') {
						rowid.parent().parent().next().next().next().next().children().html(prefix + "Cr " + ledger_bal + suffix);
					} else {
						rowid.parent().parent().next().next().next().next().children().html("");
					}
				}
			});
		} else {
			rowid.parent().parent().next().next().next().next().children().text("");
		}
	});

	/* Recalculate Total */
	$(document).on('click', 'table td .recalculate', function() {
		/* Recalculate Total */
		$('.dr-item:first').trigger('change');
		$('.cr-item:first').trigger('change');
	});

	/* Delete ledger row */
	$(document).on('click', '.deleterow', function() {
		$(this).parent().parent().remove();
		/* Recalculate Total */
		$('.dr-item:first').trigger('change');
		$('.cr-item:first').trigger('change');
	});


	/* On page load initiate all triggers */
	$('.dc-dropdown').trigger('change');
	$('.ledger-dropdown').trigger('change');
	$('.dr-item:first').trigger('change');
	$('.cr-item:first').trigger('change');

	/* Calculate date range in javascript */
	startDate = new Date(1491019200000  + (new Date().getTimezoneOffset() * 60 * 1000));
	endDate = new Date(1522468800000  + (new Date().getTimezoneOffset() * 60 * 1000));

	/* Setup jQuery datepicker ui */
	$('#EntryDate').datepicker({
		minDate: startDate,
		maxDate: endDate,
		dateFormat: 'yyyy-mm-dd',
		numberOfMonths: 1,
	});

	$(".ledger-dropdown").select2({width:'100%'});
});

</script>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Add Entry 
        <small>Receipt</small>
      </h1>
      <ol class="breadcrumb">
        <?php if($count_1 > 0){ }else{ ?>
        <li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
        <?php  } ?>
        <li><a href="branch_page.php?branch_id=<?= $branch_id ?>"><?php if($count_1 > 0){ ?><i class="fa fa-home"></i> Home <?php }else{ echo $branch_name; } ?></a></li>
        <li class="active">Add Entry</li>
      </ol>
    </section>

    <!-- Main content -->
    
    <section class="content">
      <div class="row">
	  
    	   <div class="col-xs-12">
         <div class="box box-primary">
            <div class="box-header with-border">
            </div>
            <!-- /.box-header -->

<div class="box-body">
	<?php if(isset($_SESSION['getReceipt'])){
	  $message = $_SESSION['getReceipt'];
	  ?> 
	  <div class="alert alert-success text-center">
	    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
	    <p><?php echo $message; ?></p>
	  </div>
	  <?php unset($_SESSION["getReceipt"]); 
	}
	  ?>
	<div class="entry add form">
		 <?php echo $error_message; ?>
		<form action="" id="register-form" method="post">
			<div class="row meta-receipt">
				<div class="col-xs-4">
					<div class="form-group demo">
						   <label for="date">Date</label>
							 <input class="form-control jquery-date" id="entydate" name="entydate" placeholder="YYYY-MM-DD" type="text" readonly="">
							<i class="glyphicon glyphicon-calendar fa fa-calendar"></i>
					</div>
				</div><div class="col-xs-4">
					<div class="form-group">
						<label for="number">Voucher Number</label>
						<input type="number" name="voucher_no" value="<?=$voucher_count?>" id="voucher_no" beforeinput="" afterinput="" class="form-control" style="background-color:white" readonly>
					</div>
				</div>
				<div class="col-xs-2">
					<div class="form-group demo">
						   <label for="type">Voucher Type</label>
							 <select class="form-control" id="voucher_type" name="voucher_type">
							 	<option value="JV">Journal Voucher</option>
							 	<option value="CR">Customer Receipt</option>
							 	<option value="CP">Cash Voucher</option>
							 	<option value="BP">Bank Voucher</option>
							 </select>
					</div>
				</div>
				<div class="col-xs-2 text-center" style="border-bottom: 0">
					<div class="demo" style="border-bottom: 0">
						   <label for="type">Check Info</label><br>
							 <input name="chk1" class="check_box form-check-input" type="checkbox" data-ptag="sb1" id="chk1" value="">
					</div>
				</div>
		 </div>
		 <table id="tbUser" class="stripped text-center table-payment">
		 <tbody  id="TableBody" class="reciept-table">
			<tr>
				<th>Ledger</th>
				<th>Dr Amount (Rs)</th>
				<th>Cr Amount (Rs)</th>
				<th>Narration</th>
				<th>Actions</th>
		    </tr>
			<tr>
				<td>
					<div class="">
					
						<select name="ledger_id[]" class="form-control select2-hidden-accessible chosen form-control"
    tabindex="-1" aria-hidden="true"
    style="width: 322px;text-align: center;padding: 10px 0px 0px 0px;margin-top: 12px !important;"
    required="required">
    <option value="0">Please Select</option>
    <?php
    $control_query = mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `branch_id` = '$branch_id'");
    while ($control_items = mysqli_fetch_assoc($control_query)) {
        $control_account_id = $control_items['id'];
        $control_account_name = htmlspecialchars($control_items['name'], ENT_QUOTES);
        $control_gcode = $control_items['gcode'];
        ?>
        <option value="<?= $control_account_id ?>" disabled style="color:#23527c;font-weight:900;">
            <b>&nbsp;&nbsp;&nbsp;[<?= $control_gcode ?>] <?= $control_account_name ?></b>
        </option>
        <?php
        $general_query = mysqli_query($conn, "SELECT * FROM `general_ledgers` WHERE `branch_id` = '$branch_id' AND `control_account_id` = '$control_account_id'");
        while ($general_item = mysqli_fetch_assoc($general_query)) {
            $general_ledger_id = $general_item['id'];
            $general_ledger_name = htmlspecialchars($general_item['name'], ENT_QUOTES);
            $general_ledger_gcode = $general_item['gcode'];
            ?>
            <option value="<?= $general_ledger_id ?>" disabled style="color:#72afd2;font-weight:900;">
                <b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[<?= $general_ledger_gcode ?>] <?= $general_ledger_name ?></b>
            </option>
            <?php
            $ledger_query = mysqli_query($conn, "SELECT * FROM `ledgers` WHERE `branch_id` = '$branch_id' AND `control_account_id` = '$control_account_id' AND `general_ledger_id` = '$general_ledger_id'");
            while ($ledger_item = mysqli_fetch_assoc($ledger_query)) {
                $ledger_id = $ledger_item['id'];
                $ledger_name = htmlspecialchars($ledger_item['name'], ENT_QUOTES);
                $ledger_gcode = $ledger_item['gcode'];
                $ledger_customer_id = $ledger_item['customer_id'];
                $ledger_block_id = $ledger_item['block_id'];

                // Get customer name
                $lopped_customer_name = '';
                if ($ledger_customer_id) {
                    $cust_query = mysqli_query($conn, "SELECT `name` FROM `customers` WHERE `id` = '$ledger_customer_id'");
                    $cust_data = mysqli_fetch_assoc($cust_query);
                    $lopped_customer_name = $cust_data['name'] ?? '';
                }

                // Get block name
                $ledger_block_name = '';
                if ($ledger_block_id) {
                    $block_query = mysqli_query($conn, "SELECT `name` FROM `branch_categories` WHERE `id` = '$ledger_block_id'");
                    $block_data = mysqli_fetch_assoc($block_query);
                    $ledger_block_name = $block_data['name'] ?? '';
                }
                ?>
                <option value="<?= $ledger_id ?>">
                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[<?= $ledger_gcode ?>]
                    <?= $lopped_customer_name ? $lopped_customer_name . ' - ' : '' ?>
                    <?= $ledger_name ?>
                    <?= $ledger_block_name ? "($ledger_block_name)" : '' ?>
                </option>
                <?php
            }
        }
    }
    ?>
</select>

							<span class="p4"></span> 
					</div>
				</td>
				<td>
					<div class="form-group-entryitem">
						<input type="number" name="dr_amount[]" value="" class="dr-item form-control someClass dr_amount">
					</div>
				</td>
				<td>
					<div class="form-group-entryitem">
						<input type="number" name="cr_amount[]" value="" class="cr-item form-control credit cr_amount">
					</div>
				</td>
				<td style="width:29%">
					<div class="form-group-entryitem">
						<input type="text" value="" name="narration[]" class="form-control narration">
					</div>
				</td>
				<td>
					<span class="deleterow glyphicon glyphicon-trash" escape="false"></span>
				</td>
			</tr>
			<tr class="check_info">
											<td>
											<div class="form-group-entryitem">
												<input type="text" name="check_num[]" value="" class="form-control" placeholder="Check Number">
											</div>
										</td>
										<td>
											<div class="form-group-entryitem">
												<input type="text" name="check_name[]" value="" class="form-control" placeholder="Check Name">
											</div>
										</td>
										<td>
											<div class="form-group-entryitem">
												<input type="text" name="check_date[]" value="" class="form-control"  placeholder="Check Date">
											</div>
										</td>
										<td style="width:29%">
											<div class="form-group-entryitem">
												<input type="text" value="" name="check_details[]" class="form-control" placeholder="Check Details">
											</div>
										</td>
										<td>
											<select name="check_to[]" class="form-control">
												<option value="1">Customer</option>
												<option value="2">Supplier</option>
												<option value="3">Land Owner</option>
											</select>
										</td>

			</tr>

			<tr>
				<td>
					<div class="">
					
						<select name="ledger_id[]" class="form-control select2-hidden-accessible chosen form-control"
    tabindex="-1" aria-hidden="true"
    style="width: 322px;text-align: center;padding: 10px 0px 0px 0px;margin-top: 12px !important;"
    required="required">
    <option value="0">Please Select</option>

    <?php
    $control_query = mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `branch_id` = '$branch_id'");
    while ($control_items = mysqli_fetch_assoc($control_query)) {
        $control_account_id = $control_items['id'];
        $control_account_name = htmlspecialchars($control_items['name'], ENT_QUOTES);
        $control_gcode = $control_items['gcode'];
        ?>
        <option value="<?= $control_account_id ?>" disabled style="color:#23527c;font-weight:900;">
            <b>&nbsp;&nbsp;&nbsp;[<?= $control_gcode ?>] <?= $control_account_name ?></b>
        </option>
        <?php
        $general_query = mysqli_query($conn, "SELECT * FROM `general_ledgers` WHERE `branch_id` = '$branch_id' AND `control_account_id` = '$control_account_id'");
        while ($general_item = mysqli_fetch_assoc($general_query)) {
            $general_ledger_id = $general_item['id'];
            $general_ledger_name = htmlspecialchars($general_item['name'], ENT_QUOTES);
            $general_ledger_gcode = $general_item['gcode'];
            ?>
            <option value="<?= $general_ledger_id ?>" disabled style="color:#72afd2;font-weight:900;">
                <b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[<?= $general_ledger_gcode ?>] <?= $general_ledger_name ?></b>
            </option>
            <?php
            $ledger_query = mysqli_query($conn, "SELECT * FROM `ledgers` WHERE `branch_id` = '$branch_id' AND `control_account_id` = '$control_account_id' AND `general_ledger_id` = '$general_ledger_id'");
            while ($ledger_item = mysqli_fetch_assoc($ledger_query)) {
                $ledger_id = $ledger_item['id'];
                $ledger_name = htmlspecialchars($ledger_item['name'], ENT_QUOTES);
                $ledger_gcode = $ledger_item['gcode'];
                $ledger_customer_id = $ledger_item['customer_id'];
                $ledger_block_id = $ledger_item['block_id'];

                // Get customer name
                $lopped_customer_name = '';
                if ($ledger_customer_id) {
                    $cust_query = mysqli_query($conn, "SELECT `name` FROM `customers` WHERE `id` = '$ledger_customer_id'");
                    if ($cust_data = mysqli_fetch_assoc($cust_query)) {
                        $lopped_customer_name = htmlspecialchars($cust_data['name'], ENT_QUOTES);
                    }
                }

                // Get block name
                $ledger_block_name = '';
                if ($ledger_block_id) {
                    $block_query = mysqli_query($conn, "SELECT `name` FROM `branch_categories` WHERE `id` = '$ledger_block_id'");
                    if ($block_data = mysqli_fetch_assoc($block_query)) {
                        $ledger_block_name = htmlspecialchars($block_data['name'], ENT_QUOTES);
                    }
                }

                ?>
                <option value="<?= $ledger_id ?>">
                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                    [<?= $ledger_gcode ?>]
                    <?= $lopped_customer_name ? $lopped_customer_name . ' - ' : '' ?>
                    <?= $ledger_name ?>
                    <?= $ledger_block_name ? "($ledger_block_name)" : '' ?>
                </option>
                <?php
            }
        }
    }
    ?>
</select>

							<span class="p4"></span> 
					</div>
				</td>
				<td>
					<div class="form-group-entryitem">
						<input type="number" name="dr_amount[]" value="" class="dr-item form-control someClass dr_amount">
					</div>
				</td>
				<td>
					<div class="form-group-entryitem">
						<input type="number" name="cr_amount[]" value="" class="cr-item form-control credit cr_amount">
					</div>
				</td>
				<td style="width:29%">
					<div class="form-group-entryitem">
						<input type="text" value="" name="narration[]" class="form-control narration">
					</div>
				</td>
				<td>
					<span class="deleterow glyphicon glyphicon-trash" escape="false"></span>
				</td>
			</tr>
			<tr class="check_info">
											<td>
											<div class="form-group-entryitem">
												<input type="text" name="check_num[]" value="" class="form-control" placeholder="Check Number">
											</div>
										</td>
										<td>
											<div class="form-group-entryitem">
												<input type="text" name="check_name[]" value="" class="form-control" placeholder="Check Name">
											</div>
										</td>
										<td>
											<div class="form-group-entryitem">
												<input type="text" name="check_date[]" value="" class="form-control"  placeholder="Check Date">
											</div>
										</td>
										<td style="width:29%">
											<div class="form-group-entryitem">
												<input type="text" value="" name="check_details[]" class="form-control" placeholder="Check Details">
											</div>
										</td>
										<td>
											<select name="check_to[]" class="form-control">
												<option value="1">Customer</option>
												<option value="2">Supplier</option>
												<option value="3">Land Owner</option>
											</select>
										</td>

			</tr>


		</tbody>
	</table>
	<table class="text-right diff-table" style="width:100%;padding:0px">
		<tbody>
		
		
			<tr class="bold-text">
				<td style="width:30%;text-align:left"><b>Total</b></td>
				<td id="dr-total" style="background-color: rgb(255, 255, 153);width:170px;text-align:center">0</td>
				<td id="cr-total" style="background-color: rgb(255, 255, 153);width:170px;text-align:center">0</td>
				<td style="text-align:center;width:29%"><span class="recalculate" escape="false"><i class="glyphicon glyphicon-refresh"></i></span></td>
				<td style="text-align:center;cursor:pointer"><span class="addrow" escape="false"><a name="xd" id="xd"><i class="fa fa-plus fa-x" aria-hidden="true"></i></a></span></td>
			</tr>
			<tr class="bold-text" style="border-bottom:1px solid #eee">
				<td style="text-align:left"><b>Difference</b></td>
				<td id="dr-diff"></td>
				<td id="cr-diff"></td>
			</tr>
		</tbody>
	</table><br>
	<div class="form-group">
		<input type="submit" onclick="return confirm('Are You Sure You Want To Submit?');" name="submit" id="disabler" value="Submit" class="btn btn-success">
		<span class="link-pad"></span><a href="branch_page.php?branch_id=<?= $branch_id ?>" onclick="return confirm('Are You Sure You Want To Cancel The Entry?');" class="btn btn-default">Cancel</a>
	</div>
</form>

<script src="https://cdn.jsdelivr.net/jquery.validation/1.16.0/jquery.validate.min.js"></script>
<script src="https://cdn.jsdelivr.net/jquery.validation/1.16.0/additional-methods.min.js"></script>
			
</div>
</div>


</div>
</div>

</div>
<!-- /.row -->
</section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
 <!-- Footer -->
  <?php include("inc/footer.php"); ?>

  <!-- Control Sidebar -->
  <?php include("inc/aside.php"); ?>
</div>

      <style type="text/css">
      .demo { position: relative; }
      .demo i {
        position: absolute; bottom: 10px; right: 24px; top: auto; cursor: pointer;
      }
      </style>

<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<!-- Bootstrap 3.3.6 -->
<!-- DataTables -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
<!-- page script -->
<script>

  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
  
    /* for selecting with input*/
  $(".chosen").chosen();
</script>

  <script src="//ajax.aspnetcdn.com/ajax/jquery.validate/1.9/jquery.validate.min.js"></script>
  
  <!-- jQuery Form Validation code -->
  <script>
  
  // When the browser is ready...
$(document).ready(function() {
$('.check_info').hide();
$('.check_box').change(function(){
    if($('.check_box:checked').length==0){
        $('.check_info').hide();
    }else{
        $('.check_info').show();
        $('.check_box:checked').each(function(){
            $('#'+$(this).attr('data-ptag')).hide();
        });
    }
    
});

  $('#register-form').submit(function() {
        var error = 0;
		var ledger_id = $('.ledger_id').val();	
		var dr_amount = $('.dr_amount').val();
		var cr_amount = $('.cr_amount').val();		
		if (dr_amount == '' && cr_amount == '') {
            error = 1;
			$(".p5").text("please choose dr or cr");
			$(".p5").css("color", "red");
			alert('please choose dr or cr');
			
        }		
        if (ledger_id == '0') {
            error = 1;
			$(".p4").text("Please Select Ledger id");
			$(".p4").css("color", "red");
        }

        if (error) {
            return false;
        } else {
            return true;
        }

    });
	





   $("#register-form").validate({
    
        // Specify the validation rules
        rules: {
			entydate: "required",
			voucher_no: "required",
			
        },
        
        // Specify the validation error messages
        messages: {
            entydate: "Please Enter Entery Date",
			voucher_no: "Please Enter Voucher No"
        },
        
        submitHandler: function(form) {
            form.submit();
        }
    });

	 
  
});    


//ajax add student end



</script>

<!-- Date range Picker start -->
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css"/>

<script>
	$('body').on('click', "#xd", function() {
		/*  For Cheque Date after clicking add row  */
		var date_input=$('input[name="check_date[]"]'); //our date input has the name "date"
		var container=$('.bootstrap-iso form').length>0 ? $('.bootstrap-iso form').parent() : "body";
		date_input.datepicker({
			format: 'yyyy-mm-dd',
			container: container,
			todayHighlight: true,
			autoclose: true,
		});	
});
	$('.check_date').click(function() {
	
	});

	$(document).ready(function(){
		
		/*  For Cheque Date  */
		var date_input=$('input[name="check_date[]"]'); //our date input has the name "date"
		var container=$('.bootstrap-iso form').length>0 ? $('.bootstrap-iso form').parent() : "body";
		date_input.datepicker({
			format: 'yyyy-mm-dd',
			container: container,
			todayHighlight: true,
			autoclose: true,
			<?php if($count_1 > 0 && !$privileges['previousDate']){ ?>startDate: '-0m',<?php }?>
		});

		var date_input=$('input[name="entydate"]'); //our date input has the name "date"
		var container=$('.bootstrap-iso form').length>0 ? $('.bootstrap-iso form').parent() : "body";
		date_input.datepicker({
			format: 'yyyy-mm-dd',
			container: container,
			todayHighlight: true,
			autoclose: true,
			<?php if($count_1 > 0 && !$privileges['previousDate']){ ?>startDate: '-0m',<?php }?>
		});
			
		
		var count = 1;
			
        $('#xd').click(function() {
			
			var count = count+1;
			
            var lines = "";
            
			lines += '<tr>';
			lines += '<td>';
					lines += '<div class="">';
						lines += '<select  class="form-control select2-hidden-accessible chosen form-control "  name="ledger_id[]" tabindex="-1" aria-hidden="true" style="width: 322px;text-align: center;padding: 10px 0px 0px 0px;margin-top: 12px !important;" required>';
								lines += '<option value="">Please Select</option>';
								<?php $control_query = mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `branch_id` = '$branch_id'");
										while($control_items=mysqli_fetch_assoc($control_query)){
											$control_account_id = $control_items['id'];
											$control_account_name = mysqli_real_escape_string($conn, $control_items['name']);
											$control_gcode = $control_items['gcode'];?>													
								lines += '<option value="<?=$control_account_id?>" disabled="" style="color:#23527c;font-weight:900;""><b>&nbsp;&nbsp;&nbsp;[<?=$control_gcode?>] <?=$control_account_name?></b></option>';
								<?php $general_query = mysqli_query($conn, "SELECT * FROM `general_ledgers` WHERE `branch_id` = '$branch_id' AND `control_account_id` = '$control_account_id' ");
										while($general_item=mysqli_fetch_assoc($general_query)){
											 $general_ledger_id = $general_item['id'];
											 $general_ledger_branch_id = $general_item['branch_id'];
											 $general_ledger_controller_id = $general_item['control_account_id'];
											 $general_ledger_name = mysqli_real_escape_string($conn, $general_item['name']);
											 $general_ledger_gcode = $general_item['gcode'];
								?>
								lines += '<option value="<?=$general_ledger_id?>" disabled="" style="color:#72afd2;font-weight:900;"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[<?=$general_ledger_gcode?>] <?=$general_ledger_name?></b></option>';
								<?php $ledger_query=mysqli_query($conn, "SELECT * FROM `ledgers` WHERE `branch_id` = '$branch_id' AND `control_account_id` = '$control_account_id' AND `general_ledger_id` = '$general_ledger_id' ");
										while($ledger_item=mysqli_fetch_array($ledger_query)){
											 $ledger_id = $ledger_item['id'];
											 $ledger_branch_id = $ledger_item['branch_id'];
											 $ledger_controller_id = $ledger_item['control_account_id'];
											 $ledger_customer_id = $ledger_item['customer_id'];
											 $ledger_block_id = $ledger_item['block_id'];
											 $ledger_name = mysqli_real_escape_string($conn, $ledger_item['name']);
											 $ledger_gcode = $ledger_item['gcode'];

											 $lopped_customer_query=mysqli_query($conn, "SELECT * FROM `customers` WHERE `id` = '$ledger_customer_id'");
											while($lopped_customer_row=mysqli_fetch_array($lopped_customer_query)){
											 $lopped_customer_id=$lopped_customer_row['id'];
											 $lopped_customer_name=$lopped_customer_row['name'];
											}

											$select_query_block=mysqli_query($conn, "SELECT * FROM `branch_categories` WHERE `id` = '$ledger_block_id'");
											  while($row_block=mysqli_fetch_array($select_query_block)){
											       $ledger_block_name = $row_block['name'];
											  }

											 ?>
								lines += '<option value="<?=$ledger_id?>">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[<?=$ledger_gcode?>]  <?php if($ledger_customer_id == $lopped_customer_id){ echo $lopped_customer_name; } ?> <?=$ledger_name?> <?php if($ledger_block_id){ echo '('.$ledger_block_name.')'; } ?></option>';
										<?php }
										}
									}
									?>
						lines += '</select>';
						lines += '<span class="p4"></span>'; 
					lines += '</div>';
				lines += '</td>';
				lines += '<td>';
				lines += '	<div class="form-group-entryitem">';
				lines += '		<input type="number"  name="dr_amount[]" value="" class="dr-item form-control debit dr_amount">';
				lines += '	</div>';
				lines += '</td>';
				lines += '<td>';
				lines += '	<div class="form-group-entryitem">';
				lines += '		<input type="number" name="cr_amount[]" value="" class="cr-item form-control credit cr_amount">';
				lines += '	</div>';
				lines += '</td>'; 	 	
				lines += '<td style="width:29%">';
				lines += '	<div class="form-group-entryitem">';
				lines += '		<input type="text"  name="narration[]" value="" class=" form-control">';
				lines += '	</div>';
				lines += '</td>';
				lines += '<td>';
				lines += '	<a type="button" value="Delete" onclick="deleteRow(this)" class="deleterow glyphicon glyphicon-trash" style="cursor:pointer" escape="false"></a>';
				lines += '</td>';
            lines += '</tr>';
            lines += '<tr class="check_info" style="display:none">';
            	 lines += '<td>';
											 lines += '<div class="form-group-entryitem">';
												 lines += '<input type="text" name="check_num[]" value="" class="form-control" placeholder="Check Number">';
											 lines += '</div>';
										 lines += '</td>';
										 lines += '<td>';
											 lines += '<div class="form-group-entryitem">';
												 lines += '<input type="text" name="check_name[]" value="" class="form-control" placeholder="Check Name">';
											 lines += '</div>';
										 lines += '</td>';
										 lines += '<td>';
											 lines += '<div class="form-group-entryitem">';
												 lines += '<input type="text" name="check_date[]" value="" class="form-control"  placeholder="Check Date">';
											 lines += '</div>';
										 lines += '</td>';
										 lines += '<td style="width:29%">';
										 lines += '<div class="form-group-entryitem">';
										 lines += '<input type="text" value="" name="check_details[]" class="form-control" placeholder="Check Details">';
										 lines += '</div>';
										 lines += '</td>';
										lines += '<td>';
											lines += '<select name="check_to[]" class="form-control">';
												lines += '<option value="1">Customer</option>';
												lines += '<option value="2">Supplier</option>';
												lines += '<option value="3">Land Owner</option>';
											lines += '</select>';
										lines += '</td>';
										
			lines += '</tr>';
			
            $('#TableBody').append(lines);
            sumOfColumns();
			}); 
			
			$(document).on('click', '#xd', function() {
			$(".chosen").chosen();
			});

			 function deleteRow(btn) {
				var row = btn.parentNode.parentNode;
				row.parentNode.removeChild(row);
				sumOfColumns();
			}

			+$("#tbUser").on('click', '.deleterow', function () {
			    $(this).closest('tr').next().remove();
			});
		
			function sumOfColumns(){
		
				var totalDebit = 0;
				var totalCredit = 0;
				$(".debit").each(function(){
					totalDebit += parseInt($(this).val());
					$(".totalDebit").html(totalDebit);
				});
		
				$(".credit").each(function(){
					totalCredit += parseInt($(this).val());
					$(".totalCredit").html(totalCredit);
				});
			}
	});	
	  
</script>


  </body>
</html>
