<?php 
ob_start();
session_start();
include("db.php");

$date = date('Y-m-d');

// Check login
if (!isset($_SESSION['user_email'])) {
    header("location:login.php?login=failed");
    exit;
}

$user_email = $_SESSION['user_email'];

// Get manager info
$select_query_q = "SELECT * FROM `managers` WHERE `email` = '$user_email'";
$result_q = mysqli_query($conn, $select_query_q);

$branch_id = '';
$M_name = '';

while ($rowq = mysqli_fetch_assoc($result_q)) {
    $branch_id = $rowq['branch_id'];
    $M_name = $rowq['name'];
}
$count_1 = mysqli_num_rows($result_q);

// Get branch ID from URL
$branch_id_s = $_GET['branch_id'] ?? '';

if ($count_1 > 0 && $branch_id_s != $branch_id) {
    header("location:javascript://history.go(-1)");
    exit;
}

// Get branch info
$select_query = "SELECT * FROM `branches` WHERE `id` = '$branch_id_s'";
$result_query = mysqli_query($conn, $select_query) or die($select_query . "<br/><br/>" . mysqli_error($conn));

while ($row = mysqli_fetch_assoc($result_query)) {
    $branch_id = $row['id'];
    $branch_name = $row['name'];
    $branch_image = $row['image'];
    $branch_location = $row['location'];
    $branch_phone = $row['branch_phone'];
    $square_feet_size = $row['square_feet_size'];
}

// Get manager info for this branch
$manager_name = $manager_email = $manager_phone = '';
$select_query4 = "SELECT * FROM `managers` WHERE `branch_id` = '$branch_id'";
$result_query4 = mysqli_query($conn, $select_query4) or die($select_query4 . "<br/><br/>" . mysqli_error($conn));

while ($row4 = mysqli_fetch_assoc($result_query4)) {
    $manager_name = $row4['name'];
    $manager_email = $row4['email'];
    $manager_phone = $row4['phone'];
}
?>

<!DOCTYPE html>
<html>
<head>
<meta charset=utf-8>
<meta http-equiv=X-UA-Compatible content="IE=edge">
<title>Annual Recovery</title>
<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name=viewport>
<link rel=stylesheet href=bootstrap/css/bootstrap.min.css>
<link rel=stylesheet href=https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css>
<link rel=stylesheet href=https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css>
<link rel=stylesheet href=plugins/datatables/dataTables.bootstrap.css>
<link rel=stylesheet href=dist/css/AdminLTE.min.css>
<link rel=stylesheet href=dist/css/skins/_all-skins.min.css>
<link href=dist/css/style.css rel=stylesheet type=text/css>
<script src=//ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js></script>
<script type=text/javascript>$(window).load(function(){$(".loader").fadeOut("slow")});</script>
<script src=bootstrap/js/bootstrap.min.js></script>
<script src=plugins/jQuery/choosen.js></script>
<link href=dist/css/chosen.css rel=stylesheet type=text/css>
<Style>@media print{ .no-show-print{ display: none; }.no-history,.no-show{display:none}.print-header *{visibility:visible}th,td{padding:5px!important;border:1px solid black; font-size:80%}table{ outline: 1px solid black; }body *{visibility:hidden}#section-to-print,#section-to-print *{visibility:visible}#section-to-print{margin-top:100px}.balancesheet,.sheet-info,.defining-colors{display:none}}th{text-align:center}.print-header{width:100%;visibility:hidden;position:absolute}.middles th,td{vertical-align:middle!important}.recover-table{overflow:scroll}.recover-table th,td{padding:5px}.box-covers{margin:5px}.box-covers span{font-weight:bold;margin-left:5px}.little-boxes{margin:3px;height:15px;width:15px;border:1px solid lightgrey;float:left}.loader{position:fixed;left:0;top:0;width:100%;height:100%;z-index:9999;background:url('dist/img/page-loader.gif') 50% 50% no-repeat #f9f9f9}</style>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class=loader></div>
<div class=wrapper>
<header class=main-header>
<?php  include('inc/main-header.php');  ?>
</header>
<aside class=main-sidebar>
<?php  include('inc/main-sidebar.php');  ?>
</aside>
<?php include('inc/calculator.php'); ?>
<div class=content-wrapper>
<section class=content-header>
<h1> Annual Recovery</h1>
<ol class=breadcrumb>
<?php if($count_1 > 0){ }else{ ?>
<li><a href=index.php><i class="fa fa-home"></i> Home</a></li>
<?php  } ?>
<li><a href="branch_page.php?branch_id=<?= $branch_id ?>">
<?php if($count_1 > 0){ ?>
<i class="fa fa-home"></i> Home
<?php }else{ echo $branch_name; } ?>
</a></li>
<li class=active>Annual Recovery</li>
</ol>
</section>
<section class=content>
<div class=row>
<div class=print-header>
<div class=page-header>
<div style=width:35%;float:left;text-align:center><img src=<?=$branch_image?> alt style=width:120px;height:80px;border-radius:5% /></div>
<div style=width:30%;max-height:120px;float:left;text-align:justify>
<div style=text-align:center;float:left>
<h2 style=font-weight:bold;>
<?=$branch_name?>
</h2>
<h5>
<?=$branch_location?>
</h5>
<h5>
<?=$branch_phone?>
</h5>
</div>
</div>
<div style=width:35%;float:left;text-align:center;padding-top:50px>
<h5>User:-
<?php if($manager_name){ echo $manager_name; }else{ echo 'Admin'; } ?>
</h5>
<h5>Print Date:- <?php echo date("d M Y", strtotime($date))?></h5>
</div>
</div>
</div>
<div class=col-xs-12>
<div class="box box-primary">
<div class="box-header with-border"> </div>
<div class=box-body>
<div class="balancesheet form">
<form role=form id=form-customer method=post action accept-charset=utf-8>
<div class=row>
	<div class=col-md-5>
		<div class=form-group>
		<label>Floor</label>
		<br>
		<select name=block id=block class="form-control select2-hidden-accessible chosen" tabindex=-1 aria-hidden=true style="text-align:center;padding:10px 0 0 0;margin-top:12px!important" required>
		<?php  $block_query=mysqli_query($conn,"SELECT * FROM `branch_categories` WHERE `branch_id` = '$branch_id'");
		while($block_item=mysqli_fetch_assoc($block_query)){
			 $block_id = $block_item['id'];
			 $block_name = $block_item['name'];
			 ?>
		<option value=<?=$block_id?>>
		<?=$block_name?>
		</option>
		<?php } ?>
		</select>
		</div>
	</div>
	<div class=col-md-5>
		<div class=form-group>
		<label>Year</label>
		<br>
			<select name=year id=year class="form-control select2-hidden-accessible chosen" tabindex=-1 aria-hidden=true style="text-align:center;padding:10px 0 0 0;margin-top:12px!important" required>
			<?php for($j = 2010; $j <= 2050 ; $j ++){ ?>
			<option value=<?=$j?> <?php if($j == date('Y')){ echo 'selected'; } ?>>
			<?=$j?>
			</option>
			<?php } ?>
			</select>
		</div>
	</div>
<div class=col-md-2>
<div class=form-group style=padding:20px>
<input type=submit name=submit id=submit class="btn btn-primary" value=Submit>
</div>
</div>
</div>
</div>
</div>
</div>
<?php if(isset($_POST['submit'])){  
$year = trim($_POST['year']);
$block_id = trim($_POST['block']);

$block_query=mysqli_query($conn, "SELECT * FROM `branch_categories` WHERE `id` = '$block_id'");
while($block_row=mysqli_fetch_assoc($block_query)){
$block_name =$block_row['name']; }

function month_name($month){

switch ($month) {
	case '01':
		$month_name='January';
		break;
	case '02':
		$month_name='Feburary';
		break;
	case '03':
		$month_name='March';
		break;
	case '04':
		$month_name='April';
		break;
	case '05':
		$month_name='May';
		break;
	case '06':
		$month_name='June';
		break;
	case '07':
		$month_name='July';
		break;
	case '08':
		$month_name='Agaust';
		break;
	case '09':
		$month_name='September';
		break;
	case '10':
		$month_name='October';
		break;
	case '11':
		$month_name='November';
		break;
	case '12':
		$month_name='December';
		break;

	default:
		$month_name='Month';
		break;
	}
	return $month_name;
}

 ?>

          <div class="box box-primary">
            <div class="box-header">
            </div>
            <!-- /.box-header -->
            <div class="box-body no-padding" id="section-to-print">
            	<h3 class="text-center">Annual Report of <?=$year?> (<?=$block_name?>)</h3>
              <table class="table table-striped">
                <tr>
                  <th>Month</th>
                  <th class="text-right">Amount</th>
                  <th class="no-show-print">Average</th>
                  <th class="no-show-print" style="width: 40px">%</th>
                </tr>
<?php
for ($m = 1; $m <= 12; $m++) {
    $month = str_pad($m, 2, '0', STR_PAD_LEFT); // e.g., 01, 02...12

    $total_installment_amounts = 0;
    $total_advances = 0;
    $total_amounts_allyear = 0;
    $total_advances_year = 0;
    $amount_all_year = 0;

    // Get advance amount (current month)
    $booking_query = mysqli_query($conn, "SELECT * FROM `book_plot` WHERE `branch_id` = '$branch_id' AND `block_id` = '$block_id' AND DATE_FORMAT(date,'%Y%m') = '$year$month'");
    while ($booking_row = mysqli_fetch_assoc($booking_query)) {
        $advance_amount = $booking_row['advance_amount'];
        $total_advances += $advance_amount;
    }

    // Get installment amount (current month)
    $installment_query = mysqli_query($conn, "SELECT * FROM `installments` WHERE `branch_id` = '$branch_id' AND `block_id` = '$block_id' AND DATE_FORMAT(date_of_installment,'%Y%m') = '$year$month'");
    while ($installment_row = mysqli_fetch_assoc($installment_query)) {
        $installment_amount = $installment_row['payment_per_installment'];
        $total_installment_amounts += $installment_amount;
    }

    $amount = $total_installment_amounts + $total_advances;

    // Total installments in the year
    $whole_year_query = mysqli_query($conn, "SELECT * FROM `installments` WHERE `branch_id` = '$branch_id' AND `block_id` = '$block_id' AND DATE_FORMAT(date_of_installment,'%Y') = '$year'");
    while ($whole_year_row = mysqli_fetch_assoc($whole_year_query)) {
        $whole_year_amount = $whole_year_row['payment_per_installment'];
        $total_amounts_allyear += $whole_year_amount;
    }

    // Total advances in the year
    $booking_year_query = mysqli_query($conn, "SELECT * FROM `book_plot` WHERE `branch_id` = '$branch_id' AND `block_id` = '$block_id' AND DATE_FORMAT(date,'%Y') = '$year'");
    while ($booking_year_row = mysqli_fetch_assoc($booking_year_query)) {
        $advance_amount_year = $booking_year_row['advance_amount'];
        $total_advances_year += $advance_amount_year;
    }

    $amount_all_year = $total_amounts_allyear + $total_advances_year;

    // Avoid division by zero
    $average = ($amount_all_year > 0) ? ($amount / $amount_all_year) * 100 : 0;

    $running_month = month_name($month); // assuming this function returns month name
    // Now you can display or use $running_month and $average

?>

	<tr>
	  <td class="text-center"><?=$running_month?></td>
	  <td class="text-right"><?php echo number_format($amount); ?></td>
	  <td class="no-show-print">
	    <div class="progress progress-xs progress-striped">
	      <div class="progress-bar progress-bar-primary" style="width: <?=$average?>%"></div>
	    </div>
	  </td>
	  <td class="no-show-print"><span class="badge bg-light-blue"><?php echo number_format((float)$average, 1, '.', ''); ?>%</span></td>
    </tr>
<?php } ?>
	<tr>
	  <th>Total</th>
	  <th class="text-right"><?php echo number_format($amount_all_year); ?></th>
	  <th class="no-show-print"></th>
	  <th class="no-show-print" style="width: 40px"></th>
	</tr>

              </table>
            </div>
            <!-- /.box-body -->
          </div>
<?php 
}?>
<?php if(isset($_POST['submit'])){  ?>
<center>
<button onclick=myFunction() class="btn btn-primary">Generate Print</button>
</center>
<?php } ?>
</div>
</section>
</div>
<?php include("inc/footer.php"); ?>
<?php include("inc/aside.php"); ?>
</div>
<script src=plugins/datatables/jquery.dataTables.min.js></script>
<script src=plugins/datatables/dataTables.bootstrap.min.js></script>
<script src=plugins/slimScroll/jquery.slimscroll.min.js></script>
<script src=plugins/fastclick/fastclick.js></script>
<script src=dist/js/app.min.js></script>
<script src=dist/js/demo.js></script>
<script>$(function(){$("#example1").DataTable();$("#example2").DataTable({paging:true,lengthChange:false,searching:false,ordering:true,info:true,autoWidth:false})});jQuery(document).ready(function(a){a(".clickable-row").click(function(){window.location=a(this).data("href")})});$(".chosen").chosen();</script>
<script>function myFunction(){window.print()}$("#submit").click(function(){$(".loader").fadeIn("slow")});</script>
</body>
</html>