<?php 
ob_start();
session_start();
include("db.php"); // Make sure $conn = new mysqli(...) is defined here

if (!isset($_SESSION['user_email'])) {
    header("Location: login.php?login=failed");
    exit;
}

$user_email = $_SESSION['user_email'];

// Show session alert message
if (isset($_SESSION['control'])) {
    $message = $_SESSION['control']; 
    echo "<script>alert('{$message}');</script>";
    unset($_SESSION["control"]);
}

// Get manager info
$branch_id = '';
$M_name = '';

$stmt = $conn->prepare("SELECT branch_id, name FROM managers WHERE email = ?");
$stmt->bind_param("s", $user_email);
$stmt->execute();
$result = $stmt->get_result();
$count_1 = $result->num_rows;

if ($row = $result->fetch_assoc()) {
    $branch_id = $row['branch_id'];
    $M_name = $row['name'];
}
$stmt->close();

// Validate GET parameter
$branch_id_s = $_GET['branch_id'] ?? null;

if (!$branch_id_s || ($count_1 > 0 && $branch_id_s != $branch_id)) {
    header("Location: javascript://history.go(-1)");
    exit;
}

// Get branch info
$stmt2 = $conn->prepare("SELECT id, name, image, square_feet_size FROM branches WHERE id = ?");
$stmt2->bind_param("i", $branch_id_s);
$stmt2->execute();
$result2 = $stmt2->get_result();

if ($row = $result2->fetch_assoc()) {
    $branch_id = $row['id'];
    $branch_name = $row['name'];
    $branch_image = $row['image'];
    $square_feet_size = $row['square_feet_size'];
} else {
    echo "Branch not found.";
    exit;
}
$stmt2->close();
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Post Dated Cheques To Suppliers</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
  <link href="dist/css/style.css" rel="stylesheet" type="text/css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
 <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
 <script src="bootstrap/js/bootstrap.min.js"></script>
<Style>
th {
  text-align:center;
}
.middles th,td
{
  vertical-align: middle !important;
  white-space: nowrap;
}
.recover-table
{
  overflow: scroll;
}
.recover-table th,td
{
  padding: 10px;
} 
</Style>
</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <header class="main-header">
    <!-- Logo -->
 <?php  include('inc/main-header.php');  ?>
    </header>
  <!-- Left side column. contains the logo and sidebar -->
    <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
 <?php  include('inc/main-sidebar.php');  ?>
  </aside>
<?php include('inc/calculator.php'); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Post Dated Cheques To Suppliers
        <small><?=$branch_name?></small>
      </h1>
      <ol class="breadcrumb">
        <?php if($count_1 > 0){ }else{ ?>
        <li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
        <?php  } ?>
        <li><a href="branch_page.php?branch_id=<?= $branch_id ?>"><?php if($count_1 > 0){ ?><i class="fa fa-home"></i> Home <?php }else{ echo $branch_name; } ?></a></li>
        <li class="active"> Cheques To Suppliers</li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-xs-12">
        

          <div class="box box-primary">
            <div class="box-header">
   <?php 

   $select_query_all_payments=mysqli_query($conn, "SELECT * FROM `all_payments` WHERE `branch_id` = '$branch_id' AND `check_num` != '' AND `check_to` = '2' ORDER BY `date` ASC;");
   if(mysqli_num_rows($select_query_all_payments) > 0 || isset($selected_ledger_balance) != 0){ 
                ?>
            <div style="overflow: auto;">
              <table id="" class="table table-bordered" style="text-align:center; font-size:12px;">

              <thead>
                <tr class="middles">
                  <th>Date</th>
                  <th>Vchr#</th>
                  <th>Ledger</th>
                  <th>Details</th>
                  <th>Description</th>
                  <th>Cheque No.</th>
                  <th>Name/Cheque</th>
                  <th>Date/Cheque</th>
                  <th>Dr Amount (RS)</th>
                  <th>Cr Amount (RS)</th>
                  <th>Balance (RS)</th>
                  <th>Forward</th>
                </tr>
              </thead>
                <tbody>
<?php
$total_debit = 0;
$total_credit = 0;
$specific_balance = 0;
$total_entries = 0;

while ($row_q = $select_query_all_payments->fetch_assoc()) {
    $enrty_id = $row_q['id'];
    $voucher_no = $row_q['voucher_no'];
    $voucher_type = $row_q['voucher_type'];
    $selected_ledger_id = $row_q['ledger_id'];
    $debit = $row_q['debit'];
    $credit = $row_q['credit'];
    $narration = $row_q['narration'];
    $entrydate = $row_q['date'];
    $check_num = $row_q['check_num'];
    $check_name = $row_q['check_name'];
    $check_date = $row_q['check_date'];
    $check_details = $row_q['check_details'];

    $total_entries++;
    $total_debit += $debit;
    $total_credit += $credit;

    // Get ledger info
    $stmt_ledger = $conn->prepare("SELECT name, block_id, customer_id FROM `ledgers` WHERE `branch_id` = ? AND `id` = ?");
    $stmt_ledger->bind_param("ii", $branch_id, $selected_ledger_id);
    $stmt_ledger->execute();
    $result_ledger = $stmt_ledger->get_result();
    $ledger_name = $ledger_block_id = $ledger_customer_id = null;

    if ($ledger_row = $result_ledger->fetch_assoc()) {
        $ledger_name = $ledger_row['name'];
        $ledger_block_id = $ledger_row['block_id'];
        $ledger_customer_id = $ledger_row['customer_id'];
    }
    $stmt_ledger->close();

    // Get block name
    $ledger_block_name = '';
    if ($ledger_block_id !== null) {
        $stmt_block = $conn->prepare("SELECT name FROM `branch_categories` WHERE `id` = ?");
        $stmt_block->bind_param("i", $ledger_block_id);
        $stmt_block->execute();
        $result_block = $stmt_block->get_result();
        if ($block_row = $result_block->fetch_assoc()) {
            $ledger_block_name = $block_row['name'];
        }
        $stmt_block->close();
    }

    // Get customer name
    $lopped_customer_name = '';
    if ($ledger_customer_id !== null) {
        $stmt_customer = $conn->prepare("SELECT name FROM `customers` WHERE `id` = ?");
        $stmt_customer->bind_param("i", $ledger_customer_id);
        $stmt_customer->execute();
        $result_customer = $stmt_customer->get_result();
        if ($cust_row = $result_customer->fetch_assoc()) {
            $lopped_customer_name = $cust_row['name'];
        }
        $stmt_customer->close();
    }

    $specific_balance += $debit;
    $specific_balance -= $credit;
?>

                <tr>
                  <td><?php echo date("d-m-Y", strtotime($entrydate)); ?></td>
                  <td><?=$voucher_no?></td>
                  <td><?php if($ledger_customer_id == $lopped_customer_id){ echo $lopped_customer_name; } ?> <?=$ledger_name?> <?php if($ledger_block_id){ echo '('.$ledger_block_name.')'; } ?></td>
                  <td style="text-align:left;"><?=$check_details?></td>
                  <td style="text-align:left;"><?=$narration?></td>
                  <td><?=$check_num?></td>
                  <td><?=$check_name?></td>
                  <td><?php echo date("d M Y", strtotime($check_date)); ?></td>
                  <td style="text-align:right;"><?php if($debit != '') { echo number_format($debit); }else{ echo '0'; }; ?></td>
                  <td style="text-align:right;"><?php if($credit != '') { echo number_format($credit); }else{ echo '0'; }; ?></td>
                  <td style="text-align:right;"><?php if($specific_balance > 0){ echo 'DR '.number_format(abs($specific_balance)); }elseif($specific_balance < 0) { echo 'CR '.number_format(abs($specific_balance)); }else { echo $specific_balance; };?></td>
                  <td>
                    <a href="edit_entry.php?branch_id=<?=$branch_id?>&voucher_no=<?=$voucher_no?>" class="no-hover btn btn-primary" target="_blank" escape="false">Forward</a>
                  </td>
                </tr>
                <?php } ?>
                <tr>
                  <th colspan="8" style="text-align: left">Totals</th>
                  <th><?php if(isset($total_debit)) { echo number_format($total_debit); } ?></th>
                  <th><?php if(isset($total_debit)){ echo number_format($total_credit); } ?></th>
                  <th></th>
                  <th></th>
                </tr>
                </tbody></table>
              </div>
                 <?php }else{ ?>
                            <div class="alert alert-danger text-center">
                          <button data-dismiss="alert" class="close" type="button">×</button>
                          <p>No Entries To show</p>
                        </div>
                <?php }  ?>
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
 <!-- Footer -->
  <?php include("inc/footer.php"); ?>

  <!-- Control Sidebar -->
  <?php include("inc/aside.php"); ?>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<!-- Bootstrap 3.3.6 -->
<!-- DataTables -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
<!-- page script -->
<script>

  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
   jQuery(document).ready(function($) {
    $(".clickable-row").click(function() {
        window.location = $(this).data("href");
    });
});
</script>

  <script src="//ajax.aspnetcdn.com/ajax/jquery.validate/1.9/jquery.validate.min.js"></script>
  
  <!-- jQuery Form Validation code -->

</body>
</html>
