<?php 
ob_start();
session_start();
include("db.php");

// Check user session
if (!isset($_SESSION['user_email'])) {
    header("Location: login.php?login=failed");
    exit();
}

$user_email = $_SESSION['user_email'];

// Show session message
if (isset($_SESSION['control'])) {
    $message = $_SESSION['control']; 
    echo "<script>alert('".htmlspecialchars($message, ENT_QUOTES)."');</script>";
    unset($_SESSION["control"]);
}

// Escape email
$user_email_escaped = mysqli_real_escape_string($conn, $user_email);

// Fetch manager data
$select_query_q = "SELECT * FROM `managers` WHERE `email` = '$user_email_escaped'";
$result_q = mysqli_query($conn, $select_query_q);

$branch_id = '';
$M_name = '';
$count_1 = mysqli_num_rows($result_q);

while ($rowq = mysqli_fetch_assoc($result_q)) {
    $branch_id = $rowq['branch_id'];
    $M_name = $rowq['name'];
}

// Validate branch ID from GET
$branch_id_s = isset($_GET['branch_id']) ? mysqli_real_escape_string($conn, $_GET['branch_id']) : '';

if ($count_1 > 0 && $branch_id_s !== $branch_id) {
    header("Location: javascript://history.go(-1)");
    exit();
}

// Fetch branch details
$select_query = "SELECT * FROM `branches` WHERE `id` = '$branch_id_s'";
$result_query = mysqli_query($conn, $select_query);

if (!$result_query) {
    die("Query Error: " . mysqli_error($conn));
}

while ($row = mysqli_fetch_assoc($result_query)) {
    $branch_id = $row['id'];
    $branch_name = $row['name'];
    $branch_image = $row['image'];
    $square_feet_size = $row['square_feet_size'];
}

// Fetch control accounts
$control_account_query = mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `branch_id` = '$branch_id'");

while ($row_2 = mysqli_fetch_assoc($control_account_query)) {
    $control_account_id = $row_2['id'];
}
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Control Accounts</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
  <link href="dist/css/style.css" rel="stylesheet" type="text/css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
 <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
 <script src="bootstrap/js/bootstrap.min.js"></script>

</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <header class="main-header">
    <!-- Logo -->
 <?php  include('inc/main-header.php');  ?>
    </header>
  <!-- Left side column. contains the logo and sidebar -->
    <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
 <?php  include('inc/main-sidebar.php');  ?>
  </aside>
<?php include('inc/calculator.php'); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Control Accounts
        <small><?= $branch_name ?></small>
		<a href="add_control_account.php?branch_id=<?= $branch_id ?>" class="btn btn-primary">Add New Control Account</a>
      </h1>
      <ol class="breadcrumb">
        <?php if($count_1 > 0){ }else{ ?>
        <li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
        <?php  } ?>
        <li><a href="branch_page.php?branch_id=<?= $branch_id ?>"><?php if($count_1 > 0){ ?><i class="fa fa-home"></i> Home <?php }else{ echo $branch_name; } ?></a></li>
        <li class="active"> Control Accounts</li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-xs-12">
        

          <div class="box box-primary">
            <div class="box-header">
   <?php
    $numbering = 0;
	$select_query="SELECT * FROM `control_accounts` WHERE `branch_id` = '$branch_id'";
  	$result=mysqli_query($conn, $select_query);
		if(mysqli_num_rows($result) > 0){
	?>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <table id="example1" class="table table-bordered text-center table-hover">
                <thead>
                <tr>
                  <th>SN#</th>
                  <th>Name</th>
                  <th>Description</th>
				          <th>Group Code</th>
                  <th>Registry Date</th>
                  <?php if($count_1 > 0){ }else{?><th>Edit</th><?php } ?>
                  <?php if($count_1 > 0){ }else{?><th>Delete</th><?php } ?>
                </tr>
                </thead>
                <tbody>
   <?php 
  
	
	while($row=mysqli_fetch_assoc($result)){
			 $numbering++;
			 $control_account_id = $row['id'];
			 $control_account_branch_id = $row['branch_id'];
			 $control_account_name = $row['name'];
			 $description = $row['description'];
			 $gcode = $row['gcode'];
			 $creation_date = $row['date'];
			 
?>
                <tr class='clickable-row cursor' data-href='general_ledgers.php?branch_id=<?=$branch_id?>&control_account_id=<?=$control_account_id?>' style="cursor:pointer">
				          <td><?= $numbering; ?></td>
                  <td style="text-align: left"><?= $control_account_name ?></td>
                  <td><?= $description ?></td>
				          <td><?= $gcode ?></td>
                  <td><?= $creation_date ?></td>
                  <?php if($count_1 > 0){ }else{?><td><a href="edit_control_account.php?branch_id=<?=$branch_id?>&control_account_id=<?=$control_account_id?>" class="btn btn-xs btn-block btn-primary">Edit</td><?php } ?>
                    <?php if($count_1 > 0){ }else{?><td><a href="delete_functions.php?control_account_id=<?=$control_account_id?>" onclick="return confirm('Are You sure You Want To Delete?');" class="btn btn-xs btn-block btn-danger">Delete</td><?php } ?>
                </tr>
                <?php } ?>
                </tbody>
                <tfoot>
                </tfoot>
              </table>
               <?php }else{ ?>
                    <b>No Data Found</b>
				<?php }
					$gcode_control = $numbering+1;
					$_SESSION['gcode-control'] = $gcode_control; ?>
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
 <!-- Footer -->
  <?php include("inc/footer.php"); ?>

  <!-- Control Sidebar -->
  <?php include("inc/aside.php"); ?>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<!-- Bootstrap 3.3.6 -->
<!-- DataTables -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
<!-- page script -->
<script>

  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
   jQuery(document).ready(function($) {
    $(".clickable-row").click(function() {
        window.location = $(this).data("href");
    });
});
</script>

  <script src="//ajax.aspnetcdn.com/ajax/jquery.validate/1.9/jquery.validate.min.js"></script>
  
  <!-- jQuery Form Validation code -->

</body>
</html>
