<?php 
ob_start();
session_start();
include("db.php");

// Check if user is logged in
if (!isset($_SESSION['user_email'])) {
    header("Location: login.php?login=failed");
    exit();
}

$user_email = $_SESSION['user_email'];
$user_email_escaped = mysqli_real_escape_string($conn, $user_email);

// Fetch manager info
$select_query_1 = "SELECT * FROM `managers` WHERE `email` = '$user_email_escaped'";
$result_1 = mysqli_query($conn, $select_query_1);

$branch_id = '';
$M_name = '';
$count_1 = mysqli_num_rows($result_1);

while ($row = mysqli_fetch_assoc($result_1)) {
    $branch_id = $row['branch_id'];
    $M_name = $row['name'];
}

// Get branch_id and control_account_id from GET and escape
$branch_id_s = isset($_GET['branch_id']) ? mysqli_real_escape_string($conn, $_GET['branch_id']) : '';
$control_account_id = isset($_GET['control_account_id']) ? mysqli_real_escape_string($conn, $_GET['control_account_id']) : '';

// Validate branch access
if ($count_1 > 0 && $branch_id_s !== $branch_id) {
    header("Location: javascript://history.go(-1)");
    exit();
}

// Alert on session message
if (isset($_SESSION['edit_control'])) {
    $message = $_SESSION['edit_control']; 
    echo "<script>alert('" . htmlspecialchars($message, ENT_QUOTES) . "');</script>";
    unset($_SESSION["edit_control"]);
}

// Fetch branch info
$select_query = "SELECT * FROM `branches` WHERE `id` = '$branch_id_s'";
$result_query = mysqli_query($conn, $select_query);

if (!$result_query) {
    die($select_query . "<br><br>" . mysqli_error($conn));
}

while ($row = mysqli_fetch_assoc($result_query)) {
    $branch_id = $row['id'];
    $branch_name = $row['name'];
    $branch_image = $row['image'];
    $branch_area = $row['area'];
    $square_feet_size = $row['square_feet_size'];
}

// Redirect if session has control flag set
if (isset($_SESSION['control'])) {
    header("Location: control_accounts.php?branch_id=" . $branch_id);
    exit();
}

// Fetch selected control account
$control_account_query = mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `branch_id` = '$branch_id' AND `id` = '$control_account_id'");
if ($control_account_query && mysqli_num_rows($control_account_query) > 0) {
    while ($control_account_row = mysqli_fetch_assoc($control_account_query)) {
        $control_account_branch_id = $control_account_row['branch_id'];
        $control_account_name = $control_account_row['name'];
        $description = $control_account_row['description'];
        $gcode = $control_account_row['gcode'];
    }
}

// Fetch all control accounts of this branch
$control_account_query_all = mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `branch_id` = '$branch_id'");
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Creare Control Account</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
  <link href="dist/css/style.css" rel="stylesheet" type="text/css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
 <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
 <script src="bootstrap/js/bootstrap.min.js"></script>

</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <header class="main-header">
    <!-- Logo -->
 <?php  include('inc/main-header.php');  ?>
    </header>
  <!-- Left side column. contains the logo and sidebar -->
    <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
 <?php  include('inc/main-sidebar.php');  ?>
  </aside>
<?php include('inc/calculator.php'); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Control Account
        <small><?= $branch_name ?></small>
      </h1>
      <ol class="breadcrumb">
      	<?php if($count_1 > 0){ }else{ ?>
        <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
        <?php  } ?>
        <li><a href="branch_page.php?branch_id=<?= $branch_id ?>"><?php if($count_1 > 0){ ?><i class="fa fa-dashboard"></i> Home <?php }else{ echo $branch_name; } ?></a></li>
        <li><a href="control_accounts.php?branch_id=<?= $branch_id ?>">Control Accounts</a></li>
		<li class="active">Add Control Account</li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-xs-12">
        

          <div class="box box-primary">
            <div class="box-header">
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              
            <form role="form" id="register-form" method="post"  novalidate="novalidate" action=""> 
              <div class="box-body">
              	<div class="form-group" style="width:48%;float:left">
                	<label for="">Project</label>
                    <select name="branch_id" id="branch_id" class="form-control" style="width:90%;">
                    	<option value="<?= $branch_id ?>"><?= $branch_name ?></option>
                    </select>
                </div>
                <div class="form-group" style="width:48%;float:left">
                  <label for="">Name</label>
                  <input type="text" name="name" id="name" placeholder="Control Account name"  value="<?=$control_account_name?>" class="form-control" style="width:90%;">
                </div>
				<div class="form-group" style="width:48%;float:left">
                  <label for="">Group Code</label>
                  <input type="text" name="gcode" id="gcode" placeholder="Group Code" value="<?=$gcode?>" class="form-control" style="width:90%;background-color:white" readonly>
                </div>
                <div class="form-group" style="width:48%;float:left">
                  <label for="">Description</label>
                  <input type="text" name="description" id="description" value="<?=$description?>" placeholder="Description" class="form-control" style="width:90%;">
                </div>
                
                </div>
              <!-- /.box-body -->

              <div class="box-footer">
                <input type="submit" id="edit_control_account" class="btn btn-primary">
              </div>
            </form>
  		
           
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
 <!-- Footer -->
  <?php include("inc/footer.php"); ?>

  <!-- Control Sidebar -->
  <?php include("inc/aside.php"); ?>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<!-- Bootstrap 3.3.6 -->
<!-- DataTables -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
<!-- page script -->
<script>

  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
</script>

  <script src="//ajax.aspnetcdn.com/ajax/jquery.validate/1.9/jquery.validate.min.js"></script>
  
  <!-- jQuery Form Validation code -->
  <script>
  
  // When the browser is ready...
$(document).ready(function() {
  
    // Setup form validation on the #register-form element
    $("#register-form").validate({
    
        // Specify the validation rules
        rules: {
            name: "required",
			gcode: "required"
        },
        
        // Specify the validation error messages
        messages: {
			name: "Please enter the name",
			gcode: "Group code not found"
        },
        
        submitHandler: function(form) {
            form.submit();
        }
    });
	//ajax area add student
	  $("#edit_control_account").click(function(){
		var branch_id = $("#branch_id").val();
		var name = $("#name").val();
		var description = $("#description").val();
		var gcode = $("#gcode").val();
	 
	  $.ajax({
		url: "functions.php?control_account_id=<?=$control_account_id?>",
		type: "POST",
		async: false,
		data: {
		"control_account_edited": 1,
		"s_branch_id": branch_id,
		"s_name": name,
		"s_description": description,
		"s_gcode": gcode,
		},
		success: function(data){
			
		}
		
	})
	

	  });
	
    
});

//ajax add student end

  </script>
</body>
</html>
