<?php 
ob_start();
session_start();
include("db.php");

if (!isset($_SESSION['user_email'])) {
    header("location:login.php?login=failed");
    exit;
}

$user_email = $_SESSION['user_email'];

// Fetch manager info
$select_query_q = "SELECT * FROM `managers` WHERE `email` = '$user_email'";
$result_q = mysqli_query($conn, $select_query_q);

$count_1 = mysqli_num_rows($result_q);
$rowq = mysqli_fetch_assoc($result_q);

$branch_id = $rowq['branch_id'] ?? '';
$M_name = $rowq['name'] ?? '';

// Validate branch_id from URL
$branch_id_s = $_GET['branch_id'] ?? '';
if ($count_1 > 0 && $branch_id_s != $branch_id) {
    header("location:javascript://history.go(-1)");
    exit;
}

// Fetch branch info
$select_query = "SELECT * FROM `branches` WHERE `id` = '$branch_id_s'";
$result_query = mysqli_query($conn, $select_query);
if (!$result_query) {
    die("Query Failed: $select_query<br><br>" . mysqli_error($conn));
}

$row = mysqli_fetch_assoc($result_query);

$branch_id = $row['id'] ?? '';
$branch_name = $row['name'] ?? '';
$branch_image = $row['image'] ?? '';
$square_feet_size = $row['square_feet_size'] ?? '';

// Fetch ledger info
$ledger_id = $_GET['ledger_id'] ?? '';
$ledger_query = mysqli_query($conn, "SELECT * FROM `ledgers` WHERE `id` = '$ledger_id'");
$ledger_item = mysqli_fetch_assoc($ledger_query);

$ledger_name = $ledger_item['name'] ?? '';
$ledger_gcode = $ledger_item['gcode'] ?? '';
$ledger_description = $ledger_item['description'] ?? '';
$ledger_control_account_id = $ledger_item['control_account_id'] ?? '';
$ledger_general_ledger_id = $ledger_item['general_ledger_id'] ?? '';

if (isset($_SESSION['edit_ledger'])) {
    header("location:ledgers.php?branch_id={$branch_id}&control_account_id={$ledger_control_account_id}&general_ledger_id={$ledger_general_ledger_id}");
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Edit Ledger</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
  <link href="dist/css/style.css" rel="stylesheet" type="text/css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
 <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
 <script src="bootstrap/js/bootstrap.min.js"></script>

</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <header class="main-header">
    <!-- Logo -->
 <?php  include('inc/main-header.php');  ?>
    </header>
  <!-- Left side column. contains the logo and sidebar -->
    <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
 <?php  include('inc/main-sidebar.php');  ?>
  </aside>
<?php include('inc/calculator.php'); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
		Edit Ledger
        <small><?= $branch_name ?></small>
      </h1>
      <ol class="breadcrumb">
        <?php if($count_1 > 0){ }else{ ?>
        <li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
        <?php  } ?>
        <li><a href="branch_page.php?branch_id=<?= $branch_id ?>"><?php if($count_1 > 0){ ?><i class="fa fa-home"></i> Home <?php }else{ echo $branch_name; } ?></a></li>
        <li><a href="control_accounts.php?branch_id=<?= $branch_id ?>">Control Accounts</a></li>
		<li><a href="general_ledgers.php?branch_id=<?=$branch_id?>&control_account_id=<?=$ledger_control_account_id?>">General Ledgers</a></li>
		<li><a href="ledgers.php?branch_id=<?=$branch_id?>&control_account_id=<?=$ledger_control_account_id?>&general_ledger_id=<?=$ledger_general_ledger_id?>">Ledgers</a></li>
		<li class="active">Edit Ledger</li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-xs-12">
        

          <div class="box">
            <div class="box-header">
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              
            <form role="form" id="register-form" method="post" onsubmit="return getdata()" novalidate action=""> 
              <div class="box-body">
              	<div class="form-group" style="width:48%;float:left">
                	<label for="">Project</label>
                    <select name="branch_id" id="branch_id" class="form-control" style="width:90%;">
                    	<option value="<?= $branch_id ?>"><?= $branch_name ?></option>
                    </select>
                </div>
                <div class="form-group" style="width:48%;float:left">
                	<label for="">Control Account</label>
                    <select name="control_account_id" id="control_account_id" class="form-control" style="width:90%;">
					<?php $select_query_a=mysqli_query($conn,"SELECT * FROM `control_accounts`	WHERE `id` = '$ledger_control_account_id'");
									while($row_a=mysqli_fetch_assoc($select_query_a)){
									$control_account_id = $row_a['id'];
									$control_account_name = $row_a['name'];
									?>
                    	<option value="<?= $control_account_id ?>"><?= $control_account_name ?></option>
						<?php } ?>
					</select>
                </div>
				<div class="form-group" style="width:48%;float:left">
                	<label for="">General Ledger</label>
                    <select name="general_account_id" id="general_account_id" class="form-control" style="width:90%;">
					<?php $select_query_a=mysqli_query($conn, "SELECT * FROM `general_ledgers`	WHERE `id` = '$ledger_general_ledger_id'");
									while($row_a=mysqli_fetch_assoc($select_query_a)){
									$general_ledger_id = $row_a['id'];
									$general_ledger_name = $row_a['name'];
									?>
                    	<option value="<?= $general_ledger_id ?>"><?= $general_ledger_name ?></option>
						<?php } ?>
					</select>
                </div>
                <div class="form-group" style="width:48%;float:left">
                  <label for="">Name</label>
                  <input type="text" name="name" id="name" class="form-control" value="<?=$ledger_name?>" placeholder="Ledger Account Name" style="width:90%;">
                </div>
				<div class="form-group" style="width:48%;float:left">
                  <label for="">Group Code</label>
                  <input type="text" name="gcode" id="gcode" placeholder="Group Code" value="<?=$ledger_gcode?>" class="form-control" style="width:90%;background-color:white" readonly>
                </div>
				<div class="form-group" style="width:48%;float:left">
                  <label for="">Description</label>
                  <input type="text" name="description" id="description" placeholder="Description" value="<?=$ledger_description?>" class="form-control" style="width:90%;">
                </div>
                
                </div>
              <!-- /.box-body -->

              <div class="box-footer">
                <input type="submit" id="edit_ledger" class="btn btn-primary">
              </div>
            </form>
  		
           
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
 <!-- Footer -->
  <?php include("inc/footer.php"); ?>

  <!-- Control Sidebar -->
  <?php include("inc/aside.php"); ?>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<!-- Bootstrap 3.3.6 -->
<!-- DataTables -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
<!-- page script -->
<script>

  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
</script>

  <script src="//ajax.aspnetcdn.com/ajax/jquery.validate/1.9/jquery.validate.min.js"></script>
  
  <!-- jQuery Form Validation code -->
  <script>
  
  // When the browser is ready...
$(document).ready(function() {

    // Setup form validation on the #register-form element
    $("#register-form").validate({
    
        // Specify the validation rules
        rules: {
			name: "required",
			control_account_id: "required",
			general_account_id: "required",
			gcode: "required"
		},
        
        // Specify the validation error messages
        messages: {
			name: "Please enter the Name",
            control_account_id: "Control ID Not found",
			general_account_id: "General ID Not found",
			gcode: "Group code not found"
        },
        
        submitHandler: function(form) {
            form.submit();
        }
    });
	//ajax area 
	  $("#edit_ledger").click(function(){
		var name = $("#name").val();
		var description = $("#description").val();
	 
	  $.ajax({
		url: "functions.php?ledger_id=<?=$ledger_id?>",
		type: "POST",
		async: false,
		data: {
		"ledger_edited": 1,
		"s_name": name,
		"s_description": description,
		},
		success: function(data){
		}
		
	})
	

	  });
	
    
});


  </script>
</body>
</html>
