<?php 
ob_start(); // Start output buffering

session_start(); // Start the session

include ("db.php"); // Include database connection

// If there is a message in the session under 'manager', show it as an alert and then unset it
if (isset($_SESSION['manager'])) {
    $message = $_SESSION['manager']; 
?> 
<script> alert('<?= $message ?>'); </script>
<?php unset($_SESSION["manager"]); }

// Check if the user is logged in
$user_email = $_SESSION['user_email'] ?? ''; // If the session does not contain email, assign empty string

if (!$user_email) {
    header("location:login.php?login=failed"); // Redirect to login page if user is not logged in
    exit();
}

// Get the manager's branch ID based on the logged-in user's email
$select_query_1 = "SELECT * FROM `managers` WHERE `email` = '$user_email'";
$result_1 = mysqli_query($conn, $select_query_1);

// Initialize branch ID
$branch_id = '';
while ($row = mysqli_fetch_assoc($result_1)) {
    $branch_id = $row['branch_id']; // Store the branch ID from the result
}

// Count the number of rows returned
$count_1 = mysqli_num_rows($result_1);

// If the manager record exists, redirect to the previous page
if ($count_1 > 0) {
    header("location:javascript://history.go(-1)"); 
    exit();
}

// Get the manager ID from the URL
$manager_id = $_GET['manager_id'] ?? 0; // Use default 0 if not provided

// Retrieve the manager details using the ID
$select_query = "SELECT * FROM `managers` WHERE `id` = '$manager_id'";
$result_query_q = mysqli_query($conn, $select_query);

// Store manager details in variables
while ($row = mysqli_fetch_assoc($result_query_q)) {
    $manager_id       = $row['id'];
    $manager_name     = $row['name'];
    $manager_email    = $row['email'];
    $manager_cnic     = $row['cnic_number'];
    $manager_phone    = $row['phone'];
    $manager_image    = $row['image'] ?? '';
    $manager_address  = $row['address'];
    $joining_date     = $row['date'];
}
?>

 <!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Edit Manager</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
  <link href="dist/css/style.css" rel="stylesheet" type="text/css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
 <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
 <script src="bootstrap/js/bootstrap.min.js"></script>

</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <header class="main-header">
    <!-- Logo -->
 <?php  include('inc/main-header.php');  ?>
    </header>
  <!-- Left side column. contains the logo and sidebar -->
    <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
 <?php  include('inc/main-sidebar.php');  ?>
  </aside>
<?php
//Manager's Picture
if(isset($_FILES['image'])){
      $errors= array();
      $file_name = $_FILES['image']['name'];
      $file_size =$_FILES['image']['size'];
      $file_tmp =$_FILES['image']['tmp_name'];
      $file_type=$_FILES['image']['type'];
      $file_ext=strtolower(end(explode('.',$_FILES['image']['name'])));
      
      $expensions= array("jpeg","jpg","png");
      
      if(in_array($file_ext,$expensions)=== false){
         $errors[]="extension not allowed, please choose a JPEG or PNG file.";
      }
      
      if($file_size > 2097152){
         $errors[]='File size must be excately 2 MB';
      }
      
    $file_path="uploads/".$file_name;
    
      if(empty($errors)==true){
         move_uploaded_file($file_tmp,$file_path);
      }else{
      }
   }
?>


  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Edit Manager
        <small>Details</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
        <li><a href="managers.php"> Managers</a></li>
        <li class="active">Edit Manager</li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-xs-12">
        
          <div class="box box-primary">
            <div class="box-header">
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              
            <form role="form" id="register-form" method="post"  novalidate="novalidate" action="" enctype="multipart/form-data"> 
              <div class="box-body">
                <div class="form-group" style="width:48%;float:left">
                  <label for="">Name</label>
                  <input type="text" name="name" id="name" value="<?=$manager_name?>" placeholder="Manager's name" class="form-control" style="width:90%;">
                </div>
                <div class="form-group" style="width:48%;float:left">
                  <label for="">CNIC Number</label>
                  <input type="text" name="cnic" id="cnic" value="<?=$manager_cnic?>" class="form-control" maxlength="15" placeholder="CNIC Number" style="width:90%;">
                </div>
                <div class="form-group" style="width:48%;float:left">
                  <label for="">Email Address</label>
                  <input type="email" name="email" id="email" value="<?=$manager_email?>" class="form-control" placeholder="Email Address" style="width:90%;">
                </div>
                <div class="form-group" style="width:48%;float:left">
                  <label for="">Phone Number</label>
                  <input type="number" name="phone" id="phone" value="<?=$manager_phone?>" class="form-control" placeholder="Phone Number" style="width:90%;">
                </div>
                <div class="form-group" style="width:48%;float:left">
                  <label for="">Address</label>
                  <input type="text" name="address" id="address" value="<?=$manager_address?>" class="form-control" placeholder="Address" style="width:90%;">
                </div>
                </div>
              <!-- /.box-body -->

              <div class="box-footer">
                <input type="submit" id="edit_manager" value="Save" class="btn btn-primary">
              </div>
            </form>
  		
           
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <!-- Footer -->
  <?php include("inc/footer.php"); ?>

  <!-- Control Sidebar -->
  <?php include("inc/aside.php"); ?>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<!-- Bootstrap 3.3.6 -->
<!-- DataTables -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
<!-- page script -->
<script>

/* For CNIC number format*/
$('#cnic').keydown(function(){

  //allow  backspace, tab, ctrl+A, escape, carriage return
  if (event.keyCode == 8 || event.keyCode == 9 
                    || event.keyCode == 27 || event.keyCode == 13 
                    || (event.keyCode == 65 && event.ctrlKey === true) )
                        return;
  if((event.keyCode < 48 || event.keyCode > 57))
   event.preventDefault();

  var length = $(this).val().length; 
              
  if(length == 5 || length == 13)
   $(this).val($(this).val()+'-');

 });

  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
</script>

  <script src="//ajax.aspnetcdn.com/ajax/jquery.validate/1.9/jquery.validate.min.js"></script>
  
  <!-- jQuery Form Validation code -->
  <script>
  
  // When the browser is ready...
$(document).ready(function() {
  
    // Setup form validation on the #register-form element
    $("#register-form").validate({
    
        // Specify the validation rules
        rules: {
            name: "required",
            cnic: "required",
            email: "required",
      			phone: "required",
      			address: "required"
        },
        
        // Specify the validation error messages
        messages: {
            name: "Please Enter The Name",
            cnic: "Please Enter CNIC Number",
            email: "Please Enter The Email Address",
            phone: "Please Enter The Phone Number",
      			address: "Please Enter The Adderss"
        },
        
        submitHandler: function(form) {
            form.submit();
        }
    });




	  $("#edit_manager").click(function(){
		  var name = $("#name").val();
	  	var cnic = $("#cnic").val();
  		var email = $("#email").val();
  		var phone = $("#phone").val();
  	 	var address = $("#address").val();
	  $.ajax({
		url: "functions.php?manager_id=<?=$manager_id?>",
		type: "POST",
		async: false,
		data: {
		"manager_edited": 1,
		"s_name": name,
		"s_cnic": cnic,
		"s_phone": phone,
		"s_email": email,
		"s_address": address,
		},
		success: function(data){
		}
		
	})
	

	  });
	
    
});

//ajax add student end

  </script>
</body>
</html>
