<?php 
ob_start();
session_start();
include("db.php");
include("functions_format.php");

// Check if user is logged in
if (!isset($_SESSION['user_email'])) {
    header("location:login.php?login=failed");
    exit;
}

$user_email = $_SESSION['user_email'];

// Get manager info using helper
$manager = select1($conn, 'managers', 'email', $user_email);
$branch_id = $manager['branch_id'] ?? null;
$M_name = $manager['name'] ?? '';
$count_1 = count1($conn, 'managers', 'email', $user_email);

// Get and sanitize GET input
$branch_id_s = isset($_GET['branch_id']) ? mysqli_real_escape_string($conn, $_GET['branch_id']) : '';

if ($count_1 > 0 && $branch_id_s !== $branch_id) {
    header("location:javascript://history.go(-1)");
    exit;
}

// Get branch info using helper
$branch = select1($conn, 'branches', 'id', $branch_id_s);
$branch_id = $branch['id'] ?? '';
$branch_name = $branch['name'] ?? '';
$branch_image = $branch['image'] ?? '';
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Electricity Bills</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Select2 -->
  <link rel="stylesheet" href="plugins/select2/select2.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
 <script src="dist/js/jquery-1.12.1.min.js"></script>
 <script src="bootstrap/js/bootstrap.min.js"></script>
 <!-- Month year selector jquery files start -->
 <link href="dist/css/jquery-ui.css" rel="stylesheet" type="text/css" />
<link href="dist/css/MonthPicker.min.css" rel="stylesheet" type="text/css" />
<link rel="stylesheet" type="text/css" href="dist/css/examples.css" />
<script src="dist/js/jquery-ui.min.js"></script>
<script src="dist/js/jquery.maskedinput.min.js"></script>
<script src="dist/js/MonthPicker.min.js"></script>
<script src="dist/js/examples.js"></script>
 <!-- Month year selector jquery files end -->
<style type="text/css">
.form-control,.select2-selection
{
  border-radius: 5px !important; 
  background-color: #fff !important;
}
.ui-datepicker-calendar {
    display: none;
    }
.form-control + label,span + label{
  color: red;
}
</style>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <header class="main-header">
    <!-- Logo -->
 <?php  include('inc/main-header.php');  ?>
    </header>
  <!-- Left side column. contains the logo and sidebar -->
    <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
 <?php  include('inc/main-sidebar.php');  ?>
  </aside>
<?php include('inc/calculator.php'); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Electricity Bills
      </h1>
      <ol class="breadcrumb">
        <?php if($count_1 > 0){ }else{ ?>
        <li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
        <?php  } ?>
        <li><a href="branch_page.php?branch_id=<?= $branch_id ?>"><?php if($count_1 > 0){ ?><i class="fa fa-home"></i> Home <?php }else{ echo $branch_name; } ?></a></li>
        <li class="active"> Electricity Bills</li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
          <div class="box box-primary">
            <div class="box-header">
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <?php query_status('electricity_bills'); ?>
            <form role="form" id="register-form" method="post"  novalidate="novalidate" action=""  enctype="multipart/form-data"> 
              <div class="box-body">
              <div class="col-md-6">
                <div class="form-group">
                  <label for="">Company / Agreement</label><br>
                  <select class="form-control select2" id="agreementId" name="agreementId">
                    <option value="">Select Brand</option>
                    <?php $agreementData = loop1($conn, 'rental_agreement','branch_id',$branch_id); 
                    while($agreementRow=mysqli_fetch_assoc($agreementData)){
                      $totalArea = $agreementRow['area'];
                      $company = select1($conn,'company','id',$agreementRow['company_id']);
                      $shops = loop1($conn,'rental_shops','agreement_id',$agreementRow['id']); 

                      $bills = limit1($conn,'electricity_bills','agreement_id',$agreementRow['id'],'DESC',1);

                      //get arrears start
                      //amount to be paid by now
                      $amountTBPdata = select1($conn,'electricity_bills_recovery','agreement_id',$agreementRow['id']);
                      $amountTBP = $amountTBPdata['arrears'];
                      //paid amount
                      $paiedAmount = ledgerBalance($conn, $agreementRow['billing_ledger_id']);
                      //total arrears
                      $arrears = $amountTBP-$paiedAmount;
                      //get arrears end

                    ?>
                    <option value="<?=$agreementRow['id']?> <?=$bills['meter_reading']?> <?=$arrears?>"><?=$company['name']?>(
                      <?php while($shopRow=mysqli_fetch_assoc($shops)){
                        $shopNo=select1($conn,'shops','id',$shopRow['shop_id']);
                        echo $shopNo['shop_no'].' '; 
                      } ?>
                    ) ( <?php $floor = select1($conn, 'branch_categories','id',$shopNo['floor_id']);
                    echo $floor['name']; ?> )</option>
                    <?php } ?>
                  </select>
                  <label for="agreementId" generated="true" class="error" style="display: none"></label>
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label for="">Billing Month</label><br>
                  <input type="text" name="billingMonth" id="AltMonthField2" class="form-control date-picker"  placeholder="Billing Month" readonly="">
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label for="">Issue Date</label><br>
                  <input type="text" name="issueDate" id="issueDate" class="form-control jquery-date"  placeholder="Issue Date" readonly="">
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label for="">Due Date</label><br>
                  <input type="text" name="dueDate" id="dueDate" class="form-control jquery-date"  placeholder="Due Date" readonly="">
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label for="">Previous Meter Reading</label>
                  <input type="number" class="form-control" placeholder="0" name="previousMeterReading" value="" id="previousMeterReading" readonly>
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label for="">Current Meter Reading</label>
                  <input type="number" class="form-control" placeholder="Meter Reading" name="meterReading" id="meterReading">
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label for="">Units Consumed</label>
                  <input type="number" class="form-control" placeholder="0" name="unitsConsumed" id="unitsConsumed" readonly>
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label for="">Lobby Generator Charges</label>
                  <input type="number" class="form-control" placeholder="Lobby Generator Charges" name="lobbyCharges" id="lobbyCharges">
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label for="">Unit Rate</label>
                  <input type="number" class="form-control" placeholder="Unit Rate" name="unitRate" id="unitRate">
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label for="">Current Month Bill</label>
                  <input type="number" class="form-control" placeholder="0" name="currentMonthBill" id="currentMonthBill" readonly>
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label for="">Arrears</label>
                  <input type="number" class="form-control" placeholder="0" name="arrears" id="arrears" readonly>
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label for="">Total Bill</label>
                  <input type="number" class="form-control" placeholder="0" name="totalBill" id="totalBill" readonly>
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label for="">L.P Surcharge (Percentage)</label>
                  <input type="number" class="form-control" placeholder="%" name="lpSurcharge" id="lpSurcharge">
                </div>
              </div>
              
              <div class="col-md-6">
                <div class="form-group">
                  <label for="">Bill After Due Date</label>
                  <input type="number" class="form-control" placeholder="0" name="lateBill" id="lateBill" readonly>
                </div>
              </div>

              </div>
              <!-- /.box-body -->

              <div class="box-footer">
                <input type="submit" id="submit" class="btn btn-primary">
              </div>
            </form>
           
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        <!-- /.col -->
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <!-- Footer -->
  <?php include("inc/footer.php"); ?>

  <!-- Control Sidebar -->
  <?php include("inc/aside.php"); ?>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<!-- Bootstrap 3.3.6 -->
<!-- DataTables -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
<!-- page script -->
<script src="plugins/select2/select2.full.min.js"></script>
<script>

  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
</script>

  <script src="//ajax.aspnetcdn.com/ajax/jquery.validate/1.9/jquery.validate.min.js"></script>
    <!-- jQuery Form Validation code -->
 <!-- Date range Picker start -->
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css"/>

  
<!-- jQuery Form Validation code -->
<script>

function countTotalBill(){
    var agreement = $('#agreementId').val();
    if(agreement){
      var unitRate = $('#unitRate').val();
      //get meter reading start
      var str =$('#agreementId').val();
      var ret = str.split(" ");
      var previousMeterReading = ret[1];
      $('#previousMeterReading').val(previousMeterReading);
        //get and put arrears
        var arrears = ret[2];
        if(arrears>0){ $('#arrears').val(arrears); }else{ $('#arrears').val(0); }
      //get meter reading End
      var currentMeterReading = $('#meterReading').val();
      var currentUnits = currentMeterReading-previousMeterReading;

      var lobbyCharges = $('#lobbyCharges').val();
      var billNlobby = currentUnits*unitRate;
      var currentBill = +billNlobby + +lobbyCharges;
      //current month bill
        if(unitRate){ $('#currentMonthBill').val(currentBill); }
      var totalBill = +currentBill + +arrears;
      if(currentUnits >= 0){ $('#unitsConsumed').val(currentUnits); }
      if(unitRate){ $('#totalBill').val(totalBill); }
      //bill after due date
      var lpSurcharge = $('#lpSurcharge').val();
      var lateBillPercentage = (totalBill/100)*lpSurcharge;
      var lateBill = totalBill+lateBillPercentage;
      if(lpSurcharge){ $('#lateBill').val(lateBill); }
    }else{
      $('#previousMeterReading').val(0);
      $('#arrears').val(0);
      $('#currentMonthBill').val(0);
      $('#lateBill').val(0);
    }
}

$( "#meterReading" ).keyup(function() {
  countTotalBill();
});
$( "#lobbyCharges" ).keyup(function() {
  countTotalBill();
});
$( "#unitRate" ).keyup(function() {
  countTotalBill();
});
$( "#lpSurcharge" ).keyup(function() {
  countTotalBill();
});
$( "#agreementId" ).on('change', function() {
  countTotalBill();
});
$(function () {
  //Initialize Select2 Elements
  $(".select2").select2();
});

  // When the browser is ready...
$(document).ready(function() {

  /* Setup jQuery datepicker ui */
    var date_input=$('.jquery-date'); //our date input has the name "date"
    var container=$('.bootstrap-iso form').length>0 ? $('.bootstrap-iso form').parent() : "body";
    date_input.datepicker({
      format: 'yyyy-mm-dd',
      container: container,
      todayHighlight: true,
      autoclose: true,
    });
    
  
    // Setup form validation on the #register-form element
    $("#register-form").validate({
    
        // Specify the validation rules
        rules: {
            agreementId: "required",
            meterReading: "required",
            lpSurcharge: "required",
            issueDate: "required",
            dueDate: "required",
            unitRate: "required",
            billingMonth: "required",
        },
        
        // Specify the validation error messages
        messages: {
            agreementId: "Please Select Shops",
            meterReading: "Enter Meter Reading",
            lpSurcharge: "Enter L.P Surcharge",
            issueDate: "Select Issue Date",
            dueDate: "Select Due Date",
            unitRate: "Enter Unit Rate",
            billingMonth: "Select The Billing Month",
        },
        
        submitHandler: function(form) {
            form.submit();
        }
    });
    
	  $("#submit").click(function(){
    var branchId = <?=$branch_id?>;
    //get agreement id start
    var str =$('#agreementId').val();
    var ret = str.split(" ");
    var agreementId = ret[0];
    //get agreement id End
    var meterReading = $("#meterReading").val();
    var unitsConsumed = $("#unitsConsumed").val();
    var lobbyCharges = $("#lobbyCharges").val();
    var lpSurcharge = $("#lpSurcharge").val();
    var issueDate = $("#issueDate").val();
    var dueDate = $("#dueDate").val();
    var billingMonth = $("#AltMonthField2").val();
    var unitRate = $("#unitRate").val();
    var totalBill = $("#totalBill").val();

	  $.ajax({
		url: "functions.php",
		type: "POST",
		async: false,
		data: {
		"electricity_bill_added": 1,
    "branchId": branchId,
    "agreementId": agreementId,
    "unitRate": unitRate,
    "lpSurcharge": lpSurcharge,
    "meterReading": meterReading,
    "unitsConsumed": unitsConsumed,
    "issueDate": issueDate,
    "dueDate": dueDate,
    "billingMonth": billingMonth,
    "lobbyCharges": lobbyCharges,
    "totalBill": totalBill,
		},
		success: function(data){
		}
		
	})
	

	  });
	
    
});

  </script>
  

</body>
</html>
