<?php 
ob_start();
session_start();
include ('db.php'); 
include ('functions_format.php'); 

$date=date('Y-m-d');	

if (isset($_FILES['file']['name'])) {
    if (0 < $_FILES['file']['error']) {
        echo 'Error during file upload' . $_FILES['file']['error'];
    } else {
        if (file_exists('uploads/' . $_FILES['file']['name'])) {
            echo 'File already exists : uploads/' . $_FILES['file']['name'];
        } else {
			$file_path = 'uploads/' . $_FILES['file']['name'];
            move_uploaded_file($_FILES['file']['tmp_name'], $file_path);
            echo 'File successfully uploaded : uploads/' . $_FILES['file']['name'];
        }
    }
} else {
    echo 'Please choose a file';
}




if(isset($_POST['submit'])){


foreach (array('branch_id', 'block_id', 'entydate', 'voucher_no', 'drcr', 'ledger_id', 'dr_amount', 'cr_amount', 'narration') as $pos) {
    foreach ($_POST[$pos] as $id => $row) {
        $_POST[$pos][$id] = mysqli_real_escape_string($conn, $row);
    }

}
	$branch_id = $_POST['branch_id'];
	$block_id = $_POST['block_id'];
	$entydate = $_POST['entydate'];
	$voucher_no = $_POST['voucher_no'];
	$drcr = $_POST['drcr'];
	$ledger_id = $_POST['ledger_id'];
	$dr_amount = $_POST['dr_amount'];
	$cr_amount = $_POST['cr_amount'];
	$narration = $_POST['narration'];

$items = array();


echo $size = count($row);
}

for($i = 0 ; $i <= $size ; $i++){
    // Check for part id
    if (empty($branch_id[$i]) || empty($block_id[$i]) || empty($entydate[$i]) || empty($voucher_no[$i]) || empty($drcr[$i]) || empty($ledger_id[$i]) || empty($dr_amount[$i]) || empty($cr_amount[$i]) || empty($narration[$i])) {
        continue;
    }
    $items[] = array(
        "branch_ids"     => $branch_id[$i], 
        "block_ids"    => $block_id[$i],
        "entydates"       => $entydate[$i],
		"voucher_nos"       => $voucher_no[$i],
		"drcrs"       => $drcr[$i],
		"ledger_ids"       => $ledger_id[$i],
		"dr_amounts"       => $dr_amount[$i],
		"cr_amounts"       => $cr_amount[$i],
		"narrations"       => $narration[$i]
    );
}


//---------------- Adding Employee Start-----------------------------

if(isset($_POST['employee_added'])){
	// Assign data to variables
	$branch_id = $_POST['s_branch_id'];
	$name = $_POST['s_name'];
	$cnic = $_POST['s_cnic'];
	$email = $_POST['s_email'];
	$phone = $_POST['s_phone'];
	$city = $_POST['s_city'];
	$country = $_POST['s_country'];
	$address = $_POST['s_address'];
	$role = $_POST['s_role'];
	$salary = $_POST['s_salary'];
	
	
	//check if email already exists
	$check_query=mysqli_query($conn, "SELECT * FROM `employees`	WHERE `email` = '$email' OR `cnic_number` = '$cnic' AND `email` != '' AND `cnic_number` != ''");
	
	
	if(mysqli_num_rows($check_query) > 0){
		$_SESSION['employee'] = 'Error: CNIC Number or Email Address Already Exists!';
	}else{
	//INsert data in database
	if(!empty($branch_id) && !empty($name) && !empty($phone) && !empty($city) && !empty($country) && !empty($address) && !empty($role) && !empty($salary)){
	$insert_query=mysqli_query($conn, "insert into employees (id, branch_id, name, cnic_number, email, phone, address, city, country, salary, role, date) values(NULL, '$branch_id', '$name', '$cnic', '$email', '$phone', '$address', '$city', '$country', '$salary', '$role', '$date')");
	$_SESSION['employee'] = 'Successfully Registerd '.$name.' as Employee.';	
	exit();
	}
	}
}
	
//------------------Adding Employee End-------------------------------




//---------------- Editing Employee Start-----------------------------

if(isset($_POST['employee_edited'])){
	// Assign data to variables
	$branch_id = $_POST['s_branch_id'];
	$name = $_POST['s_name'];
	$cnic = $_POST['s_cnic'];
	$email = $_POST['s_email'];
	$phone = $_POST['s_phone'];
	$city = $_POST['s_city'];
	$country = $_POST['s_country'];
	$address = $_POST['s_address'];
	$role = $_POST['s_role'];
	$salary = $_POST['s_salary'];
	
	$employee_id = $_GET['employee_id'];
	
	//check if email already exists
	$check_query=mysqli_query($conn, "SELECT * FROM `employees`	WHERE `email` = '$email' AND `id` != '$employee_id'");
	$check_query1=mysqli_query($conn, "SELECT * FROM `employees`	WHERE `cnic_number` = '$cnic' AND `id` != '$employee_id'");
	
	
	if(mysqli_num_rows($check_query) > 0 || mysqli_num_rows($check_query1) > 0){
		$_SESSION['employee_edit'] = 'Error: CNIC Number or Email Address Already Exists!';
	}else{
	//Update data in database
	if(!empty($branch_id) && !empty($name) && !empty($phone) && !empty($city) && !empty($country) && !empty($address) && !empty($role) && !empty($salary)){
	$Update_query=mysqli_query($conn, "UPDATE `employees` SET `branch_id` = '$branch_id', `name` = '$name', `cnic_number` = '$cnic', `email` = '$email', `phone` = '$phone', `address` = '$address', `city` = '$city', `country` = '$country', `salary` = '$salary', `role` = '$role' WHERE `id` = '$employee_id';");
	$_SESSION['employee_edit'] = 'Successfully Edited Employee '.$name;	
	exit();
	}
	}
}
	
//------------------Editing Employee End-------------------------------



//---------------- Adding Manager Start-----------------------------

if(isset($_POST['manager_added'])){
	// Assign data to variables
		$name = mysqli_real_escape_string($conn, $_POST['s_name']);
		$cnic = mysqli_real_escape_string($conn, $_POST['s_cnic']);
		$email = mysqli_real_escape_string($conn, $_POST['s_email']);
		$phone = mysqli_real_escape_string($conn, $_POST['s_phone']);
		$city = mysqli_real_escape_string($conn, $_POST['s_city']);
		$country = mysqli_real_escape_string($conn, $_POST['s_country']);
		$address = mysqli_real_escape_string($conn, $_POST['s_address']);
	
	//check if email already exists
	$check_query=mysqli_query($conn, "SELECT * FROM `managers`	WHERE `email` = '$email' OR `cnic_number` = '$cnic'");
	
	
	if(mysqli_num_rows($check_query) > 0){
		$_SESSION['manager'] = 'Error: CNIC Number or Email Address Already Exists!';
	}else{
	//INsert data in database
	if(!empty($name) && !empty($cnic) && !empty($phone) && !empty($city) && !empty($country) && !empty($address)){
	$insert_query=mysqli_query($conn, "INSERT INTO `managers`(`id`, `branch_id`, `password`, `name`, `cnic_number`, `email`, `phone`, `address`, `city`, `country`, `privileges`, `date`) VALUES (NULL,'0','','$name','$cnic','$email','$phone','$address','$city','$country','','$date')");
	$_SESSION['manager'] = 'Successfully Registerd '.$name.' as Manager.';
	exit();
	}
	}
}



	
//------------------Adding Manager End-------------------------------





//---------------- Edit Manager Start-----------------------------


if (isset($_POST['manager_edited'])) {

    include("db.php"); // db connection include karo

    $manager_id = $_GET['manager_id']; // manager_id URL se lo

    // Form data secure tareeqe se variables me save karo
    $name    = mysqli_real_escape_string($conn, $_POST['s_name']);      // manager ka name
    $cnic    = mysqli_real_escape_string($conn, $_POST['s_cnic']);      // CNIC number
    $email   = mysqli_real_escape_string($conn, $_POST['s_email']);     // Email address
    $phone   = mysqli_real_escape_string($conn, $_POST['s_phone']);     // Phone number
    $address = mysqli_real_escape_string($conn, $_POST['s_address']);   // Address

    // Check karo ke email kisi aur manager ka to nahi
    $check_query  = mysqli_query($conn, "SELECT * FROM `managers` WHERE `email` = '$email' AND `id` != '$manager_id'");
    
    // Check karo ke CNIC kisi aur manager ka to nahi
    $check_query2 = mysqli_query($conn, "SELECT * FROM `managers` WHERE `cnic_number` = '$cnic' AND `id` != '$manager_id'");

    // Check karo ke email admin table me to nahi
    $check_query1 = mysqli_query($conn, "SELECT * FROM `admins` WHERE `email` = '$email'");

    // Agar email ya CNIC already exist karta ho to error do
    if (mysqli_num_rows($check_query) > 0 || mysqli_num_rows($check_query2) > 0) {
        $_SESSION['manager'] = 'Error: CNIC Number or Email Address Already Exists!';
    } elseif (mysqli_num_rows($check_query1) > 0) {
        $_SESSION['manager'] = 'Error: Email Address Already Exists!';
    } else {
        // Agar sab theek ho to update query run karo
        if (!empty($name) && !empty($cnic) && !empty($phone) && !empty($address)) {
            $update_query = mysqli_query($conn, "UPDATE `managers` SET `name` = '$name', `cnic_number` = '$cnic', `email` = '$email', `phone` = '$phone', `address` = '$address' WHERE `id` = '$manager_id'");
            
            // Success message session me save karo
            $_SESSION['manager'] = 'Successfully Edited ' . $name;
            exit();
        }
    }
}


//------------------Edit Manager End-------------------------------



//----------------Shift Ledger Start-----------------------------
if(isset($_POST['ledger_shift'])){
	// Assign data to variables
	$control_id = mysqli_real_escape_string($conn, $_POST['control_id']);
	$general_id = mysqli_real_escape_string($conn, $_POST['general_id']);
	$ledger_id = mysqli_real_escape_string($conn, $_POST['ledger_id']);
	
	//INsert data in database
	if(!empty($control_id) && !empty($general_id) && !empty($ledger_id)){
		$shift_query=mysqli_query($conn, "UPDATE `ledgers` SET `control_account_id`='$control_id',`general_ledger_id`='$general_id' WHERE `id` = '$ledger_id'");
		if($shift_query){
			$_SESSION['shift_ledger'] = 'Ledger Shifted Successfully';
		}else{
			$_SESSION['shift_ledger'] = 'Query could not execute!';
		}
	exit();
	}else{
		$_SESSION['shift_ledger'] = 'Plesae Fill All The Fields';
	}
}	
//------------------Shift Ledger End-------------------------------



//---------------- Adding Company Start-----------------------------
if(isset($_POST['company_added'])){
	// Assign data to variables
	$branch_id = mysqli_real_escape_string($conn, $_POST['branch_id']);
	$company_name = mysqli_real_escape_string($conn, $_POST['company_name']);
	$contact = mysqli_real_escape_string($conn, $_POST['contact']);
	$other_contact = mysqli_real_escape_string($conn, $_POST['other_contact']);
	$manager_name = mysqli_real_escape_string($conn, $_POST['manager_name']);
	$manager_contact = mysqli_real_escape_string($conn, $_POST['manager_contact']);
	$address = mysqli_real_escape_string($conn, $_POST['address']);
	
	//INsert data in database
	if(!empty($branch_id) && !empty($company_name) && !empty($contact) && !empty($manager_name) && !empty($manager_contact) && !empty($address)){
		$insert_query=mysqli_query($conn, "INSERT INTO `company`(`id`, `branch_id`, `name`, `manager_name`, `manager_contact`, `contact`, `other_contact`, `address`, `date`) VALUES (NULL,'$branch_id','$company_name','$manager_name','$manager_contact','$contact','$other_contact','$address',NULL)");
		if($insert_query){
			$_SESSION['company'] = 'Successfully Registerd '.$company_name;
		}else{
			$_SESSION['company'] = 'Query could not execute!';
		}
	exit();
	}else{
		$_SESSION['company'] = 'Plesae Fill All The Fields';
	}
}	
//------------------Adding Company End-------------------------------



//---------------- Editing Company Start-----------------------------
if (isset($_POST['company_edited'])) {

    // Assign and escape data
    $company_id = mysqli_real_escape_string($conn, $_POST['company_id']);
    $company_name = mysqli_real_escape_string($conn, $_POST['company_name']);
    $contact = mysqli_real_escape_string($conn, $_POST['contact']);
    $other_contact = mysqli_real_escape_string($conn, $_POST['other_contact']);
    $manager_name = mysqli_real_escape_string($conn, $_POST['manager_name']);
    $manager_contact = mysqli_real_escape_string($conn, $_POST['manager_contact']);
    $address = mysqli_real_escape_string($conn, $_POST['address']);

    // Check required fields
    if (!empty($company_id) && !empty($company_name) && !empty($contact) && !empty($manager_name) && !empty($manager_contact) && !empty($address)) {
        
        // Update query
        $update_query = mysqli_query($conn, "UPDATE `company` SET 
            `name` = '$company_name', 
            `manager_name` = '$manager_name', 
            `manager_contact` = '$manager_contact', 
            `contact` = '$contact', 
            `other_contact` = '$other_contact', 
            `address` = '$address' 
            WHERE `id` = '$company_id'
        ");

        // Check result
        if ($update_query) {
            $_SESSION['edit_company'] = 'Successfully Updated ' . $company_name;
        } else {
            $_SESSION['edit_company'] = 'Query could not execute!';
        }

        exit();
    } else {
        $_SESSION['edit_company'] = 'Please fill all the fields';
    }
}

//------------------Editing Company End-------------------------------



//---------------- Adding Partner Start-----------------------------

if (isset($_POST['partner_added'])) {
   

    // Assign and escape data
    $branch_id = mysqli_real_escape_string($conn, $_POST['s_branch_id']);
    $name = mysqli_real_escape_string($conn, $_POST['s_name']);
    $cnic = mysqli_real_escape_string($conn, $_POST['s_cnic']);
    $email = mysqli_real_escape_string($conn, $_POST['s_email']);
    $phone = mysqli_real_escape_string($conn, $_POST['s_phone']);
    $city = mysqli_real_escape_string($conn, $_POST['s_city']);
    $country = mysqli_real_escape_string($conn, $_POST['s_country']);
    $address = mysqli_real_escape_string($conn, $_POST['s_address']);
    $investment = mysqli_real_escape_string($conn, $_POST['s_investment']);
    $share = mysqli_real_escape_string($conn, $_POST['s_share']);
    $date = date('Y-m-d'); // assuming you want to store current date

    // Check if CNIC or Email already exists
    $check_query = mysqli_query($conn, "SELECT * FROM `partners` WHERE `email` = '$email' OR `cnic_number` = '$cnic'");

    if (mysqli_num_rows($check_query) > 0) {
        $_SESSION['partner'] = 'Error: CNIC Number or Email Address Already Exists!';
    } else {
        // Check if all required fields are filled
        if (
            !empty($branch_id) && !empty($name) && !empty($phone) &&
            !empty($city) && !empty($country) && !empty($address) &&
            !empty($investment) && !empty($share)
        ) {
            // Insert into database
            $insert_query = mysqli_query($conn, "INSERT INTO `partners` 
            (`branch_id`, `name`, `cnic_number`, `email`, `phone`, `address`, `city`, `country`, `investment`, `share`, `date`) 
            VALUES 
            ('$branch_id', '$name', '$cnic', '$email', '$phone', '$address', '$city', '$country', '$investment', '$share', '$date')");

            if ($insert_query) {
                $_SESSION['partner'] = 'Successfully Registered ' . $name . ' as Partner.';
            } else {
                $_SESSION['partner'] = 'Query could not execute!';
            }

            exit();
        } else {
            $_SESSION['partner'] = 'Please fill all required fields.';
        }
    }
}

	
//------------------Adding Partner End-------------------------------




//---------------- Editing Partner Start-----------------------------

if (isset($_POST['partner_edited'])) {
    
    // Assign and escape data
    $branch_id = mysqli_real_escape_string($conn, $_POST['s_branch_id']);
    $name = mysqli_real_escape_string($conn, $_POST['s_name']);
    $cnic = mysqli_real_escape_string($conn, $_POST['s_cnic']);
    $email = mysqli_real_escape_string($conn, $_POST['s_email']);
    $phone = mysqli_real_escape_string($conn, $_POST['s_phone']);
    $city = mysqli_real_escape_string($conn, $_POST['s_city']);
    $country = mysqli_real_escape_string($conn, $_POST['s_country']);
    $address = mysqli_real_escape_string($conn, $_POST['s_address']);
    $investment = mysqli_real_escape_string($conn, $_POST['s_investment']);
    $share = mysqli_real_escape_string($conn, $_POST['s_share']);
    
    $partner_id = $_GET['partner_id'];

    // Check if email or CNIC already exists for another partner
    $check_query = mysqli_query($conn, "SELECT * FROM `partners` WHERE `email` = '$email' AND `id` != '$partner_id'");
    $check_query1 = mysqli_query($conn, "SELECT * FROM `partners` WHERE `cnic_number` = '$cnic' AND `id` != '$partner_id'");

    if (mysqli_num_rows($check_query) > 0 || mysqli_num_rows($check_query1) > 0) {
        $_SESSION['partner_edit'] = 'Error: CNIC Number or Email Address Already Exists!';
    } else {
        // Update the partner if all fields are filled
        if (
            !empty($branch_id) && !empty($name) && !empty($phone) &&
            !empty($city) && !empty($country) && !empty($address) &&
            !empty($investment) && !empty($share)
        ) {
            $update_query = mysqli_query($conn, "UPDATE `partners` 
                SET 
                    `branch_id` = '$branch_id', 
                    `name` = '$name', 
                    `cnic_number` = '$cnic', 
                    `email` = '$email', 
                    `phone` = '$phone', 
                    `address` = '$address', 
                    `city` = '$city', 
                    `country` = '$country', 
                    `investment` = '$investment', 
                    `share` = '$share' 
                WHERE `id` = '$partner_id'");

            if ($update_query) {
                $_SESSION['partner_edit'] = 'Successfully Edited Partner ' . $name;
            } else {
                $_SESSION['partner_edit'] = 'Query could not execute!';
            }

            exit();
        }
    }
}

	
//------------------Editing Partner End-------------------------------




//---------------- Adding Sale Man Start-----------------------------

if (isset($_POST['sale_man_added'])) {
   
    // Assign and escape data
    $branch_id = mysqli_real_escape_string($conn, $_POST['s_branch_id']);
    $name = mysqli_real_escape_string($conn, $_POST['s_name']);
    $cnic = mysqli_real_escape_string($conn, $_POST['s_cnic']);
    $email = mysqli_real_escape_string($conn, $_POST['s_email']);
    $phone = mysqli_real_escape_string($conn, $_POST['s_phone']);
    $city = mysqli_real_escape_string($conn, $_POST['s_city']);
    $country = mysqli_real_escape_string($conn, $_POST['s_country']);
    $address = mysqli_real_escape_string($conn, $_POST['s_address']);
    $state = mysqli_real_escape_string($conn, $_POST['s_state']);
    $nationality = mysqli_real_escape_string($conn, $_POST['s_nationality']);
    $date = date('Y-m-d');

    // Check if email or CNIC already exists
    $check_query = mysqli_query($conn, "SELECT * FROM `sale_men` WHERE `email` = '$email' OR `cnic_number` = '$cnic'");

    if (mysqli_num_rows($check_query) > 0) {
        $_SESSION['sale_man'] = 'Error: CNIC Number or Email Address Already Exists!';
    } else {
        // Insert into database if all required fields are filled
        if (
            !empty($name) && !empty($phone) && !empty($city) &&
            !empty($country) && !empty($address) && !empty($state) && !empty($nationality)
        ) {
            $insert_query = mysqli_query($conn, "
                INSERT INTO `sale_men` 
                (`id`, `branch_id`, `name`, `cnic_number`, `email`, `phone`, `address`, `city`, `country`, `state`, `nationality`, `date`) 
                VALUES 
                (NULL, '$branch_id', '$name', '$cnic', '$email', '$phone', '$address', '$city', '$country', '$state', '$nationality', '$date')
            ");

            if ($insert_query) {
                $_SESSION['sale_man'] = 'Successfully Registered ' . $name . ' as Sale man';
            } else {
                $_SESSION['sale_man'] = 'Query could not execute!';
            }

            exit();
        }
    }
}

	
//------------------Adding Sale Man End-------------------------------




//---------------- Editing Sale Man Start-----------------------------

if (isset($_POST['sale_man_edited'])) {
  

    // Assign and escape form data
    $branch_id = mysqli_real_escape_string($conn, $_POST['s_branch_id']);
    $name = mysqli_real_escape_string($conn, $_POST['s_name']);
    $cnic = mysqli_real_escape_string($conn, $_POST['s_cnic']);
    $email = mysqli_real_escape_string($conn, $_POST['s_email']);
    $phone = mysqli_real_escape_string($conn, $_POST['s_phone']);
    $city = mysqli_real_escape_string($conn, $_POST['s_city']);
    $country = mysqli_real_escape_string($conn, $_POST['s_country']);
    $address = mysqli_real_escape_string($conn, $_POST['s_address']);
    $state = mysqli_real_escape_string($conn, $_POST['s_state']);
    $nationality = mysqli_real_escape_string($conn, $_POST['s_nationality']);

    $sale_man_id = $_GET['sale_man_id'];

    // Check if email or CNIC already exists for another saleman
    $check_query = mysqli_query($conn, "SELECT * FROM `sale_men` WHERE `email` = '$email' AND `id` != '$sale_man_id'");
    $check_query1 = mysqli_query($conn, "SELECT * FROM `sale_men` WHERE `cnic_number` = '$cnic' AND `id` != '$sale_man_id'");

    if (mysqli_num_rows($check_query) > 0 || mysqli_num_rows($check_query1) > 0) {
        $_SESSION['sale_man_edit'] = 'Error: CNIC Number or Email Address Already Exists!';
    } else {
        // Update data if all fields are filled
        if (
            !empty($name) && !empty($phone) && !empty($city) &&
            !empty($country) && !empty($address) && !empty($state) && !empty($nationality)
        ) {
            $update_query = mysqli_query($conn, "
                UPDATE `sale_men` 
                SET 
                    `name` = '$name',
                    `cnic_number` = '$cnic',
                    `email` = '$email',
                    `phone` = '$phone',
                    `address` = '$address',
                    `city` = '$city',
                    `country` = '$country',
                    `state` = '$state',
                    `nationality` = '$nationality' 
                WHERE `id` = '$sale_man_id'
            ");

            if ($update_query) {
                $_SESSION['sale_man_edit'] = 'Successfully Edited Saleman ' . $name;
            } else {
                $_SESSION['sale_man_edit'] = 'Query could not execute!';
            }

            exit();
        }
    }
}
	
//------------------Editing Sale Man End-------------------------------





//------------------Adding Branch start-------------------------------

if (isset($_POST['branch_added'])) {
    
    $date = date("Y-m-d");

    // Use real_escape_string via $conn
    $name = $conn->real_escape_string($_POST['s_name']);
    $manager = (int) $_POST['s_manager'];
    $pass = password_hash($_POST['s_pass'], PASSWORD_BCRYPT); // use bcrypt instead of md5
    $location = $conn->real_escape_string($_POST['s_location']);
    $area = floatval($_POST['s_area']);
    $image = $conn->real_escape_string($_POST['s_image']);
    $map = $conn->real_escape_string($_POST['s_map']);
    $sqr = floatval($_POST['s_sqr']);
    $status = (int) $_POST['s_status'];
    $branch_phone = $conn->real_escape_string($_POST['s_branch_phone']);

    // Check if branch already exists
    $check_stmt = $conn->prepare("SELECT id FROM branches WHERE name = ?");
    $check_stmt->bind_param("s", $name);
    $check_stmt->execute();
    $check_stmt->store_result();

    if ($check_stmt->num_rows > 0) {
        $_SESSION['branch'] = "Error: Branch '$name' Already Exists!";
    } else {
        if (!empty($name) && !empty($location) && !empty($area) && !empty($image) && !empty($manager) && !empty($map) && !empty($sqr)) {
            // Insert branch
            $insert_stmt = $conn->prepare("
                INSERT INTO branches (name, manager, location, area, square_feet_size, status, branch_phone, image, map, date)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
            ");
            $insert_stmt->bind_param("sissiiisss", $name, $manager, $location, $area, $sqr, $status, $branch_phone, $image, $map, $date);
            $insert_stmt->execute();
            $branch_id = $insert_stmt->insert_id;
            $insert_stmt->close();

            // Update manager with branch ID and hashed password
            $manager_stmt = $conn->prepare("UPDATE managers SET branch_id = ?, password = ? WHERE id = ?");
            $manager_stmt->bind_param("isi", $branch_id, $pass, $manager);
            $manager_stmt->execute();
            $manager_stmt->close();

            // Insert default control accounts
            $control_accounts = [
                ['Capital', '01'],
                ['Land Owners', '02'],
                ['Current Accounts', '03'],
                ['Admin Expenses', '04'],
                ['Development Expenses', '05']
            ];

            $control_stmt = $conn->prepare("
                INSERT INTO control_accounts (branch_id, name, description, gcode, date)
                VALUES (?, ?, '', ?, ?)
            ");

            foreach ($control_accounts as [$control_name, $gcode]) {
                $control_stmt->bind_param("isss", $branch_id, $control_name, $gcode, $date);
                $control_stmt->execute();
            }

            $control_stmt->close();

            $_SESSION['branch'] = "Successfully added new Branch '$name'";
            exit();
        }
    }

    $check_stmt->close();
    $conn->close();
}



//------------------Adding Branch End-------------------------------
	
	
	

//------------------Adding Bank start-------------------------------


if (isset($_POST['bank_added'])) {
   

    // Assign and escape data
    $name = mysqli_real_escape_string($conn, $_POST['s_name']);
    $date = date('Y-m-d');

    // Check if bank with the same name already exists
    $check_query = mysqli_query($conn, "SELECT * FROM `banks` WHERE `name` = '$name'");

    if (mysqli_num_rows($check_query) > 0) {
        $_SESSION['bank'] = 'Error: Bank ' . $name . ' Already Exists!';
    } else {
        // Insert if name is not empty
        if (!empty($name)) {
            $insert_query = mysqli_query($conn, "INSERT INTO `banks` (`id`, `name`, `date`) VALUES (NULL, '$name', '$date')");

            if ($insert_query) {
                $_SESSION['bank'] = 'Successfully added new Bank ' . $name;
            } else {
                $_SESSION['bank'] = 'Failed to add bank due to query error.';
            }

            exit();
        }
    }
}


//------------------Adding Bank End-------------------------------
	
	
	
	
//------------------Adding Bank Account start-------------------------------

if (isset($_POST['bank_account_added'])) {


    // Assign and escape data
    $bank_id = mysqli_real_escape_string($conn, $_POST['s_bank_id']);
    $title = mysqli_real_escape_string($conn, $_POST['s_title']);
    $balance = mysqli_real_escape_string($conn, $_POST['s_balance']);
    $account_number = mysqli_real_escape_string($conn, $_POST['s_account_number']);
    $phone = mysqli_real_escape_string($conn, $_POST['s_phone']);
    $date = date("Y-m-d");

    // Check if the account number already exists for the selected bank
    $check_query = mysqli_query($conn, "SELECT * FROM `bank_accounts` WHERE `account_number` = '$account_number' AND `bank_id` = '$bank_id'");

    if (mysqli_num_rows($check_query) > 0) {
        $_SESSION['bank_account'] = 'Error: Bank Account Number ' . $account_number . ' Already Exists!';
    } else {
        // Insert new bank account if all fields are filled
        if (!empty($bank_id) && !empty($title) && !empty($balance) && !empty($account_number) && !empty($phone)) {
            $insert_query = mysqli_query($conn, "
                INSERT INTO `bank_accounts` 
                (`id`, `bank_id`, `account_title`, `balance`, `account_number`, `phone`, `date`) 
                VALUES (NULL, '$bank_id', '$title', '$balance', '$account_number', '$phone', '$date')
            ");

            if ($insert_query) {
                $_SESSION['bank_account'] = 'Successfully added new Bank Account ' . $account_number;
            } else {
                $_SESSION['bank_account'] = 'Failed to add bank account due to query error.';
            }

            exit();
        }
    }
}

//------------------Adding Bank Account End-------------------------------
	
	
	
	
	
//------------------Editing Branch start-------------------------------

if (isset($_POST['branch_edited'])) {
    include("db.php"); // Make sure $conn = mysqli_connect(...) is defined in db.php

    // Assign data to variables
    $name = mysqli_real_escape_string($conn, $_POST['s_name']);
    $manager = mysqli_real_escape_string($conn, $_POST['s_manager']);
    $pass = mysqli_real_escape_string($conn, $_POST['s_pass']);
    $location = mysqli_real_escape_string($conn, $_POST['s_location']);
    $area = mysqli_real_escape_string($conn, $_POST['s_area']);
    $image = mysqli_real_escape_string($conn, $_POST['s_image']);
    $map = mysqli_real_escape_string($conn, $_POST['s_map']);
    $status = mysqli_real_escape_string($conn, $_POST['s_status']);
    $branch_phone = mysqli_real_escape_string($conn, $_POST['s_branch_phone']);
    $branch_id_s = mysqli_real_escape_string($conn, $_GET['branch_id']);

    // Check if branch name already exists
    $check_query = mysqli_query($conn, "SELECT * FROM `branches` WHERE `name` = '$name'");
    
    if (mysqli_num_rows($check_query) > 1) {
        $_SESSION['edit_branch'] = 'Error: Branch ' . $name . ' Already Exists!';
    } else {
        if (!empty($name) && !empty($location) && !empty($area) && !empty($image) && !empty($manager)) {

            // Get current manager ID of the branch
            $current_manager_branch_id = null;
            $select_query1 = "SELECT * FROM `managers` WHERE `branch_id` = '$branch_id_s'";
            $result_query1 = mysqli_query($conn, $select_query1);
            while ($row1 = mysqli_fetch_assoc($result_query1)) {
                $current_manager_branch_id = $row1['id'];
            }

            // Reset branch of old manager
            if ($current_manager_branch_id && $current_manager_branch_id != $manager) {
                mysqli_query($conn, "UPDATE `managers` SET `branch_id` = '0', `password` = '0' WHERE `id` = '$current_manager_branch_id'");
            }

            // Update branch with conditional image/map logic
            if ($image == 'uploads/.' && $map != 'uploads/.') {
                $update_query = mysqli_query($conn, "UPDATE `branches` SET `name` = '$name', `manager` = '$manager', `location` = '$location', `area` = '$area', `status` = '$status', `branch_phone` = '$branch_phone', `map` = '$map' WHERE `id` = '$branch_id_s'");
            } elseif ($map == 'uploads/.' && $image != 'uploads/.') {
                $update_query = mysqli_query($conn, "UPDATE `branches` SET `name` = '$name', `manager` = '$manager', `location` = '$location', `area` = '$area', `status` = '$status', `branch_phone` = '$branch_phone', `image` = '$image' WHERE `id` = '$branch_id_s'");
            } elseif ($map == 'uploads/.' && $image == 'uploads/.') {
                $update_query = mysqli_query($conn, "UPDATE `branches` SET `name` = '$name', `manager` = '$manager', `location` = '$location', `area` = '$area', `status` = '$status', `branch_phone` = '$branch_phone' WHERE `id` = '$branch_id_s'");
            } else {
                $update_query = mysqli_query($conn, "UPDATE `branches` SET `name` = '$name', `manager` = '$manager', `location` = '$location', `area` = '$area', `status` = '$status', `branch_phone` = '$branch_phone', `image` = '$image', `map` = '$map' WHERE `id` = '$branch_id_s'");
            }

            // Get updated branch ID
            $branch_id = '';
            $select_query = "SELECT * FROM `branches` WHERE `manager` = '$manager'";
            $result_query = mysqli_query($conn, $select_query);
            while ($row = mysqli_fetch_assoc($result_query)) {
                $branch_id = $row['id'];
            }

            // Update manager with branch ID and password
            mysqli_query($conn, "UPDATE `managers` SET `branch_id` = '$branch_id', `password` = '$pass' WHERE `id` = '$manager'");

            $_SESSION['edit_branch'] = 'Successfully Made Changes in ' . $name;
            exit();
        }
    }
}


//------------------Editing Branch End-------------------------------
	
	
	
	
//---------------- Adding Customer Start-----------------------------

if (isset($_POST['customer_added'])) {
   

    // Assign data to variables
    $branch_id = mysqli_real_escape_string($conn, $_POST['s_branch_id']);
    $name = mysqli_real_escape_string($conn, $_POST['s_name']);
    $fname = mysqli_real_escape_string($conn, $_POST['s_fname']);
    $cnic = mysqli_real_escape_string($conn, $_POST['s_cnic']);
    $email = mysqli_real_escape_string($conn, $_POST['s_email']);
    $phone = mysqli_real_escape_string($conn, $_POST['s_phone']);
    $other_contact = mysqli_real_escape_string($conn, $_POST['s_other_contact']);
    $city = mysqli_real_escape_string($conn, $_POST['s_city']);
    $country = mysqli_real_escape_string($conn, $_POST['s_country']);
    $address = mysqli_real_escape_string($conn, $_POST['s_address']);
    $state = mysqli_real_escape_string($conn, $_POST['s_state']);
    $gender = mysqli_real_escape_string($conn, $_POST['s_gender']);
    $image = mysqli_real_escape_string($conn, $_POST['s_image']);

    // Check if email or CNIC already exists
    $check_query = mysqli_query($conn, "SELECT * FROM `customers` WHERE `email` = '$email' AND `branch_id` = '$branch_id' AND `email` != ''");
    $check_query1 = mysqli_query($conn, "SELECT * FROM `customers` WHERE `cnic_number` = '$cnic' AND `branch_id` = '$branch_id' AND `cnic_number` != ''");

    if (mysqli_num_rows($check_query) > 0 || mysqli_num_rows($check_query1) > 0) {
        $_SESSION['customer'] = 'Error: CNIC Number or Email Address Already Exists!';
    } else {
        // Insert data in database
        if (!empty($name) && !empty($fname) && !empty($image) && !empty($phone) && !empty($city) && !empty($country) && !empty($address) && !empty($state) && !empty($gender)) {
            
            $insert_query = mysqli_query($conn, "
                INSERT INTO `customers` 
                (`id`, `branch_id`, `name`, `fname`, `cnic_number`, `email`, `phone`, `other_contact`, `address`, `city`, `country`, `state`, `gender`, `image`, `date`) 
                VALUES 
                (NULL, '$branch_id', '$name', '$fname', '$cnic', '$email', '$phone', '$other_contact', '$address', '$city', '$country', '$state', '$gender', '$image', '$date')
            ");

            $_SESSION['customer'] = 'Successfully Registered ' . $name . ' as Customer';
            exit();
        }
    }
}


	
//------------------Adding Customer End-------------------------------



	
//---------------- Editing Customer Start-----------------------------

if (isset($_POST['customer_edited'])) {

    // Assign data to variables
    $branch_id = mysqli_real_escape_string($conn, $_POST['s_branch_id']);
    $name = mysqli_real_escape_string($conn, $_POST['s_name']);
    $fname = mysqli_real_escape_string($conn, $_POST['s_fname']);
    $cnic = mysqli_real_escape_string($conn, $_POST['s_cnic']);
    $email = mysqli_real_escape_string($conn, $_POST['s_email']);
    $phone = mysqli_real_escape_string($conn, $_POST['s_phone']);
    $city = mysqli_real_escape_string($conn, $_POST['s_city']);
    $country = mysqli_real_escape_string($conn, $_POST['s_country']);
    $address = mysqli_real_escape_string($conn, $_POST['s_address']);
    $state = mysqli_real_escape_string($conn, $_POST['s_state']);
    $gender = mysqli_real_escape_string($conn, $_POST['s_gender']);
    $image = mysqli_real_escape_string($conn, $_POST['s_image']);

    $customer_id = $_GET['customer_id'];

    // Check if email or CNIC already exists in same branch but different customer
    $check_query = mysqli_query($conn, "SELECT * FROM `customers` WHERE `email` = '$email' AND `branch_id` = '$branch_id' AND `id` != '$customer_id' AND `email` != ''");
    $check_query1 = mysqli_query($conn, "SELECT * FROM `customers` WHERE `cnic_number` = '$cnic' AND `branch_id` = '$branch_id' AND `id` != '$customer_id' AND `cnic_number` != ''");

    if (mysqli_num_rows($check_query) > 0 || mysqli_num_rows($check_query1) > 0) {
        $_SESSION['edit_customer'] = 'Error: CNIC Number or Email Address Already Exists!';
    } else {
        // Update customer only if all required fields are filled
        if (!empty($name) && !empty($fname) && !empty($image) && !empty($phone) && !empty($city) && !empty($country) && !empty($address) && !empty($state) && !empty($gender)) {

            if ($image == 'uploads/.') {
                $update_query = mysqli_query($conn, "
                    UPDATE `customers` 
                    SET 
                        `branch_id` = '$branch_id',
                        `name` = '$name',
                        `fname` = '$fname',
                        `cnic_number` = '$cnic',
                        `email` = '$email',
                        `phone` = '$phone',
                        `address` = '$address',
                        `city` = '$city',
                        `country` = '$country',
                        `state` = '$state',
                        `gender` = '$gender'
                    WHERE `id` = '$customer_id'
                ");
            } else {
                $update_query = mysqli_query($conn, "
                    UPDATE `customers` 
                    SET 
                        `branch_id` = '$branch_id',
                        `name` = '$name',
                        `fname` = '$fname',
                        `cnic_number` = '$cnic',
                        `email` = '$email',
                        `phone` = '$phone',
                        `address` = '$address',
                        `city` = '$city',
                        `country` = '$country',
                        `state` = '$state',
                        `gender` = '$gender',
                        `image` = '$image'
                    WHERE `id` = '$customer_id'
                ");
            }

            $_SESSION['edit_customer'] = 'Successfully Edited Customer Details of ' . $name;
            exit();
        }
    }
}

	
//------------------Editing Customer End-------------------------------




	
//---------------- Adding Land Owner Start-----------------------------

if(isset($_POST['land_owner_added'])){

    $branch_id = $_POST['s_branch_id'];
    $name = $_POST['s_name'];
    $fname = $_POST['s_fname'];
    $cnic = $_POST['s_cnic'];
    $email = $_POST['s_email'];
    $phone = $_POST['s_phone'];
    $city = $_POST['s_city'];
    $country = $_POST['s_country'];
    $address = $_POST['s_address'];
    $state = $_POST['s_state'];
    $image = $_POST['s_image'];
    $date = date("Y-m-d");

    $check_query = mysqli_query($conn, "SELECT * FROM `land_owners` WHERE `email` = '$email' AND `branch_id` = '$branch_id' AND `email` != ''");
    $check_query1 = mysqli_query($conn, "SELECT * FROM `land_owners` WHERE `cnic_number` = '$cnic' AND `branch_id` = '$branch_id' AND `cnic_number` != ''");

    if(mysqli_num_rows($check_query) > 0 || mysqli_num_rows($check_query1) > 0){
        $_SESSION['land_owner'] = 'Error: CNIC Number or Email Address Already Exists!';
    } else {
        if(!empty($name) && !empty($fname) && !empty($image) && !empty($phone) && !empty($city) && !empty($country) && !empty($address) && !empty($state)) {

            mysqli_query($conn, "INSERT INTO `land_owners` (`branch_id`, `name`, `fname`, `cnic_number`, `email`, `phone`, `address`, `city`, `country`, `state`, `image`, `date`) 
            VALUES ('$branch_id', '$name', '$fname', '$cnic', '$email', '$phone', '$address', '$city', '$country', '$state', '$image', '$date')");

            // Check and create control account
            $control_query = mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `branch_id` = '$branch_id' AND `name` = 'Land Owner Payable'");
            if(mysqli_num_rows($control_query) < 1){
                $gcode_q = mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `branch_id` = '$branch_id' ORDER BY gcode DESC LIMIT 1");
                $row = mysqli_fetch_assoc($gcode_q);
                preg_match("/(.*?)(\d+)$/", $row['gcode'], $matches);
                $new_control_gcode = $matches[1].'0'.($matches[2]+1);
                mysqli_query($conn, "INSERT INTO `control_accounts` (`branch_id`, `name`, `description`, `gcode`, `date`) 
                VALUES ('$branch_id', 'Land Owner Payable', 'Control For Land Owner Payments ', '$new_control_gcode', '$date')");
            }

            $control_data = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `branch_id` = '$branch_id' AND `name` = 'Land Owner Payable'"));
            $control_account_id = $control_data['id'];

            // Check and create general ledger
            $general_query = mysqli_query($conn, "SELECT * FROM `general_ledgers` WHERE `branch_id` = '$branch_id' AND `control_account_id` = '$control_account_id' AND `name` = 'Land Payments'");
            if(mysqli_num_rows($general_query) < 1){
                $gcode_q = mysqli_query($conn, "SELECT * FROM `general_ledgers` WHERE `branch_id` = '$branch_id' AND `control_account_id` = '$control_account_id' ORDER BY gcode DESC LIMIT 1");
                $row = mysqli_fetch_assoc($gcode_q);
                preg_match("/(.*?)(\d+)$/", $row['gcode'], $matches);
                $new_general_gcode = $matches[1].'0'.($matches[2]+1);
                $new_gcode = $new_control_gcode.'-'.$new_general_gcode;
                mysqli_query($conn, "INSERT INTO `general_ledgers` (`branch_id`, `control_account_id`, `name`, `description`, `gcode`, `date`) 
                VALUES ('$branch_id', '$control_account_id', 'Land Payments', 'General For Land Payments', '$new_gcode', '$date')");
            }

            $general_data = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM `general_ledgers` WHERE `branch_id` = '$branch_id' AND `control_account_id` = '$control_account_id' AND `name` = 'Land Payments'"));
            $general_account_id = $general_data['id'];

            // Generate ledger gcode
            $ledger_query = mysqli_query($conn, "SELECT * FROM `ledgers` WHERE `branch_id` = '$branch_id' AND `control_account_id` = '$control_account_id' AND `general_ledger_id` = '$general_account_id' ORDER BY gcode DESC LIMIT 1");
            $gcode = "";
            if(mysqli_num_rows($ledger_query) > 0){
                $ledger_row = mysqli_fetch_assoc($ledger_query);
                preg_match("/(.*?)(\d+)$/", $ledger_row['gcode'], $matches);
                $gcode = $matches[1].'0'.($matches[2]+1);
            } else {
                $gcode = $new_control_gcode.'-'.$new_general_gcode.'-001';
            }

            // get last land owner id
            $land_owner_id = mysqli_insert_id($conn);

            mysqli_query($conn, "INSERT INTO `ledgers` (`branch_id`, `control_account_id`, `general_ledger_id`, `customer_id`, `name`, `description`, `gcode`, `debit`, `credit`, `balance`, `date`) 
            VALUES ('$branch_id', '$control_account_id', '$general_account_id', '$land_owner_id', '$name', 'Payments of $name', '$gcode', '0', '0', '0', '$date')");

            $_SESSION['land_owner'] = 'Successfully Registered '.$name.' as Land Owner';	
            exit();
        }
    }
}


	
//------------------Adding land Owner End-------------------------------




	
//---------------- Expanding Area Start-----------------------------


if (isset($_POST['area_expanded'])) {

    // Sanitize input using mysqli_real_escape_string
    $branch_id = mysqli_real_escape_string($conn, $_POST['s_branch_id']);
    $name = mysqli_real_escape_string($conn, $_POST['s_name']);
    $cnic = mysqli_real_escape_string($conn, $_POST['s_cnic']);
    $phone = mysqli_real_escape_string($conn, $_POST['s_phone']);
    $address = mysqli_real_escape_string($conn, $_POST['s_address']);
    $area = mysqli_real_escape_string($conn, $_POST['s_area']);
    $expanding_date = mysqli_real_escape_string($conn, $_POST['s_expanding_date']);
    $price = mysqli_real_escape_string($conn, $_POST['s_price']);
    $date = date("Y-m-d"); // Assuming you want current date

    // Check if CNIC already exists
    $check_query = mysqli_query($conn, "SELECT * FROM `expand_area` WHERE `cnic_number` = '$cnic' AND `branch_id` = '$branch_id'");

    if (mysqli_num_rows($check_query) > 0) {
        $_SESSION['expand_area'] = 'Error: CNIC Number Already Exists!';
    } else {
        // Validate required fields
        if (!empty($name) && !empty($cnic) && !empty($phone) && !empty($address) && !empty($area) && !empty($expanding_date) && !empty($price)) {
            
            // Insert new expanded area record
            $insert_query = mysqli_query($conn, "INSERT INTO `expand_area` (`id`, `branch_id`, `old_owner_name`, `cnic_number`, `phone`, `address`, `area`, `expanding_date`, `price`, `date`) VALUES (NULL, '$branch_id', '$name', '$cnic', '$phone', '$address', '$area', '$expanding_date', '$price', '$date')");

            // Fetch current area of the branch
            $result_query = mysqli_query($conn, "SELECT * FROM `branches` WHERE `id` = '$branch_id'") or die(mysqli_error($conn));
            $row = mysqli_fetch_assoc($result_query);
            $old_area = $row['area'];
            $branch_name = $row['name'];

            $new_area = $old_area + $area;

            // Update area of the branch
            $update_query = mysqli_query($conn, "UPDATE `branches` SET `area` = '$new_area' WHERE `id` = '$branch_id'");

            $_SESSION['expand_area'] = 'Successfully Expanded Area of ' . $branch_name;
            exit();
        }
    }
}


	
//------------------Expanding Area End-------------------------------





//---------------Adding Branch Expenses start--------------------------

if(isset($_POST['expense_added'])){
	
	// Assign data to variables
	$branch_id = ($_POST['s_branch_id']);
	$category = ($_POST['s_category']);
	$name = ($_POST['s_name']);
	$price = ($_POST['s_price']);
	$quantity = ($_POST['s_quantity']);
	$type = ($_POST['s_type']);
	
	//INsert data in database
	if(!empty($name) && !empty($category) && !empty($price) && !empty($quantity) && !empty($type))
	{
		$insert_query=mysqli_query($conn, "insert into branch_expenses (id, branch_id, category, name, price, quantity, type, date) values(NULL, '$branch_id', '$category', '$name', '$price', '$quantity', '$type', '$date')");
		$_SESSION['expenses'] = 'Successfully added branch Expenses';	
	exit();
	}

}

//------------------Adding Branch Expenses End-------------------------




//---------------Adding Branch Category start--------------------------

if (isset($_POST['branch_category_added'])) {
   

    // Assign and sanitize input
    $branch_id = mysqli_real_escape_string($conn, $_POST['s_branch_id']);
    $name = mysqli_real_escape_string($conn, $_POST['s_name']);
    $area = floatval($_POST['s_area']); // ensure numeric value
    $date = date("Y-m-d");

    // Get total branch area
    $area_query = mysqli_query($conn, "SELECT `area` FROM `branches` WHERE `id` = '$branch_id'");
    $branch_area = 0;
    if ($row1 = mysqli_fetch_assoc($area_query)) {
        $branch_area = $row1['area'];
    }

    // Calculate already assigned area
    $total_area = 0;
    $result_query = mysqli_query($conn, "SELECT `area` FROM `branch_categories` WHERE `branch_id` = '$branch_id'") or die(mysqli_error($conn));
    while ($row = mysqli_fetch_assoc($result_query)) {
        $total_area += $row['area'];
    }

    $total_area += $area;

    // Check for duplicate name
    $check_query = mysqli_query($conn, "SELECT 1 FROM `branch_categories` WHERE `name` = '$name' AND `branch_id` = '$branch_id'");
    
    if (mysqli_num_rows($check_query) > 0) {
        $_SESSION['category'] = 'Error: Floor Name Already Exists!';
    } elseif ($total_area > $branch_area) {
        $_SESSION['category'] = 'Error: Area exceeding more than Plaza Area!';
    } else {
        if (!empty($name) && !empty($branch_id) && !empty($area)) {
            mysqli_query($conn, "INSERT INTO `branch_categories` (`id`, `branch_id`, `name`, `area`, `date`) VALUES (NULL, '$branch_id', '$name', '$area', '$date')") or die(mysqli_error($conn));
            $_SESSION['category'] = 'Successfully added ' . $name;
            exit();
        }
    }
}



//------------------Adding Branch Category End-------------------------



//---------------Editing Branch Category start--------------------------

if (isset($_POST['branch_category_edited'])) {

    // Assign data to variables
    $branch_id = mysqli_real_escape_string($conn, $_POST['s_branch_id']);
    $name = mysqli_real_escape_string($conn, $_POST['s_name']);
    $area = mysqli_real_escape_string($conn, $_POST['s_area']);
    $block_id = mysqli_real_escape_string($conn, $_GET['block_id']);

    // Get total branch area
    $area_query = mysqli_query($conn, "SELECT `area` FROM `branches` WHERE `id` = '$branch_id'");
    $branch_area = 0;
    if ($row1 = mysqli_fetch_assoc($area_query)) {
        $branch_area = $row1['area'];
    }

    // Get sum of all other blocks (excluding current block)
    $result_query = mysqli_query($conn, "SELECT `area` FROM `branch_categories` WHERE `branch_id` = '$branch_id' AND `id` != '$block_id'") or die(mysqli_error($conn));
    $total_area = 0;
    while ($row = mysqli_fetch_assoc($result_query)) {
        $total_area += $row['area'];
    }
    $total_area += $area;

    // Check if floor name already exists (excluding current block)
    $check_query = mysqli_query($conn, "SELECT * FROM `branch_categories` WHERE `name` = '$name' AND `branch_id` = '$branch_id' AND `id` != '$block_id'");

    if (mysqli_num_rows($check_query) > 0) {
        $_SESSION['edit_block'] = 'Error: Floor Name Already Exists!';
    } elseif ($total_area > $branch_area) {
        $_SESSION['edit_block'] = 'Error: Area exceeding more than Branch Area!';
    } else {
        if (!empty($name) && !empty($branch_id) && !empty($area)) {
            mysqli_query($conn, "UPDATE `branch_categories` SET `branch_id` = '$branch_id', `name` = '$name', `area` = '$area' WHERE `id` = '$block_id'") or die(mysqli_error($conn));
            $_SESSION['edit_block'] = 'Successfully Edited ' . $name;
            exit();
        }
    }
}


//------------------Editing Branch Category End-------------------------



//---------------Adding Floor start--------------------------

if(isset($_POST['floor_added'])){
	// Assign data to variables
    
    $branch_id = mysqli_real_escape_string($conn, $_POST['s_branch_id']);
    $name = mysqli_real_escape_string($conn, $_POST['s_name']);
    $area = mysqli_real_escape_string($conn, $_POST['s_area']);
	
	//check if block Area Exceeding branch Area
	$area_query=select1($conn, 'branches','id',$branch_id);
	$branch_area = $area_query['area'];
		
	$result_query=mysqli_query($conn, "SELECT * FROM `floors` WHERE `branch_id` = '$branch_id'");
	$total_area = 0;
		while($row=mysqli_fetch_assoc($result_query)){
		$cat_area=$row['area'];
		$total_area += $cat_area; 
	}
	$total_area += $area;
	
	//check if block name already exists
	$check_query=mysqli_query($conn, "SELECT * FROM `floors` WHERE `name` = '$name' AND `branch_id` = '$branch_id'");
		
	
	if(mysqli_num_rows($check_query) > 0){
		$_SESSION['floor'] = 'Error: Floor Name Already Exists!';
	}elseif($total_area > $branch_area){
		$_SESSION['floor'] = 'Error: Area exceeding more than Plaza Area!';
	}else{
	//INsert data in database
	if(!empty($name) && !empty($branch_id) && !empty($area))
	{
		$insert_query=mysqli_query($conn, "insert into floors (id, branch_id, name, area, date) values(NULL, '$branch_id', '$name', '$area', NULL)");
	$_SESSION['floor'] = 'Successfully added '.$name;
	exit();
	}
	}

}

//------------------Adding Floor End-------------------------



//---------------Editing floor start--------------------------

if(isset($_POST['floor_edited'])){
    // Assign data to variables
    $branch_id = mysqli_real_escape_string($conn, $_POST['s_branch_id']);
    $name = mysqli_real_escape_string($conn, $_POST['s_name']);
    $area = mysqli_real_escape_string($conn, $_POST['s_area']);
    $floor_id = mysqli_real_escape_string($conn, $_GET['floor_id']);
	
	//check if block Area Exceeding branch Area
	$area_query=select1($conn, 'branches','id',$branch_id);
	$branch_area = $area_query['area'];
	
	$floor_id = $_GET['floor_id'];

		$select_query="SELECT * FROM `floors` WHERE `branch_id` = '$branch_id' AND `id` != '$floor_id'";
		$result_query=mysqli_query($conn, $select_query) or die($select_query."<br/><br/>".mysqli_error($conn));
		$total_area = 0;
			while($row=mysqli_fetch_assoc($result_query)){
			$cat_area=$row['area'];
			echo $total_area += $cat_area; 
		}
	echo $total_area += $area;

	//check if block name already exists
	$check_query=mysqli_query($conn, "SELECT * FROM `floors` WHERE `name` = '$name' AND `branch_id` = '$branch_id' AND `id` != '$floor_id'");
		
	
	if(mysqli_num_rows($check_query) > 0){
		$_SESSION['edit_floor'] = 'Error: Floor Name Already Exists!';
	}elseif($total_area > $branch_area){
		$_SESSION['edit_floor'] = 'Error: Area exceeding more than Branch Area!';
	}else{
	//INsert data in database
	if(!empty($name) && !empty($branch_id) && !empty($area))
	{
		$insert_query=mysqli_query($conn, "UPDATE `floors` SET `branch_id` = '$branch_id', `name` = '$name', `area` = '$area' WHERE `id` = '$floor_id';");
	$_SESSION['edit_floor'] = 'Successfully Edited '.$name;
	exit();
	}
	}

}

//------------------Editing floor End-------------------------


//---------------Adding Sub Category start--------------------------



if (isset($_POST['sub_category_added'])) {
   

    // Assign and sanitize input
    $branch_id = mysqli_real_escape_string($conn, $_POST['s_branch_id']);
    $block_id = mysqli_real_escape_string($conn, $_POST['s_block_id']);
    $name = mysqli_real_escape_string($conn, $_POST['s_name']);
    $type = mysqli_real_escape_string($conn, $_POST['s_type']);
    $area = floatval($_POST['s_area']); // ensure numeric
    $date = date("Y-m-d");

    // Get block area
    $block_area = 0;
    $result_query = mysqli_query($conn, "SELECT `area` FROM `branch_categories` WHERE `branch_id` = '$branch_id' AND `id` = '$block_id'") or die(mysqli_error($conn));
    if ($row = mysqli_fetch_assoc($result_query)) {
        $block_area = $row['area'];
    }

    // Sum existing sub_category area
    $s_total_area = 0;
    $area_query = mysqli_query($conn, "SELECT `area` FROM `sub_categories` WHERE `branch_id` = '$branch_id' AND `block_id` = '$block_id'");
    while ($row1 = mysqli_fetch_assoc($area_query)) {
        $s_total_area += $row1['area'];
    }

    // Sum existing plot area
    $p_total_area = 0;
    $area_query1 = mysqli_query($conn, "SELECT `area` FROM `plots` WHERE `branch_id` = '$branch_id' AND `block_id` = '$block_id'");
    while ($row1 = mysqli_fetch_assoc($area_query1)) {
        $p_total_area += $row1['area'];
    }

    // Total area including new sub-category
    $total_area = $s_total_area + $p_total_area + $area;

    // Check for duplicate sub-category name
    $check_query = mysqli_query($conn, "SELECT 1 FROM `sub_categories` WHERE `name` = '$name' AND `branch_id` = '$branch_id'");
    
    if (mysqli_num_rows($check_query) > 0) {
        $_SESSION['sub_category'] = "Error: $name Already Exists!";
    } elseif ($total_area > $block_area) {
        $_SESSION['sub_category'] = "Error: Area exceeding more than Block Area!";
    } else {
        if (!empty($name) && (!empty($type) || $type === '0') && !empty($area)) {
            mysqli_query($conn, "INSERT INTO `sub_categories` (`id`, `branch_id`, `block_id`, `name`, `type`, `area`, `date`) 
                                 VALUES (NULL, '$branch_id', '$block_id', '$name', '$type', '$area', '$date')") 
                                 or die(mysqli_error($conn));
            $_SESSION['sub_category'] = "Successfully added $name";
            exit();
        }
    }
}


//------------------Adding Sub Category End-------------------------



//--------------- ADD shop start--------------------------

if (isset($_POST['plot_added'])) {

    // Assign and sanitize input
    $branch_id = mysqli_real_escape_string($conn, $_POST['s_branch_id']);
    $block_id = mysqli_real_escape_string($conn, $_POST['s_block_id']);
    $plot_no = mysqli_real_escape_string($conn, $_POST['s_plot_no']);
    $sqrfoot = isset($_POST['s_sqrfoot']) ? floatval($_POST['s_sqrfoot']) : 0;
    $date = date("Y-m-d");

    // Get block area
    $block_area = 0;
    $result_query = mysqli_query($conn, "SELECT `area` FROM `branch_categories` WHERE `branch_id` = '$branch_id' AND `id` = '$block_id'")
        or die(mysqli_error($conn));
    if ($row = mysqli_fetch_assoc($result_query)) {
        $block_area = $row['area'];
    }

    // Sum sub-categories area
    $s_total_area = 0;
    $area_query = mysqli_query($conn, "SELECT `area` FROM `sub_categories` WHERE `branch_id` = '$branch_id' AND `block_id` = '$block_id'");
    while ($row2 = mysqli_fetch_assoc($area_query)) {
        $s_total_area += $row2['area'];
    }

    // Sum existing plots area
    $p_total_area = 0;
    $area_query1 = mysqli_query($conn, "SELECT `area` FROM `plots` WHERE `branch_id` = '$branch_id' AND `block_id` = '$block_id'");
    while ($row1 = mysqli_fetch_assoc($area_query1)) {
        $p_total_area += $row1['area'];
    }

    // Calculate total used area including new plot
    $total_area = $s_total_area + $p_total_area + $sqrfoot;

    // Check if plot number already exists
    $check_query = mysqli_query($conn, "SELECT 1 FROM `plots` WHERE `plot_no` = '$plot_no' AND `branch_id` = '$branch_id' AND `block_id` = '$block_id'");
    
    if (mysqli_num_rows($check_query) > 0) {
        $_SESSION['plot'] = 'Error: Shop Number ' . $plot_no . ' Already Exists!';
    } elseif ($total_area > $block_area) {
        $_SESSION['plot'] = 'Error: Area exceeding more than Floor Area!';
    } else {
        if (!empty($plot_no) && $sqrfoot > 0) {
            mysqli_query($conn, "INSERT INTO `plots` (`id`, `branch_id`, `block_id`, `plot_no`, `area`, `status`, `date`) 
                                 VALUES (NULL, '$branch_id', '$block_id', '$plot_no', '$sqrfoot', '1', '$date')")
                or die(mysqli_error($conn));
            $_SESSION['plot'] = 'Successfully Added Shop number ' . $plot_no;
            exit();
        }
    }
}



//------------------ ADD shop End-------------------------




//--------------- Edit Plot start--------------------------

if (isset($_POST['plot_edited'])) {

    // Sanitize inputs
    $branch_id = mysqli_real_escape_string($conn, $_POST['s_branch_id']);
    $block_id = mysqli_real_escape_string($conn, $_POST['s_block_id']);
    $plot_no = mysqli_real_escape_string($conn, $_POST['s_plot_no']);
    $sqrfoot = floatval($_POST['s_sqrfoot']);
    $plot_id = mysqli_real_escape_string($conn, $_GET['plot_id']);

    // Get block area
    $block_area = 0;
    $block_result = mysqli_query($conn, "SELECT `area` FROM `branch_categories` WHERE `branch_id` = '$branch_id' AND `id` = '$block_id'")
        or die(mysqli_error($conn));
    if ($row = mysqli_fetch_assoc($block_result)) {
        $block_area = $row['area'];
    }

    // Calculate total area of sub-categories
    $s_total_area = 0;
    $subcat_result = mysqli_query($conn, "SELECT `area` FROM `sub_categories` WHERE `branch_id` = '$branch_id' AND `block_id` = '$block_id'");
    while ($row2 = mysqli_fetch_assoc($subcat_result)) {
        $s_total_area += $row2['area'];
    }

    // Calculate total area of plots
    $p_total_area = 0;
    $plot_result = mysqli_query($conn, "SELECT `area` FROM `plots` WHERE `branch_id` = '$branch_id' AND `block_id` = '$block_id'");
    while ($row1 = mysqli_fetch_assoc($plot_result)) {
        $p_total_area += $row1['area'];
    }

    // Get original plot area to subtract
    $original_plot = mysqli_query($conn, "SELECT `area` FROM `plots` WHERE `id` = '$plot_id'");
    $plot_area = 0;
    if ($plot = mysqli_fetch_assoc($original_plot)) {
        $plot_area = $plot['area'];
    }

    // Total area after replacing old with new plot area
    $total_area = $s_total_area + $p_total_area - $plot_area + $sqrfoot;

    // Check if plot number already exists (excluding current plot ID)
    $check_query = mysqli_query($conn, "SELECT 1 FROM `plots` WHERE `plot_no` = '$plot_no' AND `branch_id` = '$branch_id' AND `block_id` = '$block_id' AND `id` != '$plot_id'");

    if (mysqli_num_rows($check_query) > 0) {
        $_SESSION['edit_plot'] = "Error: Shop Number $plot_no Already Exists!";
    } elseif ($total_area > $block_area) {
        $_SESSION['edit_plot'] = "Error: Area exceeding more than Floor Area!";
    } else {
        if (!empty($plot_no) && $sqrfoot > 0) {
            mysqli_query($conn, "UPDATE `plots` SET 
                `branch_id` = '$branch_id', 
                `block_id` = '$block_id', 
                `plot_no` = '$plot_no', 
                `area` = '$sqrfoot' 
                WHERE `id` = '$plot_id'")
            or die(mysqli_error($conn));
            
            $_SESSION['edit_plot'] = "Successfully Edited Shop number $plot_no";
            exit();
        }
    }
}


//------------------ Edit Plot End-------------------------



//--------------- ADD shop start--------------------------

if (isset($_POST['shop_added'])) {
   
    $date = date("Y-m-d"); // current date

    // Sanitize input
    $branch_id = mysqli_real_escape_string($conn, $_POST['branch_id']);
    $floor_id = mysqli_real_escape_string($conn, $_POST['floor_id']);
    $shop_no = mysqli_real_escape_string($conn, $_POST['shop_no']);
    $sqrfoot = isset($_POST['sqrfoot']) ? floatval($_POST['sqrfoot']) : 0;

    // Fetch floor area using select2()
    function select2($table, $col1, $val1, $col2, $val2) {
        global $conn;
        $val1 = mysqli_real_escape_string($conn, $val1);
        $val2 = mysqli_real_escape_string($conn, $val2);
        $query = "SELECT * FROM `$table` WHERE `$col1` = '$val1' AND `$col2` = '$val2' LIMIT 1";
        $result = mysqli_query($conn, $query);
        return mysqli_fetch_assoc($result);
    }

    $floor = select2('floors', 'branch_id', $branch_id, 'id', $floor_id);
    $block_area = isset($floor['area']) ? $floor['area'] : 0;

    // Sum total area already used by other shops on this floor
    $total_area = 0;
    $area_query1 = mysqli_query($conn, "SELECT `area` FROM `shops` WHERE `branch_id` = '$branch_id' AND `floor_id` = '$floor_id'");
    while ($row1 = mysqli_fetch_assoc($area_query1)) {
        $total_area += $row1['area'];
    }

    $total_area += $sqrfoot;

    // Check if shop number already exists
    $check_query = mysqli_query($conn, "SELECT 1 FROM `shops` WHERE `shop_no` = '$shop_no' AND `branch_id` = '$branch_id' AND `floor_id` = '$floor_id'");

    if (mysqli_num_rows($check_query) > 0) {
        $_SESSION['shop'] = "Error: Shop Number $shop_no Already Exists!";
    } elseif ($total_area > $block_area) {
        $_SESSION['shop'] = "Error: Area exceeding more than Floor Area!";
    } else {
        if (!empty($shop_no) && $sqrfoot > 0) {
            mysqli_query($conn, "INSERT INTO `shops` (`id`, `branch_id`, `floor_id`, `shop_no`, `area`, `status`, `date`) 
                                 VALUES (NULL, '$branch_id', '$floor_id', '$shop_no', '$sqrfoot', '1', '$date')")
                or die(mysqli_error($conn));
            $_SESSION['shop'] = "Successfully Added Shop number $shop_no";
            exit();
        }
    }
}


//------------------ ADD shop End-------------------------



//--------------- Edit shop start--------------------------

if(isset($_POST['shop_edited'])){
	// Assign data to variables
    // Sanitize inputs
    $shop_id = mysqli_real_escape_string($conn, $_POST['shop_id']);
    $branch_id = mysqli_real_escape_string($conn, $_POST['branch_id']);
    $floor_id = mysqli_real_escape_string($conn, $_POST['floor_id']);
    $shop_no = mysqli_real_escape_string($conn, $_POST['shop_no']);
    $sqrfoot = isset($_POST['sqrfoot']) ? floatval($_POST['sqrfoot']) : 0;
	
	//To Get The Total Area Of The shop
	//check if shop Area Exceeding floor Area
	$floor = select2($conn, 'floors','branch_id',$branch_id,'id',$floor_id);
	$block_area = isset($floor['area']) ? $floor['area'] : 0;
    // Calculate total area excluding the current shop
    $total_area = 0;
    $area_query = mysqli_query($conn, "SELECT `area` FROM `shops` WHERE `branch_id` = '$branch_id' AND `floor_id` = '$floor_id' AND `id` != '$shop_id'");
    while ($row = mysqli_fetch_assoc($area_query)) {
        $total_area += $row['area'];
    }

    // Add the updated area for the current shop
    $total_area += $sqrfoot;

	 // Check if shop number already exists (excluding current one)
    $check_query = mysqli_query($conn, "SELECT 1 FROM `shops` WHERE `shop_no` = '$shop_no' AND `branch_id` = '$branch_id' AND `floor_id` = '$floor_id' AND `id` != '$shop_id'");

    if (mysqli_num_rows($check_query) > 0) {
        $_SESSION['edit_shop'] = "Error: Shop Number $shop_no Already Exists!";
    } elseif ($total_area > $block_area) {
        $_SESSION['edit_shop'] = "Error: Area exceeding more than Floor Area!";
    } else {
        if (!empty($shop_no) && $sqrfoot > 0) {
            mysqli_query($conn, "UPDATE `shops` SET 
                                    `branch_id` = '$branch_id', 
                                    `floor_id` = '$floor_id', 
                                    `shop_no` = '$shop_no', 
                                    `area` = '$sqrfoot' 
                                 WHERE `id` = '$shop_id'")
            or die(mysqli_error($conn));

            $_SESSION['edit_shop'] = "Successfully Edited Shop number $shop_no";
            exit();
        }
    }

}

//------------------ Edit shop End-------------------------




//--------------- Register Plot start--------------------------


if (isset($_POST['plot_registerd'])) {
   
    $date = date("Y-m-d");

    // Sanitize inputs
    $branch_id = mysqli_real_escape_string($conn, $_POST['s_branch_id']);
    $block_id = mysqli_real_escape_string($conn, $_POST['s_block_id']);
    $plot_no = mysqli_real_escape_string($conn, $_POST['s_plot_no']);
    $customer_id = mysqli_real_escape_string($conn, $_POST['s_customer_id']);
    $registry_date = mysqli_real_escape_string($conn, $_POST['s_registry_date']);
    $registry_name = mysqli_real_escape_string($conn, $_POST['s_registry_name']);
    $marla = mysqli_real_escape_string($conn, $_POST['s_marla']);
    $sarsai = mysqli_real_escape_string($conn, $_POST['s_sarsai']);
    $sqrfoot = mysqli_real_escape_string($conn, $_POST['s_sqrfoot']);

    // Validate required fields
    if (!empty($registry_date) && !empty($customer_id) && !empty($registry_name)) {
        $query = "INSERT INTO `registory_detail` (
            `id`, `branch_id`, `block_id`, `plot_no`, `registory_date`, `customer_id`, 
            `registory_name`, `marla`, `sarsai`, `square_foot`, `date`
        ) VALUES (
            NULL, '$branch_id', '$block_id', '$plot_no', '$registry_date', '$customer_id', 
            '$registry_name', '$marla', '$sarsai', '$sqrfoot', '$date'
        )";

        mysqli_query($conn, $query) or die(mysqli_error($conn));

        $_SESSION['register_plot'] = 'Successfully Registered Plot number ' . $plot_no;
        exit();
    }
}



//------------------ Register Plot End-------------------------





//---------------Adding Sale Plot start--------------------------

if (isset($_POST['plot_sell_out'])) {
    
    $date = date("Y-m-d");

    // Assign and sanitize data
    $branch_id        = mysqli_real_escape_string($conn, $_POST['s_branch_id']);
    $block_id         = mysqli_real_escape_string($conn, $_POST['s_block_id']);
    $customer_id      = mysqli_real_escape_string($conn, $_POST['s_customer_id']);
    $plot_no          = mysqli_real_escape_string($conn, $_POST['s_plot_no']);
    $area             = floatval($_POST['s_area']);
    $price            = floatval($_POST['s_price']);
    $advance_amount   = floatval($_POST['s_advance_amount']);
    $payment_method   = mysqli_real_escape_string($conn, $_POST['s_payment_method']);
    $bank_account     = mysqli_real_escape_string($conn, $_POST['s_bank_account']);
    $check_no         = mysqli_real_escape_string($conn, $_POST['s_check_no']);
    $name_on_check    = mysqli_real_escape_string($conn, $_POST['s_name_on_check']);
    $date_on_check    = mysqli_real_escape_string($conn, $_POST['s_date_on_check']);
    $installments     = intval($_POST['s_installments']);
    $plot_id          = mysqli_real_escape_string($conn, $_GET['plot_id']);

    // Fetch square feet per marla for the branch
    $result = mysqli_query($conn, "SELECT `square_feet_size` FROM `branches` WHERE `id` = '$branch_id'");
    $row = mysqli_fetch_assoc($result);
    $square_feet_size = floatval($row['square_feet_size']);

    $total_marla = $area / $square_feet_size;
    $total_price = $total_marla * $price;

    // Validate required fields
    $is_cash = ($payment_method === 'cash');
    $common_valid = !empty($price) && !empty($advance_amount) && !empty($customer_id) && !empty($installments) && !empty($payment_method) && !empty($bank_account);
    $check_valid = !empty($check_no) && !empty($name_on_check) && !empty($date_on_check);

    if (($is_cash && $common_valid) || (!$is_cash && $common_valid && $check_valid)) {

        // 1. Insert into sale_plot
        mysqli_query($conn, "INSERT INTO `sale_plot` (
            `id`, `branch_id`, `block_id`, `customer_id`, `plot_no`, `total_area`, `total_price`,
            `advance_amount`, `payment_method`, `bank_account`, `check_no`, `name_on_check`,
            `date_on_check`, `number_of_installments`, `date`
        ) VALUES (
            NULL, '$branch_id', '$block_id', '$customer_id', '$plot_no', '$area', '$total_price',
            '$advance_amount', '$payment_method', '$bank_account', '$check_no', '$name_on_check',
            '$date_on_check', '$installments', '$date'
        )") or die(mysqli_error($conn));

        $_SESSION['plot_sold'] = "Successfully Sold Plot Number $plot_no";

        // 2. Mark the plot as sold
        mysqli_query($conn, "UPDATE `plots` SET `status` = '0' WHERE `id` = '$plot_id'") or die(mysqli_error($conn));

        // 3. Determine installment logic
        if ($total_price <= $advance_amount) {
            $sale_status = '0';
            $payment_per_installment = 0;
            $remaining_amount = 0;
            $installments = 0;
        } else {
            $sale_status = '1';
            $remaining_amount = $total_price - $advance_amount;
            $payment_per_installment = $remaining_amount / $installments;
        }

        // 4. Insert into installments
        mysqli_query($conn, "INSERT INTO `installments` (
            `id`, `branch_id`, `block_id`, `plot_no`, `customer_id`, `bank_account`,
            `payment_per_installment`, `remaining_installments`, `installments_paid`,
            `remaining_amount`, `status`, `date`
        ) VALUES (
            NULL, '$branch_id', '$block_id', '$plot_no', '$customer_id', '$bank_account',
            '$payment_per_installment', '$installments', '0', '$remaining_amount', '$sale_status', '$date'
        )") or die(mysqli_error($conn));

        // 5. Update bank balance
        $bank_result = mysqli_query($conn, "SELECT `balance` FROM `bank_accounts` WHERE `id` = '$bank_account'");
        $bank = mysqli_fetch_assoc($bank_result);
        $new_balance = $bank['balance'] + $advance_amount;
        mysqli_query($conn, "UPDATE `bank_accounts` SET `balance` = '$new_balance' WHERE `id` = '$bank_account'") or die(mysqli_error($conn));

        exit();
    } else {
        $_SESSION['plot_sold'] = "Error selling Plot Number $plot_no";
    }
}


//------------------Adding Sale Plot End-------------------------





//---------------Booking Plot start--------------------------

if(isset($_POST['plot_booked'])){
	
	$plot_id_forstatus=$_GET['plot_id'];


	// Assign data to variables using mysqli and PHP 8.2 compatible syntax
	$branch_id = mysqli_real_escape_string($conn, $_POST['s_branch_id']);
	$block_id = mysqli_real_escape_string($conn, $_POST['s_block_id']);
	$customer_id = mysqli_real_escape_string($conn, $_POST['s_customer_id']);
	$sale_man_id = mysqli_real_escape_string($conn, $_POST['s_sale_man_id']);
	$plot_no = mysqli_real_escape_string($conn, $_POST['s_plot_no']);
	$area = mysqli_real_escape_string($conn, $_POST['s_area']);
	$price = mysqli_real_escape_string($conn, $_POST['s_price']);
	$total_price = mysqli_real_escape_string($conn, $_POST['s_total_price']);
	$advance_amount = mysqli_real_escape_string($conn, $_POST['s_advance_amount']);
	$booking_date = mysqli_real_escape_string($conn, $_POST['s_booking_date']);
	$registery_time = mysqli_real_escape_string($conn, $_POST['s_registery_time']);
	$num_installments = mysqli_real_escape_string($conn, $_POST['s_num_installments']);
	$time_period = mysqli_real_escape_string($conn, $_POST['s_time_period']);
	$period_unit = mysqli_real_escape_string($conn, $_POST['s_period_unit']);
	$payment_method = mysqli_real_escape_string($conn, $_POST['s_payment_method']);
	$payment_per_installment = mysqli_real_escape_string($conn, $_POST['s_payment_per_installment']);
	$last_payment_amount = mysqli_real_escape_string($conn, $_POST['s_last_payment_amount']);
	$witness_1_name = mysqli_real_escape_string($conn, $_POST['s_witness_1_name']);
	$witness_1_cnic = mysqli_real_escape_string($conn, $_POST['s_witness_1_cnic']);
	$witness_2_name = mysqli_real_escape_string($conn, $_POST['s_witness_2_name']);
	$witness_2_cnic = mysqli_real_escape_string($conn, $_POST['s_witness_2_cnic']);
	$description = mysqli_real_escape_string($conn, $_POST['s_description']);
	
	$total_months_installments = (int)$time_period * (int)$period_unit;

	$gap_of_installments_months = ($num_installments > 0) ? $total_months_installments / (int)$num_installments : 0;

	$total_days_installments = $total_months_installments * 30;

	$gap_of_installments = $gap_of_installments_months * 30;
	
	$area_query=mysqli_query($conn, "SELECT * FROM `branches`	WHERE `id` = '$branch_id'");
	while($row1=mysqli_fetch_array($area_query)){
			$square_feet_size = $row1['square_feet_size'];
	}
	
	$remaining_amount = $total_price-$advance_amount;
			
	$doublle_click_restrict=mysqli_query($conn, "SELECT * FROM `book_plot` WHERE `branch_id` = '$branch_id' AND `block_id` = '$block_id' AND `plot_no` = '$plot_no'");
	if(mysqli_num_rows($doublle_click_restrict) <= 0){

	//Checking payment Method
	if($payment_method == 'cash'){
	
	//Insert data in database if Payment Method cash
	if(!empty($customer_id) && !empty($price) && !empty($advance_amount) && !empty($registery_time) && !empty($payment_method) && !empty($booking_date))
	{
		$insert_query = mysqli_query($conn, "INSERT INTO `book_plot` (`id`, `branch_id`, `block_id`, `customer_id`, `sale_man_id`, `plot_no`, `total_area`, `rate_per_marla`, `total_price`, `advance_amount`, `remaining_amount`, `per_installment`, `num_installments`, `time_period`, `gap_of_installments`, `payment_method`, `registery_time`, `witness_1_name`, `witness_1_cnic`, `witness_2_name`, `witness_2_cnic`, `description`, `last_payment_amount`, `date`) 
		VALUES (NULL, '$branch_id', '$block_id', '$customer_id', '$sale_man_id', '$plot_no', '$area', '$price', '$total_price', '$advance_amount', '$remaining_amount', '$payment_per_installment', '$num_installments', '$total_months_installments', '$gap_of_installments', '$payment_method', '$registery_time', '$witness_1_name', '$witness_1_cnic', '$witness_2_name', '$witness_2_cnic', '$description', '$last_payment_amount', '$booking_date');");
		//Update Status in Plots;
		$plot_status="UPDATE `plots` SET `status` = '2' WHERE  `id` = '$plot_id_forstatus';";
		$plot_status_data=mysqli_query($conn, $plot_status);

		$_SESSION['plot_booked'] = 'Successfully Booked Plot Number '.$plot_no;
		

		//Setting Installments start
		if($payment_method == 'installment'){ 
			$sale_status = '2';
		}else{
			$sale_status = '0';
		}	
			$datess=date_create("$booking_date");

			$installment_query = mysqli_query($conn, "INSERT INTO `installments` (`id`, `branch_id`, `block_id`, `plot_no`, `customer_id`, `date_of_installment`, `payment_per_installment`, `remaining_installments`, `installments_paid`, `remaining_amount`, `status`, `date`) VALUES (NULL, '$branch_id', '$block_id', '$plot_no', '$customer_id', '$booking_date', '0', '0', '0', '$total_price', '2', '$date');");
		//Setting Installments End
		

		$select_query_q="SELECT * FROM `book_plot` ORDER BY id DESC LIMIT 1";
		$result_query_q=mysqli_query($conn, $select_query_q) or die($select_query_q."<br/><br/>".mysqli_error($conn));
			while($row_q=mysqli_fetch_assoc($result_query_q)){
			$book_plot_id=$row_q['id'] ?? null;
			}


	//getting customer Inforamtion like name
		$customer_query=mysqli_query($conn, "SELECT * FROM `customers` WHERE `id` = '$customer_id'");
			while($customer_data=mysqli_fetch_assoc($customer_query)){
			$customer_name=$customer_data['name'] ?? '';
			}


	//creating ledger for customer
	
		//checking for control account
		$control_query = mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `branch_id` = '$branch_id' AND `name` = 'Customer Recievable'");

		if (mysqli_num_rows($control_query) < 1) {
			$control_gcode_query = mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `branch_id` = '$branch_id' ORDER BY id DESC LIMIT 1");
			while ($control_gcode_fetcher = mysqli_fetch_assoc($control_gcode_query)) {
				$control_gcode = $control_gcode_fetcher['gcode'];
			}

			preg_match("/(.*?)(\d+)$/", $control_gcode, $control_matches);
			$new_control_gcode = $control_matches[1] . '0' . ($control_matches[2] + 1);

			mysqli_query($conn, "INSERT INTO `control_accounts` (`id`, `branch_id`, `name`, `description`, `gcode`, `date`) 
				VALUES (NULL, '$branch_id', 'Customer Recievable', 'Control For customer Payments ', '$new_control_gcode', '$date')");
		}

		$new_control_query = mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `branch_id` = '$branch_id' AND `name` = 'Customer Recievable'");
		while ($control_id_fetcher = mysqli_fetch_assoc($new_control_query)) {
			$control_account_id = $control_id_fetcher['id'];
		}

		
		
//checking for general account
$general_query = mysqli_query($conn, "SELECT * FROM `general_ledgers` WHERE `branch_id` = '$branch_id' AND `control_account_id` = '$control_account_id' AND `name` = 'Customer Payments'");

if (mysqli_num_rows($general_query) < 1) {
    $control_gcode_query = mysqli_query($conn, "SELECT * FROM `general_ledgers` WHERE `branch_id` = '$branch_id' AND `control_account_id` = '$control_account_id' ORDER BY id DESC LIMIT 1");

    while ($general_gcode_fetcher = mysqli_fetch_assoc($control_gcode_query)) {
        $general_gcode = $general_gcode_fetcher['gcode'];
    }

    preg_match("/(.*?)(\d+)$/", $general_gcode, $general_matches);
    $new_general_gcode = $general_matches[1] . '0' . ($general_matches[2] + 1);
    $full_gcode = $new_control_gcode . '-' . $new_general_gcode;

    mysqli_query($conn, "INSERT INTO `general_ledgers` (`id`, `branch_id`, `control_account_id`, `name`, `description`, `gcode`, `date`) 
        VALUES (NULL, '$branch_id', '$control_account_id', 'Customer Payments', 'General For Customer Payments', '$full_gcode', '$date')");
}

$new_general_query = mysqli_query($conn, "SELECT * FROM `general_ledgers` WHERE `branch_id` = '$branch_id' AND `control_account_id` = '$control_account_id' AND `name` = 'Customer Payments'");

while ($general_id_fetcher = mysqli_fetch_assoc($new_general_query)) {
    $general_account_id = $general_id_fetcher['id'];
}

	
	//setting ledger gcode
	$ledger_query=mysqli_query($conn, "SELECT * FROM `ledgers` WHERE `branch_id` = '$branch_id' AND `control_account_id` = '$control_account_id' AND `general_ledger_id` = '$general_account_id' ORDER BY id DESC LIMIT 1");
	while($row=mysqli_fetch_assoc($ledger_query)){
			 $gcode = $row['gcode'];
	}
    preg_match("/(.*?)(\d+)$/", $gcode,$matches);
	$newgcode = $matches[1].'0'.($matches[2]+1);
	
	
	if(mysqli_num_rows($ledger_query) < 1){
		$newgcode = $new_control_gcode.'-'.$new_general_gcode.'-'.$newgcode;
	}

	$insert_ledger=mysqli_query($conn, "INSERT INTO `ledgers` (`id`, `branch_id`, `control_account_id`, `general_ledger_id`, `customer_id`, `block_id`, `name`, `description`, `gcode`, `debit`, `credit`, `balance`, `date`) 
	VALUES (NULL, '$branch_id', '$control_account_id', '$general_account_id', '$customer_id', '$block_id', 'Shop No. $plot_no', 'Payments of $customer_name', '$newgcode', '0', '0', '0', '$date');");


		$_SESSION['book_plot_id'] = $book_plot_id;
		
		
	}else{
		$_SESSION['plot_booked'] = 'Error booking Shop Number '.$plot_no;	
	}
	}else{
		
		
			// Setting Installments start
			$sale_status = ($payment_method == 'installment') ? '2' : '0';

			$datess = date_create($booking_date);

			for ($i = 1; $i <= $num_installments; $i++) {
				if ($gap_of_installments_months >= 1) {
					date_add($datess, date_interval_create_from_date_string("$gap_of_installments_months month"));
				} else {
					date_add($datess, date_interval_create_from_date_string("$gap_of_installments days"));
				}

				$date_of_installment = date_format($datess, "Y-m-d");

				$installment_query = mysqli_query($conn, "
					INSERT INTO `installments` 
					(`id`, `branch_id`, `block_id`, `plot_no`, `customer_id`, `date_of_installment`, `payment_per_installment`, `remaining_installments`, `installments_paid`, `remaining_amount`, `status`, `date`) 
					VALUES 
					(NULL, '$branch_id', '$block_id', '$plot_no', '$customer_id', '$date_of_installment', '$payment_per_installment', '$num_installments', '0', '$remaining_amount', '2', '$date')
				");
			}

				// Setting Installments End
				$select_query_q = mysqli_query($conn, "SELECT * FROM `installments` ORDER BY id DESC LIMIT 1");

				if ($select_query_q && mysqli_num_rows($select_query_q) > 0) {
					$row_q = mysqli_fetch_assoc($select_query_q);
					$last_installment_date = $row_q['date_of_installment'];

					if ($payment_method == 'installment') {
						$registery_time = $last_installment_date;
					}
				}

			
		
		//INsert data in database if Payment Method is installment
// Insert data in database if Payment Method is installment
if (
    !empty($customer_id) && !empty($price) && !empty($advance_amount) &&
    !empty($registery_time) && !empty($payment_method) &&
    !empty($num_installments) && !empty($time_period) &&
    !empty($payment_per_installment) && !empty($booking_date)
) {
    $insert_query = mysqli_query($conn, "INSERT INTO `book_plot` (`id`, `branch_id`, `block_id`, `customer_id`, `sale_man_id`, `plot_no`, `total_area`, `rate_per_marla`, `total_price`, `advance_amount`, `remaining_amount`, `per_installment`, `num_installments`, `time_period`, `gap_of_installments`, `payment_method`, `registery_time`, `witness_1_name`, `witness_1_cnic`, `witness_2_name`, `witness_2_cnic`, `description`, `last_payment_amount`, `date`) 
    VALUES (NULL, '$branch_id', '$block_id', '$customer_id', '$sale_man_id', '$plot_no', '$area', '$price', '$total_price', '$advance_amount', '$remaining_amount', '$payment_per_installment', '$num_installments', '$total_months_installments', '$gap_of_installments', '$payment_method', '$registery_time', '$witness_1_name', '$witness_1_cnic', '$witness_2_name', '$witness_2_cnic', '$description', '$last_payment_amount', '$booking_date');");

    $plot_status = "UPDATE `plots` SET `status` = '2' WHERE  `id` = '$plot_id_forstatus';";
    $plot_status_data = mysqli_query($conn, $plot_status);

    $_SESSION['plot_booked'] = 'Successfully Booked Shop Number ' . $plot_no;

    // Get last inserted book_plot ID
    $select_query_q = "SELECT * FROM `book_plot` ORDER BY id DESC LIMIT 1";
    $result_query_q = mysqli_query($conn, $select_query_q) or die($select_query_q . "<br/><br/>" . mysqli_error($conn));
    if ($row_q = mysqli_fetch_assoc($result_query_q)) {
        $book_plot_id = $row_q['id'];
    }

    // Getting customer information
    $customer_query = mysqli_query($conn, "SELECT * FROM `customers` WHERE `id` = '$customer_id'");
    if ($customer_data = mysqli_fetch_assoc($customer_query)) {
        $customer_name = $customer_data['name'];
    }




	// Creating ledger for customer

	// Checking for control account
	$control_query = mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `branch_id` = '$branch_id' AND `name` = 'Customer Recievable'");
	if (mysqli_num_rows($control_query) < 1) {

		$control_gcode = '';
		$control_gcode_query = mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `branch_id` = '$branch_id' ORDER BY id DESC LIMIT 1");
		while ($control_gcode_fetcher = mysqli_fetch_assoc($control_gcode_query)) {
			$control_gcode = $control_gcode_fetcher['gcode'];
		}

		if (!empty($control_gcode)) {
			preg_match("/(.*?)(\d+)$/", $control_gcode, $control_matches);
			$new_control_gcode = $control_matches[1] . '0' . ($control_matches[2] + 1);
		} else {
			$new_control_gcode = 'CUSTREC001'; // fallback if no previous gcode
		}

		$control_insert_query = mysqli_query($conn, "INSERT INTO `control_accounts` (`id`, `branch_id`, `name`, `description`, `gcode`, `date`) VALUES (NULL, '$branch_id', 'Customer Recievable', 'Control For customer Payments ', '$new_control_gcode', '$date')");
	}

	// Get control_account_id
	$new_control_query = mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `branch_id` = '$branch_id' AND `name` = 'Customer Recievable'");
	while ($control_id_fetcher = mysqli_fetch_assoc($new_control_query)) {
		$control_account_id = $control_id_fetcher['id'];
	}

		
		// Checking for general account
		$general_query = mysqli_query($conn, "SELECT * FROM `general_ledgers` WHERE `branch_id` = '$branch_id' AND `control_account_id` = '$control_account_id' AND `name` = 'Customer Payments'");
		if (mysqli_num_rows($general_query) < 1) {

			$general_gcode = '';
			$general_gcode_query = mysqli_query($conn, "SELECT * FROM `general_ledgers` WHERE `branch_id` = '$branch_id' AND `control_account_id` = '$control_account_id' ORDER BY id DESC LIMIT 1");
			while ($general_gcode_fetcher = mysqli_fetch_assoc($general_gcode_query)) {
				$general_gcode = $general_gcode_fetcher['gcode'];
			}

			if (!empty($general_gcode)) {
				preg_match("/(.*?)(\d+)$/", $general_gcode, $general_matches);
				$new_general_gcode = $general_matches[1] . '0' . ($general_matches[2] + 1);
			} else {
				$new_general_gcode = 'GENPAY001'; // fallback
			}

			// You must make sure $new_control_gcode is defined before this block
			$new_full_gcode = $new_control_gcode . '-' . $new_general_gcode;

			$general_insert_query = mysqli_query($conn, "INSERT INTO `general_ledgers` (`id`, `branch_id`, `control_account_id`, `name`, `description`, `gcode`, `date`) 
			VALUES (NULL, '$branch_id', '$control_account_id', 'Customer Payments', 'General For Customer Payments', '$new_full_gcode', '$date')");
		}

		// Get general_account_id
		$new_general_query = mysqli_query($conn, "SELECT * FROM `general_ledgers` WHERE `branch_id` = '$branch_id' AND `control_account_id` = '$control_account_id' AND `name` = 'Customer Payments'");
		while ($general_id_fetcher = mysqli_fetch_assoc($new_general_query)) {
			$general_account_id = $general_id_fetcher['id'];
		}

	//setting ledger gcode
	$ledger_query=mysqli_query($conn, "SELECT * FROM `ledgers` WHERE `branch_id` = '$branch_id' AND `control_account_id` = '$control_account_id' AND `general_ledger_id` = '$general_account_id' ORDER BY id DESC LIMIT 1");
	if (mysqli_num_rows($ledger_query) > 0) {
	while($row=mysqli_fetch_assoc($ledger_query)){
			 $gcode = $row['gcode'];
	}
    preg_match("/(.*?)(\d+)$/", $gcode,$matches);
	$newgcode = $matches[1].'0'.($matches[2]+1);
	}else{
		 // Fallback if no previous ledger found
    	$newgcode = $new_control_gcode . '-' . $new_general_gcode . '-001';
	}
	


		// Insert into ledger
		$insert_ledger = mysqli_query($conn, "INSERT INTO `ledgers` (`id`, `branch_id`, `control_account_id`, `general_ledger_id`, `customer_id`, `block_id`, `name`, `description`, `gcode`, `debit`, `credit`, `balance`, `date`) 
		VALUES (NULL, '$branch_id', '$control_account_id', '$general_account_id', '$customer_id', '$block_id', 'Plot No. $plot_no', 'Payments of $customer_name', '$newgcode', '0', '0', '0', '$date')");

		$_SESSION['book_plot_id'] = $book_plot_id;

		
	}else{
		$_SESSION['plot_booked'] = 'Error booking Shop Number '.$plot_no;	
	}
	}
  }	
}

//---------------Booking Plot end--------------------------		



//---------------Land Owner Setup start--------------------------
if (isset($_POST['land_owned'])) {
    // Include your DB connection
    // Example: $conn = mysqli_connect("localhost", "username", "password", "database");

    // Assign data to variables
    $branch_id = $_POST['s_branch_id'];
    $ledger_id = $_POST['s_ledger_id'];
    $fname = $_POST['s_fname'];
    $cnic = $_POST['s_cnic'];
    $phone = $_POST['s_phone'];
    $address = $_POST['s_address'];
    $image = $_POST['s_image'];
    $area = $_POST['s_area'];
    $rate_per_marla = $_POST['s_rate_per_marla'];
    $total_price = $_POST['s_total_price'];
    $advance_amount = $_POST['s_advance_amount'];
    $payment_method = $_POST['s_payment_method'];
    $num_installments = $_POST['s_num_installments'];
    $agreement_date = $_POST['s_agreement_date'];
    $registery_time = $_POST['s_registery_time'];

    // Check if all required fields are filled
    if (
        !empty($branch_id) && !empty($ledger_id) && !empty($fname) && !empty($cnic) &&
        !empty($phone) && !empty($address) && !empty($image) && !empty($area) &&
        !empty($rate_per_marla) && !empty($total_price) && !empty($advance_amount) &&
        !empty($payment_method) && !empty($agreement_date)
    ) {
        $query = "INSERT INTO `land_owner_setup` (`id`, `branch_id`, `ledger_id`, `fname`, `cnic`, `phone`, `address`, `image`, `area`, `rate_per_marla`, `total_price`, `advance_amount`, `payment_method`, `num_installments`, `agreement_date`, `registry_time`, `date`) 
        VALUES (NULL, '$branch_id', '$ledger_id', '$fname', '$cnic', '$phone', '$address', '$image', '$area', '$rate_per_marla', '$total_price', '$advance_amount', '$payment_method', '$num_installments', '$agreement_date', '$registery_time', '$date')";

        $insert_query = mysqli_query($conn, $query);

        if ($insert_query) {
            $_SESSION['own_land'] = 'Land owning Successful';
        } else {
            $_SESSION['own_land'] = 'Error: ' . mysqli_error($conn);
        }
        exit();
    } else {
        $_SESSION['own_land'] = 'Error Owning Land';
    }
}

//------------------Land Owner Setup End-------------------------




//----------------Paying Installment Start-----------------------
if (isset($_POST['installment_payed'])) {
    // Include your DB connection
    // Example: $conn = mysqli_connect("localhost", "username", "password", "database");

    // Assign data to variables
    $branch_id = $_POST['s_branch_id'];
    $block_id = $_POST['s_block_id'];
    $customer_id = $_POST['s_customer_id'];
    $plot_no = $_POST['s_plot_no'];
    $price = $_POST['s_price'];
    $bank_account = $_POST['s_bank_account'];
    $payment_per_installment = $_POST['s_payment_per_installment'];
    $remaining_installment = $_POST['s_remaining_installment'];
    $remaining_amount = $_POST['s_remaining_amount'];
    $installments_paid = $_POST['s_installments_paid'];
    $n0_of_installments = $_POST['s_n0_of_installments'];

    // Pay Installment mechanism 
    $new_installments_paid = $installments_paid + $n0_of_installments;
    $new_remaining_installments = $remaining_installment - $n0_of_installments;
    $payed_amount = $payment_per_installment * $n0_of_installments;
    $new_remaining_amount = $remaining_amount - $payed_amount;

    $new_status = ($new_remaining_installments <= 0) ? 0 : 1;

    // Get ID
    $payment_id = $_GET['payment_id'];

    // Adding Payment to the bank account
    $account_query = mysqli_query($conn, "SELECT * FROM `bank_accounts` WHERE `id` = '$bank_account'");
    if ($account_query && mysqli_num_rows($account_query) > 0) {
        $row3 = mysqli_fetch_assoc($account_query);
        $balance = $row3['balance'];
        $new_balance = $balance + $payed_amount;
        mysqli_query($conn, "UPDATE `bank_accounts` SET `balance` = '$new_balance' WHERE `id` = '$bank_account'");
    }

    // Updating Installment Data
    $update_query = "UPDATE `installments` SET 
        `branch_id` = '$branch_id',
        `block_id` = '$block_id',
        `plot_no` = '$plot_no',
        `customer_id` = '$customer_id',
        `bank_account` = '$bank_account',
        `payment_per_installment` = '$payment_per_installment',
        `remaining_installments` = '$new_remaining_installments',
        `installments_paid` = '$new_installments_paid',
        `remaining_amount` = '$new_remaining_amount',
        `status` = '$new_status' 
        WHERE `id` = '$payment_id'";

    $updating_query = mysqli_query($conn, $update_query);

    if ($updating_query) {
        $_SESSION['installment'] = 'Successfully paid Installment';
    } else {
        $_SESSION['installment'] = 'Error: ' . mysqli_error($conn);
    }
}


//----------------Paying Installment End-----------------------




//------------------Calculator Start-------------------------------

if(isset($_POST['calculate'])){
	//Fixed Values
	$square_foot = 1;
	$marla = 272*$square_foot;
	$canal = 20*$marla;
	$aker = 8*$canal;
	$maraba = 25*$aker;
	
	
	// Assign data to variables
	$typ1 = $_POST['type1'];
	$typ2 = $_POST['type1'];
	$value1 = $_POST['value1'];
	
	
	

//Switch for types

switch ($typ1) {
    case "0":
        $value1 *= $maraba;
        break;
    case "1":
        $value1 *= $aker;
        break;
    case "2":
        $value1 *= $canal;
        break;
	case "3":
        $value1 *= $marla;
        break;
	case "4":
        $value1 *= $square_foot;
        break;		
    default:
        echo "Default";
}
 echo "<script>alert('Default');</script>";
}


//------------------Calculator End-------------------------------




//---------------Adding Control Account start--------------------------
if (isset($_POST['control_account_added'])) {
   

    // Assign data to variables
    $branch_id = mysqli_real_escape_string($conn, $_POST['s_branch_id']);
    $name = mysqli_real_escape_string($conn, $_POST['s_name']);
    $description = mysqli_real_escape_string($conn, $_POST['s_description']);
    $gcode = mysqli_real_escape_string($conn, $_POST['s_gcode']);
    $date = date('Y-m-d');

    // Check if Control Account Name already exists
    $check_query = mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `name` = '$name' AND `branch_id` = '$branch_id'");
    
    if (mysqli_num_rows($check_query) > 0) {
        $_SESSION['control'] = 'Error: Account Name Already Exists!';
    } else {
        // Insert data into database
        if (!empty($name) && !empty($branch_id) && !empty($gcode)) {
            $insert_query = mysqli_query($conn, "INSERT INTO `control_accounts` (`id`, `branch_id`, `name`, `description`, `gcode`, `date`) VALUES (NULL, '$branch_id', '$name', '$description', '$gcode', '$date')");
            
            if ($insert_query) {
                $_SESSION['control'] = 'Successfully Created ' . $name;
                exit();
            } else {
                $_SESSION['control'] = 'Database Insert Error: ' . mysqli_error($conn);
            }
        } else {
            $_SESSION['control'] = 'Error creating Control Account!';
        }
    }
}

//------------------Adding Control Account End-------------------------



//---------------Editing Control Account start--------------------------
if (isset($_POST['control_account_edited'])) {


    $control_account_id = $_GET['control_account_id'];

    // Assign data to variables
    $branch_id = mysqli_real_escape_string($conn, $_POST['s_branch_id']);
    $name = mysqli_real_escape_string($conn, $_POST['s_name']);
    $description = mysqli_real_escape_string($conn, $_POST['s_description']);
    $gcode = mysqli_real_escape_string($conn, $_POST['s_gcode']);

    // Check if Control Account Name already exists
    $check_query = mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `name` = '$name' AND `branch_id` = '$branch_id' AND `id` != '$control_account_id'");

    if (mysqli_num_rows($check_query) > 0) {
        $_SESSION['edit_control'] = 'Error: Account Name Already Exists!';
    } else {
        // Update data in database
        if (!empty($name) && !empty($branch_id) && !empty($gcode)) {
            $update_query = mysqli_query($conn, "UPDATE `control_accounts` SET `name` = '$name', `description` = '$description' WHERE `id` = '$control_account_id'");

            if ($update_query) {
                $_SESSION['edit_control'] = 'Successfully Edited ' . $name;
                exit();
            } else {
                $_SESSION['edit_control'] = 'Database Update Error: ' . mysqli_error($conn);
            }
        } else {
            $_SESSION['edit_control'] = 'Error Editing Control Account!';
        }
    }
}

//------------------Editing Control Account End-------------------------




//---------------Adding General Ledger start--------------------------
if (isset($_POST['general_ledger_added'])) {
    // MySQLi connection assumed as $conn
    // Example: $conn = mysqli_connect("localhost", "username", "password", "database");

    // Assign data to variables
    $branch_id = mysqli_real_escape_string($conn, $_POST['s_branch_id']);
    $control_account_id = mysqli_real_escape_string($conn, $_POST['s_control_account_id']);
    $name = mysqli_real_escape_string($conn, $_POST['s_name']);
    $description = mysqli_real_escape_string($conn, $_POST['s_description']);
    $gcode = mysqli_real_escape_string($conn, $_POST['s_gcode']);

    // Check if General Ledger Name already exists
    $check_query = mysqli_query($conn, "SELECT * FROM `general_ledgers` WHERE `name` = '$name' AND `control_account_id` = '$control_account_id' AND `branch_id` = '$branch_id'");

    if (mysqli_num_rows($check_query) > 0) {
        $_SESSION['general'] = 'Error: General Ledger ' . $name . ' Already Exists!';
    } else {
        // Insert data in database
        if (!empty($name) && !empty($branch_id) && !empty($control_account_id) && !empty($gcode)) {
            $insert_query = mysqli_query($conn, "INSERT INTO `general_ledgers` (`id`, `branch_id`, `control_account_id`, `name`, `description`, `gcode`, `date`) 
                VALUES (NULL, '$branch_id', '$control_account_id', '$name', '$description', '$gcode', '$date');");

            if ($insert_query) {
                $_SESSION['general'] = 'Successfully Created ' . $name;
                exit();
            } else {
                $_SESSION['general'] = 'Database Insert Error: ' . mysqli_error($conn);
            }
        } else {
            $_SESSION['general'] = 'Error creating General Account!';
        }
    }
}


//------------------Adding General Ledger End-------------------------



//---------------Editing General Ledger start--------------------------
if (isset($_POST['general_ledger_edited'])) {

    // MySQLi connection assumed as $conn
    // Example: $conn = mysqli_connect("localhost", "username", "password", "database");

    $general_ledger_id = $_GET['general_ledger_id'];

    // Assign data to variables using MySQLi escape
    $branch_id = mysqli_real_escape_string($conn, $_POST['s_branch_id']);
    $control_account_id = mysqli_real_escape_string($conn, $_POST['s_control_account_id']);
    $name = mysqli_real_escape_string($conn, $_POST['s_name']);
    $description = mysqli_real_escape_string($conn, $_POST['s_description']);
    $gcode = mysqli_real_escape_string($conn, $_POST['s_gcode']);

    // Check if General Ledger Name already exists
    $check_query = mysqli_query($conn, "SELECT * FROM `general_ledgers` WHERE `name` = '$name' AND `control_account_id` = '$control_account_id' AND `branch_id` = '$branch_id' AND `id` != '$general_ledger_id'");

    if (mysqli_num_rows($check_query) > 0) {
        $_SESSION['edit_general'] = 'Error: General Ledger ' . $name . ' Already Exists!';
    } else {
        // Update data in database
        if (!empty($name) && !empty($branch_id) && !empty($control_account_id) && !empty($gcode)) {
            $update_query = mysqli_query($conn, "UPDATE `general_ledgers` SET `name` = '$name', `description` = '$description' WHERE `id` = '$general_ledger_id'");

            if ($update_query) {
                $_SESSION['edit_general'] = 'Successfully Edited ' . $name;
                exit();
            } else {
                $_SESSION['edit_general'] = 'Error: ' . mysqli_error($conn);
            }
        } else {
            $_SESSION['edit_general'] = 'Error Editing General Account!';
        }
    }
}

//------------------Editing General Ledger End--------------------



//---------------Adding Ledger start--------------------------

if (isset($_POST['ledger_added'])) {


    // Assign data to variables
    $branch_id = mysqli_real_escape_string($conn, $_POST['s_branch_id']);
    $control_account_id = mysqli_real_escape_string($conn, $_POST['s_control_account_id']);
    $general_account_id = mysqli_real_escape_string($conn, $_POST['s_general_account_id']);
    $name = mysqli_real_escape_string($conn, $_POST['s_name']);
    $description = mysqli_real_escape_string($conn, $_POST['s_description']);
    $gcode = mysqli_real_escape_string($conn, $_POST['s_gcode']);

    // Check if ledger account name already exists
    $check_query = mysqli_query($conn, "SELECT * FROM `ledgers` WHERE `branch_id` = '$branch_id' AND `control_account_id` = '$control_account_id' AND `general_ledger_id` = '$general_account_id' AND `name` = '$name'");

    if (mysqli_num_rows($check_query) <= 0) {

        // Insert data into database
        if (!empty($name) && !empty($branch_id) && !empty($control_account_id) && !empty($general_account_id) && !empty($gcode)) {
            $insert_query = mysqli_query($conn, "INSERT INTO `ledgers` (`id`, `branch_id`, `control_account_id`, `general_ledger_id`, `customer_id`, `block_id`, `name`, `description`, `gcode`, `debit`, `credit`, `balance`, `date`) 
            VALUES (NULL, '$branch_id', '$control_account_id', '$general_account_id', '', '', '$name', '$description', '$gcode', '0', '0', '0', '$date');");

            if ($insert_query) {
                $_SESSION['ledger'] = 'Successfully Created ledger ' . $name;
                exit();
            } else {
                $_SESSION['ledger'] = 'Error: ' . mysqli_error($conn);
            }
        } else {
            $_SESSION['ledger'] = 'Error creating Ledger Account!';
        }

    } else {
        $_SESSION['ledger'] = 'Error: Ledger ' . $name . ' Already Exists!';
    }
}


//------------------Adding Ledger End-------------------------


//---------------Editing Ledger start--------------------------
if (isset($_POST['ledger_edited'])) {


    // Assign data to variables
    $ledger_id = $_GET['ledger_id'];
    $name = mysqli_real_escape_string($conn, $_POST['s_name']);
    $description = mysqli_real_escape_string($conn, $_POST['s_description']);

    // Check if ledger account name already exists (excluding current ledger ID)
    $check_query = mysqli_query($conn, "SELECT * FROM `ledgers` WHERE `name` = '$name' AND `id` != '$ledger_id'");

    if (mysqli_num_rows($check_query) > 0) {
        $_SESSION['edit_ledger'] = 'Error: Ledger ' . $name . ' Already Exists!';
    } else {
        // Update data in database
        if (!empty($name)) {
            $update_query = mysqli_query($conn, "UPDATE `ledgers` SET `name` = '$name', `description` = '$description' WHERE `id` = '$ledger_id'");

            if ($update_query) {
                $_SESSION['edit_ledger'] = 'Successfully Edited ledger ' . $name;
                exit();
            } else {
                $_SESSION['edit_ledger'] = 'Error updating ledger: ' . mysqli_error($conn);
            }
        } else {
            $_SESSION['edit_ledger'] = 'Error: Ledger Name is required!';
        }
    }
}

//------------------Editing Ledger End-------------------------



//---------------adding service charges start--------------------------

if(isset($_POST['service_charges_added'])){

    $branchId = mysqli_real_escape_string($conn, $_POST['branchId']);
    $agreementId = mysqli_real_escape_string($conn, $_POST['agreementId']);
    $chargesPrSqrft = mysqli_real_escape_string($conn, $_POST['chargesPrSqrft']);
    $lpSurcharge = mysqli_real_escape_string($conn, $_POST['lpSurcharge']);
    $issueDate = mysqli_real_escape_string($conn, $_POST['issueDate']);
    $dueDate = mysqli_real_escape_string($conn, $_POST['dueDate']);
    $billingMonth = mysqli_real_escape_string($conn, $_POST['billingMonth']);
    $lobbyArea = mysqli_real_escape_string($conn, $_POST['lobbyArea']);
    $totalBill = mysqli_real_escape_string($conn, $_POST['totalBill']);
	$validateEntry = count2('service_charges','agreement_id',$agreementId,'billing_month',$billingMonth);
	
	//INsert data in database
	if($validateEntry > 0){
			$_SESSION['service_charges'] = 'Error: Already Generated Bill For This Month';
	}elseif(!empty($branchId) && !empty($agreementId) && !empty($chargesPrSqrft) && !empty($lpSurcharge) && !empty($issueDate) && !empty($dueDate) && !empty($billingMonth) && !empty($totalBill))
	{
		$lpSurcharge = ($totalBill/100)*$lpSurcharge;
		$lateBill = $totalBill+$lpSurcharge;
		$chargesQuery = mysqli_query($conn,"INSERT INTO `service_charges`(`id`, `branch_id`, `agreement_id`, `lobby_area`, `charges_pr_sqrft`, `total_bill`, `late_bill`, `lp_surcharge`, `issue_date`, `due_date`, `billing_month`, `status`, `date`) VALUES (NULL,'$branchId','$agreementId','$lobbyArea','$chargesPrSqrft','$totalBill','$lateBill','$lpSurcharge','$issueDate','$dueDate','$billingMonth','0',NULL)");
		//to insert service charges in recovery table to get arrears
		$recoveryInsertQuery = mysqli_query($conn, "UPDATE `service_charges_recovery` SET arrears=arrears+$totalBill WHERE `agreement_id` = '$agreementId'");
		if($chargesQuery){
			$_SESSION['service_charges'] = 'Successfully Generated Service Charges. <a href="view_service_charges.php?branch_id='.$branchId.'&agreementId='.$agreementId.'">Click Here</a> To generate Print.';		
		}else{
			$_SESSION['service_charges'] = 'Error: Something Went Wrong!';
		}
		exit();
	}else{
		$_SESSION['service_charges'] = 'Error: Please Fill All The Fields';	
	}
	
}

//------------------Adding service charges End-------------------------



//---------------adding Electricity Bills start--------------------------

if(isset($_POST['electricity_bill_added'])){

    // Assuming $conn is your mysqli connection
    $branchId = mysqli_real_escape_string($conn, $_POST['branchId']);
    $agreementId = mysqli_real_escape_string($conn, $_POST['agreementId']);
    $chargesPrSqrft = mysqli_real_escape_string($conn, $_POST['chargesPrSqrft']);
    $lpSurcharge = mysqli_real_escape_string($conn, $_POST['lpSurcharge']);
    $issueDate = mysqli_real_escape_string($conn, $_POST['issueDate']);
    $dueDate = mysqli_real_escape_string($conn, $_POST['dueDate']);
    $billingMonth = mysqli_real_escape_string($conn, $_POST['billingMonth']);
    $lobbyArea = mysqli_real_escape_string($conn, $_POST['lobbyArea']);
    $totalBill = mysqli_real_escape_string($conn, $_POST['totalBill']);
	if(!$lobbyCharges){ $lobbyCharges = 0;}

	// Custom function to check duplicate entry (assumed to return count)
    $validateEntry = count2($conn, 'service_charges', 'agreement_id', $agreementId, 'billing_month', $billingMonth);
	
	//INsert data in database
	if($validateEntry > 0){
			$_SESSION['electricity_bills'] = 'Error: Already Generated Bill For This Month';
	}elseif(!empty($branchId) && !empty($agreementId) && !empty($unitRate) && !empty($lpSurcharge) && !empty($issueDate) && !empty($dueDate) && !empty($billingMonth) && !empty($totalBill) && !empty($meterReading))
	{
		$lpSurcharge = ($totalBill/100)*$lpSurcharge;
		$lateBill = $totalBill+$lpSurcharge;
		$chargesQuery = mysqli_query($conn, "INSERT INTO `electricity_bills`(`id`, `branch_id`, `agreement_id`, `meter_reading`, `units_consumed`, `lobby_charges`, `unit_rate`, `lp_surcharge`, `total_bill`, `late_bill`, `billing_month`, `issue_date`, `due_date`, `status`, `date`) VALUES (NULL,'$branchId','$agreementId','$meterReading','$unitsConsumed','$lobbyCharges','$unitRate','$lpSurcharge','$totalBill','$lateBill','$billingMonth','$issueDate','$dueDate','0',NULL)");
		$billingRecoveryInsertQuery = mysqli_query($conn, "UPDATE `electricity_bills_recovery` SET arrears=arrears+$totalBill WHERE `agreement_id` = '$agreementId'");
		if($chargesQuery){
			$_SESSION['electricity_bills'] = 'Successfully Generated Electricity Bills. <a href="view_electricity_bill.php?branch_id='.$branchId.'&agreementId='.$agreementId.'">Click Here</a> To generate Print.';	
		}else{
			$_SESSION['electricity_bills'] = 'Error: Something Went Wrong!';
		}
		exit();
	}else{
		$_SESSION['electricity_bills'] = 'Error: Please Fill All The Fields';	
	}
}

//------------------Adding Electricity Bills End-------------------------



//----------------------------------------------------------Extra Ajax code start(not required)----------------------------------------------------
	//Display Form Data
	
	if(isset($_POST['display'])){
		$results=mysqli_query($conn, "select * from users");
		
		while($row=mysqli_fetch_assoc($results)){
			?>
            <div id="data_box">
            <p><?php  echo $row['name'];  ?></p>
             <p><?php  echo $row['email'];  ?></p>
            </div>
			<?php
			}
	exit();	
	}
	
if(isset($_POST['searching'])){
	$search=mysqli_escape_string($conn, $_POST['searchword']);
	$results=mysqli_query($conn, "select * from users WHERE `name` LIKE '%".$search."%' OR `email` LIKE '%".$search."%' ");  
	while($row=mysqli_fetch_assoc($results)){
			?>
            <div id="result_box" style="border:1px solid #666">
            <p><?php  echo $row['name'];  ?></p>
            <p><?php  echo $row['email'];  ?></p>
            </div>
			<?php
			}
	exit();		
}

//----------------------------------------------------------Extra Ajax code end(not required)------------------------------------------------------



//----------------------------------------------------------change privileges start----------------------------------------------------
	
if (isset($_POST['updatePrivileges'])) {
    // Assuming $conn is your active mysqli connection
    $managerId = mysqli_real_escape_string($conn, $_POST['updatePrivileges']);
    $editCustomer = mysqli_real_escape_string($conn, $_POST['editCustomer']);
    $shiftLedger = mysqli_real_escape_string($conn, $_POST['shiftLedger']);
    $editAccounts = mysqli_real_escape_string($conn, $_POST['editAccounts']);
    $deleteAccounts = mysqli_real_escape_string($conn, $_POST['deleteAccounts']);
    $previousDate = mysqli_real_escape_string($conn, $_POST['previousDate']);
    $editEntry = mysqli_real_escape_string($conn, $_POST['editEntry']);
    $deleteBooking = mysqli_real_escape_string($conn, $_POST['deleteBooking']);
    $editMap = mysqli_real_escape_string($conn, $_POST['editMap']);

    $privilegeArray = array(
        'editCustomer' => $editCustomer,
        'shiftLedger' => $shiftLedger,
        'editAccounts' => $editAccounts,
        'deleteAccounts' => $deleteAccounts,
        'previousDate' => $previousDate,
        'editEntry' => $editEntry,
        'deleteBooking' => $deleteBooking,
        'editMap' => $editMap
    );

    $privilegeArraySerialized = mysqli_real_escape_string($conn, serialize($privilegeArray));

    $query = mysqli_query($conn, "UPDATE `managers` SET `privileges` = '$privilegeArraySerialized' WHERE `id` = '$managerId'");

    exit();
}

//----------------------------------------------------------change privileges end--------------------------------------------------------

?>