<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
?>
<?php 
ob_start();
session_start();
include("db.php");

// Alert message if session set
if (isset($_SESSION['adding_branch'])) {
    $message = $_SESSION['adding_branch']; 
    echo "<script>alert('$message');</script>";
    unset($_SESSION["adding_branch"]);
}

// Get manager info
$user_email = $_SESSION['user_email'] ?? '';
$select_query_1 = "SELECT * FROM `managers` WHERE `email` = '$user_email'";
$result_1 = mysqli_query($conn, $select_query_1);

$branch_id = '';
$count_1 = mysqli_num_rows($result_1);
while ($row = mysqli_fetch_assoc($result_1)) {
    $branch_id = $row['branch_id'];
}

if ($count_1 > 0) {
    header("location:javascript://history.go(-1)");		
    exit;
}

if (!$user_email) {
    header("location:login.php?login=failed");
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Plaza Management</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
  <link rel="stylesheet" href="plugins/iCheck/flat/blue.css">
  <link rel="stylesheet" href="plugins/morris/morris.css">
  <link rel="stylesheet" href="plugins/jvectormap/jquery-jvectormap-1.2.2.css">
  <link rel="stylesheet" href="plugins/datepicker/datepicker3.css">
  <link rel="stylesheet" href="plugins/daterangepicker/daterangepicker.css">
  <link rel="stylesheet" href="plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css">
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
  <header class="main-header">
    <?php include('inc/main-header.php'); ?>
  </header>

  <aside class="main-sidebar">
    <?php include('inc/main-sidebar.php'); ?>
  </aside>

  <?php include('inc/calculator.php'); ?>

  <div class="content-wrapper">
    <section class="content-header">
      <h1>Plaza <small>Management</small>
        <a href="add_branch.php" class="btn btn-primary">Add New Plaza</a>
      </h1>
      <ol class="breadcrumb">
        <li class="active"><i class="fa fa-home"></i> Home</li>
      </ol>
    </section>

    <section class="content">
    	<div class="row">
        <?php
        $select_query = "SELECT * FROM `branches`";
        $result_query = mysqli_query($conn, $select_query);

        while ($row = mysqli_fetch_assoc($result_query)) {
            $branch_id = $row['id'];
            $branch_name = $row['name'];
            $manager = $row['manager'];
            $branch_location = $row['location'];
            $branch_area = $row['area'];
            $branch_status = $row['status'];
            $branch_image = $row['image'];
            $branch_entry_date = $row['date'];

            // Get manager name
            $manager_name = '';
            $select_query1 = "SELECT * FROM `managers` WHERE `branch_id` = '$branch_id'";
            $result_query1 = mysqli_query($conn, $select_query1);
            while ($row1 = mysqli_fetch_assoc($result_query1)) {
                $manager_name = $row1['name'];
            }
        ?>
        <div class="col-md-4">
            <div class="box box-primary">
                <div class="box-body box-profile">
                    <a href="branch_page.php?branch_id=<?= $branch_id ?>">
                      <div class="img-rounded" style="background-image:url('<?= $branch_image; ?>');width:100%;height:200px;background-size:cover;"></div>
                    </a>
                    <a href="branch_page.php?branch_id=<?= $branch_id ?>"><h3 class="text-center"><?= $branch_name; ?></h3></a>
                    <p class="text-muted text-center"><?= $branch_id ?></p>
                    <ul class="list-group list-group-unbordered">
                        <li class="list-group-item">
                          <b>Manager</b> <a class="pull-right"><?= $manager_name ?></a>
                        </li>
                        <li class="list-group-item">
                          <b>Location</b> <a class="pull-right"><?= $branch_location ?></a>
                        </li>
                        <li class="list-group-item">
                          <b>Total Area</b> <a class="pull-right"><?= $branch_area ?></a>
                        </li>
                        <li class="list-group-item">
                          <b>Status</b> <a class="pull-right"><?= $branch_status == '1' ? 'Enabled' : 'Disabled' ?></a>
                        </li>
                        <li class="list-group-item">
                          <b>Added on</b> <a class="pull-right"><?= $branch_entry_date ?></a>
                        </li>
                     </ul>
                     <a href="expand_area.php?branch_id=<?= $branch_id ?>" class="btn btn-success btn-block"><b>Expand Area</b></a>
                     <a href="edit_branch.php?branch_id=<?= $branch_id ?>" class="btn btn-primary btn-block"><b>Edit</b></a>
                </div>  
            </div>
        </div>
        <?php } ?>
        </div>
    </section>
  </div>

  <?php include('inc/footer.php'); ?>
  <?php include('inc/aside.php'); ?>
</div>

<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<script src="bootstrap/js/bootstrap.min.js"></script>
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<script src="plugins/fastclick/fastclick.js"></script>
<script src="dist/js/app.min.js"></script>
<script src="dist/js/demo.js"></script>
</body>
</html>
