<?php 
ob_start();
session_start();
include("db.php");

$date = date('Y-m-d');

// Check login
if (!isset($_SESSION['user_email'])) {
    header("location:login.php?login=failed");
    exit;
}

$user_email = $_SESSION['user_email'];

// Get manager info
$select_query_q = "SELECT * FROM `managers` WHERE `email` = '$user_email'";
$result_q = mysqli_query($conn, $select_query_q);

$branch_id = '';
$M_name = '';
$count_1 = mysqli_num_rows($result_q);

while ($rowq = mysqli_fetch_assoc($result_q)) {
    $branch_id = $rowq['branch_id'];
    $M_name = $rowq['name'];
}

// Get branch_id from GET param
$branch_id_s = $_GET['branch_id'] ?? '';

if ($count_1 > 0 && $branch_id_s != $branch_id) {
    header("location:javascript://history.go(-1)");
    exit;
}

// Get branch details
$select_query = "SELECT * FROM `branches` WHERE `id` = '$branch_id_s'";
$result_query = mysqli_query($conn, $select_query) or die($select_query . "<br/><br/>" . mysqli_error($conn));

$branch_name = '';
$branch_image = '';
$square_feet_size = '';

while ($row = mysqli_fetch_assoc($result_query)) {
    $branch_id = $row['id'];
    $branch_name = $row['name'];
    $branch_image = $row['image'];
    $square_feet_size = $row['square_feet_size'];
}
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Land Owner Payment Schedule</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
  
  <link href="dist/css/style.css" rel="stylesheet" type="text/css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
 <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
 <script src="bootstrap/js/bootstrap.min.js"></script>


<!-- for search box with input -->
  <script src="plugins/jQuery/choosen.js"></script>
  <link href="dist/css/chosen.css" rel="stylesheet" type="text/css">
<Style>
th {
	text-align:center;
}
.middles th,td
{
	vertical-align: middle !important;
	white-space: nowrap;
}
.recover-table
{
	overflow: scroll;
}
.recover-table th,td
{
	padding: 10px;
} 
</Style>
</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <header class="main-header">
    <!-- Logo -->
 <?php  include('inc/main-header.php');  ?>
    </header>
  <!-- Left side column. contains the logo and sidebar -->
    <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
 <?php  include('inc/main-sidebar.php');  ?>
  </aside>
<?php include('inc/calculator.php'); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Land Owner Payment Schedule
      </h1>
      <ol class="breadcrumb">
        <?php if($count_1 > 0){ }else{ ?>
        <li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
        <?php  } ?>
        <li><a href="branch_page.php?branch_id=<?= $branch_id ?>"><?php if($count_1 > 0){ ?><i class="fa fa-home"></i> Home <?php }else{ echo $branch_name; } ?></a></li>
        <li class="active">Land Owner Payment Schedule</li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
  <div class="row">
        <div class="col-xs-12">
          <div class="box box-primary">
            <div class="box-header">
            </div>
            <!-- /.box-header -->
            <div class="box-body">

							<?php 
							 $ins_query = mysqli_query($conn, "SELECT * FROM land_installments WHERE branch_id = '$branch_id';");

							 if(mysqli_num_rows($ins_query) > 0){ ?>
							 <div style="overflow: auto;">
							<table id="" class="table-bordered recover-table table-hover" style="text-align:center">

							<thead>
								<tr class="middles">
									<th rowspan="2">Owner</th>
									<th rowspan="2">Area</th>
									<th rowspan="2">Contact No.</th>
									<th rowspan="2">Agreement Date</th>
									<th rowspan="2">Installment Date</th>
									<th rowspan="2">Rate/Marla</th>
									<th rowspan="2">Total Amount</th>
									<th colspan="2">Advance</th>
									<th colspan="2">Installments</th>
									<th rowspan="2">Total Paid</th>
									<th rowspan="2">Remaining Amount</th>
									<th rowspan="2">Short Amount</th>
									<th rowspan="2">Short No. Of Installments</th>
									<th rowspan="2">Registry Date</th>
									<!--<th rowspan="2">History</th>-->
								</tr>
								<tr>
									<th>Total</th>
									<th>Paid</th>
									<th>Amount</th>
									<th>Paid</th>
								</tr>
							</thead>
								<tbody>
							<?php
								$all_total_prices = 0; 
								$total_advances = 0;
								$total_advances_recieved = 0;
								$total_installments = 0;
								$total_installments_received = 0;
								$amount_paid_total = 0;
								$total_remaining_amount = 0;
								$total_short_amount = 0;
								while($ins_row=mysqli_fetch_assoc($ins_query)){
							    $installment_id=$ins_row['id'];
								$land_id=$ins_row['land_id'];
								$installment_date=$ins_row['date_of_installment'];
								$installment_number=$ins_row['installment_number'];
								$installment_amount=$ins_row['installment_amount'];
								$date_of_installment=$ins_row['date_of_installment'];

							$select_query_q="SELECT * FROM `land_owner_setup` WHERE `branch_id` = '$branch_id_s' AND `id` = '$land_id'";
							$result_query_q=mysqli_query($conn, $select_query_q) or die($select_query_q."<br/><br/>".mysqli_error($conn));
								while($row_q=mysqli_fetch_assoc($result_query_q)){
								$numbering++;
								  $setup_id=$row_q['id'];
								  $ledger_id=$row_q['ledger_id'];
								  $father_name=$row_q['fname'];
								  $cnic_number=$row_q['cnic'];
								  $phone=$row_q['phone'];
								  $address=$row_q['address'];
								  $owner_image=$row_q['image'];
								  $total_area=$row_q['area'];
								  $rate_per_marla=$row_q['rate_per_marla'];
								  $total_price=$row_q['total_price'];
								  $advance_amount=$row_q['advance_amount'];
								  $payment_method=$row_q['payment_method'];
								  $num_installments=$row_q['num_installments'];
								  $agreement_date=$row_q['agreement_date'];
								  $registry_date=$row_q['registry_time']; 
								  $all_total_prices += $total_price;
								  $total_advances +=$advance_amount;
							}

							$ledger_query="SELECT * FROM `ledgers` WHERE `id` = '$ledger_id'";
						    $ledger_result=mysqli_query($conn, $ledger_query);
						    while($ledger_row=mysqli_fetch_assoc($ledger_result)){
						       $owner_name = $ledger_row['name'];
						    }
								
									//to get the amount of installments total
									$total_installments += $installment_amount;

									$total_debit = 0;
									$total_credit = 0;
									$select_query_for_balance=mysqli_query($conn, "SELECT * FROM `all_payments` WHERE `branch_id` = '$branch_id' AND `ledger_id` = '$ledger_id'");
											while($row_q=mysqli_fetch_assoc($select_query_for_balance)){
												$debit=(float)$row_q['debit'];
												$credit=(float)$row_q['credit'];
												$total_debit += $debit;
												$total_credit += $credit; 
											}

										$total_amount_paid = $selected_ledger_balance+$total_debit;
										$total_amount_paid = $total_amount_paid-$total_credit;	

										$amount_paid = abs($total_amount_paid);
									//To Get Paymens made by this customer End

									//To Get Remaining Amount Start 
										$total_installment_amounts_overall = 0;
										$remaining_amount_query=mysqli_query($conn, "SELECT * FROM `land_installments` WHERE `branch_id` = '$branch_id' AND `land_id` = '$land_id' AND `date_of_installment` = '$date_of_installment'");
									        while($remaining_amount_row=mysqli_fetch_assoc($remaining_amount_query)){
									        $running_installment_id = $remaining_amount_row['id'];
									        $payment_per_installment = $remaining_amount_row['installment_amount'];
									        $total_installment_amounts_overall += $payment_per_installment;
									    }
									        
									    $total_amount_to_pay_overall = $total_installment_amounts_overall+$advance_amount;

										//if there is a previous installment dont minus amount out of paid amount
									        $if_previous_query = mysqli_query($conn, "SELECT * FROM `land_installments` WHERE `branch_id` = '$branch_id' AND `land_id` = '$land_id' AND `id` < '$running_installment_id'");
									        $if_previous_row = mysqli_fetch_assoc($if_previous_query);
									        $previous_rows = mysqli_num_rows($if_previous_query);
									        if($previous_rows > 0){ $amount_paid = $amount_paid-$if_previous_row['installment_amount'];  }

										$remaining_amount = $total_amount_to_pay_overall-$amount_paid;
									//To Get Remaining Amount End 

									//To Get Short Amount Start
										$total_installment_amounts_till = 0;
										$short_query="SELECT * FROM `land_installments` WHERE `branch_id` = '$branch_id' AND `land_id` = '$land_id' AND `installment_number` <= '$installment_number'";
									    $result_short_query=mysqli_query($conn, $short_query) or die($short_query."<br/><br/>".mysqli_error($conn));
									        while($row_short=mysqli_fetch_assoc($result_short_query)){
									        $date_of_installment_till =$row_short['date_of_installment'];
									        $payment_per_installment_till = $row_short['installment_amount'];
									        $total_installment_amounts_till += $payment_per_installment_till;
									    }
									    $total_amount_to_pay_till = $total_installment_amounts_till+$advance_amount;

									    $short_amount = $total_amount_to_pay_till-$amount_paid;
									//To Get Short Amount End
									
									//To Get the Remaining Installments Start 
									    if($amount_paid > $advance_amount){
											$short_installments = $short_amount/$installment_amount;
											$total_advances_recieved += $advance_amount;
											if($short_installments < 0){ $short_installments = 0; }
										}else{
											$short_advance = $advance_amount-$amount_paid;
											$short_amount_advance_less = $short_amount-$short_advance;
											$short_installments = $short_amount_advance_less/$installment_amount;
											$total_advances_recieved += $amount_paid;
										}

									//To Get the Remaining Installments End
										$amount_to_pay_previous_month = $total_amount_to_pay_till-$payment_per_installment_till;
									if($amount_paid < $total_amount_to_pay_till && $amount_paid > $amount_to_pay_previous_month){
										$amount_paid_over = $amount_paid-$amount_to_pay_previous_month;
									}else{
										$amount_paid_over = 0;
									}

									//to get amount baid but not completed the installment


									//to get installments received
									if($amount_paid >= $total_amount_to_pay ){ $total_installments_received += $installment_amount; }else{
										if($amount_paid_this_month > 0){ $total_installments_received += $amount_paid_this_month; }
									} 
									//to get the total amount paid by all customers
									$amount_paid_total += $amount_paid;

									//to get the total of all remaining amounts
									$total_remaining_amount +=$remaining_amount;

									$remaining_of_the_whole_amount;

									//to get total short amount of all customers
									if($short_amount > 0){ $total_short_amount += $short_amount; }

									?>
								<tr <?php if($short_amount > 0){ ?> class="bg-danger" <?php } ?> <?php if($remaining_amount <= 0){ ?> class="bg-success" <?php } ?>>
									<td><?=$owner_name?></td>
									<td><?php echo  $total_area.' Marlay';?></td>
									<td><?=$phone?></td>
									<td><?php echo date("d M Y", strtotime($agreement_date)); ?></td>
									<td><?php echo date("d M Y", strtotime($date_of_installment)); ?></td>
									<td><?php echo number_format($rate_per_marla); ?></td>
									<td><?php echo number_format($total_price); ?></td>
									<td><?php if($previous_rows > 0){echo '-'; }else{ echo number_format($advance_amount); } ?></td>
									<td><?php if($previous_rows > 0){echo '-'; }else{ if($amount_paid >= $advance_amount){ echo number_format($advance_amount); }else{ echo number_format($amount_paid); } } ?></td>
									<td><?php echo number_format($installment_amount); ?></td>
									<td><?php if($amount_paid >= $total_amount_to_pay_till ){ echo number_format($installment_amount); }else{ if($amount_paid_over > 0){ echo number_format($amount_paid_over); }else{ echo '0'; }  } ?></td>
									<td><?php if($previous_rows > 0){echo '-'; }else{ echo number_format($amount_paid); } ?></td>
									<td><?php if($remaining_amount > $installment_amount){ echo number_format($installment_amount); }elseif($remaining_amount > 0){ echo number_format($remaining_amount); }else{ echo '0'; } ?></td>
									<td><?php if($short_amount > 0 && $short_amount < $payment_per_installment_till && $date > $date_of_installment){ echo number_format($short_amount); }elseif($short_amount > $payment_per_installment_till && $date > $date_of_installment){ echo number_format($payment_per_installment_till); }else{ echo '0'; } ?></td>
									<td><?php if(is_float($short_installments)){ echo number_format((float)$short_installments, 2, '.', ''); }elseif($remaining_installments == 0){ echo '0'; }else{ echo $short_installments; } ?></td>
									<td><?php echo date("d M Y", strtotime($registry_date)); ?></td>
									<!--<td><a href="view_recovery_sheet.php?branch_id=<?=$branch_id?>&booking_id=<?=$book_plot_id?>" target="_blank">View</a></td>-->
								</tr>
								<?php } ?>
								<tr class="bg-info" style="font-weight: bold">
									<td colspan="2">Total</td>
									<td></td>
									<td></td>
									<td></td>
									<td></td>
									<td><?php if($all_total_prices > 0){ echo number_format($all_total_prices); }else{ echo '0'; } ?></td>
									<td><?php if($total_advances > 0){ echo number_format($total_advances); }else{ echo '0'; } ?></td>
									<td><?php if($total_advances_recieved > 0){ echo number_format($total_advances_recieved); }else{ echo '0'; } ?></td>
									<td><?php if($total_installments > 0){ echo number_format($total_installments); }else{ echo '0'; } ?></td>
									<td><?php if($total_installments_received > 0){ echo number_format($total_installments_received); }else{ echo '0'; } ?></td>
									<td><?php if($amount_paid_total > 0){ echo number_format($amount_paid_total); }else{ echo '0'; } ?></td>
									<td><?php if($total_remaining_amount > 0){ echo number_format($total_remaining_amount); }else{ echo '0'; } ?></td>
									<td><?php if($total_short_amount > 0){ echo number_format($total_short_amount); }else{ echo '0'; } ?></td>
									<td></td>
									<td></td>
									<!--<td></td>-->
								</tr>
								</tbody></table>
								</div>
								 <?php }else{ ?>
				                    <div class="alert alert-danger text-center">
	          							<button data-dismiss="alert" class="close" type="button">×</button>
	          							<p>No Entries To show</p>
	          						</div>
								<?php } 
							?>
								<!-- </div> -->
				            </div>

          </div>
      </div>
      <!--<center>
      	<form method="post" style="display: inline-block;" >
			<input name="generate_pdf" type="submit" class="btn btn-success" value="Generate PDF">
		</form>
		<a href="print_ledger_statement.php?branch_id=<?=$branch_id?>&ledger_id=<?=$customer_ledger_id?><?php if($strdate){ echo '&startdate='.$startdate; } if($endate){ echo '&endate='.$enddate; } ?>" class="btn btn-primary" target="_blank">Generate Print</a>
	</center>-->
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
 <!-- Footer -->
  <?php include("inc/footer.php"); ?>

  <!-- Control Sidebar -->
  <?php include("inc/aside.php"); ?>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<!-- Bootstrap 3.3.6 -->
<!-- DataTables -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
<!-- page script -->
<script>

  $(function () {

    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
  jQuery(document).ready(function($) {
    $(".clickable-row").click(function() {
        window.location = $(this).data("href");
    });
 }); 	
  /* for selecting with input*/
  $(".chosen").chosen();
</script>

  <script src="//ajax.aspnetcdn.com/ajax/jquery.validate/1.9/jquery.validate.min.js"></script>
     <!-- Date range Picker start -->
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css"/>


  <!-- jQuery Form Validation code -->
  <script>
  
  // When the browser is ready...
$(document).ready(function() {
  /* Setup jQuery datepicker ui */
    var date_input=$('input[name="startdate"]'); //our date input has the name "date"
    var container=$('.bootstrap-iso form').length>0 ? $('.bootstrap-iso form').parent() : "body";
    date_input.datepicker({
      format: 'yyyy-mm-dd',
      container: container,
      todayHighlight: true,
      autoclose: true,
    });
    
     /* For Registry data */
     var date_input=$('input[name="enddate"]'); //our date input has the name "date"
    var container=$('.bootstrap-iso form').length>0 ? $('.bootstrap-iso form').parent() : "body";
    date_input.datepicker({
      format: 'yyyy-mm-dd',
      container: container,
      todayHighlight: true,
      autoclose: true,
    });


$("#check_info").hide();

$("input.check").click(function(){
	$("#check_info").show();
	});	
$("input.cash").click(function(){
	$("#check_info").hide();
	});		

    // Setup form validation on the #register-form element
    $("#register-form").validate({
    

        // Specify the validation rules
        rules: {
			"ledger_id": "required",
        },
        
        // Specify the validation error messages
        messages: {
			"ledger_id": "Please Select a Ledger",
        },
        
        submitHandler: function(form) {
            form.submit();
        }

    });

	  $("#plot_sold").click(function(){
		  
		var branch_id = $("#branch_id").val();

	  $.ajax({
		url: "functions.php?plot_id=<?= $p_id ?>",
		type: "POST",
		async: false,
		data: {
		"plot_sell_out": 1,
		"s_branch_id": branch_id,
		},
		success: function(data){
			
		}
		
	})
	

	  });
	
    
});


//ajax add student end

  </script>


</body>
</html>
