<?php 
ob_start();
session_start();
include("db.php");

// Show alert for own_land session
if (isset($_SESSION['own_land'])) {
    $message = $_SESSION['own_land']; 
    echo "<script>alert('$message');</script>";
    unset($_SESSION["own_land"]);
}

// Show alert for land_installments session
if (isset($_SESSION['land_installments'])) {
    $message = $_SESSION['land_installments']; 
    echo "<script>alert('$message');</script>";
    unset($_SESSION["land_installments"]);
}

// Check login
if (!isset($_SESSION['user_email'])) {
    header("Location: login.php?login=failed");
    exit;
}

$user_email = mysqli_real_escape_string($conn, $_SESSION['user_email']);

// Get manager data
$select_query_q = "SELECT * FROM `managers` WHERE `email`='$user_email'";
$result_q = mysqli_query($conn, $select_query_q) or die(mysqli_error($conn));

$branch_id = $M_name = '';
while ($rowq = mysqli_fetch_assoc($result_q)) {
    $branch_id = $rowq['branch_id'];
    $M_name = $rowq['name'];
}
$count_1 = mysqli_num_rows($result_q);

// Get and validate branch_id from URL
$branch_id_s = isset($_GET['branch_id']) ? mysqli_real_escape_string($conn, $_GET['branch_id']) : '';

if ($count_1 > 0) {
    if ($branch_id_s != $branch_id) {
        header("Location: javascript://history.go(-1)");
        exit;
    }
}

// Fetch branch details
$select_query = "SELECT * FROM `branches` WHERE `id` = '$branch_id_s'";
$result_query = mysqli_query($conn, $select_query) or die($select_query . "<br/><br/>" . mysqli_error($conn));

while ($row = mysqli_fetch_assoc($result_query)) {
    $branch_id = $row['id'];
    $branch_name = $row['name'];
    $branch_image = $row['image'];
    $square_feet_size = $row['square_feet_size'];
}
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Purchase Land</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
  <link href="dist/css/style.css" rel="stylesheet" type="text/css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
 <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
 <script src="bootstrap/js/bootstrap.min.js"></script>

<!-- for search box with input -->
  <script src="plugins/jQuery/choosen.js"></script>
  <link href="dist/css/chosen.css" rel="stylesheet" type="text/css">

<style type="text/css">

.maxQuantity:focus{
border-color: red;
}
</style>
</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <header class="main-header">
    <!-- Logo -->
 <?php  include('inc/main-header.php');  ?>
    </header>
  <!-- Left side column. contains the logo and sidebar -->
    <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
 <?php  include('inc/main-sidebar.php');  ?>
  </aside>
<?php include('inc/calculator.php'); ?>


<?php
//Land Owner Picture
if(isset($_FILES['image'])){
      $errors= array();
      $file_name = $_FILES['image']['name'];
      $file_size =$_FILES['image']['size'];
      $file_tmp =$_FILES['image']['tmp_name'];
      $file_type=$_FILES['image']['type'];
      $file_ext=strtolower(end(explode('.',$_FILES['image']['name'])));
      
      $expensions= array("jpeg","jpg","png");
      
      if(in_array($file_ext,$expensions)=== false){
         $errors[]="extension not allowed, please choose a JPEG or PNG file.";
      }
      
      if($file_size > 10485760){
         $errors[]='File size must be excately 2 MB';
      }
      
    $file_path="uploads/".$file_name;
    
      if(empty($errors)==true){
         move_uploaded_file($file_tmp,$file_path);
      }else{
         print_r($errors);
      }
   }
?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Purchase Land
        <small></small>
      </h1>
      <ol class="breadcrumb">
      	<?php if($count_1 > 0){ }else{ ?>
        <li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
        <?php  } ?>
        <li><a href="branch_page.php?branch_id=<?= $branch_id ?>"><?php if($count_1 > 0){ ?><i class="fa fa-home"></i> Home <?php }else{ echo $branch_name; } ?></a></li>
        <li class="active">Purchase Land</li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-xs-12">

          <div class="box box-primary">
            <div class="box-header">
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              
            <form role="form" id="register-form" method="post"  novalidate="novalidate" action="land_installments.php" enctype="multipart/form-data"> 
              <div class="box-body">
                <div class="form-group" style="width:48%;float:left">
                  <label for="">Project Name</label>
                    <select name="branch_id" id="branch_id" class="form-control" style="width:90%;">
                      <option value="<?= $branch_id ?>"><?= $branch_name ?></option>
                    </select>
                </div>
                <div class="form-group" style="width:48%;float:left;margin-bottom: 24px;">
                  <label>Land Owner Ledger Account</label>
                  <br>
              <select name="ledger_id" id="ledger_id" class="form-control select2-hidden-accessible chosen form-control " tabindex="-1" aria-hidden="true" style="width: 90%;text-align: center;float: left" required="required">
                <option value="0">Please Select</option>
<?php
$branch_id_safe = mysqli_real_escape_string($conn, $branch_id);

$control_query = mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `branch_id` = '$branch_id_safe'");
while ($control_items = mysqli_fetch_assoc($control_query)) {
    $control_account_id = $control_items['id'];
    $control_account_name = $control_items['name'];
    $control_gcode = $control_items['gcode'];
    ?>
    <option value="<?= $control_account_id ?>" disabled style="color:#23527c;font-weight:900;">
        <b>&nbsp;&nbsp;&nbsp;[<?= $control_gcode ?>] <?= $control_account_name ?></b>
    </option>

    <?php
    $general_query = mysqli_query($conn, "SELECT * FROM `general_ledgers` WHERE `branch_id` = '$branch_id_safe' AND `control_account_id` = '$control_account_id'");
    while ($general_item = mysqli_fetch_assoc($general_query)) {
        $general_ledger_id = $general_item['id'];
        $general_ledger_name = $general_item['name'];
        $general_ledger_gcode = $general_item['gcode'];
        ?>
        <option value="<?= $general_ledger_id ?>" disabled style="color:#72afd2;font-weight:900;">
            <b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[<?= $general_ledger_gcode ?>] <?= $general_ledger_name ?></b>
        </option>

        <?php
        $ledger_query = mysqli_query($conn, "SELECT * FROM `ledgers` WHERE `branch_id` = '$branch_id_safe' AND `control_account_id` = '$control_account_id' AND `general_ledger_id` = '$general_ledger_id'");
        while ($ledger_item = mysqli_fetch_assoc($ledger_query)) {
            $ledger_id = $ledger_item['id'];
            $ledger_customer_id = $ledger_item['customer_id'];
            $ledger_name = $ledger_item['name'];
            $ledger_gcode = $ledger_item['gcode'];

            // Get customer name
            $lopped_customer_name = '';
            $lopped_customer_query = mysqli_query($conn, "SELECT `name` FROM `customers` WHERE `id` = '$ledger_customer_id'");
            if ($customer = mysqli_fetch_assoc($lopped_customer_query)) {
                $lopped_customer_name = $customer['name'];
            }
            ?>
            <option value="<?= $ledger_id ?>">
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                [<?= $ledger_gcode ?>]
                <?= $lopped_customer_name ?> <?= $ledger_name ?>
            </option>
        <?php
        }
    }
}
?>

              </select>
              <span class="error"></span>
                  </div>
                 <div class="form-group" style="width:48%;float:left">
                  <label for="">Father's name</label>
                  <input type="text" name="fname" id="fname" class="form-control" value="" style="width:90%;">
                </div>
                <div class="form-group" style="width:48%;float:left">
                  <label for="">CNIC Number</label>
                  <input type="text" name="cnic" id="cnic" class="form-control" value="" style="width:90%;">
                </div>
                <div class="form-group" style="width:48%;float:left">
                  <label for="">Phone Number</label>
                  <input type="number" name="phone" id="phone" class="form-control" value="" style="width:90%;">
                </div>
                <div class="form-group" style="width:48%;float:left">
                  <label for="">Address</label>
                  <input type="text" name="address" id="address" class="form-control" value="" style="width:90%;">
                </div>
                <div style="width:48%;float:left">
                      <label for="">Customer Picture</label><br>
                    <input type="file" name="image" id="image" style="display:inline-block" required/>
                      
                </div>
                <div class="form-group" style="width:48%;float:left">
                  <label for="">Total Area <small>(Marly)</small></label>
                  <input type="number" name="area" id="area" class="form-control" value="" style="width:90%;background-color:white">
                </div>
                 <div class="form-group" style="width:48%;float:left">
                  <label for="">Rate Per Marla</label>
                  <input type="number" name="price" id="price" class="form-control" placeholder="Rate Per Marla" style="width:90%;" data-view-id="#location">
                </div>
                <div class="form-group" style="width:48%;float:left">
                          <label for="">Total Price</label>
                          <input type="number" name="total_price" id="total_price" class="form-control" style="width:90%;background-color:white" readonly>
                </div>
                <div class="form-group" style="width:48%;float:left">
                          <label for="">Advance Amount</label>
                          <input type="number" name="advance_amount" id="advance_amount" class="form-control" placeholder="Advance amount" style="width:90%;">
                </div>
                <div class="form-group" style="width:48%;float:left">
                          <label for="">Mode Of Agreement</label><br>
                    <input type="radio" name="payment_method" id="payment_method" value="installment" class="installment" id="payment_method"> Installment<br>
                          <input type="radio" name="payment_method" id="payment_method" value="cash" class="cash" id="payment_method" checked> Cash<br>
                </div>
                <div id="check_info">
                 <div class="form-group" style="width:48%;float:left">
                          <label for="">Total Number of Installments</label>
                          <input type="number" name="num_installments" id="num_installments" class="form-control" placeholder="Number Of Installmetns" style="width:90%;">
                </div>
                </div>
                <div class="form-group" style="width:48%;float:left">
                          <label for="">Agreement Date</label><br>
                    <input type="text" name="agreement_date" placeholder="Year-Month-Day" id="agreement_date" class="form-control"  style="width:90%;">
                </div>
                <div class="form-group" style="width:48%;float:left" id="registry_date">
                          <label for="">Registery Time</label><br>
                    <input type="text" name="registery_time" id="registery_time" placeholder="Year-Month-Day" class="form-control"  style="width:90%;">
                </div>
              <!-- /.box-body -->
            </div>
            <!-- /.box-body -->
              <div class="box-footer">
                <input type="submit" id="own_land" class="btn btn-primary">
              </div>
            </form>
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <!-- Footer -->
  <?php include("inc/footer.php"); ?>

  <!-- Control Sidebar -->
  <?php include("inc/aside.php"); ?>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<!-- Bootstrap 3.3.6 -->
<!-- DataTables -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
<!-- page script -->
<script>

  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });


   /* for selecting with input*/
  $(".chosen").chosen();

</script>

  <script src="//ajax.aspnetcdn.com/ajax/jquery.validate/1.9/jquery.validate.min.js"></script>

   <!-- Date range Picker start -->
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css"/>
  
  <!-- jQuery Form Validation code -->
  <script>
  
  // When the browser is ready...
$(document).ready(function() {
  $("#check_info").hide();

$("input.installment").click(function(){
  $("#check_info").show();
  }); 
$("input.cash").click(function(){
  $("#check_info").hide();
  }); 

/* Setup jQuery datepicker ui */
    var date_input=$('input[name="agreement_date"]'); //our date input has the name "date"
    var container=$('.bootstrap-iso form').length>0 ? $('.bootstrap-iso form').parent() : "body";
    date_input.datepicker({
      format: 'yyyy-mm-dd',
      container: container,
      todayHighlight: true,
      autoclose: true,
    });
  var date_input=$('input[name="registery_time"]'); //our date input has the name "date"
    var container=$('.bootstrap-iso form').length>0 ? $('.bootstrap-iso form').parent() : "body";
    date_input.datepicker({
      format: 'yyyy-mm-dd',
      container: container,
      todayHighlight: true,
      autoclose: true,
    });


    // Setup form validation on the #register-form element
    $("#register-form").validate({
    
        // Specify the validation rules
      rules: {
      branch_id: "required",
      ledger_id: "required",
      fname: "required",
      cnic: "required",
      phone: "required",
      address: "required",
      image: "required",
      area: "required",
      price: "required",
      total_price: "required",
      advance_amount: "required",
      num_installments: "required",
      agreement_date: "required",
      registery_time: "required"
        },
        
        // Specify the validation error messages
      messages: {
      branch_id: "Please Select A Branch",
      ledger_id: "Please Select a Land Owner",
      fname: "Please Enter Father Name",
      cnic: "Please Enter CNIC No.",
      phone: "Please Enter Phone No.",
      address: "Please Enter Address",
      image: "Please Select An Image",
      area: "Please Enter Total Area",
      price: "Please Enter Rate/Marla",
      total_price: "Please Enter Total Price",
      advance_amount: "Please Enter Advance Amount",
      num_installments: "Please Enter Number Of Installments",
      agreement_date: "Please Enter Agreement Date",
      registery_time: "Please Enter Registry Time"
        },
        
        submitHandler: function(form) {
            form.submit();
        }
    });
	//ajax area add student
	  $("#own_land").click(function(){
	  var branch_id = $("#branch_id").val();
    var ledger_id = $("#ledger_id").val();
    var fname = $("#fname").val();
    var cnic = $("#cnic").val();
    var phone = $("#phone").val();
    var address = $("#address").val();
    var image = $('#image').val().split('\\').pop();
      image1=image.split('.')[0];
    fileExtension = image.substr((image.lastIndexOf('.') + 1));
    console.log (fileExtension);
    var area = $("#area").val();
    var price = $("#price").val();
    var total_price = $("#total_price").val();
    var advance_amount = $("#advance_amount").val();
    var payment_method = $("input[name=payment_method]:checked").val();
    var num_installments = $("#num_installments").val();
    var agreement_date = $("#agreement_date").val();
    var registery_time = $("#registery_time").val();
	 
	  $.ajax({
		url: "functions.php",
		type: "POST",
		async: false,
		data: {
		"land_owned": 1,
		"s_branch_id": branch_id,
    "s_ledger_id": ledger_id,
    "s_fname": fname,
    "s_cnic": cnic,
    "s_phone": phone,
    "s_address": address,
    "s_image": 'uploads/'+image1+'.'+fileExtension,
    "s_area": area,
    "s_rate_per_marla": price,
    "s_total_price": total_price,
    "s_advance_amount": advance_amount,
    "s_payment_method": payment_method,
    "s_num_installments": num_installments,
    "s_agreement_date": agreement_date,
    "s_registery_time": registery_time,
		},
		success: function(data){
			
		}
		
	})
	

	  });
	
    
});

  </script>


<script type="text/javascript">
  $(document).ready(function() {
  //For Total Price According to Rate/Marla
$( "#price" )
  .keyup(function() {
  var value = $( "#price" ).val();
  var tarea = $("#area").val();
  var total_p = Number(value*tarea).toFixed(0);
  $( "#total_price" ).val(total_p);
  });

$('.maxQuantityMsg').hide();
$('#advance_amount').on('keydown keyup', function(e){
  var g = $( "#total_price" ).val();
  var values = parseInt(g);
    if ($(this).val() > values
        && e.keyCode != 46 // delete
        && e.keyCode != 8 // backspace
    ){
        e.preventDefault();
        $(this).val(values);
        $(this).addClass('maxQuantity').focus();
    } else{
        $(this).removeClass("maxQuantity");
        $(this).attr("placeholder", "0");    
    }
});
});
</script>
</body>
</html>
