<?php 
ob_start();
session_start();
include("db.php");

// Check login session
if (!isset($_SESSION['user_email'])) {
    header("Location: login.php?login=failed");
    exit;
}

$user_email = mysqli_real_escape_string($conn, $_SESSION['user_email']);

// Fetch manager details
$select_query_q = "SELECT * FROM `managers` WHERE `email` = '$user_email'";
$result_q = mysqli_query($conn, $select_query_q) or die(mysqli_error($conn));

$branch_id = $M_name = '';
while ($rowq = mysqli_fetch_assoc($result_q)) {
    $branch_id = $rowq['branch_id'];
    $M_name = $rowq['name'];
}
$count_1 = mysqli_num_rows($result_q);

// Get and sanitize branch_id from URL
$branch_id_s = isset($_GET['branch_id']) ? mysqli_real_escape_string($conn, $_GET['branch_id']) : '';

if ($count_1 > 0 && $branch_id_s != $branch_id) {
    header("Location: javascript://history.go(-1)");
    exit;
}

// Fetch branch details
$select_query = "SELECT * FROM `branches` WHERE `id` = '$branch_id_s'";
$result_query = mysqli_query($conn, $select_query) or die($select_query . "<br/><br/>" . mysqli_error($conn));

while ($row = mysqli_fetch_assoc($result_query)) {
    $branch_id = $row['id'];
    $branch_name = $row['name'];
    $manager_name = $row['manager'];
    $branch_location = $row['location'];
    $branch_area = $row['area'];
    $branch_status = $row['status'];
    $branch_image = $row['image'];
    $square_feet_size = $row['square_feet_size'];
    $branch_entry_date = $row['date'];
}

// Display success alert if plot was registered
if (isset($_SESSION['register_plot'])) {
    $message = $_SESSION['register_plot'];
    echo "<script>alert('$message');</script>";
    unset($_SESSION["register_plot"]);
}
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Purchased Lands</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
  <!-- iCheck -->
  <link rel="stylesheet" href="plugins/iCheck/flat/blue.css">
  <!-- Morris chart -->
  <link rel="stylesheet" href="plugins/morris/morris.css">
  <!-- jvectormap -->
  <link rel="stylesheet" href="plugins/jvectormap/jquery-jvectormap-1.2.2.css">
  <!-- Date Picker -->
  <link rel="stylesheet" href="plugins/datepicker/datepicker3.css">
  <!-- Daterange picker -->
  <link rel="stylesheet" href="plugins/daterangepicker/daterangepicker.css">
  <!-- bootstrap wysihtml5 - text editor -->
  <link rel="stylesheet" href="plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css">
 <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
 <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
  <Style>
  th {
  text-align:center;
}
.middles th,td
{
  vertical-align: middle !important;
  white-space: nowrap;
}
.recover-table
{
  overflow: scroll;
}
.recover-table th,td
{
  padding: 10px;
} 
</Style>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <header class="main-header">
    <!-- Logo -->
 <?php  include('inc/main-header.php');  ?>
    </header>
  <!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
 <?php  include('inc/main-sidebar.php');  ?>
  </aside>
 <?php include('inc/calculator.php'); ?>
 
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Purchased Lands
        <small><?= $branch_name ?></small>
      </h1>
      <ol class="breadcrumb">
        <?php if($count_1 > 0){ }else{ ?>
        <li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
        <?php  } ?>
        <li><a href="branch_page.php?branch_id=<?= $branch_id ?>"><?php if($count_1 > 0){ ?><i class="fa fa-home"></i> Home <?php }else{ echo $branch_name; } ?></a></li>
        <li class="active">Purchased Lands</li>
      </ol><br>
      

    </section>

    <!-- Main content -->
    
<!-- /.content -->

     <section class="content">
      <div class="row">
        <div class="col-xs-12">
        

          <div class="box box-primary">
            <div class="box-header">
        <?php
		$select_query_q="SELECT * FROM `land_owner_setup` WHERE `branch_id` = '$branch_id_s'";
		$result_query_q=mysqli_query($conn, $select_query_q) or die($select_query_q."<br/><br/>".mysqli_error($conn));
			$total_booked = 0;
			if(mysqli_num_rows($result_query_q) > 0){ 
		?>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <div style="overflow: auto">
              <table id="example1" class="table recover-table table-bordered text-center">
                <thead>
                <tr class="middles">
                  <th>SN#</th>
                  <th>Owner Name</th>
                  <th>Father's Name</th>
        				  <th>CNIC No.</th>
        				  <th>Phone</th>
        				  <th>Address</th>
        				  <th>Area</th>
        				  <th>Rate/Marla</th>
        				  <th>Total Price</th>
                  <th>Advance</th>
                  <th>Installments</th>
                  <th>Date</th>
                  <th>View</th>
        				  <?php if($count_1 > 0){ }else{?><th>Delete</th><?php } ?>

                </tr>
                </thead>
                <tbody>
   <?php
   			$numbering = 0;
			while($row_q=mysqli_fetch_assoc($result_query_q)){
			$numbering++;
			$setup_id=$row_q['id'];
			$ledger_id=$row_q['ledger_id'];
			$father_name=$row_q['fname'];
			$cnic_number=$row_q['cnic'];
			$phone=$row_q['phone'];
			$address=$row_q['address'];
			$owner_image=$row_q['image'];
			$total_area=$row_q['area'];
			$rate_per_marla=$row_q['rate_per_marla'];
			$total_price=$row_q['total_price'];
			$advance_amount=$row_q['advance_amount'];
      $payment_method=$row_q['payment_method'];
      $num_installments=$row_q['num_installments'];
      $agreement_date=$row_q['agreement_date'];
      $registry_date=$row_q['registry_time'];
			$total_booked += 1;
			
		$ledger_query="SELECT * FROM `ledgers` WHERE `id` = '$ledger_id'";
		$ledger_result=mysqli_query($conn, $ledger_query);
		while($ledger_row=mysqli_fetch_assoc($ledger_result)){
			 $owner_name = $ledger_row['name'];
		}

	?>
                <tr>
                  <td><?= $numbering; ?></td>
                  <td><?= $owner_name; ?></td>
                  <td><?= $father_name ?></td>
				          <td><?= $cnic_number ?></td>
				          <td><?= $phone ?></td>
        				  <td><?= $address ?></td>
        				  <td><?=$total_area?></td>
        				  <td><?php echo number_format($rate_per_marla); ?></td>
        				  <td><?php echo number_format($total_price); ?></td>
        				  <td><?php echo number_format($advance_amount); ?></td>
                  <td><?php if($num_installments){ echo $num_installments; }else{ echo '0'; }?></td>
                  <td><?=$agreement_date?></td>
        				  <td><a href="view_purchased_lands.php?branch_id=<?=$branch_id?>&setup_id=<?=$setup_id?>" class="btn btn-primary"><b>View</b></a></td>
                  <!--<td><a href="register_plot.php?branch_id=<?=$branch_id?>&booking_id=<?=$book_plot_id;?>" onclick="return confirm('Do You Want To Register Plot No. <?=$p_no;?> ?');"
                  class="btn btn-success"><b>Register</b></a></td>                
               -->
                  <?php if($count_1 > 0){ }else{?><td><a href="delete_booking.php?branch_id=<?=$branch_id?>&block_id=<?=$block;?>&plot_no=<?=$p_no;?>" onclick="return confirm('Are you sure you want to Delete this Bookings?');"
                  class="btn btn-danger"><b>Delete</b></a></td><?php } ?>
 </tr>
               <?php } ?>
                </tbody>
                <tfoot>
                </tr>
                </tfoot>
              </table>
            </div>
               <?php }else{ ?>
                    <b>No Data Found</b>
				<?php } ?>
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    
<!-- /.content -->




  </div>
  <!-- /.content-wrapper -->
  <?php include('inc/footer.php'); ?>

  <!-- Control Sidebar -->
 <?php include('inc/aside.php'); ?>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- DataTables -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
<!-- page script -->
<script>

  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
</script>

  <script src="//ajax.aspnetcdn.com/ajax/jquery.validate/1.9/jquery.validate.min.js"></script>
  
  <!-- jQuery Form Validation code -->
</body>
</html>
