<?php 
ob_start();
session_start();
include("db.php");

// Check user session
if (!isset($_SESSION['user_email'])) {
    header("Location: login.php?login=failed");
    exit();
}

$user_email = mysqli_real_escape_string($conn, $_SESSION['user_email']);

// Get manager info
$select_query_q = "SELECT * FROM `managers` WHERE `email` = '$user_email'";
$result_q = mysqli_query($conn, $select_query_q);

$branch_id = '';
$M_name = '';
$M_privileges = '';
$count_1 = mysqli_num_rows($result_q);

if ($rowq = mysqli_fetch_assoc($result_q)) {
    $branch_id = $rowq['branch_id'];
    $M_name = $rowq['name'];
    $M_privileges = $rowq['privileges'];
}

$branch_id_s = isset($_GET['branch_id']) ? mysqli_real_escape_string($conn, $_GET['branch_id']) : '';
$control_account_id = isset($_GET['control_account_id']) ? mysqli_real_escape_string($conn, $_GET['control_account_id']) : '';
$general_ledger_id = isset($_GET['general_ledger_id']) ? mysqli_real_escape_string($conn, $_GET['general_ledger_id']) : '';

// Validate privileges and branch access
if ($count_1 > 0) {
    $privileges = unserialize($M_privileges);
    if ($branch_id_s !== $branch_id) {
        header("Location: javascript://history.go(-1)");
        exit();
    }
}

// Show session alerts
if (isset($_SESSION['ledger'])) {
    echo "<script>alert('" . htmlspecialchars($_SESSION['ledger'], ENT_QUOTES) . "');</script>";
    unset($_SESSION["ledger"]);
}

if (isset($_SESSION['edit_ledger'])) {
    echo "<script>alert('" . htmlspecialchars($_SESSION['edit_ledger'], ENT_QUOTES) . "');</script>";
    unset($_SESSION["edit_ledger"]);
}

// Get branch details
$select_query = "SELECT * FROM `branches` WHERE `id` = '$branch_id_s'";
$result_query = mysqli_query($conn, $select_query);

if (!$result_query) {
    die($select_query . "<br><br>" . mysqli_error($conn));
}

while ($row = mysqli_fetch_assoc($result_query)) {
    $branch_id = $row['id'];
    $branch_name = $row['name'];
    $branch_image = $row['image'];
    $square_feet_size = $row['square_feet_size'];
}

// Get control account details
$control_account_query = mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `id` = '$control_account_id'");
while ($row_2 = mysqli_fetch_assoc($control_account_query)) {
    $control_account_id = $row_2['id'];
    $control_account_code = $row_2['gcode'];
}

// Get general ledger (first one found)
$select_query_for_ledger = mysqli_query($conn, "SELECT * FROM `general_ledgers` WHERE `branch_id` = '$branch_id' AND `control_account_id` = '$control_account_id'");
while ($row_3 = mysqli_fetch_assoc($select_query_for_ledger)) {
    $gl_id = $row_3['id'];
}

// Restriction: 'Customer Receivable' control account
$control_restrict_query = mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `branch_id` = '$branch_id' AND `name` = 'Customer Recievable'");
while ($row_c = mysqli_fetch_assoc($control_restrict_query)) {
    $control_restrict_id = $row_c['id'];
}

// Get restricted general ledger
$general_restrict_query = mysqli_query($conn, "SELECT * FROM `general_ledgers` WHERE `branch_id` = '$branch_id' AND `control_account_id` = '$control_restrict_id'");
while ($row_r = mysqli_fetch_assoc($general_restrict_query)) {
    $general_restrict_id = $row_r['id'];
}
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Ledgers</title>
  <!-- Tell the browser tso be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
  <link href="dist/css/style.css" rel="stylesheet" type="text/css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
 <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
 <script src="bootstrap/js/bootstrap.min.js"></script>

</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <header class="main-header">
    <!-- Logo -->
 <?php  include('inc/main-header.php');  ?>
    </header>
  <!-- Left side column. contains the logo and sidebar -->
    <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
 <?php  include('inc/main-sidebar.php');  ?>
  </aside>
<?php include('inc/calculator.php'); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Ledgers
        <small><?= $branch_name ?></small>
		<?php if($general_restrict_id != $general_ledger_id){ ?><a href="add_ledger.php?branch_id=<?=$branch_id?>&control_account_id=<?=$control_account_id?>&general_ledger_id=<?=$general_ledger_id?>" class="btn btn-primary">Add Ledger</a><?php } ?>
      </h1>
      <ol class="breadcrumb">
        <?php if($count_1 > 0){ }else{ ?>
        <li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
        <?php  } ?>
        <li><a href="branch_page.php?branch_id=<?= $branch_id ?>"><?php if($count_1 > 0){ ?><i class="fa fa-home"></i> Home <?php }else{ echo $branch_name; } ?></a></li>
        <li><a href="control_accounts.php?branch_id=<?= $branch_id ?>">Control Accounts</a></li>
		<li><a href="general_ledgers.php?branch_id=<?=$branch_id?>&control_account_id=<?=$control_account_id?>">General Ledgers</a></li>
		<li class="active"> Ledgers</li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-xs-12">
        

          <div class="box box-primary">
            <div class="box-header">
   <?php
   $numbering = 0;
	$select_query="SELECT * FROM `ledgers` WHERE `branch_id` = '$branch_id' AND `control_account_id` = '$control_account_id' AND `general_ledger_id` = '$general_ledger_id' ";	
  	$result=mysqli_query($conn, $select_query);
		if(mysqli_num_rows($result) > 0){
	?>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <table id="example1" class="table table-bordered text-center table-hover">
                <thead>
                <tr class='clickable-row cursor' data-href='ledgers.php?branch_id=<?=$branch_id?>&control_account_id=<?=$control_account_id?>&general_ledger_id=<?=$gl_id?>' style="cursor:pointer">
                  <th>SN#</th>
                  <th>Branch</th>
                  <th>Control Account</th>
				          <th>Name</th>
                  <th>Description</th>
				          <th>Group Code</th>
                  <th>Registry Date</th>
                  <?php if($count_1 <= 0 || $privileges['editAccounts']){ ?><th>Edit</th><?php } ?>
                  <?php if($count_1 <= 0 || $privileges['shiftLedger']){ ?><th>Shift</th><?php } ?>
                  <?php if($count_1 <= 0 || $privileges['deleteAccounts']){ ?><th>Delete</th><?php } ?>
                </tr>
                </thead>
                <tbody>
   <?php 
  
	
	while($row=mysqli_fetch_assoc($result)){
			 $numbering++;
			 $general_ledger_id = $row['id'];
			 $general_ledger_branch_id = $row['branch_id'];
			 $general_ledger_controller_id = $row['control_account_id'];
       $ledger_customer_id = $row['customer_id'];
       $ledger_block_id = $row['block_id'];
			 $ledger_name = $row['name'];
			 $description = $row['description'];
			 $gcode = $row['gcode'];
			 $creation_date = $row['date'];
			 
       $lopped_customer_query=mysqli_query($conn, "SELECT * FROM `customers` WHERE `id` = '$ledger_customer_id'");
                      while($lopped_customer_row=mysqli_fetch_assoc($lopped_customer_query)){
                       $lopped_customer_id=$lopped_customer_row['id'];
                       $lopped_customer_name=$lopped_customer_row['name'];
                           
                      }



	$select_query_1=mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `id` = '$general_ledger_controller_id'");
	while($row_1=mysqli_fetch_assoc($select_query_1)){
			 $control_account_name = $row_1['name'];
	}

  $select_query_block=mysqli_query($conn, "SELECT * FROM `branch_categories` WHERE `id` = '$ledger_block_id'");
  while($row_block=mysqli_fetch_assoc($select_query_block)){
       $ledger_block_name = $row_block['name'];
  }
?>
                <tr>
				  <td><?= $numbering; ?></td>
                  <td><?= $branch_name; ?></td>
                  <td><?= $control_account_name ?></td>
				  <td><?php if($ledger_customer_id == isset($lopped_customer_id)){ echo isset($lopped_customer_name); } ?> <?= $ledger_name ?> <?php if($ledger_block_id){ echo '('.$ledger_block_name.')'; } ?></td>
                  <td><?= $description ?></td>
				  <td><?= $gcode ?></td>
                  <td><?= $creation_date ?></td>
                  <?php if($count_1 <= 0 || $privileges['editAccounts']){ ?>
                    <td><a href="edit_ledger.php?branch_id=<?=$branch_id?>&ledger_id=<?=$general_ledger_id?>" class="btn btn-xs btn-block btn-primary">Edit</td>
                  <?php } ?>
                  <?php if($count_1 <= 0 || $privileges['shiftLedger']){ ?>
                    <td><a href="shift_ledger.php?branch_id=<?=$branch_id?>&ledger_id=<?=$general_ledger_id?>" class="btn btn-xs btn-block btn-warning">Shift</td>
                  <?php } ?>
                  <?php if($count_1 <= 0 || $privileges['deleteAccounts']){ ?>
                    <td><a href="delete_functions.php?ledger_id=<?=$general_ledger_id?>" onclick="return confirm('Are You sure You Want To Delete?');" class="btn btn-xs btn-block btn-danger">Delete</td>
                  <?php } ?>
                </tr>
                <?php }  ?>
                </tbody>
                <tfoot>
                </tfoot>
              </table>
               <?php }else{ ?>
                    <b>No Data Found</b>
				<?php } 
				
				$gcode_ledger = $numbering+1;
				$_SESSION['gcode_ledger'] = $gcode_ledger; ?>
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
 <!-- Footer -->
  <?php include("inc/footer.php"); ?>

  <!-- Control Sidebar -->
  <?php include("inc/aside.php"); ?>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<!-- Bootstrap 3.3.6 -->
<!-- DataTables -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
<!-- page script -->
<script>

  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
</script>

  <script src="//ajax.aspnetcdn.com/ajax/jquery.validate/1.9/jquery.validate.min.js"></script>
  
  <!-- jQuery Form Validation code -->

</body>
</html>
