<?php 
ob_start();
session_start();
include("db.php"); // Ensure $conn is a valid mysqli connection
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Log in</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <link rel="stylesheet" href="plugins/iCheck/square/blue.css">
</head>

<?php
if (isset($_POST['submit'])) {
    $email = trim($_POST['email'] ?? '');
    $password = trim($_POST['password'] ?? '');

    if (!empty($email) && !empty($password)) {
        // Check in `admins` table
        $stmt = $conn->prepare("SELECT * FROM admins WHERE email = ? AND password = ?");
        $stmt->bind_param("ss", $email, $password);
        $stmt->execute();
        $result = $stmt->get_result();
        $count = $result->num_rows;

        // Check in `managers` table
        $stmt1 = $conn->prepare("SELECT * FROM managers WHERE email = ? AND password = ?");
        $stmt1->bind_param("ss", $email, $password);
        $stmt1->execute();
        $result1 = $stmt1->get_result();
        $count1 = $result1->num_rows;

        if ($count > 0) {
            $_SESSION['user_email'] = $email;
            header("Location: index.php?login=succ");
            exit();
        } elseif ($count1 > 0) {
            $row = $result1->fetch_assoc();
            $_SESSION['user_email'] = $email;
            $branch_id = $row['branch_id'];
            header("Location: branch_page.php?login=succ&branch_id=" . urlencode($branch_id));
            exit();
        } else {
            echo "<script>alert('Wrong Email or Password');</script>";
        }
    } else {
        echo "<script>alert('Please enter email and password');</script>";
    }
}
?>

<body class="hold-transition login-page">
<div class="login-box">
  <div class="login-logo">
    <center><a href="#"><img src="dist/img/logo.png" alt="LOGO" class="img-responsive" /></a></center>
  </div>
  <div class="login-box-body">
    <p class="login-box-msg">Log in to start your work</p>
    <form action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" method="post">
      <div class="form-group has-feedback">
        <input type="email" class="form-control" value="<?php echo htmlspecialchars($_POST['email'] ?? '', ENT_QUOTES); ?>" name="email" placeholder="Email" required>
        <span class="glyphicon glyphicon-envelope form-control-feedback"></span>
      </div>
      <div class="form-group has-feedback">
        <input type="password" name="password" class="form-control" placeholder="Password" required>
        <span class="glyphicon glyphicon-lock form-control-feedback"></span>
      </div>
      <div class="row">
        <div class="col-xs-8">
          <div class="checkbox icheck">
            <label><input type="checkbox"> Remember Me</label>
          </div>
        </div>
        <div class="col-xs-4">
          <button type="submit" name="submit" class="btn btn-primary btn-block btn-flat">Log In</button>
        </div>
      </div>
    </form>
    <a href="#">I forgot my password</a><br>
  </div>
</div>

<!-- Scripts -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<script src="bootstrap/js/bootstrap.min.js"></script>
<script src="plugins/iCheck/icheck.min.js"></script>
<script>
  $(function () {
    $('input').iCheck({
      checkboxClass: 'icheckbox_square-blue',
      radioClass: 'iradio_square-blue',
      increaseArea: '20%' 
    });
  });
</script>
</body>
</html>
