<?php 
ob_start();
session_start();
include("db.php");

// Check if user is logged in
// Yeh check karta hai ke user login hua hai ya nahi
if (!isset($_SESSION['user_email'])) {
    header("location:login.php?login=failed");
    exit();
}

$user_email = $_SESSION['user_email'];

// Get manager details from email
// Manager ka data retrieve kar rahe hain user_email ke zariye
$select_query_q = "SELECT * FROM `managers` WHERE `email` = '$user_email'";
$result_q = mysqli_query($conn, $select_query_q);
$count_1 = mysqli_num_rows($result_q);
$branch_id = '';
$M_name = '';

if (mysqli_num_rows($result_q) > 0) {
    while ($rowq = mysqli_fetch_assoc($result_q)) {
        $branch_id = $rowq['branch_id'];
        $M_name = $rowq['name'];
    }
}

// Check if the manager is trying to access another branch
// Yeh check karta hai ke manager apni branch hi access kar raha hai ya kisi aur ki
if (isset($_GET['branch_id']) && $_GET['branch_id'] != $branch_id) {
    header("location:javascript://history.go(-1)");
    exit();
}

// Get selected manager ID from GET
// GET parameter se selected manager ID le rahe hain
$managerId = $_GET['managerId'];

// Fetch manager data by ID
// Manager ka data ID ke zariye nikaal rahe hain
$managerQuery = mysqli_query($conn, "SELECT * FROM `managers` WHERE `id` = '$managerId'");
$managerData = mysqli_fetch_assoc($managerQuery);

$managerName = $managerData['name'];
$managerPrivilegesData = $managerData['privileges'];
$managerPrivileges = @unserialize($managerPrivilegesData);

// Validate that unserialization worked and returned an array
if (!is_array($managerPrivileges)) {
    $managerPrivileges = []; // Default to empty array
}

?>


<!DOCTYPE html>

<html>

<head>

  <meta charset="utf-8">

  <meta http-equiv="X-UA-Compatible" content="IE=edge">

  <title>Managers Privileges</title>

  <!-- Tell the browser to be responsive to screen width -->

  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

  <!-- Bootstrap 3.3.6 -->

  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">

  <!-- Font Awesome -->

  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">

  <!-- Ionicons -->

  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">

  <!-- Theme style -->

  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">

  <!-- AdminLTE Skins. Choose a skin from the css/skins

       folder instead of downloading all of them to reduce the load. -->

  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">

  <!-- iCheck -->

  <link rel="stylesheet" href="plugins/iCheck/flat/blue.css">

  <!-- Morris chart -->

  <link rel="stylesheet" href="plugins/morris/morris.css">

  <!-- jvectormap -->

  <link rel="stylesheet" href="plugins/jvectormap/jquery-jvectormap-1.2.2.css">

  <!-- Date Picker -->

  <link rel="stylesheet" href="plugins/datepicker/datepicker3.css">

  <!-- Daterange picker -->

  <link rel="stylesheet" href="plugins/daterangepicker/daterangepicker.css">

  <!-- bootstrap wysihtml5 - text editor -->

  <link rel="stylesheet" href="plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css">

 <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">

 <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->

  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->

  <!--[if lt IE 9]>

  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>

  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>

  <![endif]-->

</head>

<body class="hold-transition skin-blue sidebar-mini">

<div class="wrapper">

  <header class="main-header">

    <!-- Logo -->

 <?php  include('inc/main-header.php');  ?>

    </header>

  <!-- Left side column. contains the logo and sidebar -->

  <aside class="main-sidebar">

    <!-- sidebar: style can be found in sidebar.less -->

 <?php  include('inc/main-sidebar.php');  ?>

  </aside>

  <!-- Content Wrapper. Contains page content -->

  <div class="content-wrapper">

    <!-- Content Header (Page header) -->

    <section class="content-header">

      <h1>

        Manager Privilege

        <small>branch System</small>

      </h1>

      <ol class="breadcrumb">

        <?php if($count_1 > 0){ }else{ ?>

        <li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>

        <?php  } ?>

        <li class="active">Manager Privilege</li>

      </ol><br>


    </section>

<!-- /.content -->

     <section class="content">

      <div class="row">

        <div class="col-xs-12">


          <div class="box box-primary">

            <div class="box-header">
                <div id="response"></div>
                <h3><?=$managerName?></h3>
            </div>

            <!-- /.box-header -->

             <form role="form" id="privilegeForm" method="post" action=""> 

              <input type="hidden" name="updatePrivileges" value="<?=$managerId?>">

              <div class="box-body">

              <div class="col-md-4">

                <div class="form-group">

                  <input type="checkbox" name="editCustomer" value="1" <?php if (!empty($managerPrivileges['editCustomer'])) echo 'checked'; ?>
>

                  <label for="">Edit Customer Profiles</label>

                </div>

              </div>

              <div class="col-md-4">

                <div class="form-group">

                  <input type="checkbox" name="editAccounts" value="1" <?php if (!empty($managerPrivileges['editAccounts'])) echo 'checked'; ?>
>

                  <label for="">Edit Accounts</label>

                </div>

              </div>

              <div class="col-md-4">

                <div class="form-group">

                  <input type="checkbox" name="deleteAccounts" value="1" <?php if (!empty($managerPrivileges['deleteAccounts'])) echo 'checked'; ?>
>

                  <label for="">Delete Accounts</label>

                </div>

              </div>

              <div class="col-md-4">

                <div class="form-group">

                  <input type="checkbox" name="shiftLedger" value="1" <?php if (!empty($managerPrivileges['shiftLedger'])) echo 'checked'; ?>
>

                  <label for="">Shift Ledger</label>

                </div>

              </div>

              <div class="col-md-4">

                <div class="form-group">

                  <input type="checkbox" name="previousDate" value="1" <?php if (!empty($managerPrivileges['previousDate'])) echo 'checked'; ?>
>

                  <label for="">Previous Date Entry</label>

                </div>

              </div>

              <div class="col-md-4">

                <div class="form-group">

                  <input type="checkbox" name="editEntry" value="1" <?php if (!empty($managerPrivileges['editEntry'])) echo 'checked'; ?>
>

                  <label for="">Edit Entry</label>

                </div>

              </div>

              <div class="col-md-4">

                <div class="form-group">

                  <input type="checkbox" name="deleteBooking" value="1" <?php if (!empty($managerPrivileges['deleteBooking'])) echo 'checked'; ?>
>

                  <label for="">Delete Booking</label>

                </div>

              </div>

              <div class="col-md-4">

                <div class="form-group">

                  <input type="checkbox" name="editMap" value="1" <?php if (!empty($managerPrivileges['editMap'])) echo 'checked'; ?>
>

                  <label for="">Edit Map</label>

                </div>

              </div>

                </div>

              <!-- /.box-body -->

              <div class="box-footer">

                <input type="submit" class="btn btn-success" value="Update">

              </div>

            </form>

            <!-- /.box-body -->

          </div>

          <!-- /.box -->

        </div>

        <!-- /.col -->

      </div>

      <!-- /.row -->

    </section>

<!-- /.content -->









  </div>

  <!-- /.content-wrapper -->

  <?php include('inc/footer.php'); ?>



  <!-- Control Sidebar -->

 <?php include('inc/aside.php'); ?>

</div>

<!-- ./wrapper -->



<!-- jQuery 2.2.3 -->

<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>

<!-- Bootstrap 3.3.6 -->

<script src="bootstrap/js/bootstrap.min.js"></script>

<!-- DataTables -->

<script src="plugins/datatables/jquery.dataTables.min.js"></script>

<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>

<!-- SlimScroll -->

<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>

<!-- FastClick -->

<script src="plugins/fastclick/fastclick.js"></script>

<!-- AdminLTE App -->

<script src="dist/js/app.min.js"></script>

<!-- AdminLTE for demo purposes -->

<script src="dist/js/demo.js"></script>

<!-- page script -->

<script>



  $(function () {

    $("#example1").DataTable();

    $('#example2').DataTable({

      "paging": true,

      "lengthChange": false,

      "searching": false,

      "ordering": true,

      "info": true,

      "autoWidth": false

    });

  });

  


$('#privilegeForm').on('submit', function(){
  event.preventDefault();
  if($(this).valid()){
      var data = $(this).serialize();
      $.ajax({
            type : 'POST',
            url  : 'functions.php',
            data : data,
            success :  function(response)
            { 
              $('#response').html('<div class="alert alert-info"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>Privileges Updated</div>');
            }
        //ajax end
        });
    }
});
</script>



  <script src="//ajax.aspnetcdn.com/ajax/jquery.validate/1.9/jquery.validate.min.js"></script>

  

  <!-- jQuery Form Validation code -->

</body>

</html>

