<?php 
ob_start();
session_start();
include("db.php");

if (!isset($_SESSION['user_email'])) {
    header("Location: login.php?login=failed");
    exit;
}

$user_email = mysqli_real_escape_string($conn, $_SESSION['user_email']);

// Get manager info
$select_query_q = "SELECT * FROM `managers` WHERE `email`='$user_email'";
$result_q = mysqli_query($conn, $select_query_q);
$branch_id_m = $M_name = '';

while ($rowq = mysqli_fetch_assoc($result_q)) {
    $branch_id_m = $rowq['branch_id'];
    $M_name = $rowq['name'];
}
$count_1 = mysqli_num_rows($result_q);

$date = date('d M Y');

// Get booking ID from URL
$book_plot_id = isset($_GET['book_plot_id']) ? mysqli_real_escape_string($conn, $_GET['book_plot_id']) : '';

// Fetch booking info
$select_query_q = "SELECT * FROM `book_plot` WHERE `id` = '$book_plot_id'";
$result_query_q = mysqli_query($conn, $select_query_q) or die(mysqli_error($conn));

while ($row_q = mysqli_fetch_assoc($result_query_q)) {
    $p_no = $row_q['plot_no'];
    $branch_id = $row_q['branch_id'];
    $block = $row_q['block_id'];
    $customer_id = $row_q['customer_id'];
    $p_area = $row_q['total_area'];
    $rate_per_marla = $row_q['rate_per_marla'];
    $total_price = $row_q['total_price'];
    $advance_amount = $row_q['advance_amount'];
    $num_installments = $row_q['num_installments'];
    $payment_method = $row_q['payment_method'];
    $gap_of_installments = $row_q['gap_of_installments'];
    $remaining_amount = $row_q['remaining_amount'];
    $amount_per_installment = $row_q['per_installment'];
    $registery_time = $row_q['registery_time'];
    $booking_date = $row_q['date'];
    $witness_1_name = $row_q['witness_1_name'];
    $witness_1_cnic = $row_q['witness_1_cnic'];
    $witness_2_name = $row_q['witness_2_name'];
    $witness_2_cnic = $row_q['witness_2_cnic'];
    $last_payment_amount = $row_q['last_payment_amount'];
    $description = $row_q['description'];
}

// Authorization check
if ($count_1 > 0) {
    if ($branch_id != $branch_id_m) {
        header("Location: javascript://history.go(-1)");
        exit;
    }
}

// Fetch plot info
$select_query_3 = "SELECT * FROM `plots` WHERE `branch_id` = '$branch_id' AND `block_id` = '$block' AND `plot_no` = '$p_no'";
$result_query_3 = mysqli_query($conn, $select_query_3) or die(mysqli_error($conn));

while ($row_3 = mysqli_fetch_assoc($result_query_3)) {
    $plot_area = $row_3['area'];
}

// Fetch branch info
$select_query5 = "SELECT * FROM `branches` WHERE `id` = '$branch_id'";
$result_query5 = mysqli_query($conn, $select_query5) or die(mysqli_error($conn));

while ($row5 = mysqli_fetch_assoc($result_query5)) {
    $branch_name = $row5['name'];
    $branch_location = $row5['location'];
    $branch_phone = $row5['branch_phone'];
    $branch_image = $row5['image'];
}

// Fetch block name
$block_query = mysqli_query($conn, "SELECT * FROM `branch_categories` WHERE `id` = '$block'");
while ($block_data = mysqli_fetch_assoc($block_query)) {
    $block_name = $block_data['name'];
}

// Fetch manager info
$select_query4 = "SELECT * FROM `managers` WHERE `branch_id` = '$branch_id'";
$result_query4 = mysqli_query($conn, $select_query4) or die(mysqli_error($conn));

while ($row4 = mysqli_fetch_assoc($result_query4)) {
    $manager_name = $row4['name'];
    $manager_email = $row4['email'];
    $manager_phone = $row4['phone'];
}

// Fetch customer info
$select_query2 = "SELECT * FROM `customers` WHERE `id` = '$customer_id'";
$result_query2 = mysqli_query($conn, $select_query2) or die(mysqli_error($conn));

while ($row2 = mysqli_fetch_assoc($result_query2)) {
    $customer_id = $row2['id'];
    $customer_name = $row2['name'];
    $customer_father_name = $row2['fname'];
    $customer_email = $row2['email'];
    $customer_cnic = $row2['cnic_number'];
    $customer_phone = $row2['phone'];
    $other_contact = $row2['other_contact'];
    $customer_address = $row2['address'];
    $customer_image = $row2['image'];
}

// Create branch acronym
$project_initials = explode(" ", $branch_name);
$acronym = "";
foreach ($project_initials as $w) {
    $acronym .= $w[0];
}
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Print Invioce</title>
   <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
<style>
.main {
	padding-top:50px;
}
.page-header{
    margin:0pt  20pt;
	margin-bottom:0;
	border-bottom:0;
}
.partition{
	width:50%;
	float:left;
}
.data-dives p
{
	margin-bottom: 10px;
	font-size: 10pt;
}
.actual-values
{
	border:1px solid black;
	margin-left: 25px;
	width: 180px;
	overflow: hidden;
	font-size: 10pt;
	text-align:center;
}
.actual-values_2 
{
	border:1px solid black;
	width: 180px;width: 104px;
	overflow: hidden;
	font-size: 10pt;
	text-align:center;
	display:inline-block;
}
.little-labels
{
	width:33%;
	text-align:center;
	display:inline-block;
}
.page-footer
{
	position:absolute;
	bottom:0;
	width: 100%;
}
.witness-labels
{
	text-align:center;
	display:inline-block;
	width:50%;
	margin:0;
}
.witness-data {
	border:1px solid black;
	width: 48%;
	overflow: hidden;
	font-size: 10pt;
	text-align:center;
	display:inline-block;
}
.installment-plan
{
	margin-top:50px;
}
.affidavite
{
	margin-top:0pt;
}
.affidavite span {
	width:5%;
}

.affidavite p {
	width:95%;
	text-align:justify;
}
@media print {
.installment-plan {
	page-break-before: always;
}
/*
.affidavite {
	page-break-before: always;
}
*/
.headings{
}
.table-padding-less th,td,tr
{
	padding: 0 !important;
}
.table-padding-less th,td
{
	text-align: center;
}
.headings th {
	text-align: center;
	background-color: #ccc !important;
}
}
.conditions-area
{
	padding:0pt 15pt;
	
	text-align:justify;
	margin-top:0;
	margin-bottom:0;
}
.affidavite div
{
	display: table;
	width:100%;
	margin-bottom:10px;
	font-size:16px;
}

</style>

</head>

<body onload="window.print();">
<div class="wrapper">
  <!-- Main content -->
  <section class="invoice">
    <!-- title row -->
    <div class="row">
      <div class="col-xs-12">
        <div class="page-header">

		<div style="width:65%;max-height: 120px;float:left;text-align:justify">
			<div style="text-align:center;float:right">
			<h2 style="font-weight:bold;font-size:22px;"><?=$branch_name?></h2>
			<h5><?=$branch_location?></h5>
			<h5><?=$branch_phone?></h5>
			</div>
		</div>
		<div style="width:35%;float: right; text-align:right;"><img src="<?=$branch_image?>" alt="" style="width:120px;height:80px;border-radius:5%;" /></div>
		</div>
        <h4 style="clear:both; text-transform:uppercase; font-weight:700">Allotment letter</h4>
      </div>
      <!-- /.col -->
    </div>
    <!-- info row -->
	<div class="row">
      <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 invoice-col data-dives">
      	<p>Date <span class="actual-values pull-right"><?php echo date('d M Y', strtotime($booking_date)); ?></span></p>
        <p>Customer name <span class="actual-values pull-right" style="width:auto;min-width:180px"><?=$customer_name?></span></p>
        <p>Father / Husband name <span class="actual-values pull-right"><?=$customer_father_name?></span></p>
        <p>Mobile # <span class="actual-values pull-right"><?=$customer_phone?></span></p>
		<p>CNIC <span class="actual-values pull-right"><?php if($customer_cnic) { echo $customer_cnic; }else{ echo 'Not Mentioned';}?></span></p>
		<p>Other Contact <span class="actual-values pull-right"><?php if($other_contact){ echo $other_contact; }else{ echo 'Not Mentioned'; } ?></span></p>
		<p>Email <span class="actual-values pull-right"><?php if($customer_email) { echo $customer_email; }else{ echo 'Not Mentioned';}?></span></p>
        </div>
      <!-- /.col -->
          <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 invoice-col data-dives">
            <p>Agreement # <span class="actual-values pull-right"><?=$acronym?><?=$branch_id?><?=$block?><?=$customer_id?><?=$p_no?></span></p>
            <img src="<?=$customer_image?>" class="actual-values pull-right" style="width:180px;height:167px;" alt="custmer Pic" />
          </div>
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 invoice-col data-dives">
       <p>Address <span class="actual-values pull-right" style="width:75.7%"><?=$customer_address?></span></p>
      </div>
      <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 invoice-col data-dives">
            <p>Shop # <span class="actual-values pull-right"><?=$p_no?> (<?=$block_name?>)</span></p>
            <p>Rate/SqrFt <span class="actual-values pull-right"><?php echo number_format($rate_per_marla);?></span></p>
            <p>Advance <span class="actual-values pull-right"><?php echo number_format($advance_amount);?></span></p>
            <p>Mode Of Payment <span class="actual-values pull-right"><?php if($payment_method) { echo $payment_method; }else { echo 'Undefiend'; }?></span></p>
            <p>No. Of Installments <span class="actual-values pull-right"><?=$num_installments?></span></p>
			<p>Installments Paid By <span class="actual-values pull-right"><?php if($gap_of_installments == '30'){ echo 'Monthly';}elseif($gap_of_installments == '60'){ echo 'After Two Months';}else{ echo 'After '.$gap_of_installments.' Days';}?></span></p>
      
	  </div>
	  <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 invoice-col data-dives">
            <p>Total Area(Sqr.Ft.) <span class="actual-values pull-right"><?php echo $plot_area;?></span></p>
            <p>Total Price <span class="actual-values pull-right"><?php echo number_format($total_price);?></span></p>
			<p>Remaining Amount <span class="actual-values pull-right"><?php echo number_format($remaining_amount);?></span></p>
            <p>Installment <span class="actual-values pull-right"><?php echo number_format((float)$amount_per_installment);?></span></p>
			<p>Registry Time <span class="actual-values pull-right"><?php echo $doi = date('d M Y', strtotime($registery_time));?></span></p>
			
  	 </div>
  	 <?php if (!empty($description)) { ?>
  	 <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 invoice-col data-dives">
       <p>Description <span class="actual-values pull-right" style="width:75.7%"><?=$description?></span></p>
      </div>
      <?php } ?>
      <!-- /.col -->
    </div>
    <!-- /.row -->
	<!--<div class="row conditions-area">-->
	<!--	<p style="margin-bottom:5px;" class="text-center"><b style="border-bottom:1px solid black">شرائط و ضوابط</b></p>-->
	<!--	<p style="direction:rtl;font-size: 16px;">-->
	<!--	مزید تفصیل جس کےتحت ادارہ ﴿<?=$branch_name?>﴾ نے پلاٹ /دکان مندرجہ بالا کی نسبت تمام کوائف/معلومات،موقع کی صورتحال اور تمام مجوزہ سہولتوں -->
	<!--	کی نسبت خریدار کو آگاہ کر دیا ہےخریدار مذکورہ مندرجہ شرائط ادائیگی کا پابند ہو گابمطابق شرائط معاہدہ بیان حلفی بوجہ عدم ادائیگی کسی بھی قسط پ-->
	<!--	ر پلاٹ /دکان کا سوداخود بخود بلا اطلاع منسوخ ہوگا -اور زربیعانہ/پیشگی ادائیگی ہمہ قسم ضبط تصور ہوگی- لٰہذا اقرارنامہ ہذا بقائمی ہوش ہواس بلاخمسہ-->
	<!--	جبرووکراہ کو درست تسلیم کرتے ہوئے اس پر روبروگواہان حاشیہ پڑھ سن اور سمجھ کر دستخط کر دئیے ہیں تاکہ سند ہوئے اور بوقت ضرورت کام آوئے من مقرہ-->
	<!--	اس بابت کسی قسم کی کوئی قانونی و عدالتی کاروائی کرنے کا مجاز نہ ھوگا -تکمیل معاہدہ/مکمل ادائیگی سے قبل خریدارمذکورہ پلاٹ / دکان پر بلااجازت اد-->
	<!--	ارہ ﴿<?=$branch_name?>﴾ تعمیرات کرنے یا فروخت کرنے کامجاذ نہ ہوگا- رجسڑی /منتقلی کے اخراجات بمہ حصول فرد بذمہ خریدار ہوگی- ﴿<?=$branch_name?>﴾ -->
	<!--	ادارہ موقعہ پر نقشہ تبدیلی کرسکتا ہے اور پلاٹ کی پیمائش بوقت رجسڑی جو ہوگی وہی فائنل ہوگی- موقع تعمیر بمطابق نقشہ ہوگی کوئی خریدار اپنے پلاٹ -->
	<!--	میں دکان یا کمرشل کاروبار کرنے کا مجاذ نہیں ہوگا- چاردیواری ادارہ ﴿<?=$branch_name?>﴾ کی ملکیت ہوگی اور ادارہ ﴿<?=$branch_name?>﴾ چاردیوار-->
	<!--	ی کو گرا سکتا یےاور ٹاوٴن ایکسٹینڈ کر سکتا ہے- خریدار کو کوئی اعتراض یا اعتراض نہ ہوگا- نقشہ میں تبدیلی کو خریدار کسی بھی عدالت وپنجائت میں -->
	<!--	چیلینج نہیں کر سکتا--->
	<!--	</p>-->
	<!--</div>-->
	<div class="row conditions-area">
		<p style="margin-bottom:5px;" class="text-center"><b style="border-bottom:1px solid black">Terms & condition</b></p>
		<p style="font-size: 8pt;"> According the agreement, <?=$branch_name?> (management) has informed the purchaser about all the information/documentation, situation of land and all the available facilities regarding the shop/Apartment. 
        According to agreement it may be remembered and be helpful at the time of necessity purchaser will not be entitled to take any legal action regarding to this. 
        Before the completion of agreement/full payment purchaser without the permission of <?=$branch_name?> (management) will be bound not to construct or sell the shop/apartment. 
        All the expenses regarding registry/transfer would be payable by the purchaser. <?=$branch_name?> (management) could change the map and the measurement of the shop/apartment will be taken at the time of transfer/registry and that will be final. 
        Final price may vary if shop/apartment covered area is change. The purchaser will have no objection and will not challenge the change of map in any punchait or court of law. Construction will be made according to map. Purchaser will not be entitled to make any commercial activity in an apartment. Transfer fee will be charged PKR=10,000/ file. Purchaser will be bound about all the conditions mentioned in it. So that the agreement to sell shop/apartment has been signed by accepting it right in full presence of mind and without any pressure in the presence of witnesses has been read, heard and signed.
    </p>
	</div>
	<div class="affidavite">
	<p style="margin-bottom:5px;" class="text-center"><b style="border-bottom:1px solid black">Customer’s Acknowledgement</b></p>
      <p style="font-size: 8pt;">
       I <b><?=$customer_name?></b> S/O <b><?=$customer_father_name?></b> CNIC <b><?=$customer_cnic?></b> has read and understood of all the documents, terms & conditions in the agreement. 
       I shell not make any violation of contents of agreement. My legal heirs/successors shell also be bound with regard to the terms & conditions of this agreement.
   </p>
    </div>
  </section>
  <!-- /.content -->
</div>
<!-- ./wrapper -->
<footer class="page-footer">

<div class="clearfix"></div>

  <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 invoice-col data-dives">
	<p style="margin-bottom:0;"><span class="witness-labels">Customer</span></p>
	<p style="margin-bottom:10pt;"><span class="witness-data"><?=$customer_name?></span></p>
	<p style="margin-bottom:0pt;"><span class="witness-labels">Authorized Person</span></p>
	<p><span class="witness-data"><?=$manager_name?></span></p>
  </div>
  <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 invoice-col data-dives">
	<p style="margin-bottom:0;" ><span class="witness-labels">Witness 2</span><span class="witness-labels"> CNIC </span><br></p>
	<p style="margin-bottom:10pt;" ><span class="witness-data" style="margin-left:8px"><?=$witness_2_name?></span><span class="witness-data pull-right"><?=$witness_2_cnic?></span></p>
	<p style="margin-bottom:0pt;"><span class="witness-labels">Witness 1</span><span class="witness-labels"> CNIC </span><br></p>
	<p><span class="witness-data" style="margin-left:8px"><?=$witness_1_name?></span><span class="witness-data pull-right"><?=$witness_1_cnic?></span></p>
 </div>
</footer>
<!--<div style="direction:rtl;" class="affidavite">-->
<!--	<h2 class="text-center">بیان حلفی</h2>-->
<!--	<div><p class="pull-left">-->

<!--میں مسمی / مسماۃ ۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔ ولد / شوہر ۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔۔ شناختی کارڈ نمبر <?php echo '<span style="direction:ltr;unicode-bidi: bidi-override;">'.$customer_cnic.'</span>' ?> نے اپنے پلاٹ /دکان <?=$p_no?> (<?=$block_name?>) کا موقع دیکھ لیا ہے میں اقرار کرتا ہوں /کرتی ہوں کہ-->

<!--</p></div>-->
<!--	<div><p class="pull-left"> یہ کہ میں مقررہ تاریخ پر قیہ کہ میں مقررہ تاریخ پر قسط کی ادائیگی کی پابندی کروں گا اور اگر نہ ہو سکی تو میرے پلاٹ / دکان کا سودامنسوخ اور ادا شدہ رقم ضبط ہو گی۔               </p><span><i class="fa fa-star-o" aria-hidden="true"></i></span></div>-->
<!--	<div><p class="pull-left">یہ کہ میں مقررہ تاریخ تک تمام رقم نہ ادا کر کے رجسڑی نہ کرواسکا تو ادارہ ﴿<?=$branch_name?>﴾ کو میری اداشدہ رقم ضبط اورسودے کی منسوخی کا اختیار ہوگا اور رسید بعدازتاریخ رجسڑی میعاد کسی بھی عدالت میں چیلنج نہ ہوسکے گی-اور نہ ہی کسی قسم کی کوئی قانونی وپنچائتی کاروائی کا مجاز ہوں گا-</p><span><i class="fa fa-star-o" aria-hidden="true"></i></span></div>-->
<!--	<div><p class="pull-left">یہ کہ رجسڑی یا ایگریمنٹ مدت ختم  ہونے کے 6 ماہ بعد سے 5 تا 10 مرلہ 1500 روپے اور 10 مرلہ سے زائد 2000روپے فی پلاٹ ماہانہ ادا کرنےہوںگے-</p><i class="fa fa-star-o" aria-hidden="true"></i></span></div>-->
<!--	<div><p class="pull-left">یہ کہ فائل ٹرانسفر فیس 1000 روپے فی مرلہ ادا کرنا ہوگی-</p><span><i class="fa fa-star-o" aria-hidden="true"></i></span></div>-->
<!--	<div><p class="pull-left">یہ کہ پلاٹ / گیراج کی بنیاد سڑک سے 2 فٹ سے زیادہ اونچی نہ رکھوں گا-</p><span><i class="fa fa-star-o" aria-hidden="true"></i></span></div>-->
<!--	<div><p class="pull-left">یہ کہ پلاٹ / دکان کی چنائی صرف سیمنٹ سے ہی ہو گی۔ </p><span><i class="fa fa-star-o" aria-hidden="true"></i></span></div>-->
<!--	<div><p class="pull-left">یہ کہ ٹاون کی چاردیواری ادارہ ﴿<?=$branch_name?>﴾ کی ملکیت ہوگی اور اس کو کوئی بھی خریدار توڑ نہ سکے گا اور نہ ہی راستہ بنا سکے گا-</p><span><i class="fa fa-star-o" aria-hidden="true"></i></span></div>-->
<!--	<div><p class="pull-left"> یہ کہ پلاٹ کی پیمائش چاردیواری کو چھوڑ کر دی جائے گی-</p><span><i class="fa fa-star-o" aria-hidden="true"></i></span></div>-->
<!--	<div><p class="pull-left">یہ کہ ٹاون کی چاردیواری کا رقبہ ادارہ ﴿<?=$branch_name?>﴾ کی ملکیت ھوگا – ہر خریدار نقشہ کے مطابق اپنی تعمیر کروں گا- رہائشی پلاٹ میں کمرشل دکان نہ بناوں گا –اور نہ ہی کمرشل کاروبار کروں گا-</p><span><i class="fa fa-star-o" aria-hidden="true"></i></span></div>-->
<!--	<div><p class="pull-left">یہ کہ ادارہ ﴿<?=$branch_name?>﴾ نقشے میں تبدیلی کا حق رکھتا ہے اور مجھے اس پرکوئی اعتراض یا اعتراض نہ ہوگا-</p><span><i class="fa fa-star-o" aria-hidden="true"></i></span></div>-->
<!--	<div><p class="pull-left">یہ کہ ادارہ ﴿<?=$branch_name?>﴾ اپنے پراجیکٹ میں توسیع کی صورت میں چاردیواری گرا سکتا ہے-مجھے کوئی اعتراض نہ ہوگا اور نہ ہی کسی قانونی کاروائی کا حق دار ہوں گا-</p><span><i class="fa fa-star-o" aria-hidden="true"></i></span></div>-->
<!--	<div><p class="pull-left">یہ کہ بازگشت تحریر ہذاہ کے پابند ہوں گے -</p><span><i class="fa fa-star-o" aria-hidden="true"></i></span></div>-->
<!--</div>-->


<!--
 <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 invoice-col data-dives">
<p style="margin-bottom:40px;width:75%;text-align:right" class="pull-right"><b>Customer Name </b><span class="actual-values" style="display:inline-block"><?php $customer_name?></span><span class="actual-values" style="display:inline-block"></span></p>
</div>
<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 invoice-col data-dives">
<p style="margin-bottom:40px;width:75%;text-align:right" class="pull-right"><b>Witness 1 Signature </b><span class="actual-values" style="display:inline-block"><?php $witness_1_name?></span><span class="actual-values" style="display:inline-block"></span></p>
</div>
<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 invoice-col data-dives">
<p style="margin-bottom:40px;width:75%;text-align:right" class="pull-right"><b>Witness 2 Signature </b><span class="actual-values" style="display:inline-block"><?php $witness_2_name?></span><span class="actual-values" style="display:inline-block"></span></p>
</div>
-->
<?php if($payment_method == 'installment'){ ?>
<div class="installment-plan">
<h2 class="text-center">Installment Plan</h2>
<h4 class="text-center text-bold">Shop No. <?=$p_no?> (<?=$block_name?>)</h4>
	<table id="example1" class="table table-padding-less table-bordered">
	 <thead>
		<tr class="headings" style="background-color: #ccc">
		  <th>Installments No</th>
		  <th>Date Of Installment</th>
		  <th>Installment Amount</th>
		</tr>
		</thead>
		<tbody>
<?php	$select_query6="SELECT * FROM `installments` WHERE `branch_id` = '$branch_id' AND `block_id` = '$block' AND `plot_no` = '$p_no'";
		$result_query6=mysqli_query($conn, $select_query6) or die($select_query6."<br/><br/>".mysqli_error($conn));;
				$numbering = 0;
				while($row6=mysqli_fetch_assoc($result_query6)){
				$numbering++;
				$date_of_installment =$row6['date_of_installment'];
				$payment_per_installment = $row6['payment_per_installment'];
?>
		<tr>
                  <td><?= $numbering; ?></td>
                  <td><?php echo $doi = date('d M Y', strtotime($date_of_installment)); ?></td>
                  <td style="text-align: right"><?php echo number_format( $payment_per_installment); ?></td>
		</tr>	
<?php } ?>
		</tbody>
		 <tfoot>
                </tfoot>
              </table>
			  <p style="width:50%;float:left">Last Payment Date <span class="actual-values" style="display:inline-block"><?php echo $doi = date('d M Y', strtotime($date_of_installment));?></span></p>
			  <p style="width:50%;float:left">Last Payment Amount <span class="actual-values" style="display:inline-block"><?php echo number_format($last_payment_amount);?></span></p>
   <!-- /.row -->
   <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 invoice-col data-dives">
<p style="margin-bottom:40px;width:45%;" class="pull-right">Customer Name <span class="actual-values pull-right"><?=$customer_name?></span></p>
</div>
<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 invoice-col data-dives">
<p style="margin-bottom:80px;width:45%;" class="pull-right">Customer Signature <span class="actual-values pull-right"></span></p>
</div>
</div>
<?php } ?>
</body>

</html>
