<?php 
ob_start();
session_start();
include("db.php"); // Assumes $conn is the mysqli connection object

$user_email = $_SESSION['user_email'] ?? '';

if (!$user_email) {
    header("Location: login.php?login=failed");
    exit();
}

// Manager details
$select_query_q = "SELECT * FROM `managers` WHERE `email` = '$user_email'";
$result_q = mysqli_query($conn, $select_query_q) or die(mysqli_error($conn));

while ($rowq = mysqli_fetch_assoc($result_q)) {
    $branch_id = $rowq['branch_id'];
    $M_name = $rowq['name'];
}

$count_1 = mysqli_num_rows($result_q);

$date = date('d M Y');

$branch_id_s = $_GET['branch_id'] ?? '';
$ledger_id = $_GET['ledger_id'] ?? '';
$startdate = $_GET['startdate'] ?? '';
$endate = $_GET['endate'] ?? '';

// Branch Info
$select_query5 = "SELECT * FROM `branches` WHERE `id` = '$branch_id_s'";
$result_query5 = mysqli_query($conn, $select_query5) or die($select_query5 . "<br/><br/>" . mysqli_error($conn));

while ($row5 = mysqli_fetch_assoc($result_query5)) {
    $branch_id = $row5['id'];
    $branch_name = $row5['name'];
    $branch_location = $row5['location'];
    $branch_phone = $row5['branch_phone'];
    $branch_image = $row5['image'];
}

// Ledger Info
$selected_ledger_query = mysqli_query($conn, "SELECT * FROM `ledgers` WHERE `id` = '$ledger_id'");
while ($selected_ledger_row = mysqli_fetch_assoc($selected_ledger_query)) {
    $selected_ledger_id = $selected_ledger_row['id'];
    $selected_ledger_name = $selected_ledger_row['name'];
    $selected_ledger_gcode = $selected_ledger_row['gcode'];
    $selected_ledger_balance = $selected_ledger_row['balance'];
    $selected_ledger_control_id = $selected_ledger_row['control_account_id'];
    $selected_ledger_general_id = $selected_ledger_row['general_ledger_id'];
}

// Control Account Name
$selected_control_query = mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `id` = '$selected_ledger_control_id'");
while ($selected_control_row = mysqli_fetch_assoc($selected_control_query)) {
    $selected_ledger_control_name = $selected_control_row['name'];
}

// General Ledger Name
$selected_general_query = mysqli_query($conn, "SELECT * FROM `general_ledgers` WHERE `id` = '$selected_ledger_general_id'");
while ($selected_general_row = mysqli_fetch_assoc($selected_general_query)) {
    $selected_ledger_general_name = $selected_general_row['name'];
}

// Manager Info for the Branch
$select_query4 = "SELECT * FROM `managers` WHERE `branch_id` = '$branch_id'";
$result_query4 = mysqli_query($conn, $select_query4) or die($select_query4 . "<br/><br/>" . mysqli_error($conn));
while ($row4 = mysqli_fetch_assoc($result_query4)) {
    $manager_name = $row4['name'];
    $manager_email = $row4['email'];
    $manager_phone = $row4['phone'];
}

// Entry type - Note: $voucher_no must be defined somewhere
$voucher_no = $_GET['voucher_no'] ?? '';
$voucher_query = mysqli_query($conn, "SELECT * FROM `all_payments` WHERE `branch_id` = '$branch_id' AND `voucher_no` = '$voucher_no'");
while ($row_voucher = mysqli_fetch_assoc($voucher_query)) {
    $entry_type = $row_voucher['voucher_type'];
}

// Acronym from branch name
$project_initials = explode(" ", $branch_name);
$acronym = "";
foreach ($project_initials as $w) {
    $acronym .= $w[0];
}
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Print Ledger Statement</title>
   <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
<style>

.main {
	padding-top:50px;
}
.page-header{
	margin-bottom:0;
	border-bottom:0;
}
table {
	margin-top: 20px;
	width: 100%;
	font-size:12px;
	border:1px solid black;
}
table th,td,tr {
	border:1px solid black;	
	padding: 2px 10px !important;
}
@media print {
.headings{
	background-color: #ccc !important;
	-webkit-print-color-adjust: exact;
}
}
</style>
</head>

<body onload="window.print();">
<div class="wrapper">
  <!-- Main content -->
  <section class="invoice">
    <!-- title row -->
    
<div class="row">
      <div class="col-xs-12">
        <div class="page-header">
		<div style="width:35%;float: left;"><img src="<?=$branch_image?>" alt="" style="width:120px;height:80px;border-radius:5%;" /></div>
		<div style="width:65%;max-height: 120px;float:left;text-align:justify">
			<div style="text-align:center;float:left">
			<h2 style="font-weight:bold;margin-bottom:"><?=$branch_name?></h2>
			<h5><?=$branch_location?></h5>
			<h5><?=$branch_phone?></h5>
			</div>
		</div>
		</div>
      </div>
      <!-- /.col -->
    </div>
    
<div class="row">
	<div style="font-weight:bold;" class="col-md-6"><p>Ledger Statement</p>
    <h4 style="font-weight:bold;"><?=$selected_ledger_name?></h4>
    </div>
    <div style="text-align:right" class="col-md-6">
    <?php if($startdate && $endate){ ?><p style="width:100%; float:left; text-align:right">From: <?php echo date('d M Y', strtotime($startdate));?><br>To: <?php echo date('d M Y', strtotime($endate));?></p> <?php } ?>
    Print Date: <?=$date?></div>
 </div>

    <div class="row">
    	<div class="col-md-12">
		<?php

			if($startdate && $endate){
				$select_query_all_payments=mysqli_query($conn, "SELECT * FROM `all_payments` WHERE `ledger_id` = '$selected_ledger_id' AND `date` >= '$startdate' AND `date` <= '$endate' ORDER BY `date` ASC;");
			}else{
				$select_query_all_payments=mysqli_query($conn, "SELECT * FROM `all_payments` WHERE `ledger_id` = '$selected_ledger_id' ORDER BY `date` ASC;");
				
			}



									// Getting opening balance of ledger statement start
									$opneing_balance_query=mysqli_query($conn, "SELECT * FROM `ledgers` WHERE `id` = '$selected_ledger_id';");
									while($opneing_balance_row=mysqli_fetch_assoc($opneing_balance_query)){
												$opneing_balance_specific_balance=$opneing_balance_row['balance'];
											}

									// Getting opening balance of ledger statement End
									if($startdate && $endate){
									$previous_balance=mysqli_query($conn, "SELECT * FROM `all_payments` WHERE `branch_id` = '$branch_id' AND `ledger_id` = '$selected_ledger_id' ORDER BY `date` ASC");
										while($previous_data=mysqli_fetch_assoc($previous_balance)){
											$previous_debit=(float)$previous_data['debit'];
											$previous_credit=(float)$previous_data['credit'];
											$previous_looped_date=$previous_data['date']; 
										
										if($previous_looped_date < $startdate){
											$opneing_balance_specific_balance+=$previous_debit;
											$opneing_balance_specific_balance-=$previous_credit;
										}
										}
									}


			if(mysqli_num_rows($select_query_all_payments) > 0 || $selected_ledger_balance != 0){ ?>
			<table class="" style="text-align:center;margin-top:0">

							<thead>
								<tr class="headings">
								<th style="width: 13%" class="text-center">Date</th>
								<th style="width: 7%" class="text-center">Vchr#</th>
								<th style="width: 6%" class="text-center">Type</th>
								<th style="width: 30%" class="text-center">Description</th>
								<th style="width: 13%" class="text-center">Dr Amount</th>
								<th style="width: 13%" class="text-center">Cr Amount</th>
								<th style="width: 28%" class="text-center">Balance</th>
								</tr>
							</thead>
								<tbody>
								<tr>
									<th></th>
									<th></th>
									<th></th>
									<th></th>
									<th style="border-right: none;text-align: right;">Opening</th>
									<th style="border-left:none;text-align: left;">Balance</th>
									<th class="text-right"><?php if($opneing_balance_specific_balance > 0){ echo 'DR '.number_format(abs($opneing_balance_specific_balance)); }elseif($opneing_balance_specific_balance < 0) { echo 'CR '.number_format(abs($opneing_balance_specific_balance)); }else { echo $opneing_balance_specific_balance; };?></th>
								</tr>
								 <?php
								 	$required_balance = $opneing_balance_specific_balance;
										$total_debit = 0;
										$total_credit = 0;
										$total_entries = 0;
						   			while($row_q=mysqli_fetch_assoc($select_query_all_payments)){
						   			$enrty_id=$row_q['id'];
									$voucher_no=$row_q['voucher_no'];
									$voucher_type=$row_q['voucher_type'];
									$debit=$row_q['debit'];
									$credit=$row_q['credit'];
									$narration=$row_q['narration'];
									$entrydate=$row_q['date'];
									$total_entries += 1;

										//to get the balance for every specific entry
										if($startdate && $endate){
										$select_query_for_balance=mysqli_query($conn, "SELECT * FROM `all_payments` WHERE `ledger_id` = '$selected_ledger_id' AND `id` <= '$enrty_id' AND `date` <=	 '$endate' ");
										}else{
											$select_query_for_balance=mysqli_query($conn, "SELECT * FROM `all_payments` WHERE `ledger_id` = '$selected_ledger_id' AND `id` <= '$enrty_id'");
										}
											while($row_q=mysqli_fetch_assoc($select_query_for_balance)){
												$debit=(float)$row_q['debit'];
												$credit=(float)$row_q['credit'];
												$looped_entrydate=$row_q['date']; 
											}
										$required_balance = $required_balance+$debit;
										$required_balance = $required_balance-$credit;
										//To only show entries from the selected start date
								if($startdate && $endate){
									if($looped_entrydate >= $startdate)
									{

							?>
								<tr>
									<td><?php echo date("d-m-Y", strtotime($entrydate)); ?></td>
									<td><?=$voucher_no?></td>
									<td><?=$voucher_type?></td>
									<td style="text-align:left;"><?=$narration?></td>
									<td style="text-align:right;"><?php if($debit != '') { echo number_format($debit); $total_debit += $debit; }else{ echo '0'; }; ?></td>
									<td style="text-align:right;"><?php if($credit != '') { echo number_format($credit); $total_credit += $credit; }else{ echo '0'; }; ?></td>
									<td style="text-align:right;"><?php if($required_balance > 0){ echo 'DR '.number_format(abs($required_balance)); }elseif($required_balance < 0) { echo 'CR '.number_format(abs($required_balance)); }else { echo $required_balance; };?></td>
								</tr>
								<?php 
									}//if($loopeddate >= $startdate)
								}//if (start date && endate)
								else{
									?>
								<tr>
									<td><?php echo date("d-m-Y", strtotime($entrydate)); ?></td>
									<td><?=$voucher_no?></td>
									<td><?=$voucher_type?></td>
									<td style="text-align:left;"><?=$narration?></td>
									<td style="text-align:right;"><?php if($debit != '') { echo number_format($debit); $total_debit += $debit; }else{ echo '0'; }; ?></td>
									<td style="text-align:right;"><?php if($credit != '') { echo number_format($credit); $total_credit += $credit; }else{ echo '0'; }; ?></td>
									<td style="text-align:right;"><?php if($required_balance > 0){ echo 'DR '.number_format(abs($required_balance)); }elseif($required_balance < 0) { echo 'CR '.number_format(abs($required_balance)); }else { echo $required_balance; };?></td>
								</tr>
								<?php 
								}
							} ?>
								<tr>
									<th>Totals</th>
									<th></th>
									<th></th>
									<th></th>
									<th class="text-right"><?php if(isset($total_debit)) { echo number_format($total_debit); } ?></th>
									<th class="text-right"><?php if(isset($total_debit)){ echo number_format($total_credit); } ?></th>
									<th></th>
								</tr>
								</tbody></table>
			<?php	} ?>
	</div>
		</div>
	</div>
	
  </section>
  <!-- /.content -->
</div>
<!-- ./wrapper -->
</body>
<footer class="page-footer">
	
</footer>

</html>
