<?php 
ob_start();
session_start();
include("db.php");

if (!isset($_SESSION['user_email'])) {
    header("location:login.php?login=failed");
    exit;
}

$user_email = $_SESSION['user_email'];

// Fetch manager info
$select_query_q = "SELECT * FROM `managers` WHERE `email`='$user_email'";
$result_q = mysqli_query($conn, $select_query_q);

while ($rowq = mysqli_fetch_assoc($result_q)) {
    $branch_id = $rowq['branch_id'];
    $M_name = $rowq['name'];
}
$count_1 = mysqli_num_rows($result_q);

// Get current date
$date = date('d M Y');

// Get branch_id and voucher_no from URL
$branch_id_s = $_GET['branch_id'] ?? '';
$voucher_no = $_GET['voucher_no'] ?? '';

// Get branch info
$select_query5 = "SELECT * FROM `branches` WHERE `id` = '$branch_id_s'";
$result_query5 = mysqli_query($conn, $select_query5) or die($select_query5 . "<br/><br/>" . mysqli_error($conn));

while ($row5 = mysqli_fetch_assoc($result_query5)) {
    $branch_id = $row5['id'];
    $branch_name = $row5['name'];
    $branch_location = $row5['location'];
    $branch_phone = $row5['branch_phone'];
    $branch_image = $row5['image'];
}

// Get manager info of this branch
$select_query4 = "SELECT * FROM `managers` WHERE `branch_id` = '$branch_id'";
$result_query4 = mysqli_query($conn, $select_query4) or die($select_query4 . "<br/><br/>" . mysqli_error($conn));

while ($row4 = mysqli_fetch_assoc($result_query4)) {
    $manager_name = $row4['name'];
    $manager_email = $row4['email'];
    $manager_phone = $row4['phone'];
}

// Get voucher details
$voucher_query = "SELECT * FROM `all_payments` WHERE `branch_id` = '$branch_id' AND `voucher_no` = '$voucher_no'";
$voucher_result = mysqli_query($conn, $voucher_query);

while ($row_voucher = mysqli_fetch_assoc($voucher_result)) {
    $entry_type = $row_voucher['voucher_type'];
    $voucher_date = $row_voucher['date'];
}

// Generate acronym
$project_initials = explode(" ", $branch_name);
$acronym = "";

foreach ($project_initials as $w) {
    $acronym .= $w[0];
}
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Print Voucher</title>
   <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
<style>

.main {
	padding-top:50px;
}
.page-header{
	margin-bottom:0;
	border-bottom:0;
}
table {
	margin-top: 20px;
	width: 80%;
	border:1px dashed black;
}
table td,th {
	border-right:1px dashed black;
	border-left:1px dashed black;	
}
th,td {
	padding: 5px 20px;
}
@media print {
.headings{
	background-color: #ccc !important;
	-webkit-print-color-adjust: exact;
}
}
</style>
</head>

<body onload="window.print();">
<div class="wrapper">
  <!-- Main content -->
  <section class="invoice">
    <!-- title row -->
   <div class="row">
      <div class="col-xs-12">
        <div class="page-header">
		<div style="width:35%;float: left;text-align: center;"><img src="<?=$branch_image?>" alt="" style="width:120px;height:80px;border-radius:5%;" /></div>
		<div style="width:65%;max-height: 120px;float:left;text-align:justify">
			<div style="text-align:center;float:left">
			<h2 style="font-weight:bold;margin-bottom:"><?=$branch_name?></h2>
			<h5><?=$branch_location?></h5>
			<h5><?=$branch_phone?></h5>
			</div>
		</div>
		</div>
      </div>
      <!-- /.col -->
    </div>
		<div class="row">
			<div class="col-xs-12">
			<div style="padding:0 60px">
        	<div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
        		<div> 
	        		<h5>User:- <?=$manager_name?></h5>
	        		<h5>VCHR #: <?=$voucher_no?></h5>
	        		<h5>Date: <?php echo date("d M Y", strtotime($voucher_date)); ?></h5>
	        		<h5>Print Date: <?=$date?></h5>
	        	</div>
        	</div>
			<div class="col-lg-6 col-md-6 col-sm-6 col-xs-6" class="pull-right">
        		<h4 class="text-right"><?php if($entry_type == 'JV'){ echo 'Journal voucher'; }elseif($entry_type == 'CP'){ echo 'Cash Voucher'; }elseif($entry_type == 'BP'){ echo 'Bank Voucher'; } ?></h4>
        	</div>
      	</div>
  	</div>
      <!-- /.col -->
    </div>
    <!-- info row -->
	<div class="row">
	<center>
		<table>
			<thead>
				<tr class="headings" style="background-color: #ccc;border-bottom: 1px dashed black;">
					<th style="width: 17%;text-align:center;">Code</th>
					<th style="width: 53%;text-align:center;">Particulars</th>
					<th style="width: 15%;text-align:center;">Debit</th>
					<th style="width: 15%;text-align:center;">Credit</th>
				</tr>
			</thead>
			<tbody>
				<?php
					$total_debit = 0;
					$total_credit = 0; 
					$voucher_query = mysqli_query($conn, "SELECT * FROM `all_payments` WHERE `branch_id` = '$branch_id' AND `voucher_no` = '$voucher_no'");
						while($row_voucher=mysqli_fetch_assoc($voucher_query)){
						$voucher_id = $row_voucher['id'];
						$voucher_ledger_id = $row_voucher['ledger_id'];
						$debit = (float)$row_voucher['debit'];
						$credit =  (float)$row_voucher['credit'];
						$narration = $row_voucher['narration'];
						$entrydate = $row_voucher['date'];
						$entry_type = $row_voucher['voucher_type'];
						$total_debit += $debit; 
						$total_credit += $credit;

						$selected_ledger_query=mysqli_query($conn, "SELECT * FROM `ledgers` WHERE `id` = '$voucher_ledger_id'");
							while($selected_ledger_row=mysqli_fetch_assoc($selected_ledger_query)){
							 $selected_ledger_name=$selected_ledger_row['name'];
							 $selected_ledger_gcode=$selected_ledger_row['gcode'];
							 $selected_ledger_balance=$selected_ledger_row['balance'];
							 $selected_ledger_control_account=$selected_ledger_row['control_account_id'];
							 $selected_ledger_general_ledger=$selected_ledger_row['general_ledger_id'];
							}

						 $control_query = mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `branch_id` = '$branch_id' AND `id` = '$selected_ledger_control_account'");
											while($control_items=mysqli_fetch_assoc($control_query)){
											$control_account_id = $control_items['id'];
											$control_account_name = $control_items['name'];
											$control_gcode = $control_items['gcode'];?>		
				<!-- <tr>
					<td><b><?=$control_gcode?></b></td>
					<td style="font-weight: 900"><?=$control_account_name?></td>
					<td></td>
					<td></td>
				</tr> -->
				<?php 
				 $general_query = mysqli_query($conn, "SELECT * FROM `general_ledgers` WHERE `branch_id` = '$branch_id' AND `control_account_id` = '$selected_ledger_control_account' AND `id` = '$selected_ledger_general_ledger'");
											while($general_items=mysqli_fetch_array($general_query)){
											$general_ledger_id = $general_items['id'];
											$general_ledger_name = $general_items['name'];
											$general_ledger_gcode = $general_items['gcode'];
				?>
				<!-- <tr>
					<td><b><?=$general_ledger_gcode?></b></td>
					<td style="font-weight: 600"><?=$general_ledger_name?></td>
					<td></td>
					<td></td>
				</tr> -->
				<tr>
					<td><b><?=$selected_ledger_gcode?></b></td>
					<td style="font-weight: 600"><?=$selected_ledger_name?></td>
					<td style="text-align: right"><?php if($debit > 0){ echo number_format($debit); } ?></td>
					<td style="text-align: right"><?php if($credit > 0){ echo number_format($credit); }?></td>
				</tr>
				<tr>
					<td></td>
					<td><?php if($narration){ echo $narration; } ?></td>
					<td></td>
					<td></td>
				</tr>
				<?php }
					}
				} ?>
			</tbody>
			<tfoot>
				<tr style="border-top: 1px dashed black;">
					<th>Rupees</th>
					<th></th>
					<th style="text-align: right"><?=$total_debit?></th>
					<th style="text-align: right"><?=$total_credit?></th>
				</tr>
			</tfoot>
		</table>
		      </center>
			<div style="margin:0 auto;width:80%">
				<div style="padding-top: 20px" class="row">	
					<div class="col-lg-3 col-md-3 col-sm-3 col-xs-3 text-center"><h5><?=$manager_name?></h5><h5 style="text-decoration: overline;">Prepared By</h5></div>
					<div class="col-lg-3 col-md-3 col-sm-3 col-xs-3 text-center"><h5></h5><h5 style="text-decoration: overline;padding-top: 25px"> Manager Account</h5></div>
					<div class="col-lg-3 col-md-3 col-sm-3 col-xs-3 text-center"><h5></h5><h5 style="text-decoration: overline;padding-top: 25px"> G. Manager</h5></div>
					<div class="col-lg-3 col-md-3 col-sm-3 col-xs-3 text-center"><h5></h5><h5 style="text-decoration: overline;padding-top: 25px"> Received By</h5></div>
				</div>
    </div>
    <!-- /.row -->
	
	
	</div>
	
  </section>
  <!-- /.content -->
</div>
<!-- ./wrapper -->
</body>
<footer class="page-footer">
	
</footer>

</html>
