<?php 
ob_start();
session_start();
include("db.php");

// Get current date
$date = date('Y-m-d');

// Check if user is logged in
if (!isset($_SESSION['user_email'])) {
    header("location:login.php?login=failed");
    exit;
}

$user_email = $_SESSION['user_email'];

// Fetch manager details by email
$select_query_q = "SELECT * FROM `managers` WHERE `email`='$user_email'";
$result_q = mysqli_query($conn, $select_query_q);

$branch_id = '';
$M_name = '';
$count_1 = mysqli_num_rows($result_q);

while ($rowq = mysqli_fetch_assoc($result_q)) {
    $branch_id = $rowq['branch_id'];
    $M_name = $rowq['name'];
}

// Get branch_id from GET
$branch_id_s = $_GET['branch_id'] ?? '';

if ($count_1 > 0 && $branch_id_s != $branch_id) {
    header("location:javascript://history.go(-1)");
    exit;
}

// Fetch branch details
$select_query = "SELECT * FROM `branches` WHERE `id` = '$branch_id_s'";
$result_query = mysqli_query($conn, $select_query) or die($select_query . "<br/><br/>" . mysqli_error($conn));

while ($row = mysqli_fetch_assoc($result_query)) {
    $branch_id = $row['id'];
    $branch_name = $row['name'];
    $branch_image = $row['image'];
    $branch_location = $row['location'];
    $branch_phone = $row['branch_phone'];
    $square_feet_size = $row['square_feet_size'];
}

// Fetch manager info for this branch
$select_query4 = "SELECT * FROM `managers` WHERE `branch_id` = '$branch_id'";
$result_query4 = mysqli_query($conn, $select_query4) or die($select_query4 . "<br/><br/>" . mysqli_error($conn));

while ($row4 = mysqli_fetch_assoc($result_query4)) {
    $manager_name = $row4['name'];
    $manager_email = $row4['email'];
    $manager_phone = $row4['phone'];
}
?>

<!DOCTYPE html>
<html>
<head>
<meta charset=utf-8>
<meta http-equiv=X-UA-Compatible content="IE=edge">
<title>Recovery Sheet</title>
<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name=viewport>
<link rel=stylesheet href=bootstrap/css/bootstrap.min.css>
<link rel=stylesheet href=https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css>
<link rel=stylesheet href=https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css>
<link rel=stylesheet href=plugins/datatables/dataTables.bootstrap.css>
<link rel=stylesheet href=dist/css/AdminLTE.min.css>
<link rel=stylesheet href=dist/css/skins/_all-skins.min.css>
<link href=dist/css/style.css rel=stylesheet type=text/css>
<script src=//ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js></script>
<script type=text/javascript>$(window).load(function(){$(".loader").fadeOut("slow")});</script>
<script src=bootstrap/js/bootstrap.min.js></script>
<script src=plugins/jQuery/choosen.js></script>
<link href=dist/css/chosen.css rel=stylesheet type=text/css>
<Style>@media print{.no-history,.no-show{display:none}.print-header *{visibility:visible}th,td{padding:5px!important;font-size:80%}body *{visibility:hidden}#section-to-print,#section-to-print *{visibility:visible}#section-to-print{margin-top:100px}.balancesheet,.sheet-info,.defining-colors{display:none}}th{text-align:center}.print-header{width:100%;visibility:hidden;position:absolute}.middles th,td{vertical-align:middle!important}.recover-table{overflow:scroll}.recover-table th,td{padding:5px}.box-covers{margin:5px}.box-covers span{font-weight:bold;margin-left:5px}.little-boxes{margin:3px;height:15px;width:15px;border:1px solid lightgrey;float:left}.loader{position:fixed;left:0;top:0;width:100%;height:100%;z-index:9999;background:url('dist/img/page-loader.gif') 50% 50% no-repeat #f9f9f9}</style>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class=loader></div>
<div class=wrapper>
<header class=main-header>
<?php  include('inc/main-header.php');  ?>
</header>
<aside class=main-sidebar>
<?php  include('inc/main-sidebar.php');  ?>
</aside>
<?php include('inc/calculator.php'); ?>
<div class=content-wrapper>
<section class=content-header>
<h1> Recovery Sheet </h1>
<ol class=breadcrumb>
<?php if($count_1 > 0){ }else{ ?>
<li><a href=index.php><i class="fa fa-home"></i> Home</a></li>
<?php  } ?>
<li><a href="branch_page.php?branch_id=<?= $branch_id ?>">
<?php if($count_1 > 0){ ?>
<i class="fa fa-home"></i> Home
<?php }else{ echo $branch_name; } ?>
</a></li>
<li class=active>Recovery Sheet</li>
</ol>
</section>
<section class=content>
<div class=row>
<div class=print-header>
<div class=page-header>
<div style=width:35%;float:left;text-align:center><img src=<?=$branch_image?> alt style=width:120px;height:80px;border-radius:5% /></div>
<div style=width:30%;max-height:120px;float:left;text-align:justify>
<div style=text-align:center;float:left>
<h2 style=font-weight:bold;>
<?=$branch_name?>
</h2>
<h5>
<?=$branch_location?>
</h5>
<h5>
<?=$branch_phone?>
</h5>
</div>
</div>
<div style=width:35%;float:left;text-align:center;padding-top:50px>
<h5>User:-
<?=$manager_name?>
</h5>
<h5>Print Date:- <?php echo date("d M Y", strtotime($date))?></h5>
</div>
</div>
</div>
<div class=col-xs-12>
<div class="box box-primary">
<div class="box-header with-border"> </div>
<div class=box-body>
<div class="balancesheet form">
<form role=form id=form-customer method=post action accept-charset=utf-8>
<div class=row>
<div class=col-md-3>
<div class=form-group>
<label>Floor</label>
<br>
<select name=block id=block class="form-control select2-hidden-accessible chosen" tabindex=-1 aria-hidden=true style="text-align:center;padding:10px 0 0 0;margin-top:12px!important" required>
<?php  $block_query=mysqli_query($conn, "SELECT * FROM `branch_categories` WHERE `branch_id` = '$branch_id'");
while($block_item=mysqli_fetch_assoc($block_query)){
	 $block_id = $block_item['id'];
	 $block_name = $block_item['name'];
	 ?>
<option value=<?=$block_id?>>
<?=$block_name?>
</option>
<?php } ?>
</select>
</div>
</div>
<div class=col-md-3>
<div class=form-group>
<label>Month</label>
<br>
<select name=month id=month class="form-control select2-hidden-accessible chosen" tabindex=-1 aria-hidden=true style="text-align:center;padding:10px 0 0 0;margin-top:12px!important" required>
<option value=01 <?php if(date('m') == '01'){ echo 'selected'; } ?>>January</option>
<option value=02 <?php if(date('m') == '02'){ echo 'selected'; } ?>>February</option>
<option value=03 <?php if(date('m') == '03'){ echo 'selected'; } ?>>March</option>
<option value=04 <?php if(date('m') == '04'){ echo 'selected'; } ?>>April</option>
<option value=05 <?php if(date('m') == '05'){ echo 'selected'; } ?>>May</option>
<option value=06 <?php if(date('m') == '06'){ echo 'selected'; } ?>>June</option>
<option value=07 <?php if(date('m') == '07'){ echo 'selected'; } ?>>July</option>
<option value=08 <?php if(date('m') == '08'){ echo 'selected'; } ?>>August</option>
<option value=09 <?php if(date('m') == '09'){ echo 'selected'; } ?>>September</option>
<option value=10 <?php if(date('m') == '10'){ echo 'selected'; } ?>>October</option>
<option value=11 <?php if(date('m') == '11'){ echo 'selected'; } ?>>November</option>
<option value=12 <?php if(date('m') == '12'){ echo 'selected'; } ?>>December</option>
</select>
</div>
</div>
<div class=col-md-3>
<div class=form-group>
<label>Year</label>
<br>
<select name=year id=year class="form-control select2-hidden-accessible chosen" tabindex=-1 aria-hidden=true style="text-align:center;padding:10px 0 0 0;margin-top:12px!important" required>
<?php for($j = 2010; $j <= 2050 ; $j ++){ ?>
<option value=<?=$j?> <?php if($j == date('Y')){ echo 'selected'; } ?>>
<?=$j?>
</option>
<?php } ?>
</select>
</div>
</div>
<div class=col-md-3>
<div class=form-group style=padding:20px>
<input type=submit name=submit id=submit class="btn btn-primary pull-right" value=Submit>
</div>
</div>
</div>
</div>
<?php if(isset($_POST['submit'])){  
$block_id = trim($_POST['block']); 
$month = trim($_POST['month']); 
$year = trim($_POST['year']);

$month_printer = '01-'.$month.'-2010';

// Showing Data of installments of this month 
$ins_query = mysqli_query($conn, "SELECT DISTINCT `plot_no` FROM installments WHERE branch_id = '$branch_id' AND block_id = '$block_id' ORDER BY IF(CAST(plot_no AS SIGNED) = 0, 99999, CAST(plot_no AS SIGNED));"); ?>
<div class=defining-colors>
<div class=box-covers>
<div class=little-boxes></div>
<span>No Shorts</span> </div>
<div class=box-covers>
<div class=little-boxes style=background-color:#fcf8e3></div>
<span>Shorts In Checked Month</span> </div>
<div class=box-covers>
<div class=little-boxes style=background-color:#f2dede></div>
<span>Shorts But Not In Checked Month</span> </div>
<div class=box-covers>
<div class=little-boxes style=background-color:#dff0d8></div>
<span> All Amounts Cleared</span> </div>
<div class=box-covers>
<div class=little-boxes style=background-color:#d9edf7></div>
<span>Total</span> </div>
</div>
<div class=clearfix></div>
<div style=overflow:auto id=section-to-print> <?php echo '<h4 class="text-center sheet-info"><b>Recovery Sheet of '.date("M", strtotime($month_printer)).' '.$year.'('.$block_name.')</b></h4>'; ?>
<table id class="table-bordered recover-table table-hover" style=text-align:center>
<thead>
<tr class=middles class=no-show>
<th rowspan=2>Shop No</th>
<th rowspan=2>Customer</th>
<th rowspan=2>Area</th>
<th rowspan=2>Contact No.</th>
<th rowspan=2>Booking Date</th>
<th rowspan=2>Rate/Marla</th>
<th rowspan=2>Total Amount</th>
<th colspan=2>Advance</th>
<th colspan=2><?php echo date("M", strtotime($month_printer)).' '.$year; ?></th>
<th rowspan=2>Total Recieved</th>
<th rowspan=2>Remaining Amount</th>
<th rowspan=2>Short Amount</th>
<th rowspan=2>Registry Date</th>
<th rowspan=2 class=no-history>History</th>
</tr>
<tr>
<th>Total</th>
<th>Recieved</th>
<th>Installment</th>
<th>Recieved</th>
</tr>
</thead>
<tbody>
<?php
$installments_sum=0;
$amount_paid_sum=0;
$all_total_prices = 0; 
$total_advances = 0;
$total_advances_recieved = 0;
$total_installments = 0;
$total_installments_received = 0;
$amount_paid_total = 0;
$total_remaining_amount = 0;
$total_short_amount = 0;
$selected_ledger_id = null;
$selected_ledger_balance = 0;
$amount_paid_total = 0;
$amount_paid_total_b = 0;
while($ins_row=mysqli_fetch_assoc($ins_query)){$installment_id=$ins_row['id'] ?? null;$installment_date=$ins_row['date_of_installment'] ?? '';$ins_plot_no=$ins_row['plot_no'] ?? '';
$select_query_q="SELECT * FROM `book_plot` WHERE `branch_id` = '$branch_id_s' AND `block_id` = '$block_id' AND `plot_no` = '$ins_plot_no'";$result_query_q=mysqli_query($conn, $select_query_q) or die($select_query_q."<br/><br/>".mysqli_error($conn));
$numbering = 0; while($row_q=mysqli_fetch_assoc($result_query_q)){$numbering++;$book_plot_id=$row_q['id'];$p_no=$row_q['plot_no'];$block=$row_q['block_id'];$customer_id=$row_q['customer_id'];$p_area=$row_q['total_area'];$rate_per_marla=$row_q['rate_per_marla'];$total_price=$row_q['total_price'];$advance_amount=$row_q['advance_amount'];$num_installments=$row_q['num_installments'];$time_period=$row_q['time_period'];$registery_date=$row_q['registery_time'];$payment_method=$row_q['payment_method'];$last_payment_amount = $row_q['last_payment_amount'];$booking_date=$row_q['date'];$all_total_prices += $total_price;$total_advances +=$advance_amount;}
$select_query="SELECT * FROM `customers` WHERE `id` = '$customer_id'";$result=mysqli_query($conn, $select_query);
while($row=mysqli_fetch_assoc($result)){$customer_name = $row['name'];$customer_cnic = $row['cnic_number'];$customer_phone = $row['phone'];}
$plot_query=mysqli_query($conn, "SELECT * FROM `plots` WHERE `branch_id` = '$branch_id' AND  `block_id` = '$block' AND `plot_no` = '$p_no'");while($plots_row=mysqli_fetch_assoc($plot_query)){
$p_id=$plots_row['id'];$p_area=$plots_row['area'] ?? '';$p_marla=$plots_row['marla'] ?? '';$p_sarsai=$plots_row['sarsai'] ?? '';$p_square_foot=$plots_row['square_foot'] ?? '';
}$block_query=mysqli_query($conn, "SELECT * FROM `branch_categories` WHERE `branch_id` = '$branch_id' AND  `id` = '$block'");
	while($block_row=mysqli_fetch_assoc($block_query)){$block_id=$block_row['id'];$block_name=$block_row['name'];}$installment_query=mysqli_query($conn, "SELECT * FROM `installments` WHERE `branch_id` = '$branch_id' AND  `block_id` = '$block' AND `plot_no` = '$p_no'");while($installment_row=mysqli_fetch_assoc($installment_query)){$installment_id=$installment_row['id'];$installment_amount=$installment_row['payment_per_installment'];}
$ins_check_query = mysqli_query($conn, "SELECT * FROM installments WHERE branch_id = '$branch_id' AND block_id = '$block_id' AND `plot_no` = '$p_no' AND DATE_FORMAT(date_of_installment,'%Y') = '$year' AND DATE_FORMAT(date_of_installment,'%m') = '$month';");$total_installments += $installment_amount;$customer_plot_ledger = 'Plot No. '.$p_no;
//To Get Paymens made by this customer Start
$selected_ledger_query=mysqli_query($conn, "SELECT * FROM `ledgers` WHERE `customer_id` = '$customer_id' AND `name` = '$customer_plot_ledger'");
while($selected_ledger_row=mysqli_fetch_assoc($selected_ledger_query)){$selected_ledger_id=$selected_ledger_row['id'];$selected_ledger_name=$selected_ledger_row['name'];$selected_ledger_balance=$selected_ledger_row['balance'];$selected_ledger_control_id=$selected_ledger_row['control_account_id'];$selected_ledger_general_id=$selected_ledger_row['general_ledger_id'];}$total_debit = 0;$total_credit = 0;$select_query_for_balance=mysqli_query($conn, "SELECT * FROM `all_payments` WHERE `branch_id` = '$branch_id' AND `ledger_id` = '$selected_ledger_id'");
while($row_q=mysqli_fetch_assoc($select_query_for_balance)){$debit=(float)$row_q['debit'];$credit=(float)$row_q['credit'];$total_debit += $debit;$total_credit += $credit; }$total_amount_paid = $selected_ledger_balance+$total_debit;$total_amount_paid = $total_amount_paid-$total_credit;	$amount_paid = abs($total_amount_paid);
//To Get Paymens made by this customer End
//To Get the installment amount for the checked month Start
$total_installment_amounts = 0;$select_query6="SELECT * FROM `installments` WHERE `branch_id` = '$branch_id' AND `block_id` = '$block' AND `plot_no` = '$p_no' AND DATE_FORMAT(date_of_installment,'%Y%m') <= '$year$month'";
$result_query6=mysqli_query($conn, $select_query6) or die($select_query6."<br/><br/>".mysqli_error($conn));
while($row6=mysqli_fetch_assoc($result_query6)){$id_of_installment =$row6['id'];$date_of_installment =$row6['date_of_installment'];$payment_per_installment = $row6['payment_per_installment'];$installment_amount = $row6['payment_per_installment'];$total_installment_amounts += $payment_per_installment;}
//to check if its last payment
$last_payment_query=mysqli_query($conn, "SELECT * FROM `installments` WHERE `branch_id` = '$branch_id' AND `block_id` = '$block' AND `plot_no` = '$p_no' ORDER BY id DESC LIMIT 1");
while($last_payment_row=mysqli_fetch_assoc($last_payment_query)){$last_payment_id =$last_payment_row['id'];}
if($id_of_installment == $last_payment_id){ $total_amount_to_pay = $total_installment_amounts+$advance_amount+$last_payment_amount; }else{ $total_amount_to_pay = $total_installment_amounts+$advance_amount; }
//to Get the amount of current month if not totally paid
$current_month_amount = $total_amount_to_pay-$installment_amount;$amount_paid_this_month = $amount_paid-$current_month_amount;
//To Get the installment amount for the checked month End
//To Get Remaining Amount Start 
$total_installment_amounts_overall = 0;$remaining_amount_query=mysqli_query($conn, "SELECT * FROM `installments` WHERE `branch_id` = '$branch_id' AND `block_id` = '$block' AND `plot_no` = '$p_no'");
while($remaining_amount_row=mysqli_fetch_assoc($remaining_amount_query)){
$payment_per_installment = $remaining_amount_row['payment_per_installment'];$total_installment_amounts_overall += $payment_per_installment;}$total_amount_to_pay_overall = $total_price;$remaining_amount = $total_amount_to_pay_overall-$amount_paid;
//To Get Remaining Amount End 
$amount_cleard = $total_price-$amount_paid;
//To Get Short Amount Start
$current_month = date('m'); $current_year = date('Y');$total_installment_amounts_till = 0;
$short_query="SELECT * FROM `installments` WHERE `branch_id` = '$branch_id' AND `block_id` = '$block' AND `plot_no` = '$p_no' AND DATE_FORMAT(date_of_installment,'%Y%m') < '$current_year$current_month'";
$result_short_query=mysqli_query($conn, $short_query) or die($short_query."<br/><br/>".mysqli_error($conn));while($row_short=mysqli_fetch_assoc($result_short_query)){$date_of_installment_till =$row_short['date_of_installment'];$payment_per_installment_till = $row_short['payment_per_installment'];$total_installment_amounts_till += $payment_per_installment_till;}
$total_amount_to_pay_till = $total_installment_amounts_till+$advance_amount;if($payment_method == 'cash'){$short_amount = $total_price-$amount_paid;}else{$short_amount = $total_amount_to_pay_till-$amount_paid;}
//To Get Short Amount End
//To Get the Remaining Installments Start 
// if($amount_paid > $advance_amount){$short_installments = $short_amount/$installment_amount;$total_advances_recieved += $advance_amount;if($short_installments < 0){ $short_installments = 0; }}else{$short_advance = $advance_amount-$amount_paid;$short_amount_advance_less = $short_amount-$short_advance;$short_installments = $short_amount_advance_less/$installment_amount;$total_advances_recieved += $amount_paid;}
if ($installment_amount != 0) {
    if ($amount_paid > $advance_amount) {
        $short_installments = $short_amount / $installment_amount;
        $total_advances_recieved += $advance_amount;

        if ($short_installments < 0) {
            $short_installments = 0;
        }
    } else {
        $short_advance = $advance_amount - $amount_paid;
        $short_amount_advance_less = $short_amount - $short_advance;
        $short_installments = $short_amount_advance_less / $installment_amount;
        $total_advances_recieved += $amount_paid;
    }
} else {
    // Avoid division by zero
    $short_installments = 0;
}




//To Get the Remaining Installments End
//to get installments received
if($amount_paid >= $total_amount_to_pay ){ $total_installments_received += $installment_amount; }else{
	if($amount_paid_this_month > 0){ $total_installments_received += $amount_paid_this_month; }} 
//to get the total amount paid by all customers
if($amount_paid > 0){$amount_paid_total += $amount_paid;}
//to get the total of all remaining amounts
if($remaining_amount > 0){$total_remaining_amount +=$remaining_amount;}
//to get total short amount of all customers
if($short_amount > 0){ $total_short_amount += $short_amount; }
?>
<tr <?php if($short_amount > 0 && mysqli_num_rows($ins_check_query) > 0){ echo  'class="bg-warning"'; }elseif($amount_cleard <= 0){ echo 'class="bg-success"'; }elseif($short_amount > 0 && mysqli_num_rows($ins_check_query) <= 0){ echo 'class="bg-danger"'; }else{} ?>><td><?php echo $ins_plot_no; ?></td><td><?=$customer_name?></td><td><?php $plot_total_area = $p_area/$square_feet_size; echo $p_marla.' Marly '; if($p_sarsai) { echo $p_sarsai.' Sarsai ';} if($p_square_foot) { echo $p_square_foot.' Sqr. Ft.';}?></td><td><?=$customer_phone?></td><td><?php echo date("d M Y", strtotime($booking_date)); ?></td><td><?php echo number_format($rate_per_marla); ?></td><td><?php echo number_format($total_price); ?></td><td><?php echo number_format($advance_amount); ?></td><td><?php if($amount_paid >= $advance_amount){ echo number_format($advance_amount); }else{ echo number_format($amount_paid); } ?></td><td><?php if(mysqli_num_rows($ins_check_query) > 0){ echo number_format($installment_amount); }else{ echo '0'; } ?></td><td><?php if(mysqli_num_rows($ins_check_query) > 0){ if($amount_paid >= $total_amount_to_pay ){ echo number_format($installment_amount); }else{ if($amount_paid_this_month > 0){ echo number_format($amount_paid_this_month); }else{ echo '0'; }  } }else{ echo '0'; } ?></td><td><?php echo number_format($amount_paid); ?></td><td><?php if($remaining_amount > 0){ echo number_format($remaining_amount); }else{ echo '0'; } ?></td><td><?php if($short_amount > 0){ echo number_format($short_amount); }else{ echo '0'; } ?></td><td><?php echo date("d M Y", strtotime($registery_date)); ?></td><td class=no-history><a href="view_recovery_sheet.php?branch_id=<?=$branch_id?>&booking_id=<?=$book_plot_id?>" target=_blank>View</a></td></tr><?php 
//for showing total installments and amount paid in total Start
if(mysqli_num_rows($ins_check_query) > 0){ $installments_sum+=$installment_amount; if($amount_paid >= $total_amount_to_pay){ $amount_paid_sum+=$installment_amount; }else{ if($amount_paid_this_month > 0){ $amount_paid_sum+=$amount_paid_this_month; } }}
//for showing total installments and amount paid in total End
} ?>
<tr class=bg-info style=font-weight:bold>
<td colspan=2>Total</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td><?php echo number_format($all_total_prices); ?></td>
<td><?php echo number_format($total_advances); ?></td>
<td><?php echo number_format($total_advances_recieved); ?></td>
<td><?php echo number_format($installments_sum); ?></td>
<td><?php if($amount_paid_sum > 0){ echo number_format($amount_paid_sum); }else{ echo '0'; } ?></td>
<td><?php echo number_format($amount_paid_total+$amount_paid_total_b); ?></td>
<td><?php echo number_format($total_remaining_amount); ?></td>
<td><?php echo number_format($total_short_amount); ?></td>
<td></td>
<td class=no-history></td>
</tr>
</tbody>
</table>
</div>
<?php 
}?>
</div>
</div>
<?php if(isset($_POST['submit'])){  ?>
<center>
<button onclick=myFunction() class="btn btn-primary">Generate Print</button>
</center>
<?php } ?>
</div>
</section>
</div>
<?php include("inc/footer.php"); ?>
<?php include("inc/aside.php"); ?>
</div>
<script src=plugins/datatables/jquery.dataTables.min.js></script>
<script src=plugins/datatables/dataTables.bootstrap.min.js></script>
<script src=plugins/slimScroll/jquery.slimscroll.min.js></script>
<script src=plugins/fastclick/fastclick.js></script>
<script src=dist/js/app.min.js></script>
<script src=dist/js/demo.js></script>
<script>$(function(){$("#example1").DataTable();$("#example2").DataTable({paging:true,lengthChange:false,searching:false,ordering:true,info:true,autoWidth:false})});jQuery(document).ready(function(a){a(".clickable-row").click(function(){window.location=a(this).data("href")})});$(".chosen").chosen();</script>
<script>function myFunction(){window.print()}$("#submit").click(function(){$(".loader").fadeIn("slow")});</script>
</body>
</html>