<?php 
ob_start();
session_start();
include("db.php"); // Make sure $conn = mysqli_connect(...) is defined here

if (!isset($_SESSION['user_email'])) {
    header("Location: login.php?login=failed");
    exit;
}

$user_email = $_SESSION['user_email'];

// Escape email for safety
$safe_email = mysqli_real_escape_string($conn, $user_email);

// Get manager info
$select_query_q = "SELECT * FROM `managers` WHERE `email` = '$safe_email'";
$result_q = mysqli_query($conn, $select_query_q);

$branch_id = '';
$M_name = '';

while ($rowq = mysqli_fetch_assoc($result_q)) {
    $branch_id = $rowq['branch_id'];
    $M_name = $rowq['name'];
}
$count_1 = mysqli_num_rows($result_q);

// Get branch_id from URL
$branch_id_s = $_GET['branch_id'] ?? '';

if ($count_1 > 0 && $branch_id_s != $branch_id) {
    echo "<script>history.go(-1);</script>";
    exit;
}

// Escape branch_id for safety
$safe_branch_id = mysqli_real_escape_string($conn, $branch_id_s);

// Get branch info
$select_query = "SELECT * FROM `branches` WHERE `id` = '$safe_branch_id'";
$result_query = mysqli_query($conn, $select_query);

if (!$result_query) {
    die("Query Failed: " . mysqli_error($conn));
}

while ($row = mysqli_fetch_assoc($result_query)) {
    $branch_id = $row['id'];
    $branch_name = $row['name'];
    $manager_name = $row['manager'];
    $branch_location = $row['location'];
    $branch_area = $row['area'];
    $branch_status = $row['status'];
    $branch_image = $row['image'];
    $square_feet_size = $row['square_feet_size'];
    $branch_entry_date = $row['date'];
}
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Registries</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
  <!-- iCheck -->
  <link rel="stylesheet" href="plugins/iCheck/flat/blue.css">
  <!-- Morris chart -->
  <link rel="stylesheet" href="plugins/morris/morris.css">
  <!-- jvectormap -->
  <link rel="stylesheet" href="plugins/jvectormap/jquery-jvectormap-1.2.2.css">
  <!-- Date Picker -->
  <link rel="stylesheet" href="plugins/datepicker/datepicker3.css">
  <!-- Daterange picker -->
  <link rel="stylesheet" href="plugins/daterangepicker/daterangepicker.css">
  <!-- bootstrap wysihtml5 - text editor -->
  <link rel="stylesheet" href="plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css">
 <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
 <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <header class="main-header">
    <!-- Logo -->
 <?php  include('inc/main-header.php');  ?>
    </header>
  <!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
 <?php  include('inc/main-sidebar.php');  ?>
  </aside>
 <?php include('inc/calculator.php'); ?>
 
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Registries
        <small><?= $branch_name ?></small>
      </h1>
      <ol class="breadcrumb">
        <?php if($count_1 > 0){ }else{ ?>
        <li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
        <?php  } ?>
        <li><a href="branch_page.php?branch_id=<?= $branch_id ?>"><?php if($count_1 > 0){ ?><i class="fa fa-home"></i> Home <?php }else{ echo $branch_name; } ?></a></li>
        <li class="active">Registries</li>
      </ol><br>
      

    </section>

    <!-- Main content -->
    
<!-- /.content -->

     <section class="content">
      <div class="row">
        <div class="col-xs-12">
        

          <div class="box box-primary">
            <div class="box-header">
        <?php
		$select_query_q="SELECT * FROM `registory_detail` WHERE `branch_id` = '$branch_id_s'";
		$result_query_q=mysqli_query($conn, $select_query_q) or die($select_query_q."<br/><br/>".mysqli_error($conn));
			$total_booked = 0;
			if(mysqli_num_rows($result_query_q) > 0){ 
		?>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <table id="example1" class="table table-bordered text-center">
                <thead>
                <tr>
                  <th>SN#</th>
                  <th>Shop Number</th>
        				  <th>Floor</th>
        				  <th>Customer</th>
        				  <th>Registry Date</th>
        				  <th>Registory Name</th>
        				  <th>Marla</th>
                  <th>Sarsai</th>
                  <th>Sqr Ft.</th>
                </tr>
                </thead>
                <tbody>
   <?php
   			$numbering = 0;
			while($row_q=mysqli_fetch_assoc($result_query_q)){
			$numbering++;
			$registory_id=$row_q['id'];
			$plot_no=$row_q['plot_no'];
			$block_id=$row_q['block_id'];
			$registry_date=$row_q['registory_date'];
			$customer_id=$row_q['customer_id'];
			$registory_name=$row_q['registory_name'];
			$marla=$row_q['marla'];
			$sarsai=$row_q['sarsai'];
			$square_foot=$row_q['square_foot'];
			$registery_enrtry_date=$row_q['date'];
			
		$select_query1="SELECT * FROM `branch_categories` WHERE `id` = '$block_id'";
		$result_query1=mysqli_query($conn, $select_query1) or die($select_query1."<br/><br/>".mysqli_error($conn));;
			while($row1=mysqli_fetch_assoc($result_query1)){
			$block_id=$row1['id'];
			$block_name=$row1['name'];
			$area=$row1['area'];
			}
		$select_query="SELECT * FROM `customers` WHERE `id` = '$customer_id'";
		$result=mysqli_query($conn, $select_query);
		while($row=mysqli_fetch_assoc($result)){
			 $customer_name = $row['name'];
			 $customer_cnic = $row['cnic_number'];
			 $customer_phone = $row['phone'];
		}

	?>
                <tr>
                  <td><?= $numbering; ?></td>
                  <td><?= $plot_no; ?></td>
                  <td><?= $block_name ?></td>
				          <td><?= $customer_name ?></td>
				          <td><?php echo date("d M Y", strtotime($registry_date)); ?></td>
        				  <td><?= $registory_name ?></td>
        				  <td><?= $marla ?></td>
        				  <td><?= $sarsai ?></td>
        				  <td><?= $square_foot ?></td>
               </tr>
               <?php } ?>
                </tbody>
                <tfoot>
                </tr>
                </tfoot>
              </table>
               <?php }else{ ?>
                    <b>No Data Found</b>
				<?php } ?>
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    
<!-- /.content -->




  </div>
  <!-- /.content-wrapper -->
  <?php include('inc/footer.php'); ?>

  <!-- Control Sidebar -->
 <?php include('inc/aside.php'); ?>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- DataTables -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
<!-- page script -->
<script>

  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
</script>

  <script src="//ajax.aspnetcdn.com/ajax/jquery.validate/1.9/jquery.validate.min.js"></script>
  
  <!-- jQuery Form Validation code -->
</body>
</html>
