<?php 
ob_start();
session_start();
include("db.php");
include("functions_format.php");

if (!isset($_SESSION['user_email'])) {
    header("location:login.php?login=failed");
    exit;
}

$user_email = mysqli_real_escape_string($conn, $_SESSION['user_email']);

// Manager Info
$select_query_q = "SELECT * FROM `managers` WHERE `email` = '$user_email'";
$result_q = mysqli_query($conn, $select_query_q);
while ($rowq = mysqli_fetch_assoc($result_q)) {
    $branch_id = $rowq['branch_id'];
    $M_name = $rowq['name'];
}
$count_1 = mysqli_num_rows($result_q);

$branch_id_s = mysqli_real_escape_string($conn, $_GET['branch_id'] ?? '');

if ($count_1 > 0 && $branch_id_s != $branch_id) {
    header("location:javascript://history.go(-1)");
    exit;
}

// Branch info
$select_query = "SELECT * FROM `branches` WHERE `id` = '$branch_id_s'";
$result_query = mysqli_query($conn, $select_query);
while ($row = mysqli_fetch_assoc($result_query)) {
    $branch_id = $row['id'];
    $branch_name = $row['name'];
    $branch_image = $row['image'];
    $branch_location = $row['location'];
    $square_feet_size = $row['square_feet_size'];
}

// Control accounts (if needed later)
$control_account_query = mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `branch_id` = '$branch_id'");

if (isset($_POST['rent_shop'])) {
    // Sanitize POST data
    $shops_total_area     = mysqli_real_escape_string($conn, $_POST['shops_total_area']);
    $rate_pr_sqrft        = mysqli_real_escape_string($conn, $_POST['price']);
    $rent                 = mysqli_real_escape_string($conn, $_POST['total_price']);
    $advance_amount       = mysqli_real_escape_string($conn, $_POST['advance_amount']);
    $company_ledger_id    = mysqli_real_escape_string($conn, $_POST['ledger_id']);
    $company_id           = mysqli_real_escape_string($conn, $_POST['company_id']);
    $agreement_date       = mysqli_real_escape_string($conn, $_POST['agreement_date']);
    $contract_duration    = mysqli_real_escape_string($conn, $_POST['contract_duration']);
    $increment_duration   = mysqli_real_escape_string($conn, $_POST['increment_duration']);
    $increment_percentage = mysqli_real_escape_string($conn, $_POST['increment_percentage']);
    $witness_1_name       = mysqli_real_escape_string($conn, $_POST['witness_1_name']);
    $witness_1_cnic       = mysqli_real_escape_string($conn, $_POST['witness_1_cnic']);
    $witness_2_name       = mysqli_real_escape_string($conn, $_POST['witness_2_name']);
    $witness_2_cnic       = mysqli_real_escape_string($conn, $_POST['witness_2_cnic']);
    $billing_ledger_id    = mysqli_real_escape_string($conn, $_POST['billing_ledger_id']);
    $charges_ledger_id    = mysqli_real_escape_string($conn, $_POST['charges_ledger_id']);

    if (!empty($shops_total_area) && !empty($rate_pr_sqrft) && !empty($rent) && !empty($advance_amount) &&
        !empty($company_id) && !empty($company_ledger_id) && !empty($agreement_date) &&
        !empty($contract_duration) && !empty($increment_duration) && !empty($increment_percentage) &&
        !empty($witness_1_name) && !empty($witness_1_cnic) && !empty($witness_2_name) &&
        !empty($witness_2_cnic) && !empty($billing_ledger_id) && !empty($charges_ledger_id)) {
        
        // Insert rental agreement
        $insert_agreement = mysqli_query($conn, "
            INSERT INTO `rental_agreement` (`branch_id`, `company_id`, `company_ledger_id`, `service_charges_ledger_id`, `billing_ledger_id`, 
            `area`, `rate_pr_sqrft`, `rent`, `advance`, `duration`, `increment_duration`, `increment_percentage`, 
            `witness_1_name`, `witness_1_cnic`, `witness_2_name`, `witness_2_cnic`, `agreement_date`, `date`) 
            VALUES ('$branch_id', '$company_id', '$company_ledger_id', '$charges_ledger_id', '$billing_ledger_id',
            '$shops_total_area', '$rate_pr_sqrft', '$rent', '$advance_amount', '$contract_duration', '$increment_duration', 
            '$increment_percentage', '$witness_1_name', '$witness_1_cnic', '$witness_2_name', '$witness_2_cnic', '$agreement_date', NULL)
        ");

        // Get inserted ID
        $rental_agreement_id = mysqli_insert_id($conn);

        // Insert initial service & electricity billing
        mysqli_query($conn, "INSERT INTO `service_charges_recovery` (`branch_id`, `agreement_id`, `arrears`, `date`) 
                             VALUES ('$branch_id', '$rental_agreement_id', '0', NULL)");
        mysqli_query($conn, "INSERT INTO `electricity_bills_recovery` (`branch_id`, `agreement_id`, `arrears`, `date`) 
                             VALUES ('$branch_id', '$rental_agreement_id', '0', NULL)");
    }

    // Rental shops association
    $shop_ids  = $_POST['plot_no'];
    $owner_ids = $_POST['owner'];

    $values = [];
    foreach ($shop_ids as $i => $shop_id) {
        $owner_id = $owner_ids[$i];
        if (!empty($shop_id) && !empty($owner_id)) {
            $shop_id = mysqli_real_escape_string($conn, $shop_id);
            $owner_id = mysqli_real_escape_string($conn, $owner_id);
            $values[] = "('$branch_id', '$rental_agreement_id', '$shop_id', '$owner_id')";
        }
    }

    if (empty($values)) {
        $_SESSION['rental_agreement'] = 'Please Fill The Form Properly';
    } else {
        $valueString = implode(", ", $values);
        $sql = mysqli_query($conn, "INSERT INTO `rental_shops` (`branch_id`, `agreement_id`, `shop_id`, `owner_id`) VALUES $valueString");
        $_SESSION['rental_agreement'] = 'Successfully Made A New Agreement';

        // Create rental schedule
        if ($sql) {
            $rent_date = $agreement_date;
            $increment_count = $increment_duration;

            for ($i = 0; $i < $contract_duration; $i++) {
                if ($i == $increment_count) {
                    $rent += ($rent / 100) * $increment_percentage;
                    $increment_count += $increment_duration;
                }
                $rent_date = date('Y-m-d', strtotime("+1 months", strtotime($rent_date)));
                mysqli_query($conn, "INSERT INTO `rental_schedule` (`branch_id`, `agreement_id`, `rent_amount`, `rent_date`, `status`, `datetime`) 
                                     VALUES ('$branch_id', '$rental_agreement_id', '$rent', '$rent_date', '', NULL)");
            }

            echo "<script>
                    var reciept = confirm('Do You Want A Receipt?');
                    if (reciept) {
                        window.open('rental_agreement_receipt.php?branch_id=$branch_id&agreement_id=$rental_agreement_id');
                    }
                    window.location.href = 'rental_form.php?branch_id=$branch_id';
                  </script>";
        }
    }
}
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Rental Agreement Form</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Select2 -->
  <link rel="stylesheet" href="plugins/select2/select2.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
  <link rel="stylesheet" href="dist/css/plaza.css">
  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
 <script src="//ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js"></script>
 <script type="text/javascript">
  $(window).load(function() {
  $(".loader").fadeOut("slow");
});
 </script>
 <script src="bootstrap/js/bootstrap.min.js"></script>

<style type="text/css">
.jquery-date
{
  background-color: #fff !important;
}
.chosen-container{
  width: 100% !important;
}
.agreement-text span{
  font-size: 16px;
  font-weight: 600;
}
.loader {
  position: fixed;
  left: 0px;
  top: 0px;
  width: 100%;
  height: 100%;
  z-index: 9999;
  background: url('dist/img/page-loader.gif') 50% 50% no-repeat rgb(249,249,249);
}
.form-control + label,span + label{
  color: red;
}
</style>
</head>
<script type="text/javascript">
$(document).on('change', '.block_id', function (event) { 
        var blockID = $(this).val();
        var branch = <?=$branch_id?>;
        if(blockID){
            $.ajax({
                type:'POST',
                url:'ajaxdata.php',
                data:{
                  'block_id_rental': blockID,
                  'branch_id': branch, 
                },
                context: this,
                success:function(html){
                  $(this).closest('tr').find('.plot_no').html(html);
                } 
            }); 
        }else{
                $(this).closest('tr').find('.plot_no').html('<option value="">Select Floor first</option>');
        }
});

$(document).on('change', '.plot_no', function (event) { 
        var plotNO = $(this).val();
        var blockID = $(this).closest('tr').find('.block_id').val();
        var branch = <?=$branch_id?>;
        if(plotNO){
            $.ajax({
                type:'POST',
                url:'ajaxdata.php',
                data:{
                  'shop_id': plotNO,
                  'block': blockID, 
                  'branch_id': branch, 
                },
                context: this,
                success:function(html){
                  $(this).closest('tr').find('.area').val(html);
                  //sum
                  var sum = 0;
                  $(".area").each(function(){
                      sum += +$(this).val();
                  });
                  var sum = sum.toFixed(0);
                  $(".total").val(sum);
                  //sum
                  //rent
                  var pr_sqrft = $("#price").val();
                  var price = $(".total").val();
                  var rent = price*pr_sqrft;
                  var rent = rent.toFixed(0); 
                  $("#total_price").val(rent);
                  //rent
                  //advance
                  var rent = $("#total_price").val();
                  var advance = rent*3;
                  var advance = advance.toFixed(0); 
                  $("#advance_amount").val(advance);
                  //advance
                }
            }); 
        }else{
            $(this).closest('tr').find('.area').val("");
        }
});

$(document).on('change', '.plot_no', function (event) { 
        var plotNO = $(this).val();
        var blockID = $(this).closest('tr').find('.block_id').val();
        var branch = <?=$branch_id?>;
        if(plotNO){
            $.ajax({
                type:'POST',
                url:'ajaxdata.php',
                data:{
                  'shop_no_owner': plotNO,
                  'block': blockID, 
                  'branch_id': branch, 
                },
                context: this,
                success:function(html){
                  $(this).closest('tr').find('.owner').html(html);
                }
            }); 
        }else{
            $(this).closest('tr').find('.owner').html('<option value="">Select Shop first</option>');
        }
});

$(document).on('click', '.deleterow', function (event) {
  var sum = 0;
  $(".area").each(function(){
      sum += +$(this).val();
      });
  var sum = sum.toFixed(0);
  $(".total").val(sum);
  //rent
  var pr_sqrft = $("#price").val();
  var price = $(".total").val();
  var rent = price*pr_sqrft;
  var rent = rent.toFixed(0); 
  $("#total_price").val(rent);
  //rent
  //advance
  var rent = $("#total_price").val();
  var advance = rent*3;
  var advance = advance.toFixed(0); 
  $("#advance_amount").val(advance);
  //advance
});

$(document).on('keyup', '#price', function (event) {
  var advance = 0;
  var pr_sqrft = $(this).val();
  var price = $(".total").val();
  var rent = price*pr_sqrft;
  var rent = rent.toFixed(0); 
  $("#total_price").val(rent);

  //advance
  var rent = $("#total_price").val();
  var advance = rent*3;
  var advance = advance.toFixed(0); 
  $("#advance_amount").val(advance);
  //advance
});
</script>
<style type="text/css">
.select2-container{
  width: 100% !important;
}
.form-control,.select2-selection
{
  border-radius: 5px !important; 
  background-color: #fff !important;
}
.seperator-cover{ padding:10px; }
.from-seperator{ width:100%; text-align:center; border-bottom: 1px solid #ccc; line-height:0.1em; margin:10px 0 20px; } 
.from-seperator span { background:#fff; padding:0 10px; }
.form-control + label{
  color: red;
}
</style>
<body class="hold-transition skin-blue sidebar-mini">
  <div class="loader"></div>
<div class="wrapper">

  <header class="main-header">
    <!-- Logo -->
 <?php  include('inc/main-header.php');  ?>
    </header>
  <!-- Left side column. contains the logo and sidebar -->
    <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
 <?php  include('inc/main-sidebar.php');  ?>
  </aside>
<?php include('inc/calculator.php'); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Rental Agreement 
        <small><?=$branch_name?></small>
      </h1>
      <ol class="breadcrumb">
        <?php if($count_1 > 0){ }else{ ?>
        <li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
        <?php  } ?>
        <li><a href="branch_page.php?branch_id=<?= $branch_id ?>"><?php if($count_1 > 0){ ?><i class="fa fa-home"></i> Home <?php }else{ echo $branch_name; } ?></a></li>
        <li class="active">Renatal Agreement</li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-xs-12">
        

          <div class="box box-primary">
            <div class="box-header">
             <h3 class="text-center">Rental Agreement Form</h3>

            </div>
            <!-- /.box-header -->
              <div class="box-body">
                <?php query_status('rental_agreement'); ?> 
            <form role="form" id="register-form" method="post" novalidate action=""> 
                <div class="seperator-cover col-md-12"><h4 class="from-seperator"><span>Shops Selection</span></h4></div>
                <input type="hidden" name="branch_id" id="branch_id" value="<?=$branch_id?>">

                <div class="col-md-12">
                  <div class="form-group">
                  <table  class="table table-hover small-text" id="tbUser">
                    <tbody id="TableBody">
                  <tr class="tr-header">
                  <th class="col-md-3">Floor Name</th>
                  <th class="col-md-3">Shop No.</th>
                  <th class="col-md-3">Shop Area.</th>
                  <th class="col-md-3">Owner</th>
                  <th><a href="javascript:void(0);" style="font-size:18px;" class="addrow" title="Add More Person"><span name="xd" id="xd" class="glyphicon glyphicon-plus"></span></a></th>
                </tr>
                  <tr>
                  <td class="col-md-3">                      
                    <select id="block_id" name="block_id[]" class="block_id form-control select2" required>
                        <option value="">Select Floor</option>
                        <?php
                        $branch_id_safe = mysqli_real_escape_string($conn, $branch_id);
                        $block_query = mysqli_query($conn, "SELECT * FROM `floors` WHERE `branch_id` = '$branch_id_safe'");
                        while ($block_item = mysqli_fetch_assoc($block_query)) {
                            $block_id = $block_item['id'];
                            $block_name = $block_item['name'];
                            ?>
                            <option value="<?= $block_id ?>"><?= $block_name ?></option>
                        <?php } ?>
                    </select>

                    <label for="block_id" generated="true" class="error"></label></td>
                    <td class="col-md-3">                  
                      <Select name="plot_no[]" id="plot_no" class="plot_no form-control select2" required>
                        <option value="">Select Floor First</option>
                      </Select>
                    <label for="plot_no" generated="true" class="error"></label></td>
                    <td class="col-md-3"><input type="text" name="area[]" class="area form-control" readonly></td>
                    <td class="col-md-3">                  
                      <Select name="owner[]" class="owner form-control" required>
                        <option value="">Select Shop First</option>
                      </Select></td>
                    <td><a type="button" class="glyphicon glyphicon-check" escape="false"></a></td>
                    </tr>
                    </tbody>
                    </table>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="">Total Area <small>(Sqr. Ft.)</small></label>
                    <input type="text" name="shops_total_area" id="shops_total_area" class="total form-control" style="background-color:white" readonly>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="">Rate Per Sqr<sup>ft</sup></label>
                    <input type="number" min="0" name="price" id="price" value="1" class="form-control" placeholder="Rate Per Marla" data-view-id="#location">
				          </div>
                </div>
                <div class="col-md-6">
          				<div class="form-group">
                    <label for="">Total Rent</label>
                    <input type="number" name="total_price" id="total_price" class="form-control" style="background-color:white" readonly>
          				</div>
                </div>
                <div class="col-md-6">
          				<div class="form-group">
                    <label for="">Advance Rent</label>
                    <input type="number" min="0" name="advance_amount" id="advance_amount" class="form-control" placeholder="Advance amount">
          				</div>
                </div>
                <div class="seperator-cover col-md-12"><h4 class="from-seperator"><span>Agreement Details</span></h4></div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="">Company / Brand</label><br>
                    <select id="company_id" name="company_id" class="form-control select2" required>
                        <option value="">Select Company / Brand</option>
                        <?php
                        $branch_id_safe = mysqli_real_escape_string($conn, $branch_id);
                        $company_query = mysqli_query($conn, "SELECT * FROM `company` WHERE `branch_id` = '$branch_id_safe'");

                        while ($company_row = mysqli_fetch_assoc($company_query)) {
                            $company_id = $company_row['id'];
                            $company_name = $company_row['name'];
                            ?>
                            <option value="<?= $company_id ?>"><?= $company_name ?></option>
                        <?php } ?>
                    </select>

                    <label for="company_id" generated="true" class="error"></label>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                  <label>Shops Ledger Account</label>
                  <br>
                      <select name="ledger_id" id="ledger_id" class="form-control select2-hidden-accessible select2 form-control ledger_id" tabindex="-1" aria-hidden="true" style="width: 322px;text-align: center;padding: 10px 0px 0px 0px;margin-top: 12px !important;" required>
                  <option value="">Please Select</option>
                  <?php  $ledger_query=mysqli_query($conn, "SELECT * FROM `ledgers` WHERE `branch_id` = '$branch_id'");
                      while($ledger_item=mysqli_fetch_assoc($ledger_query)){
                         $ledger_id = $ledger_item['id'];
                         $ledger_branch_id = $ledger_item['branch_id'];
                         $ledger_controller_id = $ledger_item['control_account_id'];
                         $ledger_customer_id = $ledger_item['customer_id'];
                         $ledger_block_id = $ledger_item['block_id'];
                         $ledger_name = $ledger_item['name'];
                         $ledger_gcode = $ledger_item['gcode'];

                         $block=select1('branch_categories','id',$ledger_block_id);
                         $ledger_block_name=$block['name'];

                         $customer=select1('customers','id',$ledger_customer_id);
                         $lopped_customer_id=$customer['id'];
                         $lopped_customer_name=$customer['name'];

                         $ledgerCheck = count3or($conn, 'rental_agreement','company_ledger_id',$ledger_id,'service_charges_ledger_id',$ledger_id,'billing_ledger_id',$ledger_id);
                         if($ledgerCheck <= 0){
                         ?>
                  <option value="<?=$ledger_id?>">[<?=$ledger_gcode?>] <?php if($ledger_customer_id == $lopped_customer_id){ echo $lopped_customer_name; } ?> <?=$ledger_name?> <?php if($ledger_block_id){ echo '('.$ledger_block_name.')'; } ?></option>
                      <?php }
                    }
                    ?>
                </select>
                    <label for="ledger_id" generated="true" class="error"></label>
                <span class="error"></span>

                  </div>
                </div>

                <div class="col-md-6">
                  <div class="form-group">
                  <label>Service Charges Ledger Account</label>
                  <br>
                      <select name="charges_ledger_id" id="charges_ledger_id" class="form-control select2-hidden-accessible select2 form-control ledger_id" tabindex="-1" aria-hidden="true" style="width: 322px;text-align: center;padding: 10px 0px 0px 0px;margin-top: 12px !important;" required>
                  <option value="">Please Select</option>
                  <?php  $ledger_query=mysqli_query($conn, "SELECT * FROM `ledgers` WHERE `branch_id` = '$branch_id'");
                      while($ledger_item=mysqli_fetch_assoc($ledger_query)){
                         $ledger_id = $ledger_item['id'];
                         $ledger_branch_id = $ledger_item['branch_id'];
                         $ledger_controller_id = $ledger_item['control_account_id'];
                         $ledger_customer_id = $ledger_item['customer_id'];
                         $ledger_block_id = $ledger_item['block_id'];
                         $ledger_name = $ledger_item['name'];
                         $ledger_gcode = $ledger_item['gcode'];

                         $block=select1($conn, 'branch_categories','id',$ledger_block_id);
                         $ledger_block_name=$block['name'];

                         $customer=select1($conn, 'customers','id',$ledger_customer_id);
                         $lopped_customer_id=$customer['id'];
                         $lopped_customer_name=$customer['name'];

                        $ledgerCheck = count3or($conn, 'rental_agreement','company_ledger_id',$ledger_id,'service_charges_ledger_id',$ledger_id,'billing_ledger_id',$ledger_id);
                         if($ledgerCheck <= 0){
                         ?>
                  <option value="<?=$ledger_id?>">[<?=$ledger_gcode?>] <?php if($ledger_customer_id == $lopped_customer_id){ echo $lopped_customer_name; } ?> <?=$ledger_name?> <?php if($ledger_block_id){ echo '('.$ledger_block_name.')'; } ?></option>
                      <?php }
                    }
                    ?>
                </select>
                    <label for="charges_ledger_id" generated="true" class="error"></label>
                <span class="error"></span>

                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                  <label>Electricity Bills Ledger Account</label>
                  <br>
                      <select name="billing_ledger_id" id="billing_ledger_id" class="form-control select2-hidden-accessible select2 form-control ledger_id" tabindex="-1" aria-hidden="true" style="width: 322px;text-align: center;padding: 10px 0px 0px 0px;margin-top: 12px !important;" required>
                  <option value="">Please Select</option>
                  <?php  $ledger_query=mysqli_query($conn, "SELECT * FROM `ledgers` WHERE `branch_id` = '$branch_id'");
                      while($ledger_item=mysqli_fetch_assoc($ledger_query)){
                         $ledger_id = $ledger_item['id'];
                         $ledger_branch_id = $ledger_item['branch_id'];
                         $ledger_controller_id = $ledger_item['control_account_id'];
                         $ledger_customer_id = $ledger_item['customer_id'];
                         $ledger_block_id = $ledger_item['block_id'];
                         $ledger_name = $ledger_item['name'];
                         $ledger_gcode = $ledger_item['gcode'];

                         $block=select1($conn, 'branch_categories','id',$ledger_block_id);
                         $ledger_block_name=$block['name'];

                         $customer=select1('customers','id',$ledger_customer_id);
                         $lopped_customer_id=$customer['id'];
                         $lopped_customer_name=$customer['name'];

                         $ledgerCheck = count3or($conn, 'rental_agreement','company_ledger_id',$ledger_id,'service_charges_ledger_id',$ledger_id,'billing_ledger_id',$ledger_id);
                         if($ledgerCheck <= 0){
                         ?>
                          <option value="<?=$ledger_id?>">[<?=$ledger_gcode?>] <?php if($ledger_customer_id == $lopped_customer_id){ echo $lopped_customer_name; } ?> <?=$ledger_name?> <?php if($ledger_block_id){ echo '('.$ledger_block_name.')'; } ?></option>
                      <?php }
                    }
                    ?>
                </select>
                    <label for="billing_ledger_id" generated="true" class="error"></label>
                <span class="error"></span>

                  </div>
                </div>

                <div class="col-md-6">
                  <div class="form-group">
                    <label for="">Agreement Date</label><br>
                    <input type="text" name="agreement_date" id="agreement_date" class="form-control jquery-date"  placeholder="Agreement Date" readonly="">
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="">Contract Duration</label><br>
                    <input type="number" name="contract_duration" id="contract_duration" class="form-control"  placeholder="Duration(Months)">
                  </div>
                </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label for="">Increment Duration</label><br>
                  <input type="text" name="increment_duration" id="increment_duration" placeholder="Increment Duration(Months)" class="form-control">
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label for="">Increment Percentage</label><br>
                  <input type="text" name="increment_percentage" maxlength="15" placeholder="Increment Percentage" id="increment_percentage" class=" form-control">
                </div>
              </div>
              <div class="col-md-6">
        				<div class="form-group">
                  <label for="">Witness 1 Name</label><br>
          				<input type="text" name="witness_1_name" id="witness_1_name" placeholder="Witness 1 Name" class="form-control">
                </div>
              </div>
              <div class="col-md-6">
        				<div class="form-group">
                  <label for="">Witness 1 CNIC</label><br>
          				<input type="text" name="witness_1_cnic" maxlength="15" placeholder="***** ******* *" id="witness_1_cnic" class="cnic form-control">
                </div>
              </div>
              <div class="col-md-6">
        				<div class="form-group">
                  <label for="">Witness 2 Name</label><br>
          				<input type="text" name="witness_2_name" id="witness_2_name" placeholder="Witness 2 Name" class="form-control">
                </div>
              </div>
              <div class="col-md-6">
        				<div class="form-group">
                  <label for="">Witness 2 CNIC</label><br>
          				<input type="text" name="witness_2_cnic" maxlength="15" placeholder="***** ******* *" id="witness_2_cnic" class="cnic form-control">
                </div>
              </div>
              <div class="clearfix"></div>
              <!-- /.box-body -->
              <div class="box-footer">
                <input type="submit" id="rent_shop" name="rent_shop" value="Book" onclick="return confirm('Are you sure you want to Book This Shop?');" class="btn btn-primary">
              </div>
            </form>
  		
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
 <!-- Footer -->
  <?php include("inc/footer.php"); ?>

  <!-- Control Sidebar -->
  <?php include("inc/aside.php"); ?>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<!-- Bootstrap 3.3.6 -->
<!-- DataTables -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
<!-- page script -->
<script src="plugins/select2/select2.full.min.js"></script>
<script>

 $("#register-form").submit(function() {
  var form_checker = $("#register-form").valid();
 
  if(form_checker){
        $(".loader").fadeIn("fast");
    }
});
  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
  
   /* for selecting with input*/
 $(function () {
  //Initialize Select2 Elements
  $(".select2").select2();
});
</script>

  <script src="//ajax.aspnetcdn.com/ajax/jquery.validate/1.9/jquery.validate.min.js"></script>
  
  <!-- jQuery Form Validation code -->
 <!-- Date range Picker start -->
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css"/>


  <script>
/* For CNIC number format*/
$('.cnic').keydown(function(){

  //allow  backspace, tab, ctrl+A, escape, carriage return
  if (event.keyCode == 8 || event.keyCode == 9 
                    || event.keyCode == 27 || event.keyCode == 13 
                    || (event.keyCode == 65 && event.ctrlKey === true) )
                        return;
  if((event.keyCode < 96 || event.keyCode > 105))
   event.preventDefault();

  var length = $(this).val().length; 
              
  if(length == 5 || length == 13)
   $(this).val($(this).val()+'-');

 });

  // When the browser is ready...
$(document).ready(function() {
  /* Setup jQuery datepicker ui */
    var date_input=$('input[name="agreement_date"]'); //our date input has the name "date"
    var container=$('.bootstrap-iso form').length>0 ? $('.bootstrap-iso form').parent() : "body";
    date_input.datepicker({
      format: 'yyyy-mm-dd',
      container: container,
      todayHighlight: true,
      autoclose: true,
    });
    
    // Setup form validation on the #register-form element
    $("#register-form").validate({
    
        // Specify the validation rules
        rules: {
    			price: "required",
    			advance_amount: "required",
          booking_date: "required",
    			company_id: "required",
    			agreement_date: "required",
    			contract_duration: "required",
          increment_duration: "required",
          increment_percentage: "required",
    			witness_1_name: "required",
    			witness_1_cnic: "required",
    			witness_2_name: "required",
    			witness_2_cnic: "required",
          ledger_id: "required",
          charges_ledger_id: "required",
          billing_ledger_id: "required"
        },
        
        // Specify the validation error messages
        messages: {
    			price: "Please Enter the price",
    			advance_amount: "Enter The Advance Amount",
          booking_date: "Please Enter Booking Date",
    			company_id: "Please Select a Company",
    			agreement_date: "Please Select Agreement Date",
    			contract_duration: "Please Provide Contract Duration",
    			increment_duration: "Please Enter Increment Duration",
          increment_percentage: "Please Enter Increment Percentage",
    			witness_1_name: "Please Enter Witness 1 name",
    			witness_1_cnic: "Please Enter Witness 1 Cnic",
    			witness_2_name: "Please Enter Witness 2 name",
    			witness_2_cnic: "Please Enter Witness 1 Cnic",
          ledger_id: "Select Shops Ledger Account",
          charges_ledger_id: "Select Charges Ledger Account",
          billing_ledger_id: "Select Billing Ledger Account"
        },
        
        submitHandler: function(form) {
            form.submit();
        }
    });
});

//ajax add student end

  </script>


<script>
  $(document).ready(function(){
    
    var count = 1;
      
        $('#xd').click(function() {
      
      var count = count+1;
      
            var lines = "";
            
      lines += '<tr>';
      lines += '<td class="col-md-3">';
      lines += '<Select name="block_id[]" class="block_id form-control select2" required>';
      lines += '<option value="">Select Block</option>';
      <?php $block_query=mysqli_query($conn, "SELECT * FROM `floors` WHERE `branch_id` = '$branch_id'");
          while($block_item=mysqli_fetch_assoc($block_query)){
          $block_id = $block_item['id'];
          $block_name = $block_item['name']; ?>
      lines += '<option value="<?=$block_id?>"><?=$block_name?></option>';
      <?php } ?>
      lines += '</Select></td>';
      lines += '<td class="col-md-3">';
      lines += '<Select name="plot_no[]" class="plot_no form-control select2" required>';
      lines += '<option value="">Select Floor First</option>';
      lines += '</Select></td>';
      lines += '<td class="col-md-3"><input type="text" name="area[]" class="area form-control" readonly></td>';
      lines += '<td class="col-md-3"><Select name="owner[]" class="owner form-control" required><option value="">Select Shop First</option></Select></td>';
      lines += '<td><a type="button" value="Delete" onclick="deleteRow(this)" class="deleterow glyphicon glyphicon-trash" style="cursor:pointer" escape="false"></a></td>';
      lines += '</tr>';


      $('#TableBody').append(lines);
      });   
      
      $(document).on('click', '#xd', function() {
         $(function () {
          //Initialize Select2 Elements
          $(".select2").select2();
        });
      });

      function deleteRow(btn) {
        var row = btn.parentNode.parentNode;
        row.parentNode.removeChild(row);
      }

      +$("#tbUser").on('click', '.deleterow', function () {
          $(this).closest('tr').remove();
      });
    
  }); 
    
</script>

</body>
</html>

