<?php 
ob_start();
session_start();
include("db.php");
include("functions_format.php");

// ✅ Ensure user is logged in
if (!isset($_SESSION['user_email'])) {
    header("location:login.php?login=failed");
    exit;
}

$user_email = $_SESSION['user_email'];

// ✅ Use helper function to fetch manager
$manager = select1($conn, 'managers', 'email', $user_email);
$branch_id = $manager['branch_id'] ?? null;
$M_name = $manager['name'] ?? '';

// ✅ Count check for manager existence
$count_1 = count1($conn, 'managers', 'email', $user_email);

// ✅ Sanitize branch_id from GET
$branch_id_s = isset($_GET['branch_id']) ? mysqli_real_escape_string($conn, $_GET['branch_id']) : '';

if ($count_1 > 0 && $branch_id_s !== $branch_id) {
    header("location:javascript://history.go(-1)");
    exit;
}

// ✅ Fetch branch info
$branch = select1($conn, 'branches', 'id', $branch_id_s);
$branch_id = $branch['id'] ?? '';
$branch_name = $branch['name'] ?? '';
$branch_image = $branch['image'] ?? '';
$square_feet_size = $branch['square_feet_size'] ?? '';
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Rental Recovery Sheet</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
 <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
 <script src="bootstrap/js/bootstrap.min.js"></script>

<style type="text/css">
.form-control
{
  border-radius: 5px;
}
.box-covers{margin:5px}
.box-covers span{font-weight:bold;margin-left:5px}
.little-boxes{margin:3px;height:15px;width:15px;border:1px solid lightgrey;float:left}
</style>
</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <header class="main-header">
    <!-- Logo -->
 <?php  include('inc/main-header.php');  ?>
    </header>
  <!-- Left side column. contains the logo and sidebar -->
    <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
 <?php  include('inc/main-sidebar.php');  ?>
  </aside>
<?php include('inc/calculator.php'); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Rental Recovery Sheet
        <small><?=$branch_name?></small>
      </h1>
      <ol class="breadcrumb">
      	<?php if($count_1 > 0){ }else{ ?>
        <li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
        <?php } ?>
        <li><a href="branch_page.php?branch_id=<?= $branch_id ?>"><?php if($count_1 > 0){ ?><i class="fa fa-home"></i> Home<?php }else{ echo $branch_name; } ?></a></li>
        <li class="active">Rental Recovery Sheet</li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
          <div class="box box-primary">
            <div class="box-header">
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <div class=defining-colors>
              <div class=box-covers>
              <div class=little-boxes></div>
              <span>No Shorts</span> </div>
              <div class=box-covers>
              <div class=little-boxes style=background-color:#fcf8e3></div>
              <span>Current Month Rent Short</span> </div>
              <div class=box-covers>
              <div class=little-boxes style=background-color:#f2dede></div>
              <span>Rent Remaining of more than one month</span> </div>
              <div class=box-covers>
              <div class=little-boxes style=background-color:#d9edf7></div>
              <span>Total</span> </div>
              </div>
  		        <table id="example1" class="table table-bordered text-center">
                <thead>
                  <tr>
                    <th>Company/Brand</th>
                    <th>Shops</th>
                    <th>Contact</th>
                    <th>Manager Contact</th>
                    <th>Agreement Date</th>
                    <th>Current Month Rent</th>
                    <th>Arrears</th>
                    <th>Total Receivable Rent</th>
                  </tr>
                </thead>
                <tbody>
                  <?php 
                    $totalCurrentRent = $totalArrears = $totalReceivable = 0;
                  $agreements = loop1($conn,'rental_agreement','branch_id',$branch_id);
                  while($agreementsRow=mysqli_fetch_assoc($agreements)){
                    $company = select1($conn, 'company','id',$agreementsRow['company_id']);
                    $agreementId = $agreementsRow['id'];

                    //shops
                    $shops = array();
                    $rentalShops = loop1($conn, 'rental_shops','agreement_id',$agreementId);
                    while($rentalShopsRow=mysqli_fetch_assoc($rentalShops)){
                      $shopNo = select1($conn, 'shops','id',$rentalShopsRow['shop_id']);
                      array_push($shops, $shopNo['shop_no']);
                    }

                    //current month rent
                    $currentRent = getCurrentRent($conn, $agreementId);

                    //arrears start
                      //amount to be paid by today
                      $TBPamount = getTBPrentalAmount($conn, $agreementId);
                      //paid amount
                      $paiedAmount = ledgerBalance($conn, $agreementsRow['company_ledger_id']);
                      //arears
                      $arrears=($TBPamount-$currentRent)-$paiedAmount;
                      //total receivable rent
                      $totalReceivableRent=$TBPamount-$paiedAmount;
                    //arrears end

                    //combine all amount to get total
                      $totalCurrentRent+=$currentRent;
                      $totalArrears+=$arrears;
                      $totalReceivable+=$totalReceivableRent;
                  ?>
                  <tr class="<?php if($TBPamount>$currentRent){ echo 'bg-danger'; }elseif($TBPamount<=$currentRent && $TBPamount>0){ echo 'bg-warning'; }else{} ?>">
                    <td><?=$company['name']?></td>
                    <td>( <?php foreach($shops as $shop => $shopNo){
                    echo $shopNo.' '; } ?> )</td>
                    <td><?=$company['contact']?></td>
                    <td><?=$company['manager_contact']?></td>
                    <td><?php echo date("d M Y", strtotime($agreementsRow['agreement_date'])); ?></td>
                    <td><?php echo number_format($currentRent); ?></td>
                    <td><?php echo number_format($arrears); ?></td>
                    <td><?php echo number_format($totalReceivableRent); ?></td>
                  </tr>
                <?php } ?>
                </tbody>
                <tfoot>
                  <tr class="bg-info">
                    <th>Total</th>
                    <th colspan="4"></th>
                    <th><?php echo number_format($totalCurrentRent); ?></th>
                    <th><?php echo number_format($totalArrears); ?></th>
                    <th><?php echo number_format($totalReceivable); ?></th>
                  </tr>
                </tfoot>
              </table>
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        <!-- /.col -->
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <!-- Footer -->
  <?php include("inc/footer.php"); ?>

  <!-- Control Sidebar -->
  <?php include("inc/aside.php"); ?>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<!-- Bootstrap 3.3.6 -->
<!-- DataTables -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
<!-- page script -->
<script>

  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
</script>
</body>
</html>
