<?php 
ob_start();
session_start();
include("db.php");
include("functions_format.php");

// ✅ Check login
if (!isset($_SESSION['user_email'])) {
    header("Location: login.php?login=failed");
    exit;
}

$user_email = $_SESSION['user_email'];

// ✅ Fetch manager info
$manager = select1($conn, 'managers', 'email', $user_email);
$branch_id = $manager['branch_id'] ?? null;
$M_name = $manager['name'] ?? '';

// ✅ Validate manager existence
$count_1 = count1($conn, 'managers', 'email', $user_email);

// ✅ Sanitize and get branch_id from GET
$branch_id_s = isset($_GET['branch_id']) ? mysqli_real_escape_string($conn, $_GET['branch_id']) : '';

if ($count_1 > 0 && $branch_id_s !== $branch_id) {
    header("Location: javascript://history.go(-1)");
    exit;
}

// ✅ Fetch branch info
$branch = select1($conn, 'branches', 'id', $branch_id_s);
$branch_id = $branch['id'] ?? '';
$branch_name = $branch['name'] ?? '';
$branch_image = $branch['image'] ?? '';
$square_feet_size = $branch['square_feet_size'] ?? '';
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Service Charges Recovery Sheet</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
 <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
 <script src="bootstrap/js/bootstrap.min.js"></script>

<style type="text/css">
.form-control
{
  border-radius: 5px;
}
</style>
</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <header class="main-header">
    <!-- Logo -->
 <?php  include('inc/main-header.php');  ?>
    </header>
  <!-- Left side column. contains the logo and sidebar -->
    <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
 <?php  include('inc/main-sidebar.php');  ?>
  </aside>
<?php include('inc/calculator.php'); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Service Charges Recovery Sheet
        <small><?=$branch_name?></small>
      </h1>
      <ol class="breadcrumb">
      	<?php if($count_1 > 0){ }else{ ?>
        <li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
        <?php } ?>
        <li><a href="branch_page.php?branch_id=<?= $branch_id ?>"><?php if($count_1 > 0){ ?><i class="fa fa-home"></i> Home<?php }else{ echo $branch_name; } ?></a></li>
        <li class="active">Service Charges Recovery Sheet</li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
          <div class="box box-primary">
            <div class="box-header">
            </div>
            <!-- /.box-header -->
            <div class="box-body">
  		        <table id="example1" class="table table-bordered text-center">
                <thead>
                  <tr>
                    <th>Company/Brand</th>
                    <th>Shops</th>
                    <th>Area</th>
                    <th>Contact</th>
                    <th>Manager Contact</th>
                    <th>Credit</th>
                    <th>Arrears</th>
                    <th>Current Month Bill</th>
                    <th>Total Receivable Bill</th>
                    <th>View</th>
                  </tr>
                </thead>
                <tbody>
                  <?php 
                  $agreements = loop1($conn, 'rental_agreement','branch_id',$branch_id);
                  while($agreementsRow=mysqli_fetch_assoc($agreements)){
                    $company = select1($conn, 'company','id',$agreementsRow['company_id']);

                    //shops
                    $shops = array();
                    $rentalShops = loop1($conn, 'rental_shops','agreement_id',$agreementsRow['id']);
                    while($rentalShopsRow=mysqli_fetch_assoc($rentalShops)){
                      $shopNo = select1($conn, 'shops','id',$rentalShopsRow['shop_id']);
                      array_push($shops, $shopNo['shop_no']);
                    }

                    $currentMonth = date('Y-m');
                    $currentBill = select2($conn, 'service_charges','agreement_id',$agreementsRow['id'],'billing_month',$currentMonth);

                    //get arrears start
                      //amount to be paid by now
                      $amountTBPdata = select1($conn, 'service_charges_recovery','agreement_id',$agreementsRow['id']);
                      $amountTBP = $amountTBPdata['arrears'];
                      //paid amount
                      $paiedAmount = ledgerBalance($conn, $agreementsRow['service_charges_ledger_id']);
                      //total arrears
                      $arrears = $amountTBP-$paiedAmount;
                    //get arrears end


                  ?>
                  <tr>
                    <td><?=$company['name']?></td>
                    <td>( <?php foreach($shops as $shop => $shopNo){
                    echo $shopNo.' '; } ?> )</td>
                    <td><?=$agreementsRow['area']?></td>
                    <td><?=$company['contact']?></td>
                    <td><?=$company['manager_contact']?></td>
                    <td><?php if($arrears<0){ echo number_format(abs($arrears)); }else{ echo 0; } ?></td>
                    <td><?php if($arrears>=0){ echo number_format($arrears); }else{ echo 0; } ?></td>
                    <td>
                      <?php
                       if(!empty($currentBill) && isset($currentBill['total_bill']))
                    { 
                      echo $currentBill['total_bill']; 
                    }
                    else{ echo 'Not Issued'; } 
                    ?>
                  <td>

  
                  
                  
                  </td>
                    <td><?php if($arrears>0){ echo number_format($arrears); }else{ echo 0; } ?></td>
                    <td><a href="view_service_charges.php?branch_id=<?=$branch_id?>&agreementId=<?=$agreementsRow['id']?>" class="btn btn-block btn-xs btn-primary" target="blank">View</a></td>
                  </tr>
                <?php } ?>
                </tbody>
              </table>
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        <!-- /.col -->
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <!-- Footer -->
  <?php include("inc/footer.php"); ?>

  <!-- Control Sidebar -->
  <?php include("inc/aside.php"); ?>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<!-- Bootstrap 3.3.6 -->
<!-- DataTables -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
<!-- page script -->
<script>

  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
</script>
</body>
</html>
