<?php 
ob_start();
session_start();
include("db.php");
include("functions_format.php");

if (!isset($_SESSION['user_email'])) {
    header("location:login.php?login=failed");
    exit;
}

$user_email = $_SESSION['user_email'];

// Get manager info
$select_query_q = "SELECT * FROM `managers` WHERE `email` = '$user_email'";
$result_q = mysqli_query($conn, $select_query_q);

$branch_id = '';
$M_name = '';

while ($rowq = mysqli_fetch_assoc($result_q)) {
    $branch_id = $rowq['branch_id'];
    $M_name = $rowq['name'];
}

$count_1 = mysqli_num_rows($result_q);

// Validate branch access
$branch_id_s = $_GET['branch_id'] ?? '';

if ($count_1 > 0 && $branch_id_s != $branch_id) {
    header("location:javascript://history.go(-1)");
    exit;
}

// Get branch info
$select_query = "SELECT * FROM `branches` WHERE `id` = '$branch_id_s'";
$result_query = mysqli_query($conn, $select_query) or die($select_query . "<br><br>" . mysqli_error($conn));

$row = mysqli_fetch_assoc($result_query);
$branch_id = $row['id'] ?? '';
$branch_name = $row['name'] ?? '';
$branch_image = $row['image'] ?? '';
$square_feet_size = $row['square_feet_size'] ?? '';

// Get control accounts
$control_account_query = mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `branch_id` = '$branch_id'");

// Get ledger data using select1 helper
$ledger_id = $_GET['ledger_id'] ?? '';
$ledgerData = select1($conn, 'ledgers', 'id', $ledger_id); // Assumes select1 is already updated for mysqli

$ledgerName = $ledgerData['name'] ?? '';
$ledgerCustomerId = $ledgerData['customer_id'] ?? '';
$ledgerBlockId = $ledgerData['block_id'] ?? '';
$ledgerGeneralId = $ledgerData['general_ledger_id'] ?? '';
$ledgerControlId = $ledgerData['control_account_id'] ?? '';
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Shift Ledger</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css"><!-- Select2 -->
  <link rel="stylesheet" href="plugins/select2/select2.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
 <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
 <script src="bootstrap/js/bootstrap.min.js"></script>

<style type="text/css">
.form-control
{
  border-radius: 5px;
}
</style>
</head>
<script type="text/javascript">
$(document).on('change', '#control_id', function (event) { 
  var controlID = $(this).val();
  var ledger_general = <?=$ledgerGeneralId?>;
  if(controlID){
      $.ajax({
          type:'POST',
          url:'ajaxdata.php',
          data:{
            'control_id_shift': controlID,
            'ledger_general': ledger_general,
          },
          success:function(html){
              $('#general_id').html(html);
          }
      }); 
  }else{
      $('#general_id').html('<option value="">Select Control Account First</option>');
  }
});
</script>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <header class="main-header">
    <!-- Logo -->
 <?php  include('inc/main-header.php');  ?>
    </header>
  <!-- Left side column. contains the logo and sidebar -->
    <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
 <?php  include('inc/main-sidebar.php');  ?>
  </aside>
<?php include('inc/calculator.php'); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Shift Ledger
        <small><?=$branch_name?></small>
      </h1>
      <ol class="breadcrumb">
        <?php if($count_1 > 0){ }else{ ?>
        <li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
        <?php  } ?>
        <li><a href="branch_page.php?branch_id=<?= $branch_id ?>"><?php if($count_1 > 0){ ?><i class="fa fa-home"></i> Home <?php }else{ echo $branch_name; } ?></a></li>
        <li><a href="control_accounts.php?branch_id=<?= $branch_id ?>">Control Accounts</a></li>
        <li><a href="general_ledgers.php?branch_id=<?=$branch_id?>&control_account_id=<?=$ledgerControlId?>">General Ledgers</a></li>
        <li><a href="ledgers.php?branch_id=<?=$branch_id?>&control_account_id=<?=$ledgerControlId?>&general_ledger_id=<?=$ledgerGeneralId?>">Ledgers</a></li>
        <li class="active"> Shift Ledger</li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
          <div class="box box-primary">
            <div class="box-header">
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <?php query_status('shift_ledger'); ?>
              <h4 class="text-center"><b>Shift 
                <?php if($ledgerCustomerId){ $customer = select1('customers','id',$ledgerCustomerId);
                echo $customer['name']; } ?>
                <?=$ledgerName?>
                <?php if($ledgerBlockId){ $block = select1('branch_categories','id',$ledgerBlockId);
                echo '('.$block['name'].')'; } ?>
                 To</b></h4>
            <form role="form" id="register-form" method="post"  novalidate="novalidate" action=""  enctype="multipart/form-data"> 
              <div class="box-body">
              <div class="col-md-6">
                <div class="form-group">
                  <label for="">Control Account</label><br>
                  <select class="form-control select2" id="control_id" name="control_id">
                    <option value="">Select Control Account</option>
                    <?php $controlAccountData = mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `branch_id` = '$branch_id'"); 
                    while($controlRow=mysqli_fetch_assoc($controlAccountData)){?>
                    <option value="<?=$controlRow['id']?>"><?=$controlRow['name']?></option>
                    <?php } ?>
                  </select>
                  <label for="control_id" generated="true" class="error"></label>
                </div>
              </div>
           
              <div class="col-md-6">
                <div class="form-group">
                  <label for="">General Ledger</label>
                  <select class="form-control select2" id="general_id" name="general_id">
                    <option value="">Select Control Account First</option>
                  </select>
                  <label for="general_id" generated="true" class="error"></label>
                </div>
              </div>

                </div>
              <!-- /.box-body -->

              <div class="box-footer">
                <input type="submit" id="submit" value="Shift" class="btn btn-success">
              </div>
            </form>
  		
           
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        <!-- /.col -->
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <!-- Footer -->
  <?php include("inc/footer.php"); ?>

  <!-- Control Sidebar -->
  <?php include("inc/aside.php"); ?>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<!-- Bootstrap 3.3.6 -->
<!-- DataTables -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
<!-- page script -->
<script src="plugins/select2/select2.full.min.js"></script>
<script>

  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
</script>

  <script src="//ajax.aspnetcdn.com/ajax/jquery.validate/1.9/jquery.validate.min.js"></script>
  
  <!-- jQuery Form Validation code -->
  <script>
  $(function () {
    //Initialize Select2 Elements
    $(".select2").select2();
  });
  // When the browser is ready...
$(document).ready(function() {
  
    // Setup form validation on the #register-form element
    $("#register-form").validate({
    
        // Specify the validation rules
        rules: {
            control_id: "required",
      			general_id: "required"
        },
        
        // Specify the validation error messages
        messages: {
            control_id: "Please Select Control Account",
      			general_id: "Please Select General Account"
        },
        
        submitHandler: function(form) {
            form.submit();
        }
    });
    
	  $("#submit").click(function(){
		var control_id = $("#control_id").val();
		var general_id = $("#general_id").val();
    var ledger_id = <?=$ledger_id?>;

	  $.ajax({
		url: "functions.php",
		type: "POST",
		async: false,
		data: {
		"ledger_shift": 1,
		"control_id": control_id,
		"general_id": general_id,
    "ledger_id": ledger_id,
		},
		success: function(data){
		}
		
	})
	

	  });
	
    
});

  </script>
  

</body>
</html>
