<?php 
ob_start();
session_start();
include("db.php"); // $conn should be defined here

if (!isset($_SESSION['user_email'])) {
    header("location:login.php?login=failed");		
    exit;
}

$user_email = $_SESSION['user_email'];

// Get manager info
$select_query_q = "SELECT * FROM `managers` WHERE `email` = '$user_email'";
$result_q = mysqli_query($conn, $select_query_q);

$branch_id = '';
$M_name = '';
$count_1 = 0;

if ($result_q) {
    while ($rowq = mysqli_fetch_assoc($result_q)) {
        $branch_id = $rowq['branch_id'];
        $M_name = $rowq['name'];
    }
    $count_1 = mysqli_num_rows($result_q);
} else {
    die("Query Error (managers): " . mysqli_error($conn));
}

// Validate branch access
$branch_id_s = $_GET['branch_id'] ?? '';

if ($count_1 > 0 && $branch_id_s != $branch_id) {
    header("location:javascript://history.go(-1)");
    exit;
}

// Get branch details
$select_query = "SELECT * FROM `branches` WHERE `id` = '$branch_id_s'";
$result_query = mysqli_query($conn, $select_query);

if (!$result_query) {
    die($select_query . "<br><br>" . mysqli_error($conn));
}

while ($row = mysqli_fetch_assoc($result_query)) {
    $branch_id = $row['id'];
    $branch_name = $row['name'];
    $manager_name = $row['manager'];
    $branch_location = $row['location'];
    $branch_area = $row['area'];
    $branch_status = $row['status'];
    $branch_image = $row['image'];
    $square_feet_size = $row['square_feet_size'];
    $branch_entry_date = $row['date'];
}

// Get block info
$block_id_s = $_GET['block_id'] ?? '';
$select_query1 = "SELECT * FROM `branch_categories` WHERE `id` = '$block_id_s'";
$result_query1 = mysqli_query($conn, $select_query1);

$block_id = $block_name = '';
$area = 0;

if (!$result_query1) {
    die($select_query1 . "<br><br>" . mysqli_error($conn));
}

while ($row = mysqli_fetch_assoc($result_query1)) {
    $block_id = $row['id'];
    $block_name = $row['name'];
    $area = $row['area'];
}
$control_account_query=mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `branch_id` = '$branch_id'");
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Shops Report</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
  <!-- iCheck -->
  <link rel="stylesheet" href="plugins/iCheck/flat/blue.css">
  <!-- Morris chart -->
  <link rel="stylesheet" href="plugins/morris/morris.css">
  <!-- jvectormap -->
  <link rel="stylesheet" href="plugins/jvectormap/jquery-jvectormap-1.2.2.css">
  <!-- Date Picker -->
  <link rel="stylesheet" href="plugins/datepicker/datepicker3.css">
  <!-- Daterange picker -->
  <link rel="stylesheet" href="plugins/daterangepicker/daterangepicker.css">
  <!-- bootstrap wysihtml5 - text editor -->
  <link rel="stylesheet" href="plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css">
 <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
 <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <header class="main-header">
    <!-- Logo -->
 <?php  include('inc/main-header.php');  ?>
    </header>
  <!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
 <?php  include('inc/main-sidebar.php');  ?>
  </aside>
 <?php include('inc/calculator.php'); ?>
 
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Shops Report
        <small><?= $branch_name ?></small>
      </h1>
      <ol class="breadcrumb">
        <?php if($count_1 > 0){ }else{ ?>
        <li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
        <?php  } ?>
        <li><a href="branch_page.php?branch_id=<?= $branch_id ?>"><?php if($count_1 > 0){ ?><i class="fa fa-home"></i> Home <?php }else{ echo $branch_name; } ?></a></li>
        <li><a href="sold_out_area.php?branch_id=<?= $branch_id ?>">Sold out Area</a></li>
        <li class="active">Sold out Shops</li>
      </ol><br>
      

    </section>

    <!-- Main content -->
    
<!-- /.content -->

     <section class="content">
      <div class="row">
        <div class="col-xs-12">

         <form accept="" method="post">
          <div class="col-xs-10">
          <div class="form-group">

          <select name="select_value" class="form-control">
            <option>Please Select</option>
            <option value="1">Available</option>
            <option value="2">Booked</option>
          </select>
        </div>
      </div>
      <div class="col-xs-2">
        <div class="form-group">
          <input class="form-control btn btn-primary" type="submit" name="submit_select_value">
          </div>
        </div>
        <div class="clearfix"></div>
          </form>

          <div class="box box-primary">

            <div class="box-header">
        <?php
		$block_id_s = $_GET['block_id'];
    $select_value = 1; // Default to "Available" (value 1)
    if(isset($_POST['submit_select_value'])){
      $select_value=$_POST['select_value'] ?? 1;
      if($select_value==0){
        echo '<div class="alert alert-danger text-center">Please Select list</div>';

      }

    }
		$select_query="SELECT * FROM `plots` WHERE `branch_id` = '$branch_id_s' AND `block_id` = '$block_id_s' AND `status` = '$select_value'";
		$result_query=mysqli_query($conn, $select_query) or die($select_query."<br/><br/>".mysqli_error($conn));
			$total_sold = 0;
			if(mysqli_num_rows($result_query) > 0){ 
		?>
          <?php  if($select_value==2){ ?>
              <h3 class="box-title text-bold"><?=$block_name;?> : Booked Shops</h3>
<?php } ?>
         <?php  if($select_value==1){ ?>
              <h3 class="box-title text-bold"><?=$block_name;?> : Available Shops</h3>
<?php } ?>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <table id="example1" class="table table-bordered">
                <thead>
                <tr>
                  <th>SN#</th>
                  <th>Shops Number</th>
                  <th>Floor</th>
                  <th>Area</th>
                  <?php  if($select_value==2){ ?>
                    <th>Customer Name</th>
                    <th>Selling Price</th>
                  <?php } ?>
                  <th>Status</th>
                </tr>
                </thead>
                <tbody>
   <?php
   			$numbering = 0;
			while($row=mysqli_fetch_assoc($result_query)){
			$numbering++;
      $p_id=$row['id'];
      $p_block_id=$row['block_id'];
      $p_no=$row['plot_no'];
      $p_status=$row['status'];
      $p_area=$row['area'];
      $p_marla=$row['marla'] ?? '';
      $p_sarsai=$row['sarsai'] ?? '';
      $p_square_foot=$row['square_foot'] ?? '';
     
      $booking_query=mysqli_query($conn, "SELECT * FROM `book_plot` WHERE `branch_id` = '$branch_id' AND `block_id` = '$p_block_id' AND `plot_no` = '$p_no'");
        while($row_q=mysqli_fetch_assoc($booking_query)){
        $book_plot_id=$row_q['id'];
        $customer_id=$row_q['customer_id'];
        $total_price=$row_q['total_price'];
      }

      $customer_query=mysqli_query($conn, "SELECT * FROM `customers` WHERE `id` = '$customer_id'");
        while($customer_row=mysqli_fetch_array($customer_query)){
           $customer_name = $customer_row['name'];
        }
	?>
                <tr>
                  <td><?=$numbering?></td>
                  <td><?=$p_no?></td>
                  <td><?=$block_name?></td>
                  <td><?php $plot_total_area = $p_area/$square_feet_size; echo $p_marla.' Marly '; if($p_sarsai) { echo $p_sarsai.' Sarsai ';} if($p_square_foot) { echo $p_square_foot.' Sqr. Ft.';}?></td>
                  <?php  if($select_value==2){ ?>
                    <td><?=$customer_name?></td>
                    <td><?php echo number_format($total_price); ?></td>
                  <?php } ?>
                  <td><?php if($p_status == '1' ){ ?><b>Available</b><?php }else{?><b>Booked</b> <?php } ?></td>
                </tr>
               <?php } ?>
                </tbody>
                <tfoot>
                </tr>
                </tfoot>
              </table>
              <div class="text-center" style="padding:10px 0 0 0;">
                 <form method="post" style="display: inline-block;">
                  <input name="generate_pdf" type="submit" class="btn btn-success" value="Generate PDF">
                      </form>
                      <a href="print_sold_out_plots.php?branch_id=<?=$branch_id?>&block_id=<?=$block_id?>&selected_value=<?=$select_value?>" class="btn btn-primary" target="blank">Generate Print</a>
                </div>

               <?php }else{ ?>
                    <b>No Data Found</b>
				<?php } ?>
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
      

<!-- /.content -->



  </div>
  <!-- /.content-wrapper -->
  <?php include('inc/footer.php'); ?>

  <!-- Control Sidebar -->
 <?php include('inc/aside.php'); ?>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- DataTables -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
<!-- page script -->
<script>

  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
</script>

  <script src="//ajax.aspnetcdn.com/ajax/jquery.validate/1.9/jquery.validate.min.js"></script>
  
  <!-- jQuery Form Validation code -->
</body>
</html>
