<?php 
ob_start();
session_start();
include ("db.php"); // Ensure $conn = mysqli_connect(...) inside this file

if (!isset($_SESSION['user_email'])) {
    header("location:login.php?login=failed");		
    exit;
}

$user_email = $_SESSION['user_email'];

// Fetch manager info
$select_query_q = "SELECT * FROM `managers` WHERE `email` = '$user_email'";
$result_q = mysqli_query($conn, $select_query_q);

$branch_id = '';
$M_name = '';
$count_1 = 0;

if ($result_q) {
    while ($rowq = mysqli_fetch_assoc($result_q)) {
        $branch_id = $rowq['branch_id'];
        $M_name = $rowq['name'];
    }
    $count_1 = mysqli_num_rows($result_q);
} else {
    die("Query Error: " . mysqli_error($conn));
}

$branch_id_s = $_GET['branch_id'] ?? '';

if ($count_1 > 0) {
    if ($branch_id_s != $branch_id) {
        header("location:javascript://history.go(-1)");
        exit;
    }
}

// Fetch branch info
$select_query = "SELECT * FROM `branches` WHERE `id` = '$branch_id_s'";
$result_query = mysqli_query($conn, $select_query);

if (!$result_query) {
    die($select_query . "<br><br>" . mysqli_error($conn));
}

while ($row = mysqli_fetch_assoc($result_query)) {
    $branch_id = $row['id'];
    $branch_name = $row['name'];
    $manager_name = $row['manager'];
    $branch_location = $row['location'];
    $branch_area = $row['area'];
    $branch_status = $row['status'];
    $branch_image = $row['image'];
    $branch_map = $row['map'];
    $square_feet_size = $row['square_feet_size'];
    $branch_entry_date = $row['date'];
}

// Fetch control accounts
$control_account_query = mysqli_query($conn, "SELECT * FROM `control_accounts` WHERE `branch_id` = '$branch_id'");

if (!$control_account_query) {
    die("Control Accounts Query Error: " . mysqli_error($conn));
}
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Total Area</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
  <!-- iCheck -->
  <link rel="stylesheet" href="plugins/iCheck/flat/blue.css">
  <!-- Morris chart -->
  <link rel="stylesheet" href="plugins/morris/morris.css">
  <!-- jvectormap -->
  <link rel="stylesheet" href="plugins/jvectormap/jquery-jvectormap-1.2.2.css">
  <!-- Date Picker -->
  <link rel="stylesheet" href="plugins/datepicker/datepicker3.css">
  <!-- Daterange picker -->
  <link rel="stylesheet" href="plugins/daterangepicker/daterangepicker.css">
  <!-- bootstrap wysihtml5 - text editor -->
  <link rel="stylesheet" href="plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css">
  <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <header class="main-header">
    <!-- Logo -->
 <?php  include('inc/main-header.php');  ?>
    </header>
  <!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
 <?php  include('inc/main-sidebar.php');  ?>
  </aside>
 <?php include('inc/calculator.php'); ?>
 

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Total Area
        <small><?= $branch_name ?></small>
      </h1>
      <ol class="breadcrumb">
       <?php if($count_1 > 0){ }else{ ?>
        <li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
        <?php  } ?>
        <li><a href="branch_page.php?branch_id=<?= $branch_id ?>"><?php if($count_1 > 0){ ?><i class="fa fa-home"></i> Home <?php }else{ echo $branch_name; } ?></a></li>
        <li class="active">Total Area</li>
      </ol>
    </section>

    <!-- Main content -->

    <section class="content">
      <div class="row">
        <div class="col-xs-12">
        

          <div class="box box-primary">
            <div class="box-header">
       <?php
		$select_query="SELECT * FROM `branch_categories` WHERE `branch_id` = '$branch_id_s'";
		$result_query=mysqli_query($conn,$select_query) or die($select_query."<br/><br/>".mysqli_error($conn));;
			$total_sold = 0;
			if(mysqli_num_rows($result_query) > 0){
		?>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <table id="example1" class="table table-bordered table-striped">
                <thead>
                <tr>
                  <th>ID</th>
                  <th>Floor Name</th>
                  <th>Total Area</th>
                </tr>
                </thead>
                <tbody>
   <?php
			while($row=mysqli_fetch_assoc($result_query)){
			$block_id=$row['id'];
			$block_name=$row['name'];
			$block_area=$row['area'];

	?>
                <tr>
                  <td><?= $block_id; ?></td>
                  <td><?= $block_name; ?></td>
                  <td><?= $block_area ?></td>
                </tr>
               <?php } ?>
                </tbody>
                <tfoot>
                </tr>
                </tfoot>
              </table>
               <?php }else{ ?>
                    <b>No Data Found</b>
				<?php } ?>
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    
    <section class="content-header">
    <h1>Total Area of <?= $branch_name ?>: <a><?= $branch_area ?></a></h1>
    </section>
    <section class="content-header">
    <?php if($branch_map){ ?>
    <a><h3 class="pull-left">Plaza Map</h3></a><a href="<?=$branch_map?>" class="pull-right btn btn-primary" target="_blank">View</a>
   	<img class="img-rounded img-responsive" src="<?=$branch_map?>" style="width:100%;height:auto;" />
    <?php }else{ ?>
    <a><h3 class="pull-left">Plaza Map Not Available</h3></a>
    <?php } ?>
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <?php include('inc/footer.php'); ?>

  <!-- Control Sidebar -->
 <?php include('inc/aside.php'); ?>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- DataTables -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
<!-- page script -->
<script>

  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
</script>

  <script src="//ajax.aspnetcdn.com/ajax/jquery.validate/1.9/jquery.validate.min.js"></script>
  
  <!-- jQuery Form Validation code -->



</body>
</html>
